/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class UtilityFunctions
implements OriogenConstants {
    private static UtilityFunctions instance = null;

    public static UtilityFunctions getInstance() {
        if (instance == null) {
            instance = new UtilityFunctions();
        }
        return instance;
    }

    public RandomSeed createRandomSeed() {
        return new RandomSeed();
    }

    public static double randomNumber(RandomSeed idum) {
        int ia = 16807;
        int im = Integer.MAX_VALUE;
        int iq = 127773;
        int ir = 2836;
        int mask = 123459876;
        double am = 1.0 / (double)im;
        double randomNum = 0.0;
        idum.initialSeed ^= mask;
        int k = idum.initialSeed / iq;
        idum.initialSeed = ia * (idum.initialSeed - k * iq) - ir * k;
        if (idum.initialSeed < 0) {
            idum.initialSeed += im;
        }
        randomNum = am * (double)idum.initialSeed;
        idum.initialSeed ^= mask;
        return randomNum;
    }

    public double calculateVariance(double[] data) {
        int i;
        double returnValue = Double.MAX_VALUE;
        double sumSq = 0.0;
        double sum = 0.0;
        if (data.length < 2) {
            return returnValue;
        }
        for (i = 0; i < data.length; ++i) {
            sum += data[i];
        }
        double meanVal = sum / (double)data.length;
        for (i = 0; i < data.length; ++i) {
            sumSq = (meanVal - data[i]) * (meanVal - data[i]);
        }
        returnValue = Math.sqrt(sumSq / (double)(data.length - 1));
        return returnValue;
    }

    public static void showDebugMsg(String msg) {
        System.out.println(msg);
    }

    public static String generateProfileString(ProfileStruct[] a_ProfileTable, int a_Row, boolean a_UseTab) {
        String returnValue = a_ProfileTable[a_Row].type == 1 ? (a_ProfileTable[a_Row].initialSlope == 1 ? "Increasing profile" : "Decreasing profile") : (a_ProfileTable[a_Row].type == 2 ? (a_ProfileTable[a_Row].initialSlope == 1 ? "Umbrella profile, downturn at " + String.valueOf(a_ProfileTable[a_Row].peakIndex) : "Inverted umbrella profile, upturn at " + String.valueOf(a_ProfileTable[a_Row].peakIndex)) : (a_ProfileTable[a_Row].cyclicSlope == 31 ? "Cyclic profile, downturn at " + a_ProfileTable[a_Row].timePointAtMax + ", upturn at " + a_ProfileTable[a_Row].timePointAtMin : "Cyclic profile, upturn at " + a_ProfileTable[a_Row].timePointAtMin + ", downturn at " + a_ProfileTable[a_Row].timePointAtMax));
        returnValue = a_UseTab ? a_Row + 1 + "\t" + returnValue : "  " + (a_Row + 1) + ") " + returnValue + "\n";
        return returnValue;
    }

    public static double summary(double[] yyORyb, double[] ybarORybars, double[] stdErr, double[] variance, int[] sampleSize, int valueNGRP, double[][] summaryRawData, double sse0) {
        int j;
        int i;
        int counter = 0;
        double sseVal = 0.0;
        for (i = 1; i <= valueNGRP; ++i) {
            ybarORybars[i] = 0.0;
        }
        for (i = 1; i <= valueNGRP; ++i) {
            for (j = 1; j <= sampleSize[i]; ++j) {
                summaryRawData[i][j] = yyORyb[++counter];
            }
        }
        for (i = 1; i <= valueNGRP; ++i) {
            for (j = 1; j <= sampleSize[i]; ++j) {
                ybarORybars[i] = ybarORybars[i] + summaryRawData[i][j] / (double)sampleSize[i];
            }
        }
        double sse = 0.0;
        counter = 0;
        for (int i2 = 1; i2 <= valueNGRP; ++i2) {
            stdErr[i2] = 0.0;
            for (int j2 = 1; j2 <= sampleSize[i2]; ++j2) {
                ++counter;
                double xyz = summaryRawData[i2][j2] - ybarORybars[i2];
                double xyzSquared = xyz * xyz;
                sse += xyzSquared;
                int n = i2;
                stdErr[n] = stdErr[n] + xyzSquared;
            }
            if (sampleSize[i2] <= 1) continue;
            variance[i2] = stdErr[i2] / ((double)sampleSize[i2] - 1.0);
            stdErr[i2] = Math.sqrt(stdErr[i2] / ((double)sampleSize[i2] - 1.0));
            stdErr[i2] = stdErr[i2] / Math.sqrt(sampleSize[i2]);
        }
        if (counter > valueNGRP) {
            sseVal = Math.sqrt(sse / (double)(counter - valueNGRP));
            if (sse0 < Double.MAX_VALUE) {
                sseVal += sse0;
            }
        }
        return sseVal;
    }

    public static int getOriginalIndexFromPairwiseIndex(int[] sampleSize, int pairwiseIdx, int timePt1, int timePt2) {
        int goalIdx;
        int goalTimePt;
        int returnValue = 0;
        if (pairwiseIdx >= sampleSize[timePt1]) {
            goalTimePt = timePt2;
            goalIdx = pairwiseIdx - sampleSize[timePt1];
        } else {
            goalTimePt = timePt1;
            goalIdx = pairwiseIdx;
        }
        for (int i = 1; i < goalTimePt; ++i) {
            returnValue += sampleSize[i];
        }
        return returnValue += goalIdx;
    }

    public static List applyBH(List origPValues, double alpha) {
        ArrayList<BHSortElement> returnValue = new ArrayList<BHSortElement>();
        Collections.sort(origPValues, new BHPValueComparator());
        int numP = origPValues.size();
        boolean selectAllRemaining = false;
        int idx = 0;
        for (BHSortElement bhEl : origPValues) {
            if (selectAllRemaining || bhEl.adjPValue < alpha * (double)(numP - idx) / (double)numP) {
                selectAllRemaining = true;
                bhEl.isSelected = true;
                returnValue.add(bhEl);
            }
            ++idx;
        }
        return returnValue;
    }

    public static boolean checkReadOnly(File a_File) {
        boolean returnValue = false;
        if (a_File.exists() && !a_File.canWrite()) {
            returnValue = true;
        }
        return returnValue;
    }

    public static void centerInScreen(Component frame) {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle rect = frame.getBounds();
        frame.setLocation((screen.width - rect.width) / 2, (screen.height - rect.height) / 2);
    }

    private static class BHIndexComparator
    implements Comparator {
        private BHIndexComparator() {
        }

        public int compare(Object o1, Object o2) {
            BHSortElement el1 = (BHSortElement)o1;
            BHSortElement el2 = (BHSortElement)o2;
            return el1.origIdx.compareTo(el2.origIdx);
        }
    }

    private static class BHPValueComparator
    implements Comparator {
        private BHPValueComparator() {
        }

        public int compare(Object o1, Object o2) {
            BHSortElement el1 = (BHSortElement)o1;
            BHSortElement el2 = (BHSortElement)o2;
            return -1 * el1.adjPValue.compareTo(el2.adjPValue);
        }
    }

    public static class BHSortElement {
        public Integer origIdx;
        public Double adjPValue;
        public boolean isSelected;
        public List comparisonPValues;

        public BHSortElement(int idx, double pVal, List pList) {
            this.origIdx = idx;
            this.adjPValue = pVal;
            this.isSelected = false;
            this.comparisonPValues = pList;
        }
    }

    public class RandomSeed {
        public int initialSeed;
    }
}

