/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SliderWindow
extends JFrame
implements GeneProcessorEvent,
OriogenConstants {
    private Origen_Data m_MainDoc;
    private Window m_SliderWin;
    private GeneProcessor m_GeneProcessor;
    private List m_mdFdrComparisonList = new ArrayList();
    private ProfileStruct[] m_ProfileTable;
    private int m_NumTimePoints;
    private boolean m_mdFdr;
    private String m_OutputFileName;
    private String[] m_GroupNameArray;
    private int m_NumProfiles;
    private int m_LastProfileIndex;
    private boolean m_ResultsShown = false;
    private int m_LinesReadAtUserBreak = 0;
    private int m_NumErrors = 0;
    private int m_NumGenesSelected = 0;
    private JPanel m_LogPanel;
    private JTextArea m_LogSlider;
    private Container sliderPanel;
    private JPanel manualInputPanel;
    private JPanel mdfdrInputPanel;
    private MyPanel graphPanel;
    private JPanel mdfdrListboxPanel;
    private JPanel buttonPanel;
    private JFormattedTextField formattedTextField1;
    private JSlider[] sliderArray = new JSlider[30];
    private int profileTableIndex = 0;
    private String profileDesc;
    private JMenuBar m_MenuBar;
    private JRadioButton increasingOrderButton;
    private JRadioButton decreasingOrderButton;
    private JRadioButton umbrellaPosButton;
    private JRadioButton umbrellaNegButton;
    private JRadioButton cyclicButton;
    private JRadioButton allNonCyclicButton;
    private JRadioButton hiddenRadioButton;
    private JLabel downturnLabel;
    private JLabel upturnLabel;
    private JTextField downturnField;
    private JTextField upturnField;
    private JLabel cyclicDownturnLabel;
    private JLabel cyclicUpturnLabel;
    private JTextField cyclicDownturnField;
    private JTextField cyclicUpturnField;
    private GridBagLayout manualInputLayout;
    private GridBagConstraints manualInputConstraints;
    private JLabel mdfdrListLabel;
    private JList groupNamesList;
    private JRadioButton mdfdrSingleComparison;
    private JRadioButton mdfdrAllComparisons;
    private JComboBox mdfdrComparePt1;
    private JComboBox mdfdrComparePt2;
    private GridBagLayout mdfdrInputLayout;
    private GridBagConstraints mdfdrInputConstraints;
    private GridBagLayout mdfdrListboxLayout;
    private GridBagConstraints mdfdrListboxConstraints;
    private JButton sliderSelectBtn;
    private JButton comparisonSelectBtn;

    public SliderWindow(Origen_Data mainDoc) {
        int i;
        this.m_MainDoc = mainDoc;
        this.m_SliderWin = this;
        String newline = "\n";
        this.sliderSelectBtn = null;
        this.comparisonSelectBtn = null;
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic('F');
        JMenuItem viewMenuItem = new JMenuItem("View Results");
        viewMenuItem.setMnemonic('V');
        viewMenuItem.setToolTipText("View the graphs of the results");
        fileMenu.add(viewMenuItem);
        ViewMenuHandler viewMenuHandler = new ViewMenuHandler();
        viewMenuItem.addActionListener(viewMenuHandler);
        JMenu helpMenu = new JMenu("Help");
        helpMenu.setMnemonic('H');
        JMenuItem helpAboutMenuItem = new JMenuItem("About ORIOGEN");
        helpAboutMenuItem.setMnemonic('A');
        helpAboutMenuItem.setToolTipText("View the Help screen describing the gene selection algorithm");
        helpMenu.add(helpAboutMenuItem);
        HelpAboutMenuHandler helpAboutMenuHandler = new HelpAboutMenuHandler();
        helpAboutMenuItem.addActionListener(helpAboutMenuHandler);
        JMenuItem helpContentsMenuItem = new JMenuItem("Contents");
        helpContentsMenuItem.setMnemonic('C');
        helpContentsMenuItem.setToolTipText("View the Help Contents screen");
        helpMenu.add(helpContentsMenuItem);
        HelpContentsMenuHandler helpContentsMenuHandler = new HelpContentsMenuHandler();
        helpContentsMenuItem.addActionListener(helpContentsMenuHandler);
        this.m_MenuBar = new JMenuBar();
        this.m_MenuBar.add(fileMenu);
        this.m_MenuBar.add(helpMenu);
        this.setJMenuBar(this.m_MenuBar);
        this.setTitle("ORIOGEN Version 4.01 -- Profile Selection");
        this.setSize(1000, 590);
        Container contentPane = this.getContentPane();
        GridBagLayout gblm = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        contentPane.setLayout(new GridLayout(0, 2, 0, 0));
        this.sliderPanel = new Container();
        this.manualInputPanel = new JPanel();
        this.manualInputLayout = new GridBagLayout();
        this.manualInputConstraints = new GridBagConstraints();
        this.manualInputPanel.setLayout(this.manualInputLayout);
        this.increasingOrderButton = new JRadioButton("Increasing Profile");
        this.decreasingOrderButton = new JRadioButton("Decreasing Profile");
        this.umbrellaPosButton = new JRadioButton("Umbrella Profile");
        this.cyclicButton = new JRadioButton("Cyclic Profile");
        this.umbrellaNegButton = new JRadioButton("Inverted Umbrella Profile");
        this.allNonCyclicButton = new JRadioButton("All Non-Cyclic Profiles");
        this.hiddenRadioButton = new JRadioButton();
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.increasingOrderButton);
        buttonGroup.add(this.decreasingOrderButton);
        buttonGroup.add(this.umbrellaPosButton);
        buttonGroup.add(this.umbrellaNegButton);
        buttonGroup.add(this.allNonCyclicButton);
        buttonGroup.add(this.cyclicButton);
        buttonGroup.add(this.hiddenRadioButton);
        Box umbBox1 = Box.createHorizontalBox();
        this.downturnLabel = new JLabel("Downturn at ");
        this.downturnLabel.setEnabled(false);
        this.downturnField = new JTextField(10);
        this.downturnField.setEnabled(false);
        umbBox1.add(this.umbrellaPosButton);
        umbBox1.add(Box.createHorizontalStrut(10));
        umbBox1.add(this.downturnLabel);
        umbBox1.add(this.downturnField);
        this.downturnField.setText("2");
        Box umbBox2 = Box.createHorizontalBox();
        this.upturnLabel = new JLabel("Upturn at     ");
        this.upturnLabel.setEnabled(false);
        this.upturnField = new JTextField(10);
        this.upturnField.setEnabled(false);
        this.upturnField.setText("2");
        umbBox2.add(this.umbrellaNegButton);
        umbBox2.add(Box.createHorizontalStrut(10));
        umbBox2.add(this.upturnLabel);
        umbBox2.add(this.upturnField);
        Box umbBox3 = Box.createHorizontalBox();
        this.cyclicDownturnLabel = new JLabel("Downturn at ");
        this.cyclicDownturnLabel.setEnabled(false);
        this.cyclicDownturnField = new JTextField(10);
        this.cyclicDownturnField.setEnabled(false);
        this.cyclicDownturnField.setText("2");
        this.cyclicUpturnLabel = new JLabel("Upturn at ");
        this.cyclicUpturnLabel.setEnabled(false);
        this.cyclicUpturnField = new JTextField(10);
        this.cyclicUpturnField.setEnabled(false);
        this.cyclicUpturnField.setText("3");
        umbBox3.add(this.cyclicButton);
        umbBox3.add(Box.createHorizontalStrut(10));
        umbBox3.add(this.cyclicDownturnLabel);
        umbBox3.add(this.cyclicDownturnField);
        umbBox3.add(Box.createHorizontalStrut(10));
        umbBox3.add(this.cyclicUpturnLabel);
        umbBox3.add(this.cyclicUpturnField);
        this.sliderSelectBtn = new JButton("     Add selected profile(s)     ");
        this.sliderSelectBtn.setToolTipText("Add the selected profile type to the Profile Selections used for analysis");
        Box umbBox4 = Box.createHorizontalBox();
        umbBox4.add(Box.createHorizontalStrut(70));
        umbBox4.add(this.sliderSelectBtn);
        this.manualInputConstraints.weightx = 1.0;
        this.manualInputConstraints.weighty = 1.0;
        this.manualInputConstraints.fill = 0;
        this.manualInputConstraints.anchor = 17;
        for (int i2 = 1; i2 <= 6; ++i2) {
            this.addManualInputComponent(Box.createHorizontalStrut(10), i2, 0, 1, 1);
        }
        this.manualInputConstraints.weightx = 6.0;
        this.addManualInputComponent(this.increasingOrderButton, 2, 1, 2, 1);
        this.addManualInputComponent(this.decreasingOrderButton, 3, 1, 2, 1);
        this.addManualInputComponent(umbBox1, 4, 1, 2, 1);
        this.addManualInputComponent(umbBox2, 5, 1, 2, 1);
        this.addManualInputComponent(this.allNonCyclicButton, 6, 1, 2, 1);
        this.addManualInputComponent(umbBox3, 7, 1, 2, 1);
        this.manualInputConstraints.weighty = 4.0;
        this.addManualInputComponent(umbBox4, 8, 1, 2, 1);
        ManualInputChangeHandler manualInputChangeHandler = new ManualInputChangeHandler();
        this.increasingOrderButton.addActionListener(manualInputChangeHandler);
        this.decreasingOrderButton.addActionListener(manualInputChangeHandler);
        this.umbrellaNegButton.addActionListener(manualInputChangeHandler);
        this.umbrellaPosButton.addActionListener(manualInputChangeHandler);
        this.downturnField.addActionListener(manualInputChangeHandler);
        this.upturnField.addActionListener(manualInputChangeHandler);
        this.allNonCyclicButton.addActionListener(manualInputChangeHandler);
        this.downturnField.addKeyListener(manualInputChangeHandler);
        this.upturnField.addKeyListener(manualInputChangeHandler);
        this.cyclicButton.addActionListener(manualInputChangeHandler);
        this.cyclicUpturnField.addKeyListener(manualInputChangeHandler);
        this.cyclicDownturnField.addKeyListener(manualInputChangeHandler);
        this.mdfdrInputPanel = new JPanel();
        this.mdfdrInputLayout = new GridBagLayout();
        this.mdfdrInputConstraints = new GridBagConstraints();
        this.mdfdrInputPanel.setLayout(this.mdfdrInputLayout);
        this.mdfdrSingleComparison = new JRadioButton("Select Pairwise Comparisons (enter one pair at a time)");
        this.mdfdrAllComparisons = new JRadioButton("Select All Pairwise Comparisons");
        this.comparisonSelectBtn = new JButton("     Add selected comparison(s)     ");
        this.comparisonSelectBtn.setToolTipText("Add the selected comparison to the list of pairwise comparisons used for analysis");
        ButtonGroup comparisonButtonGroup = new ButtonGroup();
        comparisonButtonGroup.add(this.mdfdrSingleComparison);
        comparisonButtonGroup.add(this.mdfdrAllComparisons);
        this.mdfdrAllComparisons.addActionListener(manualInputChangeHandler);
        this.mdfdrSingleComparison.addActionListener(manualInputChangeHandler);
        this.mdfdrSingleComparison.setSelected(true);
        this.mdfdrInputConstraints.weightx = 1.0;
        this.mdfdrInputConstraints.weighty = 1.0;
        this.mdfdrInputConstraints.anchor = 17;
        Box compareBox1 = Box.createHorizontalBox();
        this.mdfdrComparePt1 = new JComboBox();
        this.mdfdrComparePt2 = new JComboBox();
        JLabel mdfdrVsLabel = new JLabel(" vs. ");
        compareBox1.add(Box.createHorizontalStrut(50));
        compareBox1.add(this.mdfdrComparePt1);
        compareBox1.add(mdfdrVsLabel);
        compareBox1.add(this.mdfdrComparePt2);
        this.mdfdrInputConstraints.weightx = 1.0;
        for (int i3 = 1; i3 <= 6; ++i3) {
            this.addMdfdrInputComponent(Box.createHorizontalStrut(10), i3, 0, 1, 1);
        }
        this.mdfdrInputConstraints.weightx = 4.0;
        this.mdfdrInputConstraints.insets = new Insets(40, 0, 0, 0);
        this.addMdfdrInputComponent(this.mdfdrSingleComparison, 0, 1, 1, 1);
        this.mdfdrInputConstraints.insets = new Insets(5, 0, 0, 0);
        this.addMdfdrInputComponent(compareBox1, 1, 1, 1, 1);
        this.mdfdrInputConstraints.insets = new Insets(20, 0, 0, 0);
        this.addMdfdrInputComponent(this.mdfdrAllComparisons, 2, 1, 1, 1);
        this.mdfdrInputConstraints.insets = new Insets(80, 30, 0, 0);
        this.mdfdrInputConstraints.anchor = 16;
        this.addMdfdrInputComponent(this.comparisonSelectBtn, 3, 1, 1, 1);
        this.graphPanel = new MyPanel();
        this.buttonPanel = new JPanel();
        this.m_LogPanel = new JPanel();
        this.mdfdrListboxPanel = new JPanel();
        this.graphPanel.setLayout(new GridLayout(0, 1, 0, 0));
        this.buttonPanel.setLayout(gblm);
        Border b1 = BorderFactory.createEtchedBorder(0);
        this.manualInputPanel.setBorder(b1);
        Border b2 = BorderFactory.createEtchedBorder(0);
        this.buttonPanel.setBorder(b2);
        Border b3 = BorderFactory.createEtchedBorder(0);
        this.graphPanel.setBorder(b3);
        Border b4 = BorderFactory.createEtchedBorder(0);
        this.mdfdrListboxPanel.setBorder(b4);
        this.m_LogSlider = new JTextArea();
        this.m_LogSlider.setEditable(false);
        JScrollPane logScrollPane = new JScrollPane(this.m_LogSlider);
        this.m_LogPanel.add(logScrollPane);
        this.m_LogPanel.setLayout(new GridLayout(0, 1, 0, 0));
        this.mdfdrListboxLayout = new GridBagLayout();
        this.mdfdrListboxConstraints = new GridBagConstraints();
        this.mdfdrListboxConstraints.weightx = 1.0;
        this.mdfdrListboxConstraints.weighty = 1.0;
        this.mdfdrListboxConstraints.anchor = 17;
        this.mdfdrListboxPanel.setLayout(this.mdfdrListboxLayout);
        this.mdfdrListLabel = new JLabel("Group Naming (click to edit)");
        this.groupNamesList = new JList();
        this.groupNamesList.setModel(new DefaultListModel());
        JScrollPane listScroller = new JScrollPane(this.groupNamesList);
        listScroller.setAlignmentX(0.0f);
        for (i = 1; i <= 6; ++i) {
            this.addMdfdrListboxComponent(Box.createHorizontalStrut(10), i, 0, 1, 1);
        }
        this.mdfdrListboxConstraints.insets = new Insets(15, 0, 0, 0);
        this.addMdfdrListboxComponent(this.mdfdrListLabel, 0, 1, 1, 1);
        this.mdfdrListboxConstraints.weighty = 6.0;
        this.mdfdrListboxConstraints.fill = 1;
        this.mdfdrListboxConstraints.insets = new Insets(5, 0, 10, 0);
        this.addMdfdrListboxComponent(listScroller, 1, 1, 1, 5);
        for (i = 1; i <= 6; ++i) {
            this.addMdfdrListboxComponent(Box.createHorizontalStrut(10), i, 2, 1, 1);
        }
        contentPane.add(this.mdfdrListboxPanel);
        contentPane.add(this.manualInputPanel);
        contentPane.add(this.buttonPanel);
        contentPane.add(this.mdfdrInputPanel);
        contentPane.add(this.graphPanel);
        contentPane.add(this.m_LogPanel);
        this.showInitialMessages();
        JButton modifyInputsButton = new JButton("         Modify initial inputs         ");
        modifyInputsButton.setToolTipText("Enter new values on the Initial Inputs window");
        JButton sliderReset = new JButton("    Reset all selected profiles    ");
        sliderReset.setToolTipText("Erase all profile selections and restart the selection process");
        JButton sliderFinished = new JButton("         Start Processing              ");
        sliderFinished.setToolTipText("Start processing the input file using the selected profiles");
        JButton sliderHelp = new JButton("                     Help                     ");
        sliderHelp.setToolTipText("Show the help window for this screen");
        gbc.ipadx = 20;
        gbc.insets = new Insets(10, 0, 0, 0);
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.buttonPanel.add((Component)modifyInputsButton, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        this.buttonPanel.add((Component)new JSeparator(), gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        this.buttonPanel.add((Component)sliderReset, gbc);
        gbc.gridx = 0;
        gbc.gridy = 3;
        this.buttonPanel.add((Component)new JSeparator(), gbc);
        gbc.gridx = 0;
        gbc.gridy = 4;
        this.buttonPanel.add((Component)sliderFinished, gbc);
        gbc.gridx = 0;
        gbc.gridy = 5;
        this.buttonPanel.add((Component)new JSeparator(), gbc);
        gbc.gridx = 0;
        gbc.gridy = 6;
        this.buttonPanel.add((Component)sliderHelp, gbc);
        Border myBorder = BorderFactory.createEmptyBorder(20, 20, 20, 20);
        LocatorClass locator = new LocatorClass();
        Image image = Toolkit.getDefaultToolkit().getImage(locator.pathString + "/GRAPH05.GIF");
        if (image != null) {
            this.setIconImage(image);
        }
        sliderReset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SliderWindow.this.sliderResetButtonEvent(evt);
            }
        });
        sliderFinished.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SliderWindow.this.sliderFinishButtonEvent(evt);
            }
        });
        if (this.sliderSelectBtn != null) {
            this.sliderSelectBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    SliderWindow.this.sliderSelectButtonEvent(evt);
                }
            });
        }
        if (this.comparisonSelectBtn != null) {
            this.comparisonSelectBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    SliderWindow.this.sliderSelectButtonEvent(evt);
                }
            });
        }
        modifyInputsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SliderWindow.this.modifyInputsButtonEvent(evt);
            }
        });
        sliderHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SliderWindow.this.sliderHelpButtonEvent(evt);
            }
        });
        this.groupNamesList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int selIndex = SliderWindow.this.groupNamesList.getSelectedIndex();
                if (selIndex > -1) {
                    String tmpStr = JOptionPane.showInputDialog(null, "Enter name for group #" + (selIndex + 1), SliderWindow.this.m_GroupNameArray[selIndex]);
                    if (tmpStr != null) {
                        ((SliderWindow)SliderWindow.this).m_GroupNameArray[selIndex] = tmpStr;
                        SliderWindow.this.setupGroupNamesListbox();
                        SliderWindow.this.setupComparisonComboboxes();
                    }
                    SliderWindow.this.groupNamesList.setSelectedIndex(-1);
                }
            }
        });
        this.setDefaultCloseOperation(3);
    }

    public void initialize() {
        this.m_NumTimePoints = this.m_MainDoc.getNumTimePoints();
        this.m_mdFdr = this.m_MainDoc.getmdFdr();
        this.m_OutputFileName = this.m_MainDoc.getOutputFileName();
        this.m_GroupNameArray = this.m_MainDoc.getGroupNameArray();
        this.m_ProfileTable = this.m_MainDoc.getProfileTable();
    }

    public void showPanels() {
        Container contentPane = this.getContentPane();
        if (this.m_mdFdr) {
            contentPane.remove(this.manualInputPanel);
            contentPane.remove(this.graphPanel);
            if (contentPane.getComponentCount() == 2) {
                contentPane.add((Component)this.mdfdrListboxPanel, 0);
                contentPane.add((Component)this.mdfdrInputPanel, 2);
            }
            this.setupComparisonComboboxes();
            this.setupGroupNamesListbox();
        } else {
            contentPane.remove(this.mdfdrInputPanel);
            contentPane.remove(this.mdfdrListboxPanel);
            if (contentPane.getComponentCount() == 2) {
                contentPane.add((Component)this.manualInputPanel, 0);
                contentPane.add((Component)this.graphPanel, 2);
            }
        }
        contentPane.validate();
    }

    private void setupComparisonComboboxes() {
        this.mdfdrComparePt1.removeAllItems();
        this.mdfdrComparePt2.removeAllItems();
        for (int i = 1; i <= this.m_NumTimePoints; ++i) {
            if (i < this.m_NumTimePoints) {
                this.mdfdrComparePt1.addItem(this.m_GroupNameArray[i - 1]);
            }
            if (i <= 1) continue;
            this.mdfdrComparePt2.addItem(this.m_GroupNameArray[i - 1]);
        }
    }

    private void addManualInputComponent(Component component, int row, int column, int width, int height) {
        this.manualInputConstraints.gridy = row;
        this.manualInputConstraints.gridx = column;
        this.manualInputConstraints.gridwidth = width;
        this.manualInputConstraints.gridheight = height;
        this.manualInputLayout.setConstraints(component, this.manualInputConstraints);
        this.manualInputPanel.add(component);
    }

    private void addMdfdrInputComponent(Component component, int row, int column, int width, int height) {
        this.mdfdrInputConstraints.gridy = row;
        this.mdfdrInputConstraints.gridx = column;
        this.mdfdrInputConstraints.gridwidth = width;
        this.mdfdrInputConstraints.gridheight = height;
        this.mdfdrInputLayout.setConstraints(component, this.mdfdrInputConstraints);
        this.mdfdrInputPanel.add(component);
    }

    private void addMdfdrListboxComponent(Component component, int row, int column, int width, int height) {
        this.mdfdrListboxConstraints.gridy = row;
        this.mdfdrListboxConstraints.gridx = column;
        this.mdfdrListboxConstraints.gridwidth = width;
        this.mdfdrListboxConstraints.gridheight = height;
        this.mdfdrListboxLayout.setConstraints(component, this.mdfdrListboxConstraints);
        this.mdfdrListboxPanel.add(component);
    }

    public void showContinueMenu(boolean showFlag) {
    }

    private void showInitialMessages() {
        String newline = "\n";
        this.m_LogSlider.append("Input data summary:" + newline);
        this.m_LogSlider.append("   Input file name = " + this.m_MainDoc.getInputFileName() + newline);
        this.m_LogSlider.append("   Output file name = " + this.m_OutputFileName + newline);
        this.m_LogSlider.append("   Total number of genes = " + this.m_MainDoc.getNumGenes() + newline);
        this.m_LogSlider.append("   Total number of dose groups or time points = " + this.m_NumTimePoints + newline);
        this.m_LogSlider.append("   Vector of sample sizes per dose/time point = " + this.m_MainDoc.createSampleSizeString() + newline);
        this.m_LogSlider.append("   Number of initial bootstrap samples = " + this.m_MainDoc.getNumInitialBootStraps() + newline);
        if (!this.m_mdFdr) {
            this.m_LogSlider.append("   Maximum number of bootstrap samples = " + this.m_MainDoc.getMaxNumBootStraps() + newline);
        }
        this.m_LogSlider.append("   False Discovery Rate = " + this.m_MainDoc.getFDRLevel() + newline);
        if (this.m_MainDoc.getRandomSeed() == -1) {
            this.m_LogSlider.append("   Bootstrap random seed = Automatic " + newline);
        } else {
            this.m_LogSlider.append("   Bootstrap random seed = Manual, seed = " + this.m_MainDoc.getRandomSeed() + newline);
        }
        if (this.m_mdFdr) {
            this.m_LogSlider.append("   Pairwise Comparison Analysis" + newline);
        }
        this.m_LogSlider.append(newline);
        this.m_LogSlider.append("Profile Selections:" + newline);
        this.m_LogSlider.setCaretPosition(this.m_LogSlider.getDocument().getLength());
    }

    public void mySliderMoved(ChangeEvent evt) {
        JSlider curSlider = (JSlider)evt.getSource();
        int fps = curSlider.getValue();
        this.repaint();
    }

    public void myMouseEvent(MouseEvent evt) {
        JSlider curSlider = (JSlider)evt.getSource();
        int sliderValue = curSlider.getValue();
        this.repaint();
    }

    public void generate_sliders() {
        this.sliderPanel.removeAll();
        for (int x = 0; x < this.m_NumTimePoints; ++x) {
            this.sliderArray[x] = new JSlider(1);
            this.sliderArray[x].addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent evt) {
                    SliderWindow.this.mySliderMoved(evt);
                }
            });
            this.sliderArray[x].setMaximum(120);
            if (this.m_NumTimePoints > 1) {
                this.sliderArray[x].setMajorTickSpacing(120 / (this.m_NumTimePoints - 1));
            } else {
                this.sliderArray[x].setMajorTickSpacing(120);
            }
            this.sliderArray[x].setPaintTicks(true);
            this.sliderPanel.add(this.sliderArray[x]);
        }
    }

    public void sliderFinishButtonEvent(ActionEvent evt) {
        if (this.m_mdFdr) {
            if (this.m_mdFdrComparisonList.size() == 0) {
                JOptionPane.showMessageDialog(this, "You must select at least one pairwise comparison before processing.", "Error", 0);
                return;
            }
        } else {
            this.m_NumProfiles = this.m_LastProfileIndex;
            if (this.m_NumProfiles == 0) {
                JOptionPane.showMessageDialog(this, "You must select at least one profile before processing.", "Error", 0);
                return;
            }
        }
        if (this.m_ResultsShown) {
            this.resetLog();
            this.showProfilesInLog();
        }
        this.m_LogSlider.append("\nGenes Selected:\n");
        this.m_ResultsShown = true;
        this.m_LinesReadAtUserBreak = 0;
        this.m_GeneProcessor = new GeneProcessor(this, this.m_MainDoc);
        this.m_GeneProcessor.setLastProfileIndex(this.m_LastProfileIndex);
        this.m_GeneProcessor.setMdFdrComparisonList(this.m_mdFdrComparisonList);
        this.m_GeneProcessor.setNumProfiles(this.m_NumProfiles);
        this.m_GeneProcessor.setProfileTable(this.m_ProfileTable);
        this.m_GeneProcessor.setGroupNameArray(this.m_GroupNameArray);
        this.m_MainDoc.setGeneProcessor(this.m_GeneProcessor);
        this.m_GeneProcessor.start();
        this.m_NumErrors = 0;
        this.setAllEnabled(false);
        this.showContinueMenu(false);
    }

    public void setAllEnabled(boolean a_Enabled) {
        int i;
        Component[] componentArray = this.sliderPanel.getComponents();
        for (i = 0; i < componentArray.length; ++i) {
            componentArray[i].setEnabled(a_Enabled);
        }
        componentArray = this.manualInputPanel.getComponents();
        for (i = 0; i < componentArray.length; ++i) {
            componentArray[i].setEnabled(a_Enabled);
            JComponent tmpComponent = (JComponent)componentArray[i];
            Component[] subcomponentArray = tmpComponent.getComponents();
            for (int j = 0; j < subcomponentArray.length; ++j) {
                subcomponentArray[j].setEnabled(a_Enabled);
            }
        }
        componentArray = this.buttonPanel.getComponents();
        for (i = 0; i < componentArray.length; ++i) {
            componentArray[i].setEnabled(a_Enabled);
        }
    }

    @Override
    public void showProcessorError(String errorMsg) {
        JOptionPane.showMessageDialog(this, errorMsg, "Error", 0);
    }

    @Override
    public void logProcessorError(String errMsg) {
        this.m_LogSlider.append("  " + errMsg + "\n");
        this.m_LogSlider.setCaretPosition(this.m_LogSlider.getDocument().getLength());
        ++this.m_NumErrors;
    }

    @Override
    public void logProcessorEvent(String eventMsg) {
        this.m_LogSlider.append("  " + eventMsg + "\n");
        this.m_LogSlider.setCaretPosition(this.m_LogSlider.getDocument().getLength());
    }

    @Override
    public boolean confirmStop() {
        int response = JOptionPane.showConfirmDialog(this.m_SliderWin, "Are you sure you want to stop processing?", "Stop Processing", 0);
        return response == 0;
    }

    @Override
    public void geneProcessorFinished() {
        this.m_MainDoc.showProgressWindow(false);
        this.m_NumGenesSelected = this.m_GeneProcessor.getNumGenesSelected();
        if (this.m_NumErrors > 0) {
            JOptionPane.showMessageDialog(this, "Errors were found in the input data. Please see the error file located at " + this.m_MainDoc.getErrorFileName(), "Warning", 2);
        } else if (this.m_NumGenesSelected == -1) {
            JOptionPane.showMessageDialog(this, this.m_GeneProcessor.getLastError());
        }
        if (this.m_LinesReadAtUserBreak == 0) {
            if (this.m_NumGenesSelected == 0) {
                JOptionPane.showMessageDialog(this, "No genes were selected.", "Status", 2);
            } else if (this.m_NumGenesSelected > 0) {
                JOptionPane.showMessageDialog(this, "Finished with analysis. Results are found in " + this.m_OutputFileName, this.m_NumGenesSelected + " Genes Selected", 1);
                int response = 1;
                if (!this.m_mdFdr) {
                    response = JOptionPane.showConfirmDialog(this, "Do you want to view the result graphs?", "View Results", 0);
                }
                if (response == 0) {
                    ResultsViewer rv = new ResultsViewer();
                    rv.processResults(this.m_OutputFileName, this.m_NumTimePoints);
                }
            }
        }
        this.setAllEnabled(true);
        if (this.m_LinesReadAtUserBreak > 0) {
            this.showContinueMenu(true);
        } else {
            this.showContinueMenu(false);
        }
    }

    public void sliderSelectButtonEvent(ActionEvent evt) {
        if (this.m_ResultsShown) {
            this.resetLog();
            this.showProfilesInLog();
        }
        if (this.m_mdFdr) {
            if (this.mdfdrSingleComparison.isSelected()) {
                int timept2;
                int timept1 = this.mdfdrComparePt1.getSelectedIndex() + 1;
                MdFdrComparisonItem item = new MdFdrComparisonItem(timept1, timept2 = this.mdfdrComparePt2.getSelectedIndex() + 2);
                boolean sts = item.validate();
                if (!sts) {
                    JOptionPane.showMessageDialog(this, "The selected points cannot be equal", "Error", 0);
                } else if (this.m_mdFdrComparisonList.contains(item)) {
                    JOptionPane.showMessageDialog(this, "This comparison has already been selected", "Error", 0);
                } else {
                    this.m_mdFdrComparisonList.add(item);
                    this.resetLog();
                    this.showProfilesInLog();
                }
            } else {
                this.m_mdFdrComparisonList.clear();
                for (int i = 1; i < this.m_NumTimePoints; ++i) {
                    for (int j = i + 1; j <= this.m_NumTimePoints; ++j) {
                        MdFdrComparisonItem item = new MdFdrComparisonItem(i, j);
                        this.m_mdFdrComparisonList.add(item);
                    }
                }
                this.resetLog();
                this.showProfilesInLog();
            }
        } else if (this.allNonCyclicButton.isSelected()) {
            this.selectAllProfiles();
        } else {
            this.GetProfileType(true);
        }
    }

    private void setupGroupNamesListbox() {
        ((DefaultListModel)this.groupNamesList.getModel()).clear();
        for (int i = 1; i <= this.m_NumTimePoints; ++i) {
            ((DefaultListModel)this.groupNamesList.getModel()).addElement("(" + i + ") " + this.m_GroupNameArray[i - 1]);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private int GetProfileType(boolean a_FillTable) {
        int profileType;
        block23: {
            block28: {
                int timePointAtMax;
                int timePointAtMin;
                int umbrellaTwoSize;
                int umbrellaOneSize;
                block29: {
                    block27: {
                        int profileMax;
                        block26: {
                            block25: {
                                block24: {
                                    boolean TIME_POINT_ONE = true;
                                    profileType = -1;
                                    umbrellaOneSize = 0;
                                    umbrellaTwoSize = 0;
                                    if (!this.increasingOrderButton.isSelected()) break block24;
                                    profileType = 11;
                                    if (a_FillTable) {
                                        this.m_ProfileTable[this.profileTableIndex].type = 1;
                                        this.m_ProfileTable[this.profileTableIndex].initialSlope = 1;
                                        this.m_ProfileTable[this.profileTableIndex].peakIndex = this.m_NumTimePoints;
                                        this.m_ProfileTable[this.profileTableIndex].internalProfileNumber = this.m_NumTimePoints;
                                        this.m_ProfileTable[this.profileTableIndex].timePointAtMin = 0;
                                        this.m_ProfileTable[this.profileTableIndex].timePointAtMax = 0;
                                        ++this.profileTableIndex;
                                        ++this.m_LastProfileIndex;
                                        break block23;
                                    } else {
                                        this.profileDesc = "Increasing profile";
                                    }
                                    break block23;
                                }
                                if (!this.decreasingOrderButton.isSelected()) break block25;
                                profileType = 12;
                                if (a_FillTable) {
                                    this.m_ProfileTable[this.profileTableIndex].type = 1;
                                    this.m_ProfileTable[this.profileTableIndex].initialSlope = 2;
                                    this.m_ProfileTable[this.profileTableIndex].peakIndex = this.m_NumTimePoints;
                                    this.m_ProfileTable[this.profileTableIndex].internalProfileNumber = 1;
                                    this.m_ProfileTable[this.profileTableIndex].timePointAtMin = 0;
                                    this.m_ProfileTable[this.profileTableIndex].timePointAtMax = 0;
                                    ++this.profileTableIndex;
                                    ++this.m_LastProfileIndex;
                                    break block23;
                                } else {
                                    this.profileDesc = "Decreasing profile";
                                }
                                break block23;
                            }
                            if (!this.umbrellaPosButton.isSelected()) break block26;
                            profileType = 21;
                            profileMax = Integer.parseInt(this.downturnField.getText().trim());
                            if (a_FillTable) {
                                this.m_ProfileTable[this.profileTableIndex].type = 2;
                                this.m_ProfileTable[this.profileTableIndex].initialSlope = 1;
                                this.m_ProfileTable[this.profileTableIndex].peakIndex = profileMax;
                                this.m_ProfileTable[this.profileTableIndex].internalProfileNumber = profileMax;
                                this.m_ProfileTable[this.profileTableIndex].timePointAtMin = 0;
                                this.m_ProfileTable[this.profileTableIndex].timePointAtMax = 0;
                                ++this.m_LastProfileIndex;
                                ++this.profileTableIndex;
                                break block23;
                            } else {
                                this.profileDesc = "Umbrella profile, downturn at " + String.valueOf(profileMax);
                            }
                            break block23;
                        }
                        if (!this.umbrellaNegButton.isSelected()) break block27;
                        profileType = 22;
                        profileMax = Integer.parseInt(this.upturnField.getText().trim());
                        if (a_FillTable) {
                            this.m_ProfileTable[this.profileTableIndex].type = 2;
                            this.m_ProfileTable[this.profileTableIndex].initialSlope = 2;
                            this.m_ProfileTable[this.profileTableIndex].peakIndex = profileMax;
                            this.m_ProfileTable[this.profileTableIndex].internalProfileNumber = this.m_NumTimePoints - 1 + profileMax;
                            this.m_ProfileTable[this.profileTableIndex].timePointAtMin = 0;
                            this.m_ProfileTable[this.profileTableIndex].timePointAtMax = 0;
                            ++this.m_LastProfileIndex;
                            ++this.profileTableIndex;
                            break block23;
                        } else {
                            this.profileDesc = "Inverted umbrella profile, upturn at " + String.valueOf(profileMax);
                        }
                        break block23;
                    }
                    if (!this.cyclicButton.isSelected()) break block28;
                    timePointAtMin = Integer.parseInt(this.cyclicUpturnField.getText().trim());
                    if (timePointAtMin >= (timePointAtMax = Integer.parseInt(this.cyclicDownturnField.getText().trim()))) break block29;
                    profileType = 32;
                    if (a_FillTable) {
                        this.m_ProfileTable[this.profileTableIndex].type = 3;
                        this.m_ProfileTable[this.profileTableIndex].initialSlope = 2;
                        umbrellaOneSize = timePointAtMax;
                        umbrellaTwoSize = this.m_NumTimePoints - timePointAtMin + 1;
                        this.m_ProfileTable[this.profileTableIndex].largestUmbrellaSize = Math.max(umbrellaOneSize, umbrellaTwoSize);
                        this.m_ProfileTable[this.profileTableIndex].timePointAtMin = timePointAtMin;
                        this.m_ProfileTable[this.profileTableIndex].timePointAtMax = timePointAtMax;
                        this.m_ProfileTable[this.profileTableIndex].cyclicSlope = 32;
                        this.m_ProfileTable[this.profileTableIndex].internalProfileNumber = 420 + this.m_ProfileTable[this.profileTableIndex].timePointAtMin * 20 + this.m_ProfileTable[this.profileTableIndex].timePointAtMax;
                        if (umbrellaOneSize >= umbrellaTwoSize) {
                            this.m_ProfileTable[this.profileTableIndex].initialUmbSlope = 2;
                            this.m_ProfileTable[this.profileTableIndex].peakIndex = timePointAtMin;
                            this.m_ProfileTable[this.profileTableIndex].simpleOrderStartTimePt = timePointAtMax;
                            this.m_ProfileTable[this.profileTableIndex].simpleOrderEndTimePt = this.m_NumTimePoints;
                            this.m_ProfileTable[this.profileTableIndex].umbStartTimePt = 1;
                        } else {
                            int umbrellaMax = timePointAtMax - timePointAtMin + 1;
                            this.m_ProfileTable[this.profileTableIndex].initialUmbSlope = 1;
                            this.m_ProfileTable[this.profileTableIndex].peakIndex = umbrellaMax;
                            this.m_ProfileTable[this.profileTableIndex].simpleOrderStartTimePt = 1;
                            this.m_ProfileTable[this.profileTableIndex].simpleOrderEndTimePt = timePointAtMin;
                            this.m_ProfileTable[this.profileTableIndex].umbStartTimePt = timePointAtMin;
                        }
                        ++this.m_LastProfileIndex;
                        ++this.profileTableIndex;
                        break block23;
                    } else {
                        this.profileDesc = "Cyclic profile, upturn at " + String.valueOf(timePointAtMin) + ", downturn at " + String.valueOf(timePointAtMax);
                    }
                    break block23;
                }
                if (timePointAtMax < timePointAtMin) {
                    profileType = 31;
                    if (a_FillTable) {
                        this.m_ProfileTable[this.profileTableIndex].type = 3;
                        this.m_ProfileTable[this.profileTableIndex].initialSlope = 1;
                        umbrellaOneSize = timePointAtMin;
                        umbrellaTwoSize = this.m_NumTimePoints - timePointAtMax + 1;
                        this.m_ProfileTable[this.profileTableIndex].largestUmbrellaSize = Math.max(umbrellaOneSize, umbrellaTwoSize);
                        this.m_ProfileTable[this.profileTableIndex].timePointAtMax = timePointAtMax;
                        this.m_ProfileTable[this.profileTableIndex].timePointAtMin = timePointAtMin;
                        this.m_ProfileTable[this.profileTableIndex].cyclicSlope = 31;
                        this.m_ProfileTable[this.profileTableIndex].internalProfileNumber = 310 + this.m_ProfileTable[this.profileTableIndex].timePointAtMin * 20 + this.m_ProfileTable[this.profileTableIndex].timePointAtMax;
                        if (umbrellaOneSize >= umbrellaTwoSize) {
                            this.m_ProfileTable[this.profileTableIndex].initialUmbSlope = 1;
                            this.m_ProfileTable[this.profileTableIndex].peakIndex = timePointAtMax;
                            this.m_ProfileTable[this.profileTableIndex].simpleOrderStartTimePt = timePointAtMin;
                            this.m_ProfileTable[this.profileTableIndex].simpleOrderEndTimePt = this.m_NumTimePoints;
                            this.m_ProfileTable[this.profileTableIndex].umbStartTimePt = 1;
                        } else {
                            int umbrellaMin = this.m_ProfileTable[this.profileTableIndex].timePointAtMin - this.m_ProfileTable[this.profileTableIndex].timePointAtMax + 1;
                            this.m_ProfileTable[this.profileTableIndex].initialUmbSlope = 2;
                            this.m_ProfileTable[this.profileTableIndex].peakIndex = umbrellaMin;
                            this.m_ProfileTable[this.profileTableIndex].simpleOrderStartTimePt = 1;
                            this.m_ProfileTable[this.profileTableIndex].simpleOrderEndTimePt = timePointAtMax;
                            this.m_ProfileTable[this.profileTableIndex].umbStartTimePt = timePointAtMax;
                        }
                        ++this.m_LastProfileIndex;
                        ++this.profileTableIndex;
                        break block23;
                    } else {
                        this.profileDesc = "Cyclic profile, downturn at " + String.valueOf(timePointAtMax) + ", upturn at " + String.valueOf(timePointAtMin);
                    }
                    break block23;
                } else {
                    if (a_FillTable) {
                        JOptionPane.showMessageDialog(this, "The min and max points on the cycle cannot be the same.", "Error", 0);
                    }
                    return -1;
                }
            }
            if (a_FillTable) {
                JOptionPane.showMessageDialog(this, "Two consecutive time points cannot have the same value", "Error", 0);
            }
            return -1;
        }
        for (int index = 0; index < this.m_LastProfileIndex - 1; ++index) {
            if (this.m_ProfileTable[index].type != this.m_ProfileTable[this.profileTableIndex - 1].type || this.m_ProfileTable[index].initialSlope != this.m_ProfileTable[this.profileTableIndex - 1].initialSlope || this.m_ProfileTable[index].peakIndex != this.m_ProfileTable[this.profileTableIndex - 1].peakIndex || this.m_ProfileTable[index].timePointAtMin != this.m_ProfileTable[this.profileTableIndex - 1].timePointAtMin || this.m_ProfileTable[index].timePointAtMax != this.m_ProfileTable[this.profileTableIndex - 1].timePointAtMax) continue;
            if (a_FillTable) {
                JOptionPane.showMessageDialog(this, "Duplicate profiles found. The profile you just entered matches Profile #" + String.valueOf(index + 1), "Error", 0);
                --this.m_LastProfileIndex;
                --this.profileTableIndex;
                return -1;
            }
            this.profileDesc = this.profileDesc + "(same as Profile #" + String.valueOf(index + 1) + ")";
        }
        if (a_FillTable) {
            String logString = this.m_MainDoc.generateProfileString(this.profileTableIndex - 1, false);
            this.m_LogSlider.append(logString);
        }
        return profileType;
    }

    public void selectAllProfiles() {
        int i;
        if (this.m_LastProfileIndex > 0) {
            this.profileTableIndex = 0;
            for (i = 0; i < this.m_LastProfileIndex; ++i) {
                if (this.m_ProfileTable[i].type != 3) continue;
                try {
                    this.m_ProfileTable[this.profileTableIndex] = (ProfileStruct)this.m_ProfileTable[i].clone();
                    this.m_ProfileTable[this.profileTableIndex].userSelectionNumber = this.profileTableIndex + 1;
                    ++this.profileTableIndex;
                    continue;
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    // empty catch block
                }
            }
            this.m_LastProfileIndex = this.profileTableIndex;
            this.resetLog();
        }
        for (i = 0; i < 2 * (this.m_NumTimePoints - 1); ++i) {
            int k = i + this.m_LastProfileIndex;
            if (i == 0) {
                this.m_ProfileTable[k].type = 1;
                this.m_ProfileTable[k].initialSlope = 2;
                this.m_ProfileTable[k].peakIndex = this.m_NumTimePoints;
                this.m_ProfileTable[k].internalProfileNumber = 1;
                continue;
            }
            if (i < this.m_NumTimePoints - 1) {
                this.m_ProfileTable[k].type = 2;
                this.m_ProfileTable[k].initialSlope = 1;
                this.m_ProfileTable[k].peakIndex = i + 1;
                this.m_ProfileTable[k].internalProfileNumber = i + 1;
                continue;
            }
            if (i == this.m_NumTimePoints - 1) {
                this.m_ProfileTable[k].type = 1;
                this.m_ProfileTable[k].initialSlope = 1;
                this.m_ProfileTable[k].peakIndex = this.m_NumTimePoints;
                this.m_ProfileTable[k].internalProfileNumber = i + 1;
                continue;
            }
            if (i <= this.m_NumTimePoints - 1) continue;
            this.m_ProfileTable[k].type = 2;
            this.m_ProfileTable[k].initialSlope = 2;
            this.m_ProfileTable[k].peakIndex = i + 2 - this.m_NumTimePoints;
            this.m_ProfileTable[k].internalProfileNumber = i + 1;
        }
        this.m_LastProfileIndex += 2 * (this.m_NumTimePoints - 1);
        this.profileTableIndex = this.m_LastProfileIndex;
        this.showProfilesInLog();
    }

    public void sliderResetButtonEvent(ActionEvent evt) {
        int rslt = JOptionPane.showConfirmDialog(this, "Are you sure you want to reset all the profiles?", "Confirm", 0);
        if (rslt == 0) {
            this.m_LastProfileIndex = 0;
            this.profileTableIndex = 0;
            this.resetLog();
            for (int i = 0; i < this.m_NumTimePoints; ++i) {
                this.sliderArray[i].setValue(50);
            }
            this.hiddenRadioButton.setSelected(true);
            this.showContinueMenu(false);
            if (this.m_mdFdr) {
                this.m_mdFdrComparisonList.clear();
            }
        }
    }

    public void resetLog() {
        this.m_LogSlider.setRows(0);
        this.m_LogSlider.invalidate();
        this.m_LogSlider.selectAll();
        this.m_LogSlider.setText("");
        this.showInitialMessages();
    }

    public void showProfilesInLog() {
        if (this.m_mdFdr) {
            for (int i = 0; i < this.m_mdFdrComparisonList.size(); ++i) {
                MdFdrComparisonItem item = (MdFdrComparisonItem)this.m_mdFdrComparisonList.get(i);
                this.m_LogSlider.append("  " + (i + 1) + ") " + "Pairwise comparison " + item.toDisplayString(this.m_GroupNameArray) + "\n");
            }
        } else {
            for (int i = 0; i < this.m_LastProfileIndex; ++i) {
                this.m_LogSlider.append(this.m_MainDoc.generateProfileString(i, false));
            }
        }
        this.m_LogSlider.setCaretPosition(this.m_LogSlider.getDocument().getLength());
    }

    public void modifyInputsButtonEvent(ActionEvent evt) {
        this.m_MainDoc.popupInputWindow();
        this.showContinueMenu(false);
    }

    public void sliderHelpButtonEvent(ActionEvent evt) {
        LocatorClass locator = new LocatorClass();
        HelpWindow hw = new HelpWindow("ORIOGEN Help", locator.pathString + "/slider_help.htm");
    }

    @Override
    public void showProgressWindow(boolean flag) {
        this.m_MainDoc.showProgressWindow(flag);
    }

    @Override
    public void updateProgress(String msg1, String msg2) {
        this.m_MainDoc.updateProgress(msg1, msg2);
    }

    private class ManualInputChangeHandler
    implements ActionListener,
    KeyListener {
        private ManualInputChangeHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            this.updateSliders();
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            JTextField textField;
            if (e.getComponent() == SliderWindow.this.upturnField) {
                textField = SliderWindow.this.upturnField;
            } else if (e.getComponent() == SliderWindow.this.downturnField) {
                textField = SliderWindow.this.downturnField;
            } else if (e.getComponent() == SliderWindow.this.cyclicUpturnField) {
                textField = SliderWindow.this.cyclicUpturnField;
            } else if (e.getComponent() == SliderWindow.this.cyclicDownturnField) {
                textField = SliderWindow.this.cyclicDownturnField;
            } else {
                return;
            }
            if (e.getKeyChar() < '0' || e.getKeyChar() > '9') {
                return;
            }
            String curText = textField.getText();
            String selText = textField.getSelectedText();
            String newText = String.valueOf(e.getKeyChar());
            if (selText == null) {
                textField.setText(curText + newText);
            } else {
                int start = textField.getSelectionStart();
                int end = textField.getSelectionEnd();
                StringBuffer buffer = new StringBuffer(curText);
                buffer.replace(start, end, newText);
                textField.setText(buffer.toString());
            }
            try {
                int node = Integer.parseInt(textField.getText().trim());
                if (node <= 1 && SliderWindow.this.m_NumTimePoints <= 10 || node >= SliderWindow.this.m_NumTimePoints) {
                    JOptionPane.showMessageDialog(SliderWindow.this.m_SliderWin, "The acceptable range is 2 to " + (SliderWindow.this.m_NumTimePoints - 1), "Error", 0);
                    e.consume();
                    return;
                }
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(SliderWindow.this.m_SliderWin, "You must enter a number", "Error", 0);
                e.consume();
                return;
            }
            this.updateSliders();
            e.consume();
        }

        private void updateSliders() {
            if (SliderWindow.this.m_mdFdr) {
                if (SliderWindow.this.mdfdrSingleComparison.isSelected()) {
                    SliderWindow.this.mdfdrComparePt1.setEnabled(true);
                    SliderWindow.this.mdfdrComparePt2.setEnabled(true);
                } else {
                    SliderWindow.this.mdfdrComparePt1.setEnabled(false);
                    SliderWindow.this.mdfdrComparePt2.setEnabled(false);
                }
                return;
            }
            int maxValue = SliderWindow.this.sliderArray[0].getMaximum();
            int incrValue = maxValue / (SliderWindow.this.m_NumTimePoints - 1);
            SliderWindow.this.downturnLabel.setEnabled(false);
            SliderWindow.this.downturnField.setEnabled(false);
            SliderWindow.this.upturnLabel.setEnabled(false);
            SliderWindow.this.upturnField.setEnabled(false);
            SliderWindow.this.cyclicDownturnLabel.setEnabled(false);
            SliderWindow.this.cyclicDownturnField.setEnabled(false);
            SliderWindow.this.cyclicUpturnLabel.setEnabled(false);
            SliderWindow.this.cyclicUpturnField.setEnabled(false);
            try {
                if (SliderWindow.this.increasingOrderButton.isSelected()) {
                    for (int i = 0; i < SliderWindow.this.m_NumTimePoints - 1; ++i) {
                        SliderWindow.this.sliderArray[i].setValue(i * incrValue);
                    }
                    SliderWindow.this.sliderArray[SliderWindow.this.m_NumTimePoints - 1].setValue(maxValue);
                } else if (SliderWindow.this.decreasingOrderButton.isSelected()) {
                    SliderWindow.this.sliderArray[0].setValue(maxValue);
                    for (int i = 0; i < SliderWindow.this.m_NumTimePoints - 1; ++i) {
                        SliderWindow.this.sliderArray[SliderWindow.this.m_NumTimePoints - i - 1].setValue(i * incrValue);
                    }
                } else if (SliderWindow.this.umbrellaPosButton.isSelected()) {
                    SliderWindow.this.downturnLabel.setEnabled(true);
                    SliderWindow.this.downturnField.setEnabled(true);
                    int node = Integer.parseInt(SliderWindow.this.downturnField.getText().trim());
                    if (node < SliderWindow.this.m_NumTimePoints && node > 1) {
                        int i;
                        SliderWindow.this.sliderArray[node - 1].setValue(maxValue);
                        for (i = 0; i < node - 1; ++i) {
                            SliderWindow.this.sliderArray[i].setValue((i + SliderWindow.this.m_NumTimePoints - node) * incrValue);
                        }
                        for (i = node; i < SliderWindow.this.m_NumTimePoints; ++i) {
                            SliderWindow.this.sliderArray[i].setValue(maxValue - (i - node + 1) * incrValue);
                        }
                    }
                } else if (SliderWindow.this.umbrellaNegButton.isSelected()) {
                    SliderWindow.this.upturnLabel.setEnabled(true);
                    SliderWindow.this.upturnField.setEnabled(true);
                    int node = Integer.parseInt(SliderWindow.this.upturnField.getText().trim());
                    if (node < SliderWindow.this.m_NumTimePoints && node > 1) {
                        int i;
                        SliderWindow.this.sliderArray[node - 1].setValue(0);
                        for (i = 0; i < node - 1; ++i) {
                            SliderWindow.this.sliderArray[i].setValue(maxValue - (i + (SliderWindow.this.m_NumTimePoints - node)) * incrValue);
                        }
                        for (i = node; i < SliderWindow.this.m_NumTimePoints; ++i) {
                            SliderWindow.this.sliderArray[i].setValue((i - node + 1) * incrValue);
                        }
                    }
                } else if (SliderWindow.this.cyclicButton.isSelected()) {
                    SliderWindow.this.cyclicDownturnLabel.setEnabled(true);
                    SliderWindow.this.cyclicDownturnField.setEnabled(true);
                    SliderWindow.this.cyclicUpturnLabel.setEnabled(true);
                    SliderWindow.this.cyclicUpturnField.setEnabled(true);
                    int node1 = Integer.parseInt(SliderWindow.this.cyclicUpturnField.getText().trim()) - 1;
                    int node2 = Integer.parseInt(SliderWindow.this.cyclicDownturnField.getText().trim()) - 1;
                    int incrValue2 = Math.abs(maxValue / (node2 - node1));
                    if (node1 < node2) {
                        int i;
                        for (i = 0; i <= node1; ++i) {
                            SliderWindow.this.sliderArray[i].setValue((node1 - i) * incrValue);
                        }
                        for (i = node1 + 1; i < node2; ++i) {
                            SliderWindow.this.sliderArray[i].setValue(SliderWindow.this.sliderArray[i - 1].getValue() + incrValue2);
                        }
                        SliderWindow.this.sliderArray[node2].setValue(maxValue);
                        for (i = node2 + 1; i < SliderWindow.this.m_NumTimePoints; ++i) {
                            SliderWindow.this.sliderArray[i].setValue(SliderWindow.this.sliderArray[i - 1].getValue() - incrValue);
                        }
                    } else if (node1 > node2) {
                        int i;
                        for (i = 0; i < node2; ++i) {
                            SliderWindow.this.sliderArray[i].setValue(maxValue - (node2 - i) * incrValue);
                        }
                        SliderWindow.this.sliderArray[node2].setValue(maxValue);
                        for (i = node2 + 1; i < node1; ++i) {
                            SliderWindow.this.sliderArray[i].setValue(SliderWindow.this.sliderArray[i - 1].getValue() - incrValue2);
                        }
                        SliderWindow.this.sliderArray[node1].setValue(0);
                        for (i = node1 + 1; i < SliderWindow.this.m_NumTimePoints; ++i) {
                            SliderWindow.this.sliderArray[i].setValue(SliderWindow.this.sliderArray[i - 1].getValue() + incrValue);
                        }
                    }
                } else if (SliderWindow.this.allNonCyclicButton.isSelected()) {
                    for (int i = 0; i < SliderWindow.this.m_NumTimePoints; ++i) {
                        SliderWindow.this.sliderArray[i].setValue(50);
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private class HelpContentsMenuHandler
    implements ActionListener {
        private HelpContentsMenuHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            LocatorClass locator = new LocatorClass();
            HelpWindow hw = new HelpWindow("ORIOGEN Help", locator.pathString + "/contents_help.htm");
        }
    }

    private class HelpAboutMenuHandler
    implements ActionListener {
        private HelpAboutMenuHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            LocatorClass locator = new LocatorClass();
            HelpWindow hw = new HelpWindow("ORIOGEN Help", locator.pathString + "/about_help.htm");
        }
    }

    private class ViewMenuHandler
    implements ActionListener {
        private ViewMenuHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (SliderWindow.this.m_mdFdr) {
                try {
                    Runtime rt = Runtime.getRuntime();
                    Process process = rt.exec(new String[]{"rundll32", "shell32.dll", "ShellExec_RunDLL", SliderWindow.this.m_OutputFileName});
                }
                catch (IOException ex) {}
            } else {
                ResultsViewer rv = new ResultsViewer();
                rv.processResults(SliderWindow.this.m_OutputFileName);
            }
        }
    }

    class MyPanel
    extends JPanel {
        MyPanel() {
        }

        @Override
        public void paintComponent(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            Dimension d = this.getSize();
            int gridWidth = d.width;
            int gridHeight = d.height;
            double x = 0.0;
            double ellipseWidth = 7.0;
            double ellipseHeight = 7.0;
            double xincr = 0.0;
            double y = d.height / 2;
            switch (SliderWindow.this.m_NumTimePoints) {
                case 2: {
                    x = (double)d.width / 2.3;
                    xincr = 80.0;
                    break;
                }
                case 3: {
                    x = (double)d.width / 2.6;
                    xincr = 80.0;
                    break;
                }
                case 4: {
                    x = (double)d.width / 4.0;
                    xincr = 80.0;
                    break;
                }
                case 5: {
                    x = (double)d.width / 7.5;
                    xincr = 80.0;
                    break;
                }
                case 6: {
                    x = (double)d.width / 16.0;
                    xincr = 80.0;
                    break;
                }
                case 7: {
                    x = (double)d.width / 13.0;
                    xincr = 60.0;
                    break;
                }
                case 8: {
                    x = (double)d.width / 6.0;
                    xincr = 40.0;
                    break;
                }
                case 9: {
                    x = (double)d.width / 10.0;
                    xincr = 40.0;
                    break;
                }
                case 10: {
                    x = (double)d.width / 10.0;
                    xincr = 40.0;
                    break;
                }
                case 11: {
                    x = (double)d.width / 10.0;
                    xincr = 40.0;
                    break;
                }
                case 12: {
                    x = (double)d.width / 15.0;
                    xincr = 40.0;
                    break;
                }
                case 13: {
                    x = (double)d.width / 15.0;
                    xincr = 35.0;
                    break;
                }
                case 14: {
                    x = (double)d.width / 20.0;
                    xincr = 35.0;
                    break;
                }
                default: {
                    x = d.width / SliderWindow.this.m_NumTimePoints;
                    xincr = d.width / (SliderWindow.this.m_NumTimePoints + 6);
                }
            }
            for (int i = 0; i < SliderWindow.this.m_NumTimePoints; ++i) {
                g2.fill(new Ellipse2D.Double(x + (double)i * xincr - ellipseWidth / 2.0, y + 50.0 - (double)SliderWindow.this.sliderArray[i].getValue() - ellipseWidth / 2.0, ellipseWidth, ellipseHeight));
                if (i >= SliderWindow.this.m_NumTimePoints - 1) continue;
                g2.draw(new Line2D.Double(x + (double)i * xincr, y + 50.0 - (double)SliderWindow.this.sliderArray[i].getValue(), x + (double)(i + 1) * xincr, y + 50.0 - (double)SliderWindow.this.sliderArray[i + 1].getValue()));
            }
            int profileType = SliderWindow.this.GetProfileType(false);
            if (profileType == -1) {
                g2.drawString("Profile Shown: Not determined", d.width / 4, d.height * 9 / 10);
            } else {
                g2.drawString("Profile Shown: " + SliderWindow.this.profileDesc, d.width / 5, d.height * 9 / 10);
            }
        }
    }
}

