/*
 * Decompiled with CFR 0.152.
 */
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;

public class ResultsViewer
extends JFrame {
    private final int FIRST_DATA_COLUMN = 6;
    private final int FIRST_DATA_COLUMN_WITH_QVALUE = 7;
    public int m_NumTimePoints;
    public String m_OutputFileName = "";
    private ArrayList m_ResultsList = new ArrayList();
    private ArrayList m_GraphList = new ArrayList();
    private JMenuBar m_MenuBar;
    private JRadioButtonMenuItem m_ViewRawMenuItem;
    private JRadioButtonMenuItem m_ViewFittedMenuItem;
    private JMenuItem m_ViewResultsFileMenuItem;
    private JTabbedPane m_TabbedPane;
    private ResultsGraph m_SelectedGraph = null;
    private TabChangeListener m_TabListener;
    public OpenMenuHandler m_OpenMenuHandler;
    private ArrayList m_ProfileDescList = new ArrayList();
    private JFrame m_ResultsWindow = this;

    public ResultsViewer() {
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic('F');
        JMenuItem saveMenuItem = new JMenuItem("Save Image to File");
        saveMenuItem.setMnemonic('S');
        saveMenuItem.setToolTipText("Save the graph image to a JPG file");
        fileMenu.add(saveMenuItem);
        JMenuItem openMenuItem = new JMenuItem("Open");
        openMenuItem.setMnemonic('O');
        openMenuItem.setToolTipText("Open a new file");
        fileMenu.add(openMenuItem);
        SaveMenuHandler saveMenuHandler = new SaveMenuHandler();
        saveMenuItem.addActionListener(saveMenuHandler);
        this.m_OpenMenuHandler = new OpenMenuHandler();
        openMenuItem.addActionListener(this.m_OpenMenuHandler);
        JMenu viewMenu = new JMenu("View");
        viewMenu.setMnemonic('V');
        this.m_ViewFittedMenuItem = new JRadioButtonMenuItem("Plots of Fitted Means");
        this.m_ViewFittedMenuItem.setMnemonic('F');
        this.m_ViewFittedMenuItem.setToolTipText("Show the fitted mean values on the graph");
        viewMenu.add(this.m_ViewFittedMenuItem);
        this.m_ViewRawMenuItem = new JRadioButtonMenuItem("Plots of Raw Means");
        this.m_ViewRawMenuItem.setMnemonic('R');
        this.m_ViewRawMenuItem.setToolTipText("Show the raw mean values on the graph");
        viewMenu.add(this.m_ViewRawMenuItem);
        viewMenu.addSeparator();
        this.m_ViewResultsFileMenuItem = new JMenuItem("Summary Statistics");
        this.m_ViewResultsFileMenuItem.setMnemonic('E');
        this.m_ViewResultsFileMenuItem.setToolTipText("View the contents of the summary statistics file in Excel or Notepad");
        viewMenu.add(this.m_ViewResultsFileMenuItem);
        ViewMenuHandler viewMenuHandler = new ViewMenuHandler();
        this.m_ViewFittedMenuItem.addActionListener(viewMenuHandler);
        this.m_ViewRawMenuItem.addActionListener(viewMenuHandler);
        ViewFileMenuHandler viewFileMenuHandler = new ViewFileMenuHandler();
        this.m_ViewResultsFileMenuItem.addActionListener(viewFileMenuHandler);
        JMenu helpMenu = new JMenu("Help");
        helpMenu.setMnemonic('H');
        JMenuItem helpContentsMenuItem = new JMenuItem("Graph Help");
        helpContentsMenuItem.setMnemonic('G');
        helpContentsMenuItem.setToolTipText("Get help on this screen");
        helpMenu.add(helpContentsMenuItem);
        HelpMenuHandler helpMenuHandler = new HelpMenuHandler();
        helpContentsMenuItem.addActionListener(helpMenuHandler);
        ButtonGroup viewGroup = new ButtonGroup();
        viewGroup.add(this.m_ViewFittedMenuItem);
        viewGroup.add(this.m_ViewRawMenuItem);
        this.m_ViewFittedMenuItem.setSelected(true);
        this.m_MenuBar = new JMenuBar();
        this.m_MenuBar.add(fileMenu);
        this.m_MenuBar.add(viewMenu);
        this.m_MenuBar.add(helpMenu);
        this.setJMenuBar(this.m_MenuBar);
        this.m_TabbedPane = new JTabbedPane();
        this.getContentPane().add(this.m_TabbedPane);
        this.m_TabListener = new TabChangeListener();
        this.m_TabbedPane.addChangeListener(this.m_TabListener);
        LocatorClass locator = new LocatorClass();
        Image image = Toolkit.getDefaultToolkit().getImage(locator.pathString + "/GRAPH05.GIF");
        if (image != null) {
            this.setIconImage(image);
        }
        this.setSize(600, 600);
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            // empty catch block
        }
        ResultsViewer vwr = new ResultsViewer();
        vwr.setDefaultCloseOperation(3);
        vwr.center();
        vwr.setVisible(true);
        vwr.m_OpenMenuHandler.actionPerformed(null);
    }

    private void center() {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle rect = this.getBounds();
        this.setLocation((screen.width - rect.width) / 2, (screen.height - rect.height) / 2);
    }

    public void processResults(String a_Filename) {
        this.processResults(a_Filename, 0);
    }

    public void processResults(String a_Filename, int numTimePoints) {
        boolean resultsFound = false;
        this.m_OutputFileName = a_Filename;
        this.m_NumTimePoints = numTimePoints;
        File outputFile = new File(a_Filename);
        if (outputFile.exists()) {
            if (this.m_NumTimePoints == 0) {
                this.m_NumTimePoints = this.ReadNumTimePoints(a_Filename);
            }
            this.ReadProfileDescriptions(a_Filename);
            this.ReadDataFile(a_Filename);
            int numProfiles = this.CalculateMaxNumProfiles(this.m_NumTimePoints);
            for (int i = 0; i <= numProfiles; ++i) {
                boolean sts = this.FindResults(i);
                if (!sts) continue;
                resultsFound = true;
                ResultsGraph graph = new ResultsGraph(i, this);
                this.m_GraphList.add(graph);
                this.m_TabbedPane.addTab("Profile #" + i, graph);
                graph.setSize(this.m_TabbedPane.getSize());
            }
            if (!resultsFound) {
                JLabel tmpLabel = new JLabel("No results found");
                this.m_TabbedPane.removeChangeListener(this.m_TabListener);
                this.m_TabbedPane.addTab("No Results Found", tmpLabel);
            }
            this.setVisible(true);
        } else {
            JOptionPane.showMessageDialog(this, "The output file (" + a_Filename + ") was not found.", "Error", 0);
        }
    }

    private int CalculateMaxNumProfiles(int a_NumTimePoints) {
        int returnValue = 0;
        if (a_NumTimePoints > 1) {
            returnValue = 2 * (a_NumTimePoints - 1);
            for (int i = 1; i < a_NumTimePoints - 2; ++i) {
                returnValue += 2 * i;
            }
        }
        return returnValue;
    }

    private void ReadDataFile(String a_Filename) {
        String tmpLine = "";
        int firstDataColumn = 6;
        try {
            BufferedReader rdr = new BufferedReader(new FileReader(a_Filename));
            while (tmpLine.indexOf("Index\t") != 0) {
                tmpLine = rdr.readLine();
                if (tmpLine != null) continue;
                System.out.println("No header line found in " + a_Filename);
                rdr.close();
                rdr = new BufferedReader(new FileReader(a_Filename));
                tmpLine = "";
                break;
            }
            if (tmpLine != null && tmpLine.indexOf("Q Value") > 0) {
                firstDataColumn = 7;
            }
            while ((tmpLine = rdr.readLine()) != null && !tmpLine.toLowerCase().contains("not selected")) {
                ResultDataStruct resultStruct = new ResultDataStruct(this.m_NumTimePoints);
                if (!resultStruct.parseString(tmpLine, firstDataColumn)) continue;
                this.m_ResultsList.add(resultStruct);
            }
            rdr.close();
        }
        catch (Exception e) {
            System.out.println("Exception in ReadDataFile (" + a_Filename + "): " + e.getMessage());
        }
    }

    private int ReadNumTimePoints(String a_Filename) {
        String tmpLine = "";
        int returnValue = 0;
        String SEARCH_STR = "Dose groups/Time points\t";
        try {
            BufferedReader rdr = new BufferedReader(new FileReader(a_Filename));
            while (tmpLine != null) {
                tmpLine = rdr.readLine();
                int strPos = tmpLine.indexOf("Dose groups/Time points\t");
                if (strPos < 0) continue;
                String tmpStr = tmpLine.substring(strPos + "Dose groups/Time points\t".length());
                returnValue = Integer.parseInt(tmpStr);
                break;
            }
            rdr.close();
        }
        catch (Exception e) {
            System.out.println("Exception in ReadDataFile (" + a_Filename + "): " + e.getMessage());
            returnValue = 0;
        }
        return returnValue;
    }

    private void ReadProfileDescriptions(String a_Filename) {
        String tmpLine = "";
        this.m_ProfileDescList.clear();
        try {
            BufferedReader rdr = new BufferedReader(new FileReader(a_Filename));
            while (tmpLine.indexOf("Profile Selections:") != 0) {
                tmpLine = rdr.readLine();
                if (tmpLine != null) continue;
                System.out.println("No profile descriptions found in " + a_Filename);
                rdr.close();
                return;
            }
            while (tmpLine.indexOf("Index\t") != 0) {
                tmpLine = rdr.readLine();
                int tabPos = tmpLine.indexOf(9);
                String desc = tmpLine.substring(tabPos + 1);
                this.m_ProfileDescList.add(desc);
            }
            rdr.close();
        }
        catch (Exception e) {
            System.out.println("Exception in ReadProfileDescriptions (" + a_Filename + "): " + e.getMessage());
        }
    }

    private boolean FindResults(int a_ProfileNum) {
        boolean returnValue = false;
        for (int i = 0; i < this.m_ResultsList.size(); ++i) {
            ResultDataStruct resultStruct = (ResultDataStruct)this.m_ResultsList.get(i);
            if (resultStruct.m_ProfileNum != a_ProfileNum) continue;
            returnValue = true;
            break;
        }
        return returnValue;
    }

    private String GetProfileDesc(int a_ProfileNum) {
        String returnValue = "";
        if (this.m_ProfileDescList.size() >= a_ProfileNum) {
            String tmpStr = (String)this.m_ProfileDescList.get(a_ProfileNum - 1);
            returnValue = " (" + tmpStr + ")";
        }
        return returnValue;
    }

    private String getExtension(File f) {
        String ext = "";
        String s = f.getName();
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            ext = s.substring(i + 1).toLowerCase();
        }
        return ext;
    }

    public static double getDoubleValue(String a_Str, boolean a_ShowError) {
        double returnValue;
        block4: {
            returnValue = -1.7976931348623157E308;
            try {
                returnValue = Double.parseDouble(a_Str);
            }
            catch (Exception ex) {
                try {
                    DecimalFormat fmt = new DecimalFormat();
                    returnValue = fmt.parse(a_Str).doubleValue();
                }
                catch (ParseException ex2) {
                    if (!a_ShowError) break block4;
                    JOptionPane.showMessageDialog(null, "Could not parse string <" + a_Str + ">");
                }
            }
        }
        return returnValue;
    }

    public class ResultsGraph
    extends JPanel {
        private int m_ProfileNum;
        private GraphPanel m_GraphPanel;
        private double m_YScaleFactor;
        private double m_YOffset;
        private double m_XScaleFactor;
        private double m_XOffset;
        private int m_height;
        private int m_width;
        private double m_MinY;
        private double m_MaxY;
        private boolean m_SavingImage;
        private boolean m_ViewRawData;
        private ResultsGraph m_ThisGraph = this;
        private int m_SelectedResult;
        private String m_YAxisStr;
        private JFrame m_ParentFrame;
        final int DEAD_Y_REGION = 40;
        final int DEAD_X_REGION = 60;
        final int TICK_HEIGHT = 10;
        final int MAX_COLORS = 7;
        private Color[] m_ColorArray;

        public ResultsGraph(int profileNum, JFrame parentFrame) {
            this.m_ParentFrame = parentFrame;
            this.m_SelectedResult = -1;
            this.m_YAxisStr = "Fitted Mean Values";
            this.m_ColorArray = new Color[7];
            this.m_ColorArray[0] = Color.BLUE;
            this.m_ColorArray[1] = Color.GREEN;
            this.m_ColorArray[2] = Color.ORANGE;
            this.m_ColorArray[3] = Color.RED;
            this.m_ColorArray[4] = new Color(0, 128, 200);
            this.m_ColorArray[5] = new Color(128, 128, 0);
            this.m_ColorArray[6] = new Color(0, 100, 0);
            this.m_ProfileNum = profileNum;
            this.m_GraphPanel = new GraphPanel();
            this.setLayout(new GridLayout(0, 1, 0, 0));
            this.add(this.m_GraphPanel);
            this.setVisible(true);
        }

        private void calculateScaling() {
            double minValue = 9999.9;
            double maxValue = -9999.9;
            for (int i = 0; i < ResultsViewer.this.m_ResultsList.size(); ++i) {
                ResultDataStruct resultStruct = (ResultDataStruct)ResultsViewer.this.m_ResultsList.get(i);
                if (resultStruct.m_ProfileNum != this.m_ProfileNum) continue;
                for (int j = 0; j < ResultsViewer.this.m_NumTimePoints; ++j) {
                    if (resultStruct.m_RawResults[j] < minValue) {
                        minValue = resultStruct.m_RawResults[j];
                    }
                    if (!(resultStruct.m_RawResults[j] > maxValue)) continue;
                    maxValue = resultStruct.m_RawResults[j];
                }
            }
            if (maxValue < minValue + 0.01) {
                maxValue = minValue + 0.01;
            }
            this.m_YScaleFactor = -1.0 * (double)(this.m_height - 40) / ((maxValue - minValue) * 1.5);
            this.m_YOffset = (double)(this.m_height - 40) / 6.0 - this.m_YScaleFactor * maxValue;
            this.m_XScaleFactor = (double)this.m_width / ((double)ResultsViewer.this.m_NumTimePoints + 0.5);
            this.m_XOffset = 60 - (int)(this.m_XScaleFactor / 2.0);
            this.m_MinY = minValue;
            this.m_MaxY = maxValue;
        }

        public void ChangeView(boolean a_ViewRawData) {
            this.m_ViewRawData = a_ViewRawData;
            this.m_YAxisStr = this.m_ViewRawData ? "Raw Mean Values" : "Fitted Mean Values";
            this.m_height = 0;
            this.m_ThisGraph.paintAll(this.m_ThisGraph.getGraphics());
        }

        public void saveComponentAsJPEG(String filename) {
            Dimension size = this.m_GraphPanel.getSize();
            BufferedImage myImage = new BufferedImage(size.width, size.height, 1);
            Graphics2D g2 = myImage.createGraphics();
            ResultsViewer.this.getContentPane().setBackground(Color.WHITE);
            this.m_SavingImage = true;
            this.m_GraphPanel.paint(g2);
            this.m_SavingImage = false;
            try {
                FileOutputStream out = new FileOutputStream(filename);
                JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)out);
                encoder.encode(myImage);
                ((OutputStream)out).close();
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }

        public int profileNum() {
            return this.m_ProfileNum;
        }

        private class GraphPanel
        extends JPanel {
            public GraphPanel() {
                this.addMouseListener(new MouseAdapterClass());
            }

            @Override
            public void paint(Graphics g) {
                int endX;
                int endY;
                int startY;
                int startX;
                int i;
                int colorIndex = 0;
                DecimalFormat decFormat = new DecimalFormat("0.00");
                super.paint(g);
                Graphics2D g2d = (Graphics2D)g;
                g2d.setStroke(new BasicStroke(2.0f));
                Dimension size = ResultsGraph.this.m_GraphPanel.getSize();
                if (size.height != ResultsGraph.this.m_height || size.width != ResultsGraph.this.m_width) {
                    ResultsGraph.this.m_height = size.height;
                    ResultsGraph.this.m_width = size.width;
                    ResultsGraph.this.calculateScaling();
                }
                Rectangle rect = this.getBounds();
                g.setColor(Color.WHITE);
                g.fillRect(0, 0, rect.width, rect.height);
                g.setColor(Color.BLACK);
                g.drawLine(60, size.height - 40, size.width, size.height - 40);
                g.drawLine(60, size.height - 40, 60, 0);
                for (i = 0; i < ResultsViewer.this.m_NumTimePoints; ++i) {
                    startX = (int)((double)(i + 1) * ResultsGraph.this.m_XScaleFactor + ResultsGraph.this.m_XOffset);
                    startY = size.height - 40 + 10;
                    endY = size.height - 40 - 10;
                    g.drawLine(startX, startY, startX, endY);
                    g.drawString(String.valueOf(i + 1), startX - 2, startY + 13);
                }
                startX = (int)((double)(ResultsViewer.this.m_NumTimePoints + 1) / 2.0 * ResultsGraph.this.m_XScaleFactor + ResultsGraph.this.m_XOffset - 5.0);
                startY = size.height - 4;
                g.drawString("Time/Dose Points", startX - 35, startY);
                startX = 3;
                startY = (size.height - 40 - ResultsGraph.this.m_YAxisStr.length() * 15) / 2;
                if (startY < 0) {
                    startY = 0;
                }
                for (i = 0; i < ResultsGraph.this.m_YAxisStr.length(); ++i) {
                    endY = startY + i * 15;
                    g.drawString(ResultsGraph.this.m_YAxisStr.substring(i, i + 1), startX, endY);
                }
                for (i = 1; i < 6; ++i) {
                    startX = 50;
                    endX = 70;
                    startY = (size.height - 40) * (6 - i) / 6;
                    g.drawLine(startX, startY, endX, startY);
                    String yStr = decFormat.format(ResultsGraph.this.m_MinY + (ResultsGraph.this.m_MaxY - ResultsGraph.this.m_MinY) * (double)(i - 1) / 4.0);
                    g.drawString(yStr, 20, startY + 4);
                }
                g2d.setStroke(new BasicStroke(1.0f));
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                for (i = 0; i < ResultsViewer.this.m_ResultsList.size(); ++i) {
                    ResultDataStruct resultStruct = (ResultDataStruct)ResultsViewer.this.m_ResultsList.get(i);
                    if (resultStruct.m_ProfileNum != ResultsGraph.this.m_ProfileNum) continue;
                    if (resultStruct.m_Index == ResultsGraph.this.m_SelectedResult) {
                        g2d.setStroke(new BasicStroke(4.0f));
                    }
                    g.setColor(ResultsGraph.this.m_ColorArray[colorIndex]);
                    for (int j = 1; j < ResultsViewer.this.m_NumTimePoints; ++j) {
                        startX = (int)((double)j * ResultsGraph.this.m_XScaleFactor + ResultsGraph.this.m_XOffset);
                        endX = (int)((double)(j + 1) * ResultsGraph.this.m_XScaleFactor + ResultsGraph.this.m_XOffset);
                        startY = (int)(resultStruct.m_Results[j - 1] * ResultsGraph.this.m_YScaleFactor + ResultsGraph.this.m_YOffset);
                        endY = (int)(resultStruct.m_Results[j] * ResultsGraph.this.m_YScaleFactor + ResultsGraph.this.m_YOffset);
                        g.drawLine(startX, startY, endX, endY);
                    }
                    if (resultStruct.m_Index == ResultsGraph.this.m_SelectedResult) {
                        g2d.setStroke(new BasicStroke(1.0f));
                    }
                    if (++colorIndex < 7) continue;
                    colorIndex = 0;
                }
            }

            private int findClosestLine(int a_X, int a_Y) {
                int returnValue = -1;
                if ((double)a_X < ResultsGraph.this.m_XScaleFactor + ResultsGraph.this.m_XOffset) {
                    return -1;
                }
                if ((double)a_X > (double)ResultsViewer.this.m_NumTimePoints * ResultsGraph.this.m_XScaleFactor + ResultsGraph.this.m_XOffset) {
                    return -1;
                }
                double minDist = 9.9999999E7;
                for (int i = 0; i < ResultsViewer.this.m_ResultsList.size(); ++i) {
                    ResultDataStruct resultStruct = (ResultDataStruct)ResultsViewer.this.m_ResultsList.get(i);
                    if (resultStruct.m_ProfileNum != ResultsGraph.this.m_ProfileNum) continue;
                    for (int j = 1; j < ResultsViewer.this.m_NumTimePoints; ++j) {
                        int endY;
                        int startX = (int)((double)j * ResultsGraph.this.m_XScaleFactor + ResultsGraph.this.m_XOffset);
                        int endX = (int)((double)(j + 1) * ResultsGraph.this.m_XScaleFactor + ResultsGraph.this.m_XOffset);
                        int startY = (int)(resultStruct.m_Results[j - 1] * ResultsGraph.this.m_YScaleFactor + ResultsGraph.this.m_YOffset);
                        double tmpDist = this.findDistance(a_X, a_Y, startX, startY, endX, endY = (int)(resultStruct.m_Results[j] * ResultsGraph.this.m_YScaleFactor + ResultsGraph.this.m_YOffset));
                        if (!(tmpDist > 0.0) || !(tmpDist < minDist)) continue;
                        minDist = tmpDist;
                        returnValue = i;
                    }
                }
                return returnValue;
            }

            private double findDistance(int x3, int y3, int x1, int y1, int x2, int y2) {
                double u = (double)((x3 - x1) * (x2 - x1) + (y3 - y1) * (y2 - y1)) / (double)((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
                if (u < 0.0 || u > 1.0) {
                    return -1.0;
                }
                double newX = (double)x1 + u * (double)(x2 - x1);
                double newY = (double)y1 + u * (double)(y2 - y1);
                double returnValue = (newX - (double)x3) * (newX - (double)x3) + (newY - (double)y3) * (newY - (double)y3);
                return returnValue;
            }

            private class MouseAdapterClass
            implements MouseListener {
                private MouseAdapterClass() {
                }

                @Override
                public void mousePressed(MouseEvent evt) {
                }

                @Override
                public void mouseReleased(MouseEvent evt) {
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    int index = GraphPanel.this.findClosestLine(e.getX(), e.getY());
                    if (index > -1) {
                        ResultDataStruct rds = (ResultDataStruct)ResultsViewer.this.m_ResultsList.get(index);
                        ResultsGraph.this.m_SelectedResult = rds.m_Index;
                        ResultsGraph.this.m_ThisGraph.repaint();
                        JOptionPane.showMessageDialog(ResultsViewer.this.getContentPane(), rds.describeGene(), "Selected (Highlighted) Gene", 1);
                    } else {
                        ResultsGraph.this.m_SelectedResult = -1;
                        ResultsGraph.this.m_ThisGraph.repaint();
                    }
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                }

                @Override
                public void mouseExited(MouseEvent e) {
                }
            }
        }
    }

    public class ResultDataStruct {
        public int m_Index;
        public int m_InitialIndex;
        public String m_GeneId;
        public int m_ProfileNum;
        public double m_PValue1;
        public double[] m_FittedResults;
        public double[] m_RawResults;
        public double[] m_Results;
        public String m_GeneDesc;
        private int m_NumTimePoints;

        public ResultDataStruct(int numTimePoints) {
            this.m_NumTimePoints = numTimePoints;
            this.m_FittedResults = new double[numTimePoints];
            this.m_RawResults = new double[numTimePoints];
            this.m_Results = new double[numTimePoints];
        }

        public boolean parseString(String a_String, int a_FirstDataColumn) {
            boolean returnValue = true;
            int index = 0;
            int lastFittedPoint = this.m_NumTimePoints + a_FirstDataColumn;
            int lastRawMean = this.m_NumTimePoints * 2 + a_FirstDataColumn;
            int minLength = 3 * this.m_NumTimePoints + a_FirstDataColumn;
            try {
                String[] tokens = a_String.split("\t");
                if (tokens.length < minLength) {
                    return false;
                }
                this.m_Index = Integer.parseInt(tokens[0]);
                this.m_InitialIndex = Integer.parseInt(tokens[1]);
                this.m_GeneId = tokens[2];
                this.m_GeneDesc = tokens[3];
                this.m_ProfileNum = Integer.parseInt(tokens[4]);
                this.m_PValue1 = ResultsViewer.getDoubleValue(tokens[5], true);
                if (this.m_PValue1 < 0.0) {
                    returnValue = false;
                } else {
                    for (index = a_FirstDataColumn; index < lastFittedPoint; ++index) {
                        this.m_FittedResults[index - a_FirstDataColumn] = ResultsViewer.getDoubleValue(tokens[index], false);
                        this.m_Results[index - a_FirstDataColumn] = this.m_FittedResults[index - a_FirstDataColumn];
                    }
                    for (index = lastFittedPoint; index < lastRawMean; ++index) {
                        this.m_RawResults[index - lastFittedPoint] = ResultsViewer.getDoubleValue(tokens[index], false);
                    }
                }
            }
            catch (Exception e) {
                returnValue = false;
            }
            return returnValue;
        }

        public void toggleViewResults(boolean a_ViewRawData) {
            if (a_ViewRawData) {
                for (int i = 0; i < this.m_NumTimePoints; ++i) {
                    this.m_Results[i] = this.m_RawResults[i];
                }
            } else {
                for (int i = 0; i < this.m_NumTimePoints; ++i) {
                    this.m_Results[i] = this.m_FittedResults[i];
                }
            }
        }

        public String describeGene() {
            String returnValue = "Gene ID: " + this.m_GeneId;
            if (this.m_GeneDesc.length() > 0) {
                returnValue = returnValue + "\nDescription: " + this.m_GeneDesc;
            }
            return returnValue;
        }
    }

    public class JpgFileFilter
    extends FileFilter {
        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String extension = ResultsViewer.this.getExtension(f);
            if (extension != "") {
                return extension.equals("jpg") || extension.equals("jpeg");
            }
            return false;
        }

        @Override
        public String getDescription() {
            return "Images (JPG)";
        }
    }

    private class TabChangeListener
    implements ChangeListener {
        private TabChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent event) {
            String prefix = ResultsViewer.this.m_ViewRawMenuItem.isSelected() ? "Raw Means" : "Fitted Means";
            ResultsViewer.this.m_SelectedGraph = (ResultsGraph)ResultsViewer.this.m_TabbedPane.getSelectedComponent();
            String suffix = ResultsViewer.this.GetProfileDesc(ResultsViewer.this.m_SelectedGraph.profileNum());
            ResultsViewer.this.setTitle(prefix + " for Profile #" + ResultsViewer.this.m_SelectedGraph.profileNum() + suffix);
        }
    }

    private class HelpMenuHandler
    implements ActionListener {
        private HelpMenuHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            LocatorClass locator = new LocatorClass();
            HelpWindow hw = new HelpWindow("", locator.pathString + "/graph_help.htm");
        }
    }

    private class ViewMenuHandler
    implements ActionListener {
        private ViewMenuHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            int i;
            boolean viewRawData = false;
            String suffix = "";
            String prefix = "";
            if (event.getSource() == ResultsViewer.this.m_ViewRawMenuItem) {
                viewRawData = true;
                prefix = "Raw Means";
            } else {
                viewRawData = false;
                prefix = "Fitted Means";
            }
            suffix = ResultsViewer.this.GetProfileDesc(ResultsViewer.this.m_SelectedGraph.profileNum());
            for (i = 0; i < ResultsViewer.this.m_ResultsList.size(); ++i) {
                ResultDataStruct resultStruct = (ResultDataStruct)ResultsViewer.this.m_ResultsList.get(i);
                resultStruct.toggleViewResults(viewRawData);
            }
            for (i = 0; i < ResultsViewer.this.m_GraphList.size(); ++i) {
                ResultsGraph tmpGraph = (ResultsGraph)ResultsViewer.this.m_GraphList.get(i);
                tmpGraph.ChangeView(viewRawData);
                if (tmpGraph != ResultsViewer.this.m_SelectedGraph) continue;
                ResultsViewer.this.setTitle(prefix + " for Profile #" + ResultsViewer.this.m_SelectedGraph.profileNum() + suffix);
            }
        }
    }

    private class ViewFileMenuHandler
    implements ActionListener {
        private ViewFileMenuHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            try {
                Runtime rt = Runtime.getRuntime();
                Process process = rt.exec(new String[]{"rundll32", "shell32.dll", "ShellExec_RunDLL", ResultsViewer.this.m_OutputFileName});
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "This option is not available on this system");
            }
        }
    }

    private class OpenMenuHandler
    implements ActionListener {
        private OpenMenuHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            int returnVal;
            JFileChooser fc = new JFileChooser();
            File file = new File(ResultsViewer.this.m_OutputFileName);
            if (file.exists()) {
                fc.setSelectedFile(file);
                fc.setCurrentDirectory(file);
            }
            if ((returnVal = fc.showDialog(ResultsViewer.this.m_ResultsWindow, "Select Results File")) == 0) {
                ResultsViewer.this.m_OutputFileName = fc.getSelectedFile().getAbsolutePath();
                ResultsViewer.this.m_ResultsList.clear();
                ResultsViewer.this.m_GraphList.clear();
                ResultsViewer.this.m_ProfileDescList.clear();
                ResultsViewer.this.m_SelectedGraph = null;
                ResultsViewer.this.m_TabbedPane.removeChangeListener(ResultsViewer.this.m_TabListener);
                ResultsViewer.this.m_TabbedPane.removeAll();
                ResultsViewer.this.m_TabbedPane.addChangeListener(ResultsViewer.this.m_TabListener);
                ResultsViewer.this.processResults(ResultsViewer.this.m_OutputFileName);
            }
        }
    }

    private class SaveMenuHandler
    implements ActionListener {
        private SaveMenuHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (ResultsViewer.this.m_SelectedGraph != null) {
                JFileChooser fileChooser = new JFileChooser();
                JpgFileFilter filter = new JpgFileFilter();
                fileChooser.setFileSelectionMode(0);
                fileChooser.setFileFilter(filter);
                int result = fileChooser.showSaveDialog(ResultsViewer.this.getContentPane());
                if (result == 0) {
                    String filename = fileChooser.getSelectedFile().getPath();
                    String ext = ResultsViewer.this.getExtension(fileChooser.getSelectedFile());
                    if (ext.length() == 0) {
                        filename = filename + ".jpg";
                    }
                    ResultsViewer.this.m_SelectedGraph.saveComponentAsJPEG(filename);
                }
                ResultsViewer.this.getContentPane().invalidate();
            }
        }
    }
}

