/*
 * Decompiled with CFR 0.152.
 */
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class ProgressWindow
extends JFrame {
    private JLabel m_ProgressLabel = new JLabel("   Processing Gene 0 of 0");
    private JLabel m_GeneSelectedLabel = new JLabel("   Number of Genes Selected = 0");
    private JButton m_StopButton = new JButton("Stop Processing");
    private GeneProcessor m_GeneProcessor;

    public ProgressWindow() {
        this.setSize(340, 120);
        this.setAlwaysOnTop(true);
        this.getContentPane().setLayout(new GridLayout(0, 1, 5, 0));
        this.getContentPane().add(this.m_ProgressLabel);
        this.getContentPane().add(this.m_GeneSelectedLabel);
        this.getContentPane().add(this.m_StopButton);
        this.m_StopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProgressWindow.this.stopButtonPressed(evt);
            }
        });
        LocatorClass locator = new LocatorClass();
        Image image = Toolkit.getDefaultToolkit().getImage(locator.pathString + "/GRAPH05.GIF");
        if (image != null) {
            this.setIconImage(image);
        }
    }

    public void setGeneProcessor(GeneProcessor geneProc) {
        this.m_GeneProcessor = geneProc;
    }

    private void stopButtonPressed(ActionEvent evt) {
        if (this.m_GeneProcessor != null) {
            this.m_GeneProcessor.stopProcessing();
        }
    }

    public void updateStatus(String a_ProgressStr, String a_GeneStr) {
        this.m_ProgressLabel.setText("    " + a_ProgressStr);
        this.m_GeneSelectedLabel.setText("    " + a_GeneStr);
    }
}

