/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class Origen_Data
implements OriogenConstants {
    private final String SETTINGS_FILENAME = "InputSettings.txt";
    private boolean m_Transpose;
    private int m_NumGenes;
    public int m_NumTimePoints;
    private int m_NumProfiles;
    private int m_NumInitialBootStraps;
    private int m_MaxNumBootStraps;
    private double m_FDRLevel;
    private double m_S0Percentile;
    private int m_RandomSeed = -1;
    private String m_InputFileName = "";
    private String m_OutputFileName = "SelectedGenes.txt";
    private String m_LookupFileName = "Agilent_RatOligo.txt";
    private String m_ErrorFileName;
    private int m_LogTransformType;
    private boolean m_LongitudinalSampling;
    private boolean m_mdFdr;
    private boolean m_TwoGroups;
    private List m_mdFdrComparisonList = new ArrayList();
    private String m_NumSampleSizesText;
    private int m_NumDataColumns;
    private boolean m_ResultsShown = false;
    private boolean m_HeaderRowPresent = false;
    private boolean m_DescColumnPresent = false;
    private int[] m_SampleSizeDefault = new int[30];
    private String[] m_GroupNameArray = new String[30];
    private int m_NumGenesSelected = 0;
    private int m_LinesReadAtUserBreak = 0;
    private int m_NumErrors = 0;
    private String m_TransposeInputFileName;
    private double m_SubRegionPValue = 0.1;
    private boolean m_CheckSubRegions = false;
    private ProfileStruct[] m_ProfileTable = new ProfileStruct[200];
    private int m_LastProfileIndex = 0;
    private SliderWindow m_SliderWin;
    private JPanel m_LogPanel;
    private Timer m_DeathTimer;
    private DeathTimerTask m_HideSplashTimerTask;
    private JFrame m_SplashWindow;
    private JFrame m_InputFrame;
    private ProgressWindow m_ProgressWin;
    private GeneProcessor m_GeneProcessor;

    public Origen_Data() {
        int i;
        for (i = 0; i < 200; ++i) {
            this.m_ProfileTable[i] = new ProfileStruct(i + 1);
        }
        for (i = 0; i < 30; ++i) {
            this.m_GroupNameArray[i] = "Group" + (i + 1);
        }
    }

    public boolean getTranspose() {
        return this.m_Transpose;
    }

    public void setTranspose(boolean value) {
        this.m_Transpose = value;
    }

    public int getNumGenes() {
        return this.m_NumGenes;
    }

    public void setNumGenes(int value) {
        this.m_NumGenes = value;
    }

    public int getNumTimePoints() {
        return this.m_NumTimePoints;
    }

    public void setNumTimePoints(int value) {
        this.m_NumTimePoints = value;
    }

    public int getNumInitialBootStraps() {
        return this.m_NumInitialBootStraps;
    }

    public void setNumInitialBootStraps(int value) {
        this.m_NumInitialBootStraps = value;
    }

    public int getMaxNumBootStraps() {
        return this.m_MaxNumBootStraps;
    }

    public void setMaxNumBootStraps(int value) {
        this.m_MaxNumBootStraps = value;
    }

    public double getFDRLevel() {
        return this.m_FDRLevel;
    }

    public void setFDRLevel(double value) {
        this.m_FDRLevel = value;
    }

    public double getS0Percentile() {
        return this.m_S0Percentile;
    }

    public void setS0Percentile(double value) {
        this.m_S0Percentile = value;
    }

    public int getRandomSeed() {
        return this.m_RandomSeed;
    }

    public void setRandomSeed(int value) {
        this.m_RandomSeed = value;
    }

    public String getInputFileName() {
        return this.m_InputFileName;
    }

    public void setInputFileName(String value) {
        this.m_InputFileName = value;
    }

    public String getOutputFileName() {
        return this.m_OutputFileName;
    }

    public void setOutputFileName(String value) {
        this.m_OutputFileName = value;
    }

    public String getLookupFileName() {
        return this.m_LookupFileName;
    }

    public void setLookupFileName(String value) {
        this.m_LookupFileName = value;
    }

    public String getErrorFileName() {
        return this.m_ErrorFileName;
    }

    public void setErrorFileName(String value) {
        this.m_ErrorFileName = value;
    }

    public int getLogTransformType() {
        return this.m_LogTransformType;
    }

    public void setLogTransformType(int value) {
        this.m_LogTransformType = value;
    }

    public boolean getLongitudinalSampling() {
        return this.m_LongitudinalSampling;
    }

    public void setLongitudinalSampling(boolean value) {
        this.m_LongitudinalSampling = value;
    }

    public boolean getmdFdr() {
        return this.m_mdFdr;
    }

    public void setmdFdr(boolean value) {
        this.m_mdFdr = value;
    }

    public boolean getTwoGroups() {
        return this.m_TwoGroups;
    }

    public void setTwoGroups(boolean value) {
        this.m_TwoGroups = value;
    }

    public int[] getSampleSizeDefault() {
        return this.m_SampleSizeDefault;
    }

    public void setSampleSizeDefault(int[] values) {
        this.m_SampleSizeDefault = values;
    }

    public int getNumDataColumns() {
        return this.m_NumDataColumns;
    }

    public String getNumSampleSizesText() {
        return this.m_NumSampleSizesText;
    }

    public boolean getCheckSubRegions() {
        return this.m_CheckSubRegions;
    }

    public void setCheckSubRegions(boolean value) {
        this.m_CheckSubRegions = value;
    }

    public double getSubRegionPValue() {
        return this.m_SubRegionPValue;
    }

    public void setSubRegionPValue(double value) {
        this.m_SubRegionPValue = value;
    }

    public String[] getGroupNameArray() {
        return this.m_GroupNameArray;
    }

    public boolean getDescColumnPresent() {
        return this.m_DescColumnPresent;
    }

    public boolean getHeaderRowPresent() {
        return this.m_HeaderRowPresent;
    }

    public ProfileStruct[] getProfileTable() {
        return this.m_ProfileTable;
    }

    public String getTransposeInputFileName() {
        return this.m_TransposeInputFileName;
    }

    public String createSampleSizeString() {
        int i;
        String returnValue = "";
        for (i = 1; i <= this.m_NumTimePoints; ++i) {
            returnValue = returnValue + String.valueOf(this.m_SampleSizeDefault[i]);
            if (i >= this.m_NumTimePoints) continue;
            returnValue = returnValue + ",";
        }
        if (this.m_TwoGroups) {
            returnValue = returnValue + " / ";
            for (i = this.m_NumTimePoints + 1; i <= 2 * this.m_NumTimePoints; ++i) {
                returnValue = returnValue + String.valueOf(this.m_SampleSizeDefault[i]);
                if (i >= 2 * this.m_NumTimePoints) continue;
                returnValue = returnValue + ",";
            }
        }
        return returnValue;
    }

    public void createAndShowGUI() {
        this.m_SplashWindow = new JFrame();
        SplashPanel splashPanel = new SplashPanel();
        splashPanel.setOpaque(true);
        this.m_SplashWindow.setContentPane(splashPanel);
        this.m_SplashWindow.setBounds(0, 0, 500, 500);
        this.m_SplashWindow.setVisible(true);
        UtilityFunctions.centerInScreen(this.m_SplashWindow);
        JFrame.setDefaultLookAndFeelDecorated(true);
        this.m_SliderWin = new SliderWindow(this);
        this.m_InputFrame = new JFrame("ORIOGEN Version 4.01 -- Inputs");
        this.m_InputFrame.setDefaultCloseOperation(3);
        this.readInputSettings();
        InitialInputWindow newContentPane = new InitialInputWindow(this.m_InputFrame, this);
        newContentPane.setOpaque(true);
        this.m_InputFrame.setContentPane(newContentPane);
        this.m_DeathTimer = new Timer();
        this.m_HideSplashTimerTask = new DeathTimerTask();
        this.m_DeathTimer.schedule((TimerTask)this.m_HideSplashTimerTask, 2000L);
        this.m_ProgressWin = new ProgressWindow();
        UtilityFunctions.centerInScreen(this.m_ProgressWin);
    }

    public void popupInputWindow() {
        this.m_InputFrame.setDefaultCloseOperation(1);
        this.m_InputFrame.setVisible(true);
    }

    public void initialInputWindowClosed() {
        this.saveInputSettings();
        int lastSlash = this.m_OutputFileName.lastIndexOf("\\");
        if (lastSlash == -1) {
            lastSlash = this.m_OutputFileName.lastIndexOf("/");
        }
        this.m_ErrorFileName = lastSlash == -1 ? "Errors.txt" : this.m_OutputFileName.substring(0, lastSlash + 1) + "Errors.txt";
        lastSlash = this.m_InputFileName.lastIndexOf("\\");
        if (lastSlash == -1) {
            lastSlash = this.m_InputFileName.lastIndexOf("/");
        }
        this.m_TransposeInputFileName = lastSlash == -1 ? "TransposeInput.txt" : this.m_InputFileName.substring(0, lastSlash + 1) + "TransposeInput.txt";
        this.m_SliderWin.initialize();
        this.m_SliderWin.setVisible(true);
        this.m_SliderWin.generate_sliders();
        this.m_SliderWin.resetLog();
        this.m_SliderWin.showProfilesInLog();
        this.m_SliderWin.showPanels();
    }

    private void readInputSettings() {
        try {
            BufferedReader rdr = new BufferedReader(new FileReader("InputSettings.txt"));
            this.m_InputFileName = rdr.readLine();
            this.m_OutputFileName = rdr.readLine();
            String inpLine = rdr.readLine();
            this.m_NumTimePoints = Integer.parseInt(inpLine);
            this.m_NumSampleSizesText = rdr.readLine();
            inpLine = rdr.readLine();
            this.m_NumInitialBootStraps = Integer.parseInt(inpLine);
            inpLine = rdr.readLine();
            this.m_FDRLevel = Double.parseDouble(inpLine);
            this.m_LookupFileName = inpLine = rdr.readLine();
            inpLine = rdr.readLine();
            this.m_RandomSeed = Integer.parseInt(inpLine);
            inpLine = rdr.readLine();
            double tmpDouble = ResultsViewer.getDoubleValue(inpLine, false);
            if (tmpDouble > 0.0 && tmpDouble <= 1.0) {
                this.m_SubRegionPValue = tmpDouble;
            }
            inpLine = rdr.readLine().trim();
            inpLine = rdr.readLine().trim();
            if (inpLine != null) {
                try {
                    this.m_LogTransformType = Integer.parseInt(inpLine);
                }
                catch (NumberFormatException ex) {
                    this.m_LogTransformType = 0;
                }
            }
            if ((inpLine = rdr.readLine().trim()) != null) {
                this.m_Transpose = Boolean.valueOf(inpLine);
            }
            if ((inpLine = rdr.readLine().trim()) != null) {
                this.m_MaxNumBootStraps = Integer.parseInt(inpLine);
            }
            if ((inpLine = rdr.readLine().trim()) != null) {
                this.m_LongitudinalSampling = Boolean.valueOf(inpLine);
            }
            if ((inpLine = rdr.readLine().trim()) != null) {
                this.m_S0Percentile = Double.parseDouble(inpLine);
            }
            if ((inpLine = rdr.readLine().trim()) != null) {
                this.m_mdFdr = Boolean.valueOf(inpLine);
            }
            if ((inpLine = rdr.readLine().trim()) != null) {
                this.m_TwoGroups = Boolean.valueOf(inpLine);
            }
            rdr.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void saveInputSettings() {
        try {
            FileWriter fw = new FileWriter("InputSettings.txt", false);
            BufferedWriter writer = new BufferedWriter(fw);
            writer.write(this.m_InputFileName);
            writer.newLine();
            writer.write(this.m_OutputFileName);
            writer.newLine();
            writer.write(String.valueOf(this.m_NumTimePoints));
            writer.newLine();
            writer.write(this.createSampleSizeString());
            writer.newLine();
            writer.write(String.valueOf(this.m_NumInitialBootStraps));
            writer.newLine();
            writer.write(String.valueOf(this.m_FDRLevel));
            writer.newLine();
            writer.write(this.m_LookupFileName);
            writer.newLine();
            writer.write(String.valueOf(this.m_RandomSeed));
            writer.newLine();
            writer.write(String.valueOf(this.m_SubRegionPValue));
            writer.newLine();
            writer.write(String.valueOf(this.m_CheckSubRegions));
            writer.newLine();
            writer.write(String.valueOf(this.m_LogTransformType));
            writer.newLine();
            writer.write(String.valueOf(this.m_Transpose));
            writer.newLine();
            writer.write(String.valueOf(this.m_MaxNumBootStraps));
            writer.newLine();
            writer.write(String.valueOf(this.m_LongitudinalSampling));
            writer.newLine();
            writer.write(String.valueOf(this.m_S0Percentile));
            writer.newLine();
            writer.write(String.valueOf(this.m_mdFdr));
            writer.newLine();
            writer.write(String.valueOf(this.m_TwoGroups));
            writer.newLine();
            writer.flush();
            writer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int countLines(String a_FileName, JPanel parent) {
        int returnValue;
        block14: {
            File tmpFile = new File(a_FileName);
            returnValue = 0;
            this.m_HeaderRowPresent = false;
            this.m_DescColumnPresent = false;
            if (tmpFile.exists()) {
                try {
                    BufferedReader rdr = new BufferedReader(new FileReader(a_FileName));
                    String inputString = rdr.readLine();
                    String[] tokens = inputString.split("\t");
                    if (tokens.length < 2) {
                        JOptionPane.showMessageDialog(parent, "The file <" + this.m_InputFileName + "> is not a tab-delimited file.", "Error", 0);
                        returnValue = -1;
                        return returnValue;
                    }
                    if (this.m_Transpose) {
                        this.m_NumDataColumns = 1;
                        inputString = rdr.readLine();
                        tokens = inputString.split("\t");
                        boolean bl = this.m_DescColumnPresent = !this.testForNumeric(tokens[(returnValue = tokens.length) - 1], parent);
                        if (this.m_DescColumnPresent) {
                            inputString = rdr.readLine();
                            tokens = inputString.split("\t");
                        }
                        boolean bl2 = this.m_HeaderRowPresent = !this.testForNumeric(tokens[0], parent);
                        if (this.m_HeaderRowPresent) {
                            --returnValue;
                        }
                        while ((inputString = rdr.readLine()) != null) {
                            ++this.m_NumDataColumns;
                        }
                        break block14;
                    }
                    this.m_HeaderRowPresent = !this.testForNumeric(tokens[2], parent);
                    this.m_NumDataColumns = tokens.length - 1;
                    while ((inputString = rdr.readLine()) != null) {
                        if (returnValue == 0) {
                            try {
                                tokens = inputString.split("\t");
                                this.m_NumDataColumns = tokens.length - 1;
                                double testValue = Double.valueOf(tokens[1]);
                            }
                            catch (NumberFormatException e) {
                                this.m_DescColumnPresent = true;
                                --this.m_NumDataColumns;
                            }
                            catch (Exception e) {
                                JOptionPane.showMessageDialog(parent, "The file <" + this.m_InputFileName + "> has one or more empty rows.", "Error", 0);
                                returnValue = -1;
                                return returnValue;
                            }
                        }
                        ++returnValue;
                    }
                    if (!this.m_HeaderRowPresent) {
                        ++returnValue;
                    }
                }
                catch (IOException ioException) {
                    JOptionPane.showMessageDialog(parent, "Error reading input file" + ioException.getMessage(), "Error", 0);
                    returnValue = -1;
                    return returnValue;
                }
            }
        }
        return returnValue;
    }

    private boolean testForNumeric(String a_InputStr, JPanel parent) {
        boolean returnValue = true;
        try {
            if (!a_InputStr.equals(".")) {
                double d = Double.valueOf(a_InputStr);
            }
        }
        catch (NumberFormatException e) {
            returnValue = false;
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(parent, "The file <" + this.m_InputFileName + "> is not a tab-delimited file.", "Error", 0);
            returnValue = false;
            return returnValue;
        }
        return returnValue;
    }

    public String generateProfileString(int a_Row, boolean a_UseTab) {
        String returnValue = this.m_ProfileTable[a_Row].type == 1 ? (this.m_ProfileTable[a_Row].initialSlope == 1 ? "Increasing profile" : "Decreasing profile") : (this.m_ProfileTable[a_Row].type == 2 ? (this.m_ProfileTable[a_Row].initialSlope == 1 ? "Umbrella profile, downturn at " + String.valueOf(this.m_ProfileTable[a_Row].peakIndex) : "Inverted umbrella profile, upturn at " + String.valueOf(this.m_ProfileTable[a_Row].peakIndex)) : (this.m_ProfileTable[a_Row].cyclicSlope == 31 ? "Cyclic profile, downturn at " + this.m_ProfileTable[a_Row].timePointAtMax + ", upturn at " + this.m_ProfileTable[a_Row].timePointAtMin : "Cyclic profile, upturn at " + this.m_ProfileTable[a_Row].timePointAtMin + ", downturn at " + this.m_ProfileTable[a_Row].timePointAtMax));
        returnValue = a_UseTab ? a_Row + 1 + "\t" + returnValue : "  " + (a_Row + 1) + ") " + returnValue + "\n";
        return returnValue;
    }

    public void showProgressWindow(boolean flag) {
        this.m_ProgressWin.setVisible(flag);
    }

    public void updateProgress(String msg1, String msg2) {
        this.m_ProgressWin.updateStatus(msg1, msg2);
    }

    public void setGeneProcessor(GeneProcessor geneProc) {
        this.m_ProgressWin.setGeneProcessor(geneProc);
    }

    private class DeathTimerTask
    extends TimerTask {
        private DeathTimerTask() {
        }

        @Override
        public void run() {
            Origen_Data.this.m_SplashWindow.setVisible(false);
            UtilityFunctions.centerInScreen(Origen_Data.this.m_SliderWin);
            Origen_Data.this.m_InputFrame.pack();
            UtilityFunctions.centerInScreen(Origen_Data.this.m_InputFrame);
            Origen_Data.this.m_InputFrame.setVisible(true);
            if (!HelpWindow.isHideFlagSet()) {
                LocatorClass locator = new LocatorClass();
                HelpWindow helpWindow = new HelpWindow("ORIOGEN Version 4.01 -- Introduction to ORIOGEN", locator.pathString + "/about_help.htm", true);
            }
        }
    }

    private class SplashPanel
    extends JPanel {
        private ImageIcon logo;

        public SplashPanel() {
            LocatorClass locator = new LocatorClass();
            this.logo = new ImageIcon(locator.pathString + "/ORIGEN.gif");
        }

        @Override
        public void paint(Graphics g) {
            Rectangle rect = new Rectangle();
            this.getBounds(rect);
            int x = (rect.width - this.logo.getIconWidth()) / 2;
            int y = (rect.height - this.logo.getIconHeight()) / 2;
            this.logo.paintIcon(this, g, x, y);
        }
    }
}

