/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;

public class InitialInputWindow
extends JPanel
implements ActionListener,
OriogenConstants {
    private Origen_Data m_MainDoc;
    private boolean m_LongitudinalSampling;
    private boolean m_mdFdr;
    private boolean m_Transpose;
    private String m_InputFileName;
    private String m_OutputFileName;
    public int m_NumTimePoints;
    private int m_NumDataColumns;
    private int m_NumInitialBootStraps;
    private int m_MaxNumBootStraps;
    private int m_LogTransformType;
    private double m_FDRLevel;
    private double m_S0Percentile;
    private int m_RandomSeed = -1;
    private int[] m_SampleSizeDefault = new int[30];
    private String m_NumSampleSizesText;
    private int m_NumGenes;
    private JLabel analysisTypeLabel;
    private JLabel inputFileNameLabel;
    private JLabel transposeLabel;
    private JLabel outputFileNameLabel;
    private JLabel numTimePointsLabel;
    private JLabel numSampleSizesLabel;
    private JLabel numBootStrapsLabel;
    private JLabel maxBootStrapsLabel;
    private JLabel firstPvalueLabel;
    private JLabel s0PercentileLabel;
    private JLabel randomSeedLabel;
    private JLabel LogTransformTypeLabel;
    private JLabel longitudinalLabel;
    private JButton browseInputButton;
    private JButton browseOutputButton;
    private JButton sampleSizeButton;
    private JFrame johnFrame;
    private String analysisTypeString = "Analysis Type: ";
    private String inputFileNameString = "Input File Name: ";
    private String transposeString = "Transpose Input File";
    private String outputFileNameString = "Output File Name: ";
    private String numTimePointsString = "Total number of dose groups or time points: ";
    private String numSampleSizesString = "Vector of sample sizes per dose/time point: ";
    private String numBootStrapsString = "Number of initial bootstrap samples: ";
    private String maxBootStrapsString = "Maximum number of bootstrap samples: ";
    private String firstPvalueString = "FDR level for performing the actual test: ";
    private String s0PercentileString = "Percentile to use for s0 adjustment(%):";
    private String randomSeedString = "Bootstrap random seed: ";
    private String LogTransformTypeString = "Are data already log transformed?";
    private String longitudinalString = "Longitudinal sampling";
    private JComboBox analysisTypeCombo;
    private JTextField inputFileNameField;
    private JCheckBox transposeCheckBox;
    private JTextField outputFileNameField;
    private JTextField numTimePointsField;
    private JTextField numSampleSizesField;
    private JTextField numBootStrapsField;
    private JTextField maxBootStrapsField;
    private JTextField firstPvalueField;
    private JTextField s0PercentileField;
    private Box randomSeedBox;
    private JRadioButton automaticRandomButton;
    private JRadioButton manualRandomButton;
    private JTextField randomSeedField;
    private JComboBox LogTransformTypeComboBox;
    private JCheckBox longitudinalCheckBox;

    public InitialInputWindow(JFrame frame, Origen_Data mainDoc) {
        int i;
        this.m_MainDoc = mainDoc;
        this.m_LongitudinalSampling = this.m_MainDoc.getLongitudinalSampling();
        this.setLayout(new BorderLayout());
        this.johnFrame = frame;
        this.analysisTypeLabel = new JLabel(this.analysisTypeString);
        this.analysisTypeLabel.setToolTipText("The type of analysis to perform");
        this.inputFileNameLabel = new JLabel(this.inputFileNameString);
        this.inputFileNameLabel.setToolTipText("The file containing the source data");
        this.outputFileNameLabel = new JLabel(this.outputFileNameString);
        this.outputFileNameLabel.setToolTipText("The file where the fitted results will be stored.");
        this.numTimePointsLabel = new JLabel(this.numTimePointsString);
        this.numTimePointsLabel.setToolTipText("The number of time points that make up a profile");
        this.numSampleSizesLabel = new JLabel(this.numSampleSizesString);
        this.numSampleSizesLabel.setToolTipText("The number of samples in the source data. This data must be entered as a vector (e.g. \"4,4,4,4\")");
        this.numBootStrapsLabel = new JLabel(this.numBootStrapsString);
        this.numBootStrapsLabel.setToolTipText("The number of initial boot strap points used for the analysis.");
        this.maxBootStrapsLabel = new JLabel(this.maxBootStrapsString);
        this.maxBootStrapsLabel.setToolTipText("The maximum number of boot straps used when selecting significant genes.");
        this.firstPvalueLabel = new JLabel(this.firstPvalueString);
        this.firstPvalueLabel.setToolTipText("The FDR level to use when selecting significant genes.");
        this.s0PercentileLabel = new JLabel(this.s0PercentileString);
        this.s0PercentileLabel.setToolTipText("Percentile of standard error values used to moderate effects of low variance values");
        this.randomSeedLabel = new JLabel(this.randomSeedString);
        this.randomSeedLabel.setToolTipText("The seed value used to generate the randomized bootstrap values.");
        this.LogTransformTypeLabel = new JLabel(this.LogTransformTypeString);
        this.LogTransformTypeLabel.setToolTipText("Specify the type of log transpose to apply or already applied to the data");
        this.longitudinalLabel = new JLabel(this.longitudinalString);
        this.longitudinalLabel.setToolTipText("Replicates pertain to the same individuals (repeated measures)");
        this.transposeLabel = new JLabel(this.transposeString);
        this.transposeLabel.setToolTipText("Data in input file is transposed so that each gene's data is listed in a column");
        this.inputFileNameField = new JTextField(40);
        this.outputFileNameField = new JTextField(40);
        this.numTimePointsField = new JTextField(40);
        this.numSampleSizesField = new JTextField(40);
        this.numBootStrapsField = new JTextField(40);
        this.maxBootStrapsField = new JTextField(40);
        this.firstPvalueField = new JTextField(40);
        this.s0PercentileField = new JTextField(40);
        this.randomSeedField = new JTextField(10);
        this.randomSeedBox = Box.createHorizontalBox();
        this.automaticRandomButton = new JRadioButton("Automatic  ", false);
        this.manualRandomButton = new JRadioButton("Manual  ", true);
        ButtonGroup radioGroup = new ButtonGroup();
        radioGroup.add(this.automaticRandomButton);
        radioGroup.add(this.manualRandomButton);
        this.randomSeedBox.add(this.automaticRandomButton);
        this.randomSeedBox.add(this.manualRandomButton);
        this.randomSeedBox.add(this.randomSeedField);
        this.automaticRandomButton.setActionCommand("autoRandom");
        this.automaticRandomButton.addActionListener(this);
        this.manualRandomButton.setActionCommand("manualRandom");
        this.manualRandomButton.addActionListener(this);
        this.analysisTypeCombo = new JComboBox();
        for (i = 0; i < OriogenConstants.STR_ANALYSIS_TYPE_OPTIONS.length; ++i) {
            this.analysisTypeCombo.addItem(OriogenConstants.STR_ANALYSIS_TYPE_OPTIONS[i]);
        }
        this.analysisTypeCombo.setActionCommand("m_AnalysisType");
        this.analysisTypeCombo.addActionListener(this);
        this.LogTransformTypeComboBox = new JComboBox();
        for (i = 0; i < OriogenConstants.STR_LOG_TRANSFORM_OPTIONS.length; ++i) {
            this.LogTransformTypeComboBox.addItem(OriogenConstants.STR_LOG_TRANSFORM_OPTIONS[i]);
        }
        this.LogTransformTypeComboBox.setActionCommand("m_TakeLog");
        this.LogTransformTypeComboBox.addActionListener(this);
        this.longitudinalCheckBox = new JCheckBox("Longitudinal sampling", this.m_LongitudinalSampling);
        this.longitudinalCheckBox.setActionCommand("m_LongitudinalSampling");
        this.longitudinalCheckBox.addActionListener(this);
        this.transposeCheckBox = new JCheckBox("Transpose input file", this.m_Transpose);
        this.transposeCheckBox.setActionCommand("m_Transpose");
        this.transposeCheckBox.addActionListener(this);
        JButton ok = new JButton("OK");
        ok.addActionListener(this);
        ok.setActionCommand("ok");
        JButton help = new JButton("Help");
        help.addActionListener(this);
        help.setActionCommand("help");
        this.browseInputButton = new JButton("Browse...");
        this.browseInputButton.addActionListener(this);
        this.browseInputButton.setToolTipText("Browse for input file");
        this.browseOutputButton = new JButton("Browse...");
        this.browseOutputButton.addActionListener(this);
        this.browseOutputButton.setToolTipText("Browse for output file");
        this.sampleSizeButton = new JButton("Enter Sample Sizes...");
        this.sampleSizeButton.addActionListener(this);
        this.sampleSizeButton.setToolTipText("Enter the sample sizes for each dose/time point");
        this.analysisTypeLabel.setLabelFor(this.analysisTypeCombo);
        this.inputFileNameLabel.setLabelFor(this.inputFileNameField);
        this.outputFileNameLabel.setLabelFor(this.outputFileNameField);
        this.numTimePointsLabel.setLabelFor(this.numTimePointsField);
        this.numSampleSizesLabel.setLabelFor(this.numSampleSizesField);
        this.numBootStrapsLabel.setLabelFor(this.numBootStrapsField);
        this.maxBootStrapsLabel.setLabelFor(this.maxBootStrapsField);
        this.firstPvalueLabel.setLabelFor(this.firstPvalueField);
        this.s0PercentileLabel.setLabelFor(this.s0PercentileField);
        this.randomSeedLabel.setLabelFor(this.randomSeedBox);
        this.LogTransformTypeLabel.setLabelFor(this.LogTransformTypeComboBox);
        this.transposeLabel.setLabelFor(this.transposeCheckBox);
        JPanel sideButtonPane = new JPanel(new GridLayout(14, 1, 20, 20));
        JSeparator sep = new JSeparator();
        sep.setVisible(false);
        sideButtonPane.add(sep);
        sideButtonPane.add(this.browseInputButton);
        sideButtonPane.add(this.browseOutputButton);
        sep = new JSeparator();
        sep.setVisible(false);
        sideButtonPane.add(sep);
        sideButtonPane.add(this.sampleSizeButton);
        JPanel labelPane = new JPanel(new GridLayout(0, 1, 13, 20));
        labelPane.add(this.analysisTypeLabel);
        labelPane.add(this.inputFileNameLabel);
        labelPane.add(this.outputFileNameLabel);
        labelPane.add(this.numTimePointsLabel);
        labelPane.add(this.numSampleSizesLabel);
        labelPane.add(this.numBootStrapsLabel);
        labelPane.add(this.maxBootStrapsLabel);
        labelPane.add(this.firstPvalueLabel);
        labelPane.add(this.s0PercentileLabel);
        labelPane.add(this.randomSeedLabel);
        labelPane.add(this.LogTransformTypeLabel);
        labelPane.add(this.longitudinalLabel);
        labelPane.add(this.transposeLabel);
        labelPane.add(new JSeparator(0));
        JPanel fieldPane = new JPanel(new GridLayout(0, 1, 13, 20));
        fieldPane.add(this.analysisTypeCombo);
        fieldPane.add(this.inputFileNameField);
        fieldPane.add(this.outputFileNameField);
        fieldPane.add(this.numTimePointsField);
        fieldPane.add(this.numSampleSizesField);
        fieldPane.add(this.numBootStrapsField);
        fieldPane.add(this.maxBootStrapsField);
        fieldPane.add(this.firstPvalueField);
        fieldPane.add(this.s0PercentileField);
        fieldPane.add(this.randomSeedBox);
        fieldPane.add(this.LogTransformTypeComboBox);
        fieldPane.add(this.longitudinalCheckBox);
        fieldPane.add(this.transposeCheckBox);
        fieldPane.add(new JSeparator(0));
        JPanel buttonPane = new JPanel(new GridLayout(1, 0, 50, 20));
        sep = new JSeparator();
        sep.setVisible(false);
        buttonPane.add(sep);
        buttonPane.add(ok);
        buttonPane.add(help);
        sep = new JSeparator();
        sep.setVisible(false);
        buttonPane.add(sep);
        this.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        this.add((Component)labelPane, "West");
        this.add((Component)fieldPane, "Center");
        this.add((Component)buttonPane, "Last");
        this.add((Component)sideButtonPane, "East");
        LocatorClass locator = new LocatorClass();
        Image image = Toolkit.getDefaultToolkit().getImage(locator.pathString + "/GRAPH05.GIF");
        if (image != null) {
            frame.setIconImage(image);
        }
        this.getValuesFromMainDoc();
        this.setValuesInControls();
        this.setDependentControls();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if ("ok".equals(e.getActionCommand())) {
            this.setAndVerifySettings();
        } else if ("Browse...".equals(e.getActionCommand())) {
            JFileChooser fc = new JFileChooser();
            if (e.getSource() == this.browseInputButton) {
                int returnVal;
                this.m_InputFileName = this.inputFileNameField.getText().trim();
                File file = new File(this.m_InputFileName);
                if (file.exists()) {
                    fc.setSelectedFile(file);
                    fc.setCurrentDirectory(file);
                }
                if ((returnVal = fc.showDialog(this, "Select Input File")) == 0) {
                    this.m_InputFileName = fc.getSelectedFile().getAbsolutePath();
                    this.inputFileNameField.setText(this.m_InputFileName);
                }
            } else if (e.getSource() == this.browseOutputButton) {
                int returnVal;
                this.m_OutputFileName = this.outputFileNameField.getText().trim();
                File file = new File(this.m_OutputFileName);
                if (file.exists()) {
                    fc.setSelectedFile(file);
                    fc.setCurrentDirectory(file);
                }
                if ((returnVal = fc.showSaveDialog(this)) == 0) {
                    this.m_OutputFileName = fc.getSelectedFile().getAbsolutePath();
                    this.outputFileNameField.setText(this.m_OutputFileName);
                }
            }
        } else if (e.getSource() == this.sampleSizeButton) {
            this.m_NumTimePoints = Integer.parseInt(this.numTimePointsField.getText().trim());
            if (this.m_NumTimePoints > 1) {
                this.m_NumSampleSizesText = "";
                for (int i = 0; i < this.m_NumTimePoints; ++i) {
                    String tmpStr = JOptionPane.showInputDialog(this, "Enter sample size for time point " + (i + 1), "");
                    if (tmpStr == null) {
                        this.m_NumSampleSizesText = "";
                        break;
                    }
                    this.m_NumSampleSizesText = this.m_NumSampleSizesText + tmpStr;
                    if (i >= this.m_NumTimePoints - 1) continue;
                    this.m_NumSampleSizesText = this.m_NumSampleSizesText + ",";
                }
                if (this.m_NumSampleSizesText.length() > 0) {
                    this.numSampleSizesField.setText(this.m_NumSampleSizesText);
                }
            }
        } else if ("help".equals(e.getActionCommand())) {
            LocatorClass locator = new LocatorClass();
            HelpWindow helpWindow = new HelpWindow("ORIOGEN Help", locator.pathString + "/Initial_help.htm");
        } else if ("autoRandom".equals(e.getActionCommand())) {
            this.randomSeedField.setVisible(false);
            this.paintAll(this.getGraphics());
        } else if ("manualRandom".equals(e.getActionCommand())) {
            this.randomSeedField.setVisible(true);
            this.paintAll(this.getGraphics());
        } else if ("m_TakeLog".equals(e.getActionCommand())) {
            this.m_LogTransformType = this.LogTransformTypeComboBox.getSelectedIndex();
        } else if ("m_LongitudinalSampling".equals(e.getActionCommand())) {
            this.m_LongitudinalSampling = this.longitudinalCheckBox.isSelected();
        } else if ("m_Transpose".equals(e.getActionCommand())) {
            this.m_Transpose = this.transposeCheckBox.isSelected();
        } else if ("m_AnalysisType".equals(e.getActionCommand())) {
            String tmpStr = this.analysisTypeCombo.getSelectedItem().toString();
            this.m_mdFdr = tmpStr.toLowerCase().contains("multiple pairwise");
            this.setDependentControls();
        }
    }

    private void setAndVerifySettings() {
        boolean manualRandomSeedSelected = false;
        this.m_InputFileName = this.inputFileNameField.getText().trim();
        this.m_OutputFileName = this.outputFileNameField.getText().trim();
        if (this.m_InputFileName.length() == 0) {
            JOptionPane.showMessageDialog(this, "You must enter a path and filename in the Input File Name field.", "Error", 0);
            return;
        }
        if (this.m_OutputFileName.length() == 0) {
            JOptionPane.showMessageDialog(this, "You must enter a path and filename in the Output File Name field.", "Error", 0);
            return;
        }
        this.m_NumGenes = this.m_MainDoc.countLines(this.m_InputFileName, this);
        if (this.m_NumGenes < 1) {
            if (this.m_NumGenes == 0) {
                JOptionPane.showMessageDialog(this, "The file <" + this.m_InputFileName + "> does not exist or is not a tab-delimited file.", "Error", 0);
            }
            return;
        }
        try {
            this.m_NumTimePoints = Integer.parseInt(this.numTimePointsField.getText().trim());
            this.m_NumSampleSizesText = this.numSampleSizesField.getText();
            if (this.m_NumTimePoints <= 1 || this.m_NumTimePoints > 30) {
                JOptionPane.showMessageDialog(this, "The number of dose groups or time points must greater than 1 and less than 15.", "Error", 0);
                return;
            }
            int numDataColumns = this.m_MainDoc.getNumDataColumns();
            if (!this.processSampleSizes(numDataColumns)) {
                return;
            }
            this.m_NumInitialBootStraps = Integer.parseInt(this.numBootStrapsField.getText().trim());
            this.m_MaxNumBootStraps = Integer.parseInt(this.maxBootStrapsField.getText().trim());
            this.m_FDRLevel = ResultsViewer.getDoubleValue(this.firstPvalueField.getText().trim(), true);
            if (this.m_FDRLevel < 0.0) {
                return;
            }
            this.m_S0Percentile = ResultsViewer.getDoubleValue(this.s0PercentileField.getText().trim(), true);
            if (this.m_S0Percentile < 0.0) {
                return;
            }
            if (this.automaticRandomButton.isSelected()) {
                this.m_RandomSeed = -1;
            } else {
                manualRandomSeedSelected = true;
                this.m_RandomSeed = Integer.parseInt(this.randomSeedField.getText().trim());
            }
        }
        catch (Exception exc) {
            if (manualRandomSeedSelected) {
                JOptionPane.showMessageDialog(this, "Error in user input. You must enter a numeric integer value for the manual random seed value ", "Error", 0);
            } else {
                JOptionPane.showMessageDialog(this, "Error in user input. You must enter numerical values", "Error", 0);
            }
            return;
        }
        if (this.m_NumInitialBootStraps < 1) {
            JOptionPane.showMessageDialog(this, "The number of bootstraps must be greater than 0.", "Error", 0);
            return;
        }
        if (!this.m_mdFdr && this.m_MaxNumBootStraps < this.m_NumInitialBootStraps) {
            JOptionPane.showMessageDialog(this, "The maximum number of bootstraps must be greater than 0.", "Error", 0);
            return;
        }
        if (this.m_FDRLevel <= 0.0 || this.m_FDRLevel > 1.01) {
            JOptionPane.showMessageDialog(this, "The FDR level must be between 0 and 1.", "Error", 0);
            return;
        }
        if (this.m_LongitudinalSampling) {
            for (int i = 2; i <= this.m_NumTimePoints; ++i) {
                if (this.m_SampleSizeDefault[i] == this.m_SampleSizeDefault[i - 1]) continue;
                JOptionPane.showMessageDialog(this, "For longitudinal sampling all sample sizes must be the same", "Error", 0);
                return;
            }
        }
        int response = 0;
        File file1 = new File(this.m_OutputFileName);
        if (file1.exists() && (response = JOptionPane.showConfirmDialog(this, "The file " + this.m_OutputFileName + " will be overwritten. Are you sure you want to continue?", "Warning", 0)) == 1) {
            return;
        }
        if (UtilityFunctions.checkReadOnly(file1)) {
            JOptionPane.showMessageDialog(this, "The file " + file1.toString() + " is read-only. Please change the file attribute or select a new file name.", "Error", 0);
            return;
        }
        this.m_MainDoc.setInputFileName(this.m_InputFileName);
        this.m_MainDoc.setOutputFileName(this.m_OutputFileName);
        this.m_MainDoc.setLookupFileName("");
        this.m_MainDoc.setNumTimePoints(this.m_NumTimePoints);
        this.m_MainDoc.setSampleSizeDefault(this.m_SampleSizeDefault);
        this.m_MainDoc.setNumInitialBootStraps(this.m_NumInitialBootStraps);
        this.m_MainDoc.setMaxNumBootStraps(this.m_MaxNumBootStraps);
        this.m_MainDoc.setFDRLevel(this.m_FDRLevel);
        this.m_MainDoc.setS0Percentile(this.m_S0Percentile);
        this.m_MainDoc.setRandomSeed(this.m_RandomSeed);
        this.m_MainDoc.setLogTransformType(this.m_LogTransformType);
        this.m_MainDoc.setLongitudinalSampling(this.m_LongitudinalSampling);
        this.m_MainDoc.setTranspose(this.m_Transpose);
        this.m_MainDoc.setmdFdr(this.m_mdFdr);
        this.m_MainDoc.setNumGenes(this.m_NumGenes);
        this.johnFrame.setVisible(false);
        this.m_MainDoc.initialInputWindowClosed();
    }

    private void setDependentControls() {
        this.maxBootStrapsLabel.setEnabled(!this.m_mdFdr);
        this.maxBootStrapsField.setEnabled(!this.m_mdFdr);
        this.longitudinalLabel.setEnabled(!this.m_mdFdr);
        this.longitudinalCheckBox.setEnabled(!this.m_mdFdr);
        this.s0PercentileLabel.setEnabled(!this.m_mdFdr);
        this.s0PercentileField.setEnabled(!this.m_mdFdr);
    }

    private void setValuesInControls() {
        this.inputFileNameField.setText(this.m_InputFileName);
        this.outputFileNameField.setText(this.m_OutputFileName);
        this.numTimePointsField.setText(String.valueOf(this.m_NumTimePoints));
        this.numSampleSizesField.setText(this.m_NumSampleSizesText);
        this.numBootStrapsField.setText(String.valueOf(this.m_NumInitialBootStraps));
        this.firstPvalueField.setText(String.valueOf(this.m_FDRLevel));
        if (this.m_RandomSeed == -1) {
            this.automaticRandomButton.setSelected(true);
            this.randomSeedField.setVisible(false);
        } else {
            this.manualRandomButton.setSelected(true);
            this.randomSeedField.setText(String.valueOf(this.m_RandomSeed));
        }
        this.LogTransformTypeComboBox.setSelectedIndex(this.m_LogTransformType);
        this.transposeCheckBox.setSelected(this.m_Transpose);
        this.maxBootStrapsField.setText(String.valueOf(this.m_MaxNumBootStraps));
        this.longitudinalCheckBox.setSelected(this.m_LongitudinalSampling);
        this.s0PercentileField.setText(String.valueOf(this.m_S0Percentile));
        if (this.m_mdFdr) {
            this.analysisTypeCombo.setSelectedIndex(1);
        } else {
            this.analysisTypeCombo.setSelectedIndex(0);
        }
    }

    private void getValuesFromMainDoc() {
        this.m_LongitudinalSampling = this.m_MainDoc.getLongitudinalSampling();
        this.m_mdFdr = this.m_MainDoc.getmdFdr();
        this.m_Transpose = this.m_MainDoc.getTranspose();
        this.m_InputFileName = this.m_MainDoc.getInputFileName();
        this.m_OutputFileName = this.m_MainDoc.getOutputFileName();
        this.m_NumTimePoints = this.m_MainDoc.getNumTimePoints();
        this.m_NumInitialBootStraps = this.m_MainDoc.getNumInitialBootStraps();
        this.m_MaxNumBootStraps = this.m_MainDoc.getMaxNumBootStraps();
        this.m_LogTransformType = this.m_MainDoc.getLogTransformType();
        this.m_FDRLevel = this.m_MainDoc.getFDRLevel();
        this.m_S0Percentile = this.m_MainDoc.getS0Percentile();
        this.m_RandomSeed = this.m_MainDoc.getRandomSeed();
        this.m_NumSampleSizesText = this.m_MainDoc.getNumSampleSizesText();
    }

    private boolean processSampleSizes(int numDataColumns) {
        int length = this.m_NumSampleSizesText.length();
        int x = 0;
        int imSum = 0;
        int imCounter = 1;
        String myString = "";
        String digitsString = "";
        while (x < length) {
            int sampleDigit;
            char myChar = this.m_NumSampleSizesText.charAt(x);
            myString = String.valueOf(myChar);
            int test = Character.getType(myChar);
            if (test == 9) {
                digitsString = digitsString + myString;
                if (x == length - 1) {
                    sampleDigit = Integer.parseInt(digitsString);
                    imSum += sampleDigit;
                    this.m_SampleSizeDefault[imCounter] = sampleDigit;
                    ++imCounter;
                }
                ++x;
                continue;
            }
            sampleDigit = Integer.parseInt(digitsString);
            imSum += sampleDigit;
            this.m_SampleSizeDefault[imCounter] = sampleDigit;
            ++imCounter;
            digitsString = "";
            ++x;
        }
        if (imSum != numDataColumns) {
            if (this.m_Transpose) {
                JOptionPane.showMessageDialog(this, "The sum of the sample sizes (" + imSum + ") does not equal the number of input data rows (" + numDataColumns + ").", "Error", 0);
            } else {
                JOptionPane.showMessageDialog(this, "The sum of the sample sizes (" + imSum + ") does not equal the number of input data columns (" + numDataColumns + ").", "Error", 0);
            }
            this.numSampleSizesField.grabFocus();
            return false;
        }
        if (imCounter - 1 != this.m_NumTimePoints) {
            JOptionPane.showMessageDialog(this, "The sample size input string does not have the correct number of time points (" + this.m_NumTimePoints + ").", "Error", 0);
            this.numSampleSizesField.grabFocus();
            return false;
        }
        for (int i = 1; i <= this.m_NumTimePoints; ++i) {
            if (this.m_SampleSizeDefault[i] > 1) continue;
            JOptionPane.showMessageDialog(this, "All samples sizes must be greater than one.", "Error", 0);
            this.numSampleSizesField.grabFocus();
            return false;
        }
        return true;
    }
}

