/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class HelpWindow
extends JFrame
implements ActionListener {
    private final int WIDTH = 750;
    private final int HEIGHT = 625;
    static final String HIDE_FLAG_FILENAME = "HideFirstWindow.txt";
    private JEditorPane m_EditorPane;
    private URL m_HelpURL;
    private URL m_ContentsURL;
    private boolean m_ShowOnceFlag;
    private JCheckBox m_ShowCheckbox;

    public HelpWindow(String title, String filename) {
        this(title, filename, false);
    }

    public HelpWindow(String title, String filename, boolean showCheckbox) {
        super(title);
        Image image;
        this.m_ShowOnceFlag = showCheckbox;
        File tmpFile = new File(filename);
        if (tmpFile.exists()) {
            try {
                this.m_HelpURL = tmpFile.toURL();
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Exception thrown: " + e.getMessage());
            }
        } else {
            JOptionPane.showMessageDialog(null, "Help file not found: " + filename);
        }
        this.m_EditorPane = new JEditorPane();
        this.m_EditorPane.setEditable(false);
        try {
            this.m_EditorPane.setPage(this.m_HelpURL);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.m_EditorPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent ev) {
                try {
                    if (ev.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        HelpWindow.this.m_EditorPane.setPage(ev.getURL());
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        });
        this.getContentPane().add(new JScrollPane(this.m_EditorPane));
        this.addButtons();
        this.setDefaultCloseOperation(2);
        this.calculateLocation();
        this.setVisible(true);
        LocatorClass locator = new LocatorClass();
        tmpFile = new File(locator.pathString + "/contents_help.htm");
        if (tmpFile.exists()) {
            try {
                this.m_ContentsURL = tmpFile.toURL();
            }
            catch (Exception e) {
                this.m_ContentsURL = this.m_HelpURL;
            }
        } else {
            this.m_ContentsURL = this.m_HelpURL;
        }
        if ((image = Toolkit.getDefaultToolkit().getImage(locator.pathString + "/GRAPH05.GIF")) != null) {
            this.setIconImage(image);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        block6: {
            String strAction = e.getActionCommand();
            try {
                if (strAction == "Contents") {
                    URL tempURL = this.m_EditorPane.getPage();
                    this.m_EditorPane.setPage(this.m_ContentsURL);
                }
                if (strAction != "Close") break block6;
                if (this.m_ShowOnceFlag && this.m_ShowCheckbox.isSelected()) {
                    LocatorClass locator = new LocatorClass();
                    File tmpFile = new File(locator.pathString + "/" + HIDE_FLAG_FILENAME);
                    try {
                        tmpFile.createNewFile();
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                this.processWindowEvent(new WindowEvent(this, 201));
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    private void addButtons() {
        this.m_ShowCheckbox = null;
        JButton btncontents = null;
        if (this.m_ShowOnceFlag) {
            this.m_ShowCheckbox = new JCheckBox("Don't show this screen again");
            this.m_ShowCheckbox.addActionListener(this);
        } else {
            btncontents = new JButton("Contents");
            btncontents.addActionListener(this);
        }
        JButton btnclose = new JButton("Close");
        btnclose.addActionListener(this);
        JPanel panebuttons = new JPanel();
        if (this.m_ShowOnceFlag) {
            panebuttons.add(this.m_ShowCheckbox);
        } else {
            panebuttons.add(btncontents);
        }
        panebuttons.add(btnclose);
        this.getContentPane().add((Component)panebuttons, "South");
    }

    private void calculateLocation() {
        Dimension screendim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize(new Dimension(750, 625));
        int locationx = (screendim.width - 750) / 2;
        int locationy = (screendim.height - 625) / 2;
        this.setLocation(locationx, locationy);
    }

    public static boolean isHideFlagSet() {
        LocatorClass locator = new LocatorClass();
        String filename = locator.pathString + "/" + HIDE_FLAG_FILENAME;
        File tmpFile = new File(filename);
        return tmpFile.exists();
    }

    public static void main(String[] args) {
    }
}

