/*
 * Decompiled with CFR 0.152.
 */
import edu.ucla.stat.SOCR.distributions.BinomialDistribution;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;
import java.util.Random;

public class GeneProcessor
extends Thread
implements OriogenConstants {
    private ThetaHat m_StdErr;
    private ThetaHat m_StdErrBoot;
    private ThetaHat m_Variance;
    private ThetaHat m_VarianceBoot;
    private Pvt m_Pvt = new Pvt();
    private Pvt m_Pvboot = new Pvt();
    private Crit m_Crit = new Crit();
    private Sum m_T1 = new Sum();
    private Sum m_T2 = new Sum();
    private Hp m_Hp = new Hp();
    private Hp m_Hpp = new Hp();
    private Hp m_Hp1 = new Hp();
    private Hp m_Hp2 = new Hp();
    private Hp m_Tp = new Hp();
    private double[] m_CyclicDataValues = new double[30];
    private SimpOrderW m_SimpOrderW = new SimpOrderW();
    private SimpOrderW m_Wp = new SimpOrderW();
    private SimpOrderW m_Revn = new SimpOrderW();
    private SimpOrderW m_CyclicWt = new SimpOrderW();
    private SimpOrderM2 m_SimpOrderM2 = new SimpOrderM2();
    private ThatMax m_ThatMax = new ThatMax();
    private RmeanOrMax m_RMean = new RmeanOrMax();
    private RmeanOrMax m_RMax = new RmeanOrMax();
    private Weight m_Weight1 = new Weight();
    private Weight m_Weight2 = new Weight();
    private Csnp m_Csnp = new Csnp();
    private Csnp m_Csn = new Csnp();
    private ThetaHat m_THat1;
    private ThetaHat m_THat2;
    private ThetaHat m_THat3;
    private ThetaHat m_YBar;
    private ThetaHat m_YBarCyclic;
    private ThetaHat m_YnBar;
    private ThetaHat m_YBarS;
    private ThetaHat m_YnBarS;
    private ThetaHatWithZData m_RawData;
    private ThetaHatWithZData m_BootRawData;
    private ThetaHat m_YData;
    private ThetaHat m_YDataAdj;
    private boolean m_StopProcessing;
    private double s0;
    private double[] m_VarianceS0;
    private String errMsg;
    private String m_GeneID;
    private String m_GeneDesc;
    private File infile;
    private String[] inputTokens;
    private int numInputTokens;
    private int inputDataStartColumn;
    private String m_RawOutputFileName;
    private String m_RawOutputTransposeFileName;
    private String m_RejectedGenesFileName;
    private int[][] m_BootStrapIndices;
    private boolean m_InBootstrap;
    private UtilityFunctions.RandomSeed m_RandomSeedObj;
    private int[] m_SampleSize = new int[30];
    private String[] m_GroupNameArray;
    private ArrayList m_QValueArray = new ArrayList();
    private mdFdrCalculator m_mdFdrCalculator = new mdFdrCalculator();
    private PrintWriter m_DebugWriter = null;
    private GeneProcessorEvent m_GeneProcessorEvent = null;
    private int m_LinesReadAtUserBreak;
    private int m_NumGenesRejected;
    private int m_NumGenesSelected;
    private String m_OutputFileName;
    private int m_NumGenes;
    private int m_NumTimePoints;
    private boolean m_mdFdr;
    private int[] m_SampleSizeDefault;
    private List m_mdFdrComparisonList;
    private int m_LastProfileIndex;
    private ProfileStruct[] m_ProfileTable;
    private int m_NumProfiles;
    private String m_LastError;
    private Origen_Data m_MainDoc;

    public int getLinesReadAtUserBreak() {
        return this.m_LinesReadAtUserBreak;
    }

    public String getLastError() {
        return this.m_LastError;
    }

    public int getNumGenesRejected() {
        return this.m_NumGenesRejected;
    }

    public int getNumGenesSelected() {
        return this.m_NumGenesSelected;
    }

    public void setMdFdrComparisonList(List value) {
        this.m_mdFdrComparisonList = value;
    }

    public void setProfileTable(ProfileStruct[] value) {
        this.m_ProfileTable = value;
    }

    public void setLastProfileIndex(int value) {
        this.m_LastProfileIndex = value;
    }

    public void setNumProfiles(int value) {
        this.m_NumProfiles = value;
    }

    public void setGroupNameArray(String[] groupNames) {
        this.m_GroupNameArray = groupNames;
    }

    public GeneProcessor(GeneProcessorEvent ev, Origen_Data mainDoc) {
        this.m_GeneProcessorEvent = ev;
        this.m_MainDoc = mainDoc;
        this.m_RandomSeedObj = UtilityFunctions.getInstance().createRandomSeed();
        this.m_NumTimePoints = this.m_MainDoc.getNumTimePoints();
        this.m_OutputFileName = this.m_MainDoc.getOutputFileName();
        this.m_mdFdr = this.m_MainDoc.getmdFdr();
        this.m_NumGenes = this.m_MainDoc.getNumGenes();
        this.m_SampleSizeDefault = this.m_MainDoc.getSampleSizeDefault();
        this.setPriority(5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.m_StopProcessing = false;
        this.infile = this.createInputFile();
        this.m_LinesReadAtUserBreak = 0;
        BufferedReader in = null;
        PrintWriter out1 = null;
        PrintWriter out2 = null;
        PrintWriter outRej = null;
        this.m_RawOutputFileName = this.getRawOutputFileName("(Raw)");
        this.m_RawOutputTransposeFileName = this.getRawOutputFileName("(RawTranspose)");
        this.m_RejectedGenesFileName = this.getRawOutputFileName("(RejectedGenes)");
        try {
            in = new BufferedReader(new FileReader(this.infile));
            if (this.m_LinesReadAtUserBreak == 0) {
                this.m_NumGenesSelected = 0;
                this.m_NumGenesRejected = 0;
                out1 = new PrintWriter(new FileOutputStream(this.m_OutputFileName));
                outRej = new PrintWriter(new FileOutputStream(this.m_RejectedGenesFileName));
                out2 = this.m_MainDoc.getTranspose() ? new PrintWriter(new FileOutputStream(this.m_RawOutputTransposeFileName)) : new PrintWriter(new FileOutputStream(this.m_RawOutputFileName));
            } else {
                out1 = new PrintWriter(new FileOutputStream(this.m_OutputFileName, true));
                outRej = new PrintWriter(new FileOutputStream(this.m_RejectedGenesFileName, true));
                out2 = this.m_MainDoc.getTranspose() ? new PrintWriter(new FileOutputStream(this.m_RawOutputTransposeFileName, true)) : new PrintWriter(new FileOutputStream(this.m_RawOutputFileName, true));
            }
            this.processGenes(in, out1, out2, outRej);
        }
        catch (IOException er) {
            this.m_LastError = "Error writing to ouput files: " + er.getMessage();
            this.m_NumGenesSelected = -1;
        }
        catch (Exception ex) {
            this.m_LastError = ex.toString();
            this.m_NumGenesSelected = -1;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException er) {}
        }
        this.m_GeneProcessorEvent.geneProcessorFinished();
    }

    private File createInputFile() {
        File returnValue = null;
        if (this.m_MainDoc.getTranspose()) {
            boolean sts = this.transposeFile(this.m_MainDoc.getInputFileName(), this.m_MainDoc.getTransposeInputFileName(), false);
            if (!sts) {
                this.m_StopProcessing = true;
                return null;
            }
            returnValue = new File(this.m_MainDoc.getTransposeInputFileName());
        } else {
            returnValue = new File(this.m_MainDoc.getInputFileName());
        }
        return returnValue;
    }

    public void stopProcessing() {
        this.m_StopProcessing = true;
    }

    private boolean transposeFile(String a_FileName1, String a_FileName2, boolean a_DeleteOriginal) {
        boolean returnValue = true;
        File inFile = new File(a_FileName1);
        ArrayList<String> inpList = new ArrayList<String>();
        try {
            String tmpStr;
            BufferedReader in = new BufferedReader(new FileReader(inFile));
            PrintWriter out = new PrintWriter(new FileOutputStream(a_FileName2));
            while ((tmpStr = in.readLine()) != null) {
                inpList.add(tmpStr);
            }
            ListIterator it = null;
            boolean oneFound = true;
            int rowCount = 0;
            while (oneFound) {
                oneFound = false;
                String outStr = "";
                it = inpList.listIterator();
                while (it.hasNext()) {
                    tmpStr = (String)it.next();
                    this.inputTokens = tmpStr.split("\t");
                    if (this.inputTokens.length > rowCount) {
                        outStr = outStr + this.inputTokens[rowCount] + "\t";
                        oneFound = true;
                        continue;
                    }
                    outStr = outStr + "\t";
                }
                if (oneFound) {
                    out.println(outStr.substring(0, outStr.length() - 1));
                }
                ++rowCount;
            }
            in.close();
            out.close();
            if (a_DeleteOriginal) {
                inFile.delete();
            }
        }
        catch (IOException e) {
            this.m_GeneProcessorEvent.showProcessorError("Error transposing file: " + e.toString());
            returnValue = false;
        }
        return returnValue;
    }

    public void processGenes(BufferedReader inReader, PrintWriter outWriter, PrintWriter rawOutWriter, PrintWriter rejOutWriter) {
        double sse;
        boolean sts;
        QValueClass qValue;
        int i;
        int j;
        int igne = 0;
        DecimalFormat dec3Format = new DecimalFormat("0.000");
        DecimalFormat dec5Format = new DecimalFormat("0.00000");
        double rcount = 0.0;
        double rc = 0.0;
        ProfileStruct selectedProfile = null;
        Gene[] geneArray = new Gene[this.m_NumGenes];
        Gene currentGene = null;
        double alpha = this.m_MainDoc.getFDRLevel();
        boolean outOfMemory = false;
        PrintWriter tmpWriter = null;
        this.m_InBootstrap = false;
        QValueComparator qValueComparator = new QValueComparator();
        BinomialDistribution binomDist = new BinomialDistribution();
        int totalSamplesDefault = 0;
        for (j = 1; j <= this.m_NumTimePoints; ++j) {
            totalSamplesDefault += this.m_SampleSizeDefault[j];
        }
        ThetaHat yb = new ThetaHat(totalSamplesDefault);
        this.m_YBar = new ThetaHat(this.m_NumTimePoints);
        this.m_YBarCyclic = new ThetaHat(this.m_NumTimePoints);
        this.m_YBarS = new ThetaHat(this.m_NumTimePoints);
        this.m_YData = new ThetaHat(totalSamplesDefault);
        this.m_YDataAdj = new ThetaHat(totalSamplesDefault);
        this.m_YnBar = new ThetaHat(this.m_NumTimePoints);
        this.m_YnBarS = new ThetaHat(this.m_NumTimePoints);
        this.m_THat1 = new ThetaHat(this.m_NumTimePoints);
        this.m_THat2 = new ThetaHat(this.m_NumTimePoints);
        this.m_THat3 = new ThetaHat(this.m_NumTimePoints);
        this.m_RawData = new ThetaHatWithZData(this.m_NumTimePoints, totalSamplesDefault);
        this.m_BootRawData = new ThetaHatWithZData(this.m_NumTimePoints, totalSamplesDefault);
        this.m_StdErr = new ThetaHat(this.m_NumTimePoints);
        this.m_StdErrBoot = new ThetaHat(this.m_NumTimePoints);
        this.m_Variance = new ThetaHat(this.m_NumTimePoints);
        this.m_VarianceBoot = new ThetaHat(this.m_NumTimePoints);
        for (j = 0; j < this.m_NumGenes; ++j) {
            Gene gene = new Gene();
            gene.inpIndex = j;
            gene.selStatus = 2;
            gene.fittedMeans = new double[this.m_NumTimePoints + 1];
            geneArray[j] = gene;
        }
        double randomResult = 0.0;
        double iu = 0.0;
        int iuInt = 0;
        this.m_GeneProcessorEvent.showProgressWindow(true);
        GeneProcessor.yield();
        int numBootStraps = this.m_MainDoc.getNumInitialBootStraps();
        int bootStrapStartIndex = 1;
        boolean continueAdaptiveBootstraps = true;
        if (this.m_mdFdr) {
            this.m_GeneProcessorEvent.updateProgress("Initializing mdFDR parameters", "");
            this.m_mdFdrCalculator.reset();
            this.m_mdFdrCalculator.setComparisonsList(this.m_mdFdrComparisonList);
            this.m_mdFdrCalculator.setNumGenes(this.m_NumGenes);
            this.m_mdFdrCalculator.setNumBootStraps(this.m_MainDoc.getNumInitialBootStraps());
            this.m_mdFdrCalculator.setRandomSeed(this.m_MainDoc.getRandomSeed());
            this.m_mdFdrCalculator.setNumTimePoints(this.m_NumTimePoints);
            this.m_mdFdrCalculator.setDefaultSampleSize(this.m_SampleSizeDefault);
            this.m_mdFdrCalculator.setAlpha(this.m_MainDoc.getFDRLevel());
            this.m_mdFdrCalculator.setGroupNameArray(this.m_GroupNameArray);
        }
        if (this.m_LinesReadAtUserBreak == 0) {
            this.writeOutputFileHeader(outWriter);
            this.writeOutputFileHeader(rejOutWriter);
            if (rawOutWriter != null) {
                this.writeRawOutputFileHeader(rawOutWriter);
            }
            try {
                this.m_GeneProcessorEvent.updateProgress("Calculating initial variance values", "");
                this.m_VarianceS0 = this.calculateVarianceS0(inReader, totalSamplesDefault);
                inReader.close();
                File inFile = this.createInputFile();
                inReader = new BufferedReader(new FileReader(inFile));
            }
            catch (IOException e) {
                this.s0 = 0.0;
            }
        }
        if (this.m_LinesReadAtUserBreak == 0) {
            this.m_RandomSeedObj.initialSeed = this.m_MainDoc.getRandomSeed();
            this.m_QValueArray.clear();
        }
        this.m_GeneProcessorEvent.updateProgress("Creating bootstrap patterns", "");
        if (this.m_mdFdr) {
            this.m_mdFdrCalculator.createBootstrapIndices();
        } else {
            try {
                this.m_BootStrapIndices = new int[this.m_MainDoc.getMaxNumBootStraps() + 1][totalSamplesDefault + 1];
            }
            catch (OutOfMemoryError ex) {
                outOfMemory = true;
                this.errMsg = "Not enough memory to run " + this.m_MainDoc.getMaxNumBootStraps() + " bootstraps.";
                this.appendErrorLog(this.errMsg);
                UtilityFunctions.showDebugMsg(this.errMsg);
                this.m_GeneProcessorEvent.logProcessorError(this.errMsg);
                this.m_BootStrapIndices = null;
                this.closeOutputFiles(outWriter, rejOutWriter, rawOutWriter);
                return;
            }
            int numReplicates = this.m_SampleSizeDefault[1];
            for (i = 1; i <= this.m_MainDoc.getMaxNumBootStraps(); ++i) {
                for (j = 1; j <= totalSamplesDefault; ++j) {
                    randomResult = this.m_MainDoc.getRandomSeed() == -1 ? Math.random() : UtilityFunctions.randomNumber(this.m_RandomSeedObj);
                    iu = (double)totalSamplesDefault * randomResult;
                    if (iu == 0.0) {
                        iuInt = totalSamplesDefault;
                    } else {
                        iuInt = (int)iu;
                        if (iuInt == 0) {
                            iuInt = totalSamplesDefault;
                        }
                    }
                    if (this.m_MainDoc.getLongitudinalSampling()) {
                        iuInt = j <= numReplicates ? (iuInt - 1) % numReplicates + 1 : this.m_BootStrapIndices[i][j - numReplicates] + numReplicates;
                    }
                    this.m_BootStrapIndices[i][j] = iuInt;
                }
            }
        }
        this.inputDataStartColumn = this.m_MainDoc.getDescColumnPresent() ? 2 : 1;
        int adaptiveLoop = 0;
        int numInvalidGenes = 0;
        this.m_GeneProcessorEvent.updateProgress("Starting main processing loop", "");
        while (continueAdaptiveBootstraps) {
            this.m_Crit.crit[0] = -1.0;
            this.errMsg = "";
            this.m_GeneID = "";
            this.skipHeaderRow(inReader);
            for (igne = 1; igne <= this.m_NumGenes; ++igne) {
                int numInvalidBootStraps;
                ProfileStruct profileStruct;
                int profileCounter;
                int k;
                this.m_InBootstrap = false;
                currentGene = geneArray[igne - 1];
                if (adaptiveLoop == 0) {
                    qValue = new QValueClass(igne);
                    this.m_QValueArray.add(qValue);
                } else {
                    qValue = (QValueClass)this.m_QValueArray.get(igne - 1);
                }
                sts = this.readNextLine(inReader, igne, totalSamplesDefault);
                if (!sts) {
                    currentGene.selStatus = 0;
                    continue;
                }
                if (igne == 1 && this.m_DebugWriter != null) {
                    for (i = 1; i <= totalSamplesDefault; ++i) {
                        this.m_DebugWriter.print("Data" + i + "\t");
                    }
                    for (i = 1; i <= this.m_NumTimePoints; ++i) {
                        this.m_DebugWriter.print("FittedMean" + i + "\t");
                    }
                    this.m_DebugWriter.println("Crit\tSSE\tPvt\ts0\n");
                }
                if (igne == 1 && this.m_DebugWriter != null) {
                    for (i = 1; i <= totalSamplesDefault; ++i) {
                        this.m_DebugWriter.print(this.m_YData.yy[i] + "\t");
                    }
                }
                if (currentGene.selStatus != 2) continue;
                GeneProcessor.yield();
                if (this.m_StopProcessing) {
                    this.m_GeneProcessorEvent.showProgressWindow(false);
                    if (this.m_GeneProcessorEvent.confirmStop()) {
                        this.m_LinesReadAtUserBreak = igne;
                        break;
                    }
                    this.m_StopProcessing = false;
                    this.m_GeneProcessorEvent.showProgressWindow(true);
                }
                if (igne < this.m_LinesReadAtUserBreak) continue;
                if (adaptiveLoop == 0) {
                    currentGene.geneId = this.m_GeneID;
                } else if (!currentGene.geneId.equals(this.m_GeneID)) {
                    UtilityFunctions.showDebugMsg("Error matching GeneID " + this.m_GeneID);
                }
                for (j = 1; j <= this.m_NumTimePoints; ++j) {
                    if (this.m_SampleSize[j] >= 2) continue;
                    this.errMsg = "Warning - Not enough data was provided at gene " + this.m_GeneID + " at time point " + j + ". This gene was not processed.";
                    this.m_GeneID = "";
                    ++numInvalidGenes;
                    break;
                }
                if (this.errMsg.length() > 0) {
                    this.appendErrorLog(this.errMsg);
                    UtilityFunctions.showDebugMsg(this.errMsg);
                    this.m_GeneProcessorEvent.logProcessorError(this.errMsg);
                }
                if (this.m_GeneID.length() == 0) {
                    currentGene.selStatus = 0;
                    currentGene.upperCi = 999.0;
                    currentGene.lowerCi = 999.0;
                    continue;
                }
                this.m_GeneProcessorEvent.updateProgress("Bootstraps = " + numBootStraps + "   Gene " + igne + " of " + this.m_NumGenes, "# selected = " + this.m_NumGenesSelected + "  # rejected = " + this.m_NumGenesRejected + "  # outstanding = " + (this.m_NumGenes - (this.m_NumGenesSelected + this.m_NumGenesRejected)));
                sse = UtilityFunctions.summary(this.m_YDataAdj.yy, this.m_YBar.yy, this.m_StdErr.yy, this.m_Variance.yy, this.m_SampleSize, this.m_NumTimePoints, this.m_RawData.z, this.s0);
                for (k = 1; k < this.m_NumTimePoints + 1; ++k) {
                    int n = k;
                    this.m_Variance.yy[n] = this.m_Variance.yy[n] + this.m_VarianceS0[k];
                }
                if (this.m_mdFdr) {
                    this.m_mdFdrCalculator.setSampleSize(this.m_SampleSize);
                    this.m_mdFdrCalculator.setYBarArray(this.m_YBar.yy);
                    this.m_mdFdrCalculator.setVarianceArray(this.m_Variance.yy);
                    this.m_mdFdrCalculator.calculatePValues(igne, this.m_YDataAdj.yy);
                    continue;
                }
                for (k = 1; k < this.m_NumTimePoints + 1; ++k) {
                    this.m_YnBar.yy[k] = -this.m_YBar.yy[k];
                }
                for (profileCounter = 0; profileCounter < this.m_LastProfileIndex; ++profileCounter) {
                    profileStruct = this.m_ProfileTable[profileCounter];
                    switch (profileStruct.type) {
                        case 1: {
                            this.simpleOrderProfile(profileCounter);
                            break;
                        }
                        case 2: {
                            this.umbrellaOrderProfile(profileCounter);
                            break;
                        }
                        case 3: {
                            this.cyclicOrderProfile(profileCounter);
                        }
                    }
                    profileStruct.critValue = this.m_Crit.crit[profileCounter + 1];
                }
                currentGene.selProfile = this.molicl(this.m_Pvt, this.m_Crit, this.m_NumProfiles);
                selectedProfile = this.m_ProfileTable[currentGene.selProfile - 1];
                if (selectedProfile.initialSlope == 1) {
                    System.arraycopy(this.m_Hp.hp, 0, currentGene.fittedMeans, 0, this.m_NumTimePoints + 1);
                } else {
                    for (k = 1; k <= this.m_NumTimePoints; ++k) {
                        currentGene.fittedMeans[k] = this.m_Hpp.hp[this.m_NumTimePoints + 1 - k];
                    }
                }
                this.m_Pvt.pvt = sse > 0.0 ? this.m_Crit.crit[currentGene.selProfile] / sse : 1.0E10;
                if (igne == 1 && this.m_DebugWriter != null) {
                    this.getFittedValuesNonCyclic(selectedProfile);
                    for (i = 1; i <= this.m_NumTimePoints; ++i) {
                        this.m_DebugWriter.print(currentGene.fittedMeans[i] + "\t");
                    }
                    this.m_DebugWriter.print(this.m_Crit.crit[currentGene.selProfile] + "\t");
                    this.m_DebugWriter.print(sse + "\t");
                    this.m_DebugWriter.print(this.m_Pvt.pvt + "\t");
                    this.m_DebugWriter.println(this.s0);
                }
                if (numBootStraps > this.m_MainDoc.getNumInitialBootStraps()) {
                    rcount = currentGene.rcount;
                    bootStrapStartIndex = currentGene.numBootStraps + 1;
                    numInvalidBootStraps = currentGene.numInvalidBootStraps;
                } else {
                    rcount = 0.0;
                    bootStrapStartIndex = 1;
                    numInvalidBootStraps = 0;
                }
                this.m_InBootstrap = true;
                for (int iboot = bootStrapStartIndex; iboot <= numBootStraps; ++iboot) {
                    int totalSamples;
                    this.getBoot(this.m_YData, this.m_RandomSeedObj, totalSamplesDefault, yb, iboot);
                    if (igne == 1 && this.m_DebugWriter != null) {
                        for (i = 1; i <= totalSamplesDefault; ++i) {
                            this.m_DebugWriter.print(yb.yy[i] + "\t");
                        }
                    }
                    if ((totalSamples = this.adjustForMissingData(yb)) <= 0) {
                        ++numInvalidBootStraps;
                        continue;
                    }
                    double sses = UtilityFunctions.summary(yb.yy, this.m_YBarS.yy, this.m_StdErrBoot.yy, this.m_VarianceBoot.yy, this.m_SampleSize, this.m_NumTimePoints, this.m_BootRawData.z, this.s0);
                    for (k = 1; k < this.m_NumTimePoints + 1; ++k) {
                        int n = k;
                        this.m_VarianceBoot.yy[n] = this.m_VarianceBoot.yy[n] + this.m_VarianceS0[k];
                    }
                    for (k = 1; k < this.m_NumTimePoints + 1; ++k) {
                        this.m_YnBarS.yy[k] = -this.m_YBarS.yy[k];
                    }
                    block33: for (profileCounter = 0; profileCounter < this.m_LastProfileIndex; ++profileCounter) {
                        profileStruct = this.m_ProfileTable[profileCounter];
                        switch (profileStruct.type) {
                            case 1: {
                                this.simpleOrderProfile(profileCounter);
                                continue block33;
                            }
                            case 2: {
                                this.umbrellaOrderProfile(profileCounter);
                                continue block33;
                            }
                            case 3: {
                                this.cyclicOrderProfile(profileCounter);
                            }
                        }
                    }
                    int selProfile = this.molicl(this.m_Pvboot, this.m_Crit, this.m_NumProfiles);
                    if (igne == 1 && this.m_DebugWriter != null) {
                        selectedProfile = this.m_ProfileTable[selProfile - 1];
                        for (i = 1; i <= this.m_NumTimePoints; ++i) {
                            if (selectedProfile.initialSlope == 1) {
                                this.m_DebugWriter.print(this.m_Tp.hp[i] + "\t");
                                continue;
                            }
                            this.m_DebugWriter.print(this.m_Tp.hp[this.m_NumTimePoints + 1 - i] + "\t");
                        }
                        this.m_DebugWriter.print(this.m_Crit.crit[currentGene.selProfile] + "\t");
                        this.m_DebugWriter.print(sses + "\t");
                    }
                    this.m_Pvboot.pvt = sses > 0.0 ? (this.m_Pvboot.pvt /= sses) : 1.0E10;
                    if (igne == 1 && this.m_DebugWriter != null) {
                        this.m_DebugWriter.println(this.m_Pvboot.pvt);
                    }
                    if (!(this.m_Pvboot.pvt >= this.m_Pvt.pvt)) continue;
                    rcount += 1.0;
                }
                this.m_InBootstrap = false;
                int numValidBootStraps = numBootStraps - numInvalidBootStraps;
                currentGene.pValue = rc = (rcount + 1.0) / (double)(numValidBootStraps + 2);
                currentGene.numBootStraps = numBootStraps;
                currentGene.numInvalidBootStraps = numInvalidBootStraps;
                currentGene.rcount = rcount;
                qValue.pValue = rc;
                binomDist.setParameters(numValidBootStraps, rc);
                currentGene.lowerCi = binomDist.inverseCDF(0.005) / (double)numValidBootStraps;
                currentGene.upperCi = binomDist.inverseCDF(0.995) / (double)numValidBootStraps;
            }
            if (this.m_StopProcessing) break;
            if (this.m_mdFdr) {
                this.m_NumGenesSelected = this.m_mdFdrCalculator.selectSignificantGenes();
                this.m_NumGenesRejected = this.m_NumGenes - this.m_NumGenesSelected;
                for (i = geneArray.length - 1; i >= 0; --i) {
                    currentGene = geneArray[i];
                    currentGene.selStatus = this.m_mdFdrCalculator.getSelectStatus(i + 1);
                }
            } else {
                this.m_NumGenesSelected = 0;
                this.m_NumGenesRejected = 0;
                boolean setAccept = false;
                Arrays.sort(geneArray, new UpperCiComparator());
                for (i = geneArray.length - 1; i >= 0; --i) {
                    currentGene = geneArray[i];
                    if (currentGene.upperCi < (double)(i + 1) * alpha / (double)this.m_NumGenes) {
                        setAccept = true;
                    }
                    if (!setAccept) continue;
                    currentGene.selStatus = 1;
                    ++this.m_NumGenesSelected;
                }
                Arrays.sort(geneArray, new LowerCiComparator());
                if (alpha < 1.0 && numInvalidGenes < this.m_NumGenes) {
                    int rejectLimit = 0;
                    for (i = geneArray.length - 1; i >= 0; --i) {
                        currentGene = geneArray[i];
                        if (!(currentGene.lowerCi < (double)(i + 1) * alpha / (double)(this.m_NumGenes - numInvalidGenes))) continue;
                        rejectLimit = i + 1;
                        break;
                    }
                    for (i = rejectLimit; i < geneArray.length; ++i) {
                        currentGene = geneArray[i];
                        currentGene.selStatus = 0;
                        ++this.m_NumGenesRejected;
                    }
                }
                if ((numBootStraps *= 2) > this.m_MainDoc.getMaxNumBootStraps()) {
                    Arrays.sort(geneArray, new PValueComparator());
                    boolean acceptSts = false;
                    for (i = geneArray.length - 1; i >= 0; --i) {
                        currentGene = geneArray[i];
                        if (currentGene.selStatus != 2) continue;
                        if (acceptSts || alpha >= 1.0 || currentGene.pValue < (double)(i + 1) * alpha / (double)(this.m_NumGenes - numInvalidGenes)) {
                            currentGene.selStatus = 1;
                            ++this.m_NumGenesSelected;
                            acceptSts = true;
                            continue;
                        }
                        currentGene.selStatus = 0;
                        ++this.m_NumGenesRejected;
                    }
                }
            }
            this.m_GeneProcessorEvent.updateProgress("Bootstraps = " + numBootStraps + "   Gene " + (igne - 1) + " of " + this.m_NumGenes, "# selected = " + this.m_NumGenesSelected + "  # rejected = " + this.m_NumGenesRejected + "  # outstanding = " + (this.m_NumGenes - (this.m_NumGenesSelected + this.m_NumGenesRejected)));
            inReader = this.closeAndOpenInputFile(inReader);
            if (inReader == null) break;
            if (!this.m_mdFdr) {
                Arrays.sort(geneArray, new GeneIndexComparator());
            }
            boolean cont = false;
            for (i = 0; i < geneArray.length; ++i) {
                currentGene = geneArray[i];
                if (currentGene.selStatus != 2) continue;
                cont = true;
                break;
            }
            if (!cont) break;
            ++adaptiveLoop;
        }
        if (this.m_StopProcessing) {
            this.closeOutputFiles(outWriter, rejOutWriter, rawOutWriter);
            return;
        }
        int overallOutputIndex = 0;
        for (int writingLoopIndex = 0; writingLoopIndex <= 1; ++writingLoopIndex) {
            if (writingLoopIndex == 0) {
                tmpWriter = outWriter;
                this.m_GeneProcessorEvent.updateProgress("Writing accepted genes to output file", "");
            } else {
                tmpWriter = rejOutWriter;
                this.m_GeneProcessorEvent.updateProgress("Writing rejected genes to output file", "");
                inReader = this.closeAndOpenInputFile(inReader);
                if (inReader == null) break;
            }
            this.skipHeaderRow(inReader);
            for (igne = 1; igne <= this.m_NumGenes; ++igne) {
                int r;
                String tmpStr;
                currentGene = geneArray[igne - 1];
                sts = this.readNextLine(inReader, igne, totalSamplesDefault);
                if (!sts || currentGene.selStatus == 1 && writingLoopIndex == 1 || currentGene.selStatus == 0 && writingLoopIndex == 0) continue;
                tmpWriter.print(++overallOutputIndex + "\t");
                tmpWriter.print(igne + "\t");
                tmpWriter.print(this.m_GeneID + "\t");
                tmpWriter.print(this.m_GeneDesc + "\t");
                sse = UtilityFunctions.summary(this.m_YDataAdj.yy, this.m_YBar.yy, this.m_StdErr.yy, this.m_Variance.yy, this.m_SampleSize, this.m_NumTimePoints, this.m_RawData.z, this.s0);
                if (this.m_mdFdr) {
                    tmpStr = this.m_mdFdrCalculator.getPValuesStr(igne, this.m_YBar.yy, this.m_MainDoc.getLogTransformType());
                    tmpWriter.print(tmpStr);
                } else {
                    if (currentGene.selProfile < 1) continue;
                    selectedProfile = this.m_ProfileTable[currentGene.selProfile - 1];
                    if (selectedProfile.type == 3) {
                        int it;
                        for (it = 1; it <= this.m_NumTimePoints; ++it) {
                            this.m_YnBar.yy[it] = -this.m_YBar.yy[it];
                        }
                        this.cyclicOrderProfile(selectedProfile.userSelectionNumber - 1);
                        for (it = 1; it <= this.m_NumTimePoints; ++it) {
                            this.m_Hp.hp[it] = this.m_CyclicDataValues[it];
                        }
                    } else {
                        this.getFittedValuesNonCyclic(selectedProfile);
                    }
                    tmpWriter.print(selectedProfile.userSelectionNumber + "\t");
                    tmpStr = dec5Format.format(currentGene.pValue);
                    tmpWriter.print(tmpStr + "\t");
                    tmpWriter.print(".\t");
                    for (r = 1; r <= this.m_NumTimePoints; ++r) {
                        tmpStr = dec3Format.format(this.m_Hp.hp[r]);
                        tmpWriter.print(tmpStr + "\t");
                    }
                }
                for (r = 1; r <= this.m_NumTimePoints; ++r) {
                    tmpStr = dec3Format.format(this.m_YBar.yy[r]);
                    tmpWriter.print(tmpStr + "\t");
                }
                for (r = 1; r <= this.m_NumTimePoints; ++r) {
                    tmpStr = dec3Format.format(this.m_StdErr.yy[r]);
                    tmpWriter.print(tmpStr + "\t");
                }
                if (!this.m_mdFdr) {
                    tmpWriter.print(currentGene.numBootStraps);
                }
                tmpWriter.println("");
                if (rawOutWriter == null || writingLoopIndex != 0) continue;
                rawOutWriter.print(this.m_GeneID + "\t");
                if (!this.m_mdFdr) {
                    rawOutWriter.print(selectedProfile.userSelectionNumber + "\t");
                }
                for (r = this.inputDataStartColumn; r < this.numInputTokens; ++r) {
                    rawOutWriter.print(this.inputTokens[r] + "\t");
                }
                rawOutWriter.println();
                this.m_GeneProcessorEvent.logProcessorEvent("  Gene selected: " + this.m_GeneID);
            }
        }
        this.closeOutputFiles(outWriter, rejOutWriter, rawOutWriter);
        if (this.m_mdFdr) {
            this.m_GeneProcessorEvent.updateProgress("Re-sorting results files", "");
            sts = this.m_mdFdrCalculator.resortOutputFile(this.m_OutputFileName);
            if (!sts) {
                this.m_GeneProcessorEvent.showProcessorError(this.m_mdFdrCalculator.getLastError());
            }
        }
        if (this.m_DebugWriter != null) {
            this.m_DebugWriter.close();
        }
        if (this.m_QValueArray.size() >= this.m_NumGenes) {
            this.m_GeneProcessorEvent.updateProgress("Calculating q-Values", "");
            qValueComparator.comparisonType = 1;
            Collections.sort(this.m_QValueArray, qValueComparator);
            double lambda = this.calculateBestLambda(this.m_QValueArray);
            double pi0 = this.calculatePi0(this.m_QValueArray, lambda);
            UtilityFunctions.showDebugMsg("lambda = " + lambda + "  pi0 = " + pi0);
            if (pi0 > 0.0) {
                double pFDR;
                qValue = (QValueClass)this.m_QValueArray.get(this.m_NumGenes - 1);
                qValue.qValue = pFDR = this.calculateFDR(qValue, this.m_NumGenes - 1, pi0, this.m_NumGenes);
                double prevQValue = pFDR;
                for (int idx = igne - 3; idx >= 0; --idx) {
                    qValue = (QValueClass)this.m_QValueArray.get(idx);
                    pFDR = this.calculateFDR(qValue, idx, pi0, igne);
                    prevQValue = qValue.qValue = Math.min(pFDR, prevQValue);
                }
                qValueComparator.comparisonType = 2;
                Collections.sort(this.m_QValueArray, qValueComparator);
                this.m_GeneProcessorEvent.updateProgress("Adding q-Values to output file", "");
                this.addQValuesToOutputFile(this.m_QValueArray, this.m_OutputFileName);
                this.addQValuesToOutputFile(this.m_QValueArray, this.m_RejectedGenesFileName);
            }
        }
    }

    private void closeOutputFiles(PrintWriter outWriter, PrintWriter rawOutWriter, PrintWriter rejOutWriter) {
        if (outWriter != null) {
            outWriter.close();
        }
        if (rejOutWriter != null) {
            rejOutWriter.close();
        }
        if (rawOutWriter != null) {
            rawOutWriter.close();
            if (this.m_MainDoc.getTranspose()) {
                this.m_GeneProcessorEvent.updateProgress("Transposing raw output file", "");
                this.transposeFile(this.m_RawOutputTransposeFileName, this.m_RawOutputFileName, true);
            }
        }
    }

    private void skipHeaderRow(BufferedReader inReader) {
        if (this.m_MainDoc.getHeaderRowPresent()) {
            try {
                inReader.readLine();
            }
            catch (IOException e) {
                UtilityFunctions.showDebugMsg(e.getMessage());
            }
        }
    }

    private int adjustForMissingData(ThetaHat yData) {
        int totalSamples = 0;
        int totalSamplesDefault = 0;
        for (int i = 1; i <= this.m_NumTimePoints; ++i) {
            this.m_SampleSize[i] = 0;
            for (int j = 1; j <= this.m_SampleSizeDefault[i]; ++j) {
                if (!(yData.yy[++totalSamplesDefault] < Double.MAX_VALUE)) continue;
                int n = i;
                this.m_SampleSize[n] = this.m_SampleSize[n] + 1;
                yData.yy[++totalSamples] = yData.yy[totalSamplesDefault];
            }
            if (this.m_SampleSize[i] != 0) continue;
            totalSamples = -1;
            break;
        }
        return totalSamples;
    }

    private void createBootstrapData(UtilityFunctions.RandomSeed m_RandomSeedObj, double[] inData, int totalPoints, double[] outData) {
        for (int i = 0; i < totalPoints; ++i) {
            int randomInt = this.m_MainDoc.getRandomSeed() == -1 ? (int)((double)totalPoints * Math.random()) : (int)((double)totalPoints * UtilityFunctions.randomNumber(m_RandomSeedObj));
            outData[i] = inData[randomInt];
        }
    }

    private String getRawOutputFileName(String appendStr) {
        int strpos = this.m_OutputFileName.lastIndexOf(46);
        String returnValue = strpos > 0 ? this.m_OutputFileName.substring(0, strpos) + appendStr + this.m_OutputFileName.substring(strpos) : this.m_OutputFileName + appendStr;
        return returnValue;
    }

    private boolean readNextLine(BufferedReader in, int igne, int totalSamplesDefault) {
        int numMissing = 0;
        int currentTimePoint = 1;
        boolean returnValue = true;
        try {
            for (int i = 0; i < 30; ++i) {
                this.m_SampleSize[i] = this.m_SampleSizeDefault[i];
            }
            Arrays.fill(this.m_YData.yy, Double.MAX_VALUE);
            Arrays.fill(this.m_YDataAdj.yy, Double.MAX_VALUE);
            this.errMsg = "";
            this.m_GeneID = "";
            this.m_GeneDesc = "";
            String tmpStr = in.readLine();
            if (tmpStr != null) {
                this.inputTokens = tmpStr.split("\t");
                this.numInputTokens = this.inputTokens.length;
                if (this.numInputTokens <= totalSamplesDefault) {
                    this.errMsg = "Warning - The format of the input file at Gene #" + igne + " does not conform to the input specifications. This gene was not processed.";
                    this.m_GeneID = "";
                } else {
                    try {
                        int columnNumber;
                        numMissing = 0;
                        currentTimePoint = 1;
                        int numColumnsThisTimePoint = 0;
                        this.m_GeneID = this.inputTokens[0];
                        int arrayIndex = 1;
                        if (this.m_MainDoc.getDescColumnPresent()) {
                            this.m_GeneDesc = this.inputTokens[1];
                            columnNumber = 2;
                        } else {
                            this.m_GeneDesc = "";
                            columnNumber = 1;
                        }
                        while (columnNumber < this.numInputTokens && arrayIndex <= totalSamplesDefault) {
                            if (++numColumnsThisTimePoint > this.m_SampleSizeDefault[currentTimePoint]) {
                                ++currentTimePoint;
                                numColumnsThisTimePoint = 1;
                            }
                            if (this.inputTokens[columnNumber].trim().equals(".")) {
                                ++numMissing;
                                this.m_YData.yy[arrayIndex] = Double.MAX_VALUE;
                                int n = currentTimePoint;
                                this.m_SampleSize[n] = this.m_SampleSize[n] - 1;
                            } else {
                                try {
                                    this.m_YData.yy[arrayIndex] = Double.valueOf(this.inputTokens[columnNumber]);
                                    if (this.m_MainDoc.getLogTransformType() == 0) {
                                        if (this.m_YData.yy[arrayIndex] < 0.0) {
                                            this.errMsg = "Cannot have negative values if taking log, Gene = " + this.m_GeneID;
                                            this.m_GeneID = "";
                                            break;
                                        }
                                        this.m_YData.yy[arrayIndex] = Math.log(this.m_YData.yy[arrayIndex]);
                                    }
                                    this.m_YDataAdj.yy[arrayIndex - numMissing] = this.m_YData.yy[arrayIndex];
                                }
                                catch (NumberFormatException e) {
                                    this.errMsg = "Error reading gene " + this.m_GeneID + ": " + e.getMessage();
                                    this.m_GeneID = "";
                                    break;
                                }
                            }
                            ++arrayIndex;
                            ++columnNumber;
                        }
                    }
                    catch (NumberFormatException e) {
                        this.errMsg = "Error reading gene " + this.m_GeneID + ": " + e.getMessage() + " This gene was not processed.";
                        this.m_GeneID = "";
                    }
                }
            }
            if (this.errMsg.length() > 0) {
                this.appendErrorLog(this.errMsg);
                UtilityFunctions.showDebugMsg(this.errMsg);
            }
        }
        catch (Exception e) {
            UtilityFunctions.showDebugMsg("Error reading gene #" + igne + ": " + e.getMessage() + " This gene was not processed.");
            returnValue = false;
            this.m_GeneID = "";
        }
        return returnValue;
    }

    private BufferedReader closeAndOpenInputFile(BufferedReader in) {
        BufferedReader returnValue = null;
        try {
            in.close();
            returnValue = new BufferedReader(new FileReader(this.infile));
        }
        catch (IOException ex) {
            UtilityFunctions.showDebugMsg("Error in closeAndOpenInputFile = " + ex.toString());
        }
        return returnValue;
    }

    private double calculateFDR(QValueClass qValue, int geneIndex, double pi0, int numGenes) {
        double tmpVal;
        double pFDR = 0.0;
        double R = geneIndex + 1;
        double prP = R / (double)this.m_NumGenes;
        double gamma = qValue.pValue;
        if (gamma != 0.0 && (pFDR = pi0 * gamma / (prP * (1.0 - (tmpVal = Math.pow(1.0 - gamma, numGenes))))) > 1.0) {
            pFDR = 1.0;
        }
        return pFDR;
    }

    private double calculatePi0(ArrayList qValueList, double lambda) {
        double returnValue = 0.0;
        ListIterator it = qValueList.listIterator();
        double W = 0.0;
        int numGenes = qValueList.size();
        while (it.hasNext()) {
            QValueClass qValue = (QValueClass)it.next();
            if (!(qValue.pValue > lambda)) continue;
            W += 1.0;
        }
        returnValue = W / ((1.0 - lambda) * (double)numGenes);
        return returnValue;
    }

    private double calculatePi0(double[] pValueArray, int arraySize, double lambda) {
        double returnValue = 0.0;
        double W = 0.0;
        for (int i = 0; i < arraySize; ++i) {
            if (!(pValueArray[i] > lambda)) continue;
            W += 1.0;
        }
        returnValue = W / ((1.0 - lambda) * (double)arraySize);
        return returnValue;
    }

    private boolean addQValuesToOutputFile(ArrayList qValueList, String fileName) {
        boolean returnValue = true;
        DecimalFormat dec5Format = new DecimalFormat("0.00000");
        String tmpFilename = "";
        boolean appendQValue = false;
        try {
            String tmpStr;
            BufferedReader in = new BufferedReader(new FileReader(fileName));
            tmpFilename = fileName + "_tmp";
            PrintWriter out1 = new PrintWriter(new FileOutputStream(tmpFilename));
            while ((tmpStr = in.readLine()) != null) {
                if (appendQValue) {
                    String[] tokens = tmpStr.split("\t");
                    if (tokens.length > 5) {
                        int i;
                        for (i = 0; i <= 5; ++i) {
                            out1.print(tokens[i] + "\t");
                        }
                        int initialIndex = Integer.parseInt(tokens[1]);
                        QValueClass qVal = (QValueClass)qValueList.get(initialIndex - 1);
                        out1.print(dec5Format.format(qVal.qValue) + "\t");
                        for (i = 7; i < tokens.length; ++i) {
                            out1.print(tokens[i] + "\t");
                        }
                        out1.println();
                    } else {
                        out1.println(tmpStr);
                    }
                } else {
                    out1.println(tmpStr);
                }
                if (tmpStr.indexOf("Index") != 0) continue;
                appendQValue = true;
            }
            in.close();
            out1.close();
        }
        catch (IOException e) {
            UtilityFunctions.showDebugMsg(e.getMessage());
            returnValue = false;
        }
        if (returnValue) {
            boolean sts = new File(fileName).delete();
            if (sts) {
                File file1 = new File(tmpFilename);
                File file2 = new File(fileName);
                sts = file1.renameTo(file2);
                if (!sts) {
                    UtilityFunctions.showDebugMsg("Could not rename files after adding Q values");
                }
            } else {
                UtilityFunctions.showDebugMsg("Could not delete " + fileName + " when adding Q values");
            }
        }
        return returnValue;
    }

    private double calculateBestLambda(ArrayList qValueList) {
        int j;
        int i;
        if (qValueList.size() == 0) {
            return 0.0;
        }
        int NUM_LAMBDA_VALUES = 20;
        int NUM_LAMBDA_BOOTSTRAPS = 500;
        double LAMBDA_INCREMENT = 0.05;
        double[] lambdaArray = new double[20];
        double[][] pFDRArray = new double[20][500];
        double[] minFDRArray = new double[500];
        double[] bootstrapPValueArray = new double[500];
        double[] mseArray = new double[20];
        Random rnd = null;
        rnd = this.m_MainDoc.getRandomSeed() == -1 ? new Random() : new Random(this.m_MainDoc.getRandomSeed());
        for (i = 0; i < 500; ++i) {
            int randomIndex = rnd.nextInt(qValueList.size());
            QValueClass tmpQValue = (QValueClass)qValueList.get(randomIndex);
            bootstrapPValueArray[i] = tmpQValue.pValue;
            minFDRArray[i] = 1.0E10;
        }
        Arrays.sort(bootstrapPValueArray);
        for (i = 0; i < 20; ++i) {
            lambdaArray[i] = (double)i * 0.05;
            double pi0 = this.calculatePi0(bootstrapPValueArray, 500, lambdaArray[i]);
            for (j = 0; j < 500; ++j) {
                double prP = (double)(j + 1) / 500.0;
                if (bootstrapPValueArray[j] == 0.0) continue;
                double tmpVal = Math.pow(1.0 - bootstrapPValueArray[j], 500.0);
                pFDRArray[i][j] = pi0 * bootstrapPValueArray[j] / (prP * (1.0 - tmpVal));
                if (pFDRArray[i][j] > 1.0) {
                    pFDRArray[i][j] = 1.0;
                }
                if (!(pFDRArray[i][j] < minFDRArray[j])) continue;
                minFDRArray[j] = pFDRArray[i][j];
            }
        }
        int bestIndex = 0;
        for (i = 0; i < 20; ++i) {
            double sumSq = 0.0;
            for (j = 0; j < 500; ++j) {
                sumSq += Math.pow(pFDRArray[i][j] - minFDRArray[i], 2.0);
            }
            mseArray[i] = sumSq / 500.0;
            if (!(mseArray[i] < mseArray[bestIndex])) continue;
            bestIndex = i;
        }
        return lambdaArray[bestIndex];
    }

    private double calculateS0(BufferedReader in, int totalSamplesDefault) {
        double returnValue = 1.0E-10;
        int numValues = 0;
        double[] sseValues = new double[this.m_NumGenes];
        ThetaHat stdErr = new ThetaHat(this.m_NumTimePoints);
        ThetaHat variance = new ThetaHat(this.m_NumTimePoints);
        this.skipHeaderRow(in);
        for (int i = 0; i < this.m_NumGenes; ++i) {
            double sse;
            boolean sts = this.readNextLine(in, i, totalSamplesDefault);
            if (!sts) continue;
            sseValues[numValues] = sse = UtilityFunctions.summary(this.m_YDataAdj.yy, this.m_YBar.yy, stdErr.yy, variance.yy, this.m_SampleSize, this.m_NumTimePoints, this.m_RawData.z, Double.MAX_VALUE);
            ++numValues;
        }
        Arrays.sort(sseValues, 0, numValues - 1);
        int s0Index = (int)(this.m_MainDoc.getS0Percentile() / 100.0 * (double)numValues);
        returnValue = sseValues[s0Index];
        return returnValue;
    }

    private double[] calculateVarianceS0(BufferedReader in, int totalSamplesDefault) {
        double[] varValues;
        int j;
        double[] returnValue = new double[this.m_NumTimePoints + 1];
        int numValues = 0;
        ArrayList<double[]> varArrayList = new ArrayList<double[]>();
        ThetaHat stdErr = new ThetaHat(this.m_NumTimePoints);
        ThetaHat variance = new ThetaHat(this.m_NumTimePoints);
        for (j = 0; j < this.m_NumTimePoints; ++j) {
            varValues = new double[this.m_NumGenes];
            varArrayList.add(varValues);
        }
        if (!this.m_mdFdr && this.m_MainDoc.getS0Percentile() > 0.0) {
            this.skipHeaderRow(in);
            for (int i = 0; i < this.m_NumGenes; ++i) {
                boolean sts = this.readNextLine(in, i, totalSamplesDefault);
                if (!sts) continue;
                UtilityFunctions.summary(this.m_YDataAdj.yy, this.m_YBar.yy, stdErr.yy, variance.yy, this.m_SampleSize, this.m_NumTimePoints, this.m_RawData.z, Double.MAX_VALUE);
                for (j = 0; j < this.m_NumTimePoints; ++j) {
                    varValues = (double[])varArrayList.get(j);
                    varValues[i] = variance.yy[j + 1];
                }
                ++numValues;
            }
            int s0Index = (int)(this.m_MainDoc.getS0Percentile() / 100.0 * (double)numValues);
            for (j = 0; j < this.m_NumTimePoints; ++j) {
                varValues = (double[])varArrayList.get(j);
                Arrays.sort(varValues, 0, numValues - 1);
                returnValue[j + 1] = varValues[s0Index];
            }
        } else {
            for (j = 1; j <= this.m_NumTimePoints; ++j) {
                returnValue[j] = 0.0;
            }
        }
        return returnValue;
    }

    private void appendErrorLog(String a_ErrorMsg) {
        try {
            PrintWriter out1 = new PrintWriter(new FileOutputStream(this.m_MainDoc.getErrorFileName(), true));
            Date now = new Date();
            out1.print(now.toString() + " -- ");
            out1.println(a_ErrorMsg);
            out1.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private double calculateSseValue(int a_StartIndex, int a_EndIndex) {
        double returnValue = 0.0;
        int numPts = a_EndIndex - a_StartIndex + 1;
        int counter = 0;
        for (int i = a_StartIndex; i <= a_EndIndex; ++i) {
            for (int j = 1; j <= this.m_SampleSize[i]; ++j) {
                ++counter;
                double xyz = this.m_RawData.z[i][j] - this.m_YBar.yy[i];
                returnValue += xyz * xyz;
            }
        }
        if (counter > a_EndIndex - a_StartIndex + 1) {
            returnValue = Math.sqrt(returnValue / (double)(counter - numPts));
        }
        return returnValue;
    }

    private ProfileStruct findCorrespondingCyclicProfile(ProfileStruct selectedProfile, SubRegion simpleOrderSubRegion) {
        ProfileStruct returnValue = null;
        boolean foundIt = false;
        for (int i = 0; i <= this.m_LastProfileIndex; ++i) {
            if (this.m_ProfileTable[i].type != 3 || this.m_ProfileTable[i].initialSlope != selectedProfile.initialSlope) continue;
            if (this.m_ProfileTable[i].initialSlope == 1) {
                if (this.m_ProfileTable[i].timePointAtMax == simpleOrderSubRegion.startIndex && this.m_ProfileTable[i].timePointAtMin == simpleOrderSubRegion.endIndex) {
                    foundIt = true;
                }
            } else if (this.m_ProfileTable[i].timePointAtMin == simpleOrderSubRegion.startIndex && this.m_ProfileTable[i].timePointAtMax == simpleOrderSubRegion.endIndex) {
                foundIt = true;
            }
            if (!foundIt) continue;
            returnValue = this.m_ProfileTable[i];
            break;
        }
        return returnValue;
    }

    private ProfileStruct findCorrespondingUmbProfile(ProfileStruct selectedProfile, SubRegion[] subRegions) {
        ProfileStruct returnValue = null;
        int sigCode = 0;
        for (int i = 0; i < 3; ++i) {
            if (!subRegions[i].isSignificant) continue;
            sigCode = (int)((double)sigCode + Math.pow(2.0, i));
        }
        switch (sigCode) {
            case 0: {
                UtilityFunctions.showDebugMsg("All regions insignificant in findCorrespondingUmb");
                return null;
            }
            case 1: {
                returnValue = this.findProfile(1, selectedProfile.initialSlope, this.m_NumTimePoints);
                break;
            }
            case 2: {
                if (selectedProfile.initialSlope == 1) {
                    returnValue = this.findProfile(1, 2, this.m_NumTimePoints);
                    break;
                }
                returnValue = this.findProfile(1, 1, this.m_NumTimePoints);
                break;
            }
            case 3: {
                returnValue = this.findProfile(2, selectedProfile.initialSlope, subRegions[0].endIndex);
                break;
            }
            case 4: {
                returnValue = this.findProfile(1, selectedProfile.initialSlope, this.m_NumTimePoints);
                break;
            }
            case 5: {
                returnValue = this.findProfile(1, selectedProfile.initialSlope, this.m_NumTimePoints);
                break;
            }
            case 6: {
                if (selectedProfile.initialSlope == 1) {
                    returnValue = this.findProfile(2, 2, subRegions[1].endIndex);
                    break;
                }
                returnValue = this.findProfile(2, 1, subRegions[1].endIndex);
                break;
            }
            case 7: {
                return null;
            }
        }
        return returnValue;
    }

    private ProfileStruct findCorrespondingSimpleOrderProfile(ProfileStruct selectedProfile, SubRegion[] subRegions) {
        ProfileStruct returnValue = null;
        boolean foundIt = false;
        int sigCode = 0;
        for (int i = 0; i < 2; ++i) {
            if (!subRegions[i].isSignificant) continue;
            sigCode = (int)((double)sigCode + Math.pow(2.0, i));
        }
        switch (sigCode) {
            case 0: {
                UtilityFunctions.showDebugMsg("All regions insignificant in findCorrespondingSimpleOrder");
                return null;
            }
            case 1: {
                returnValue = this.findProfile(1, selectedProfile.initialSlope, this.m_NumTimePoints);
                break;
            }
            case 2: {
                if (selectedProfile.initialSlope == 1) {
                    returnValue = this.findProfile(1, 2, this.m_NumTimePoints);
                    break;
                }
                returnValue = this.findProfile(1, 1, this.m_NumTimePoints);
                break;
            }
            case 3: {
                return null;
            }
        }
        return returnValue;
    }

    private ProfileStruct findProfile(int type, int direction, int nodePt) {
        ProfileStruct returnValue = null;
        for (int i = 0; i < this.m_LastProfileIndex; ++i) {
            ProfileStruct tmpProfile = this.m_ProfileTable[i];
            if (tmpProfile.type == 1 && type == 1 && tmpProfile.initialSlope == direction) {
                returnValue = tmpProfile;
                break;
            }
            if (tmpProfile.type != type || tmpProfile.initialSlope != direction || tmpProfile.peakIndex != nodePt) continue;
            returnValue = tmpProfile;
            break;
        }
        return returnValue;
    }

    private void getFittedValuesNonCyclic(ProfileStruct selectedProfile) {
        if (selectedProfile.initialSlope == 1) {
            this.umbl(this.m_NumTimePoints, this.m_YBar, this.m_StdErr, selectedProfile.peakIndex, this.m_T1, this.m_T2, this.m_Hp, 1, this.m_SampleSize, this.m_Variance.yy);
        } else {
            int it;
            for (it = 1; it <= this.m_NumTimePoints; ++it) {
                this.m_YnBar.yy[it] = -this.m_YBar.yy[it];
            }
            this.umbl(this.m_NumTimePoints, this.m_YnBar, this.m_StdErr, selectedProfile.peakIndex, this.m_T1, this.m_T2, this.m_Hp1, 2, this.m_SampleSize, this.m_Variance.yy);
            for (it = 1; it <= this.m_NumTimePoints; ++it) {
                this.m_Hp.hp[it] = -this.m_Hp1.hp[it];
            }
        }
    }

    private boolean writeOutputFileHeader(PrintWriter out) {
        boolean returnValue = true;
        try {
            String headerStr;
            int i;
            out.println("ORIOGEN Version 4.01");
            out.println("Input data:");
            out.println("Input file\t" + this.m_MainDoc.getInputFileName());
            out.println("Total genes\t" + this.m_NumGenes);
            out.println("Dose groups/Time points\t" + this.m_NumTimePoints);
            out.println("Sample sizes\t" + this.m_MainDoc.createSampleSizeString());
            out.println("Initial Bootstrap samples\t" + this.m_MainDoc.getNumInitialBootStraps());
            out.println("Maximum Bootstrap samples\t" + this.m_MainDoc.getMaxNumBootStraps());
            out.println("FDR Level\t" + this.m_MainDoc.getFDRLevel());
            out.println("S0 Percentile\t" + this.m_MainDoc.getS0Percentile());
            out.println("Longitudinal sampling\t" + this.m_MainDoc.getLongitudinalSampling());
            out.println("Log transform\t" + OriogenConstants.STR_LOG_TRANSFORM_OPTIONS[this.m_MainDoc.getLogTransformType()]);
            out.println("Transpose data\t" + this.m_MainDoc.getTranspose());
            if (this.m_MainDoc.getRandomSeed() == -1) {
                out.println("Bootstrap random seed\tAutomatic");
            } else {
                out.println("Bootstrap random seed\t" + this.m_MainDoc.getRandomSeed());
            }
            out.println("Pairwise Comparison Analysis\t" + this.m_mdFdr);
            if (this.m_mdFdr) {
                out.println("Group Naming:");
                for (i = 0; i < this.m_NumTimePoints; ++i) {
                    out.println("\tGroup " + (i + 1) + ":\t" + this.m_GroupNameArray[i]);
                }
            }
            out.println("Profile Selections:");
            if (this.m_mdFdr) {
                for (MdFdrComparisonItem item : this.m_mdFdrComparisonList) {
                    out.println("\t" + item.toDisplayString(this.m_GroupNameArray));
                }
            } else {
                for (i = 0; i < this.m_LastProfileIndex; ++i) {
                    out.println(UtilityFunctions.generateProfileString(this.m_ProfileTable, i, true));
                }
            }
            out.println("Results:");
            if (this.m_mdFdr) {
                headerStr = this.m_mdFdrCalculator.getHeaderStr();
            } else {
                headerStr = "Index\tInput File Index\tGene ID\tUser Desc\tProfile #\tP Value";
                headerStr = headerStr + "\tQ Value";
                for (i = 1; i <= this.m_NumTimePoints; ++i) {
                    headerStr = headerStr + "\tFitted Mean " + i;
                }
                for (i = 1; i <= this.m_NumTimePoints; ++i) {
                    headerStr = headerStr + "\tRaw Mean " + i;
                }
                for (i = 1; i <= this.m_NumTimePoints; ++i) {
                    headerStr = headerStr + "\tStd Error " + i;
                }
                headerStr = headerStr + "\tBootstraps";
            }
            out.println(headerStr);
        }
        catch (Exception e) {
            UtilityFunctions.showDebugMsg("Error writing output file: " + e.getMessage());
            returnValue = false;
        }
        return returnValue;
    }

    private boolean writeRawOutputFileHeader(PrintWriter out) {
        boolean returnValue = true;
        try {
            String headerStr = "Gene ID";
            if (!this.m_mdFdr) {
                headerStr = headerStr + "\tProfile #";
            }
            for (int i = 1; i <= this.m_NumTimePoints; ++i) {
                for (int j = 0; j < this.m_SampleSizeDefault[i]; ++j) {
                    headerStr = headerStr + "\tPt" + i;
                }
            }
            out.println(headerStr);
        }
        catch (Exception e) {
            UtilityFunctions.showDebugMsg("Error writing raw output file: " + e.getMessage());
            returnValue = false;
        }
        return returnValue;
    }

    private int molicl(Pvt pvtMolicl, Crit crit, int valueN) {
        int peakIndex = 1;
        for (int i = 2; i <= valueN; ++i) {
            if (!(crit.crit[i] > crit.crit[peakIndex] || crit.crit[i] == crit.crit[peakIndex] && crit.crit2[i] > crit.crit2[peakIndex]) && (crit.crit[i] != crit.crit[peakIndex] || crit.crit2[i] != crit.crit2[peakIndex] || !(crit.crit3[i] > crit.crit3[peakIndex]))) continue;
            peakIndex = i;
        }
        pvtMolicl.pvt = crit.crit[peakIndex];
        return peakIndex;
    }

    private void getBoot(ThetaHat yy, UtilityFunctions.RandomSeed rand, double valueM, ThetaHat yb, int bootIndex) {
        double randomResult = 0.0;
        double iu = 0.0;
        int iuInt = 0;
        int i = 1;
        while ((double)i <= valueM) {
            if (bootIndex < 0) {
                randomResult = this.m_MainDoc.getRandomSeed() == -1 ? Math.random() : UtilityFunctions.randomNumber(rand);
                iu = valueM * randomResult;
                if (iu == 0.0) {
                    iuInt = (int)valueM;
                } else {
                    iuInt = (int)iu;
                    if (iuInt == 0) {
                        iuInt = (int)valueM;
                    }
                }
            } else {
                iuInt = this.m_BootStrapIndices[bootIndex][i];
            }
            yb.yy[i] = iuInt;
            ++i;
        }
        double overallMean = 0.0;
        int numPts = 0;
        i = 1;
        while ((double)i <= valueM) {
            if (yy.yy[i] < Double.MAX_VALUE) {
                overallMean += yy.yy[i];
                ++numPts;
            }
            ++i;
        }
        overallMean /= (double)numPts;
        double[] residuals = new double[(int)valueM + 1];
        i = 1;
        while ((double)i <= valueM) {
            int timePt = this.getTimePt(i);
            residuals[i] = yy.yy[i] < Double.MAX_VALUE ? yy.yy[i] - this.m_YBar.yy[timePt] : Double.MAX_VALUE;
            ++i;
        }
        i = 1;
        while ((double)i <= valueM) {
            int arrayIdx = (int)yb.yy[i];
            yb.yy[i] = residuals[arrayIdx] < Double.MAX_VALUE ? overallMean + residuals[arrayIdx] : Double.MAX_VALUE;
            ++i;
        }
    }

    private int getTimePt(int arrayIndex) {
        int returnValue = -1;
        int totPts = 0;
        for (int i = 1; i <= this.m_NumTimePoints; ++i) {
            if (arrayIndex > (totPts += this.m_SampleSizeDefault[i])) continue;
            returnValue = i;
            break;
        }
        return returnValue;
    }

    private int FindSampleIndex(int overallIndex) {
        int returnValue = 1;
        int sumSamples = 0;
        for (int i = 1; i <= this.m_NumTimePoints && (sumSamples += this.m_SampleSize[i]) < overallIndex; ++i) {
            ++returnValue;
        }
        return returnValue;
    }

    public void simpleOrderProfile(int profileArrayIndex) {
        if (this.m_ProfileTable[profileArrayIndex].initialSlope == 1) {
            for (int j = 1; j <= this.m_NumTimePoints; ++j) {
                this.m_SimpOrderW.W[j] = this.m_SampleSize[j];
            }
            this.m_SimpOrderM2.m2 = this.m_SimpOrderW.W[this.m_NumTimePoints];
            if (!this.m_InBootstrap) {
                this.simpleOrder(30, this.m_NumTimePoints, this.m_SimpOrderW, this.m_SimpOrderM2, this.m_YBar, this.m_T1, this.m_Hp, this.m_SampleSize[1], this.m_SampleSize[this.m_NumTimePoints], this.m_Variance.yy[1], this.m_Variance.yy[this.m_NumTimePoints]);
            } else {
                this.simpleOrder(30, this.m_NumTimePoints, this.m_SimpOrderW, this.m_SimpOrderM2, this.m_YBarS, this.m_T1, this.m_Hp, this.m_SampleSize[1], this.m_SampleSize[this.m_NumTimePoints], this.m_VarianceBoot.yy[1], this.m_VarianceBoot.yy[this.m_NumTimePoints]);
            }
        } else {
            ThetaHat ttemp = new ThetaHat(this.m_NumTimePoints);
            ThetaHat variance = !this.m_InBootstrap ? this.m_Variance : this.m_VarianceBoot;
            for (int j = 1; j <= this.m_NumTimePoints; ++j) {
                ttemp.yy[j] = !this.m_InBootstrap ? this.m_YBar.yy[this.m_NumTimePoints - j + 1] : this.m_YBarS.yy[this.m_NumTimePoints - j + 1];
                this.m_SimpOrderW.W[j] = this.m_SampleSize[this.m_NumTimePoints - j + 1];
            }
            this.m_SimpOrderM2.m2 = this.m_SimpOrderW.W[this.m_NumTimePoints];
            this.simpleOrder(30, this.m_NumTimePoints, this.m_SimpOrderW, this.m_SimpOrderM2, ttemp, this.m_T1, this.m_Hpp, this.m_SampleSize[this.m_NumTimePoints], this.m_SampleSize[1], variance.yy[this.m_NumTimePoints], variance.yy[1]);
        }
        this.m_Crit.crit[profileArrayIndex + 1] = this.m_T1.x;
        this.m_Crit.crit2[profileArrayIndex + 1] = 1.0E-7;
        this.m_Crit.crit3[profileArrayIndex + 1] = 1.0E-7;
    }

    public void umbrellaOrderProfile(int profileArrayIndex) {
        int timePointAtMax = this.m_ProfileTable[profileArrayIndex].peakIndex;
        if (this.m_ProfileTable[profileArrayIndex].initialSlope == 1) {
            if (!this.m_InBootstrap) {
                this.umbl(this.m_NumTimePoints, this.m_YBar, this.m_StdErr, timePointAtMax, this.m_T1, this.m_T2, this.m_Tp, 1, this.m_SampleSize, this.m_Variance.yy);
            } else {
                this.umbl(this.m_NumTimePoints, this.m_YBarS, this.m_StdErrBoot, timePointAtMax, this.m_T1, this.m_T2, this.m_Tp, 1, this.m_SampleSize, this.m_VarianceBoot.yy);
            }
        } else if (!this.m_InBootstrap) {
            this.umbl(this.m_NumTimePoints, this.m_YnBar, this.m_StdErr, timePointAtMax, this.m_T1, this.m_T2, this.m_Tp, 2, this.m_SampleSize, this.m_Variance.yy);
        } else {
            this.umbl(this.m_NumTimePoints, this.m_YnBarS, this.m_StdErrBoot, timePointAtMax, this.m_T1, this.m_T2, this.m_Tp, 2, this.m_SampleSize, this.m_VarianceBoot.yy);
        }
        this.m_Crit.crit[profileArrayIndex + 1] = this.m_T1.x;
        this.m_Crit.crit2[profileArrayIndex + 1] = this.m_T2.x;
        this.m_Crit.crit3[profileArrayIndex + 1] = 1.0E-7;
    }

    public void cyclicOrderProfile(int profileArrayIndex) {
        double vectorThreeValue;
        double vectorTwoValue;
        double vectorOneValue;
        int j;
        int k;
        int i;
        ThetaHat tmpYbar = new ThetaHat(this.m_NumTimePoints);
        double[] simpOrderVariance = new double[this.m_NumTimePoints];
        double[] simpOrderSampleSize = new double[this.m_NumTimePoints];
        int umbrellaMinOrMax = this.m_ProfileTable[profileArrayIndex].peakIndex;
        int timePointAtMin = this.m_ProfileTable[profileArrayIndex].timePointAtMin;
        int timePointAtMax = this.m_ProfileTable[profileArrayIndex].timePointAtMax;
        int simpleOrderStartTimePoint = this.m_ProfileTable[profileArrayIndex].simpleOrderStartTimePt;
        int simpleOrderStopTimePoint = this.m_ProfileTable[profileArrayIndex].simpleOrderEndTimePt;
        int simpleOrderLength = simpleOrderStopTimePoint - simpleOrderStartTimePoint + 1;
        int umbStartTimePoint = this.m_ProfileTable[profileArrayIndex].umbStartTimePt;
        int umbrellaNumTimePoints = this.m_ProfileTable[profileArrayIndex].largestUmbrellaSize;
        int[] umbSampleSize = new int[umbrellaNumTimePoints + 1];
        double[] umbVariance = new double[umbrellaNumTimePoints + 1];
        ThetaHat cyclicVariance = !this.m_InBootstrap ? this.m_Variance : this.m_VarianceBoot;
        int umbSlope = this.m_ProfileTable[profileArrayIndex].initialUmbSlope;
        for (i = 1; i <= umbrellaNumTimePoints; ++i) {
            umbSampleSize[i] = this.m_SampleSize[umbStartTimePoint + i - 1];
            umbVariance[i] = cyclicVariance.yy[umbStartTimePoint + i - 1];
            if (this.m_ProfileTable[profileArrayIndex].initialUmbSlope == 1) {
                if (!this.m_InBootstrap) {
                    tmpYbar.yy[i] = this.m_YBar.yy[umbStartTimePoint + i - 1];
                    continue;
                }
                tmpYbar.yy[i] = this.m_YBarS.yy[umbStartTimePoint + i - 1];
                continue;
            }
            tmpYbar.yy[i] = !this.m_InBootstrap ? this.m_YnBar.yy[umbStartTimePoint + i - 1] : this.m_YnBarS.yy[umbStartTimePoint + i - 1];
        }
        if (!this.m_InBootstrap) {
            this.umbl(umbrellaNumTimePoints, tmpYbar, this.m_StdErr, umbrellaMinOrMax, this.m_T1, this.m_T2, this.m_Tp, umbSlope, umbSampleSize, umbVariance);
        } else {
            this.umbl(umbrellaNumTimePoints, tmpYbar, this.m_StdErrBoot, umbrellaMinOrMax, this.m_T1, this.m_T2, this.m_Tp, umbSlope, umbSampleSize, umbVariance);
        }
        if (this.m_ProfileTable[profileArrayIndex].initialUmbSlope == 2) {
            for (i = 1; i <= umbrellaNumTimePoints; ++i) {
                this.m_Tp.hp[i] = -1.0 * this.m_Tp.hp[i];
            }
        }
        if (simpleOrderStartTimePoint == 1) {
            for (i = 1; i < simpleOrderLength + 1; ++i) {
                this.m_CyclicWt.W[i] = this.m_SampleSize[i];
                simpOrderSampleSize[i] = this.m_SampleSize[i];
                simpOrderVariance[i] = cyclicVariance.yy[i];
                if (!this.m_InBootstrap) {
                    if (this.m_ProfileTable[profileArrayIndex].cyclicSlope == 31) {
                        this.m_YBarCyclic.yy[i] = this.m_YBar.yy[i];
                        continue;
                    }
                    this.m_YBarCyclic.yy[i] = this.m_YnBar.yy[i];
                    continue;
                }
                this.m_YBarCyclic.yy[i] = this.m_ProfileTable[profileArrayIndex].cyclicSlope == 31 ? this.m_YBarS.yy[i] : this.m_YnBarS.yy[i];
            }
            this.m_CyclicWt.W[simpleOrderStopTimePoint] = 1.0E10;
            this.m_YBarCyclic.yy[simpleOrderStopTimePoint] = this.m_ProfileTable[profileArrayIndex].cyclicSlope == 31 ? this.m_Tp.hp[1] : -1.0 * this.m_Tp.hp[1];
        } else {
            this.m_CyclicWt.W[1] = 1.0E10;
            simpOrderVariance[1] = cyclicVariance.yy[simpleOrderStartTimePoint];
            simpOrderSampleSize[1] = this.m_SampleSize[1];
            this.m_YBarCyclic.yy[1] = this.m_ProfileTable[profileArrayIndex].cyclicSlope == 31 ? this.m_Tp.hp[simpleOrderStartTimePoint] : -1.0 * this.m_Tp.hp[simpleOrderStartTimePoint];
            for (i = 2; i < simpleOrderLength + 1; ++i) {
                this.m_CyclicWt.W[i] = this.m_SampleSize[simpleOrderStartTimePoint + (i - 1)];
                simpOrderSampleSize[i] = this.m_SampleSize[simpleOrderStartTimePoint + (i - 1)];
                simpOrderVariance[i] = cyclicVariance.yy[simpleOrderStartTimePoint + (i - 1)];
                if (!this.m_InBootstrap) {
                    if (this.m_ProfileTable[profileArrayIndex].cyclicSlope == 31) {
                        this.m_YBarCyclic.yy[i] = this.m_YBar.yy[simpleOrderStartTimePoint + (i - 1)];
                        continue;
                    }
                    this.m_YBarCyclic.yy[i] = this.m_YnBar.yy[simpleOrderStartTimePoint + (i - 1)];
                    continue;
                }
                this.m_YBarCyclic.yy[i] = this.m_ProfileTable[profileArrayIndex].cyclicSlope == 31 ? this.m_YBarS.yy[simpleOrderStartTimePoint + (i - 1)] : this.m_YnBarS.yy[simpleOrderStartTimePoint + (i - 1)];
            }
        }
        this.m_SimpOrderM2.m2 = 1.0E10;
        this.simpleOrder(3, simpleOrderLength, this.m_CyclicWt, this.m_SimpOrderM2, this.m_YBarCyclic, this.m_T1, this.m_Hp, this.m_SampleSize[simpleOrderStartTimePoint], this.m_SampleSize[simpleOrderStopTimePoint], simpOrderVariance[simpleOrderStartTimePoint], simpOrderVariance[simpleOrderStopTimePoint]);
        if (simpleOrderStartTimePoint == 1) {
            for (k = 1; k <= simpleOrderStopTimePoint; ++k) {
                this.m_CyclicDataValues[k] = this.m_ProfileTable[profileArrayIndex].cyclicSlope == 31 ? this.m_Hp.hp[k] : -1.0 * this.m_Hp.hp[k];
            }
            for (j = simpleOrderStopTimePoint + 1; j <= this.m_NumTimePoints; ++j) {
                this.m_CyclicDataValues[j] = this.m_Tp.hp[j - simpleOrderStopTimePoint + 1];
            }
        } else {
            for (k = 1; k <= simpleOrderStartTimePoint - 1; ++k) {
                this.m_CyclicDataValues[k] = this.m_Tp.hp[k];
            }
            for (j = simpleOrderStartTimePoint; j <= this.m_NumTimePoints; ++j) {
                this.m_CyclicDataValues[j] = this.m_ProfileTable[profileArrayIndex].cyclicSlope == 31 ? this.m_Hp.hp[j - simpleOrderStartTimePoint + 1] : -1.0 * this.m_Hp.hp[j - simpleOrderStartTimePoint + 1];
            }
        }
        if (this.m_ProfileTable[profileArrayIndex].cyclicSlope == 32) {
            double factor = this.calculateCritFactor(1, timePointAtMin, cyclicVariance.yy[1], cyclicVariance.yy[timePointAtMin]);
            vectorOneValue = Math.abs(this.m_CyclicDataValues[timePointAtMin] - this.m_CyclicDataValues[1]) / factor;
            factor = this.calculateCritFactor(timePointAtMin, timePointAtMax, cyclicVariance.yy[timePointAtMin], cyclicVariance.yy[timePointAtMax]);
            vectorTwoValue = Math.abs(this.m_CyclicDataValues[timePointAtMax] - this.m_CyclicDataValues[timePointAtMin]) / factor;
            factor = this.calculateCritFactor(timePointAtMax, this.m_NumTimePoints, cyclicVariance.yy[timePointAtMax], cyclicVariance.yy[this.m_NumTimePoints]);
            vectorThreeValue = Math.abs(this.m_CyclicDataValues[this.m_NumTimePoints] - this.m_CyclicDataValues[timePointAtMax]) / factor;
        } else {
            double factor = this.calculateCritFactor(1, timePointAtMax, cyclicVariance.yy[1], cyclicVariance.yy[timePointAtMax]);
            vectorOneValue = Math.abs(this.m_CyclicDataValues[timePointAtMax] - this.m_CyclicDataValues[1]) / factor;
            factor = this.calculateCritFactor(timePointAtMin, timePointAtMax, cyclicVariance.yy[timePointAtMin], cyclicVariance.yy[timePointAtMax]);
            vectorTwoValue = Math.abs(this.m_CyclicDataValues[timePointAtMax] - this.m_CyclicDataValues[timePointAtMin]) / factor;
            factor = this.calculateCritFactor(timePointAtMin, this.m_NumTimePoints, cyclicVariance.yy[timePointAtMin], cyclicVariance.yy[this.m_NumTimePoints]);
            vectorThreeValue = Math.abs(this.m_CyclicDataValues[this.m_NumTimePoints] - this.m_CyclicDataValues[timePointAtMin]) / factor;
        }
        if (this.m_ProfileTable[profileArrayIndex].cyclicSlope == 31) {
            int cyclicIndex = 310 + timePointAtMin * 20 + timePointAtMax;
        } else {
            int cyclicIndex = 420 + timePointAtMin * 20 + timePointAtMax;
        }
        if (vectorOneValue >= vectorTwoValue && vectorOneValue >= vectorThreeValue) {
            this.m_Crit.crit[profileArrayIndex + 1] = vectorOneValue;
            this.m_Crit.crit2[profileArrayIndex + 1] = Math.max(vectorTwoValue, vectorThreeValue);
            this.m_Crit.crit3[profileArrayIndex + 1] = Math.min(vectorTwoValue, vectorThreeValue);
        } else if (vectorTwoValue >= vectorOneValue && vectorTwoValue >= vectorThreeValue) {
            this.m_Crit.crit[profileArrayIndex + 1] = vectorTwoValue;
            this.m_Crit.crit2[profileArrayIndex + 1] = Math.max(vectorOneValue, vectorThreeValue);
            this.m_Crit.crit3[profileArrayIndex + 1] = Math.min(vectorOneValue, vectorThreeValue);
        } else {
            this.m_Crit.crit[profileArrayIndex + 1] = vectorThreeValue;
            this.m_Crit.crit2[profileArrayIndex + 1] = Math.max(vectorOneValue, vectorTwoValue);
            this.m_Crit.crit3[profileArrayIndex + 1] = Math.min(vectorOneValue, vectorTwoValue);
        }
    }

    private double calculateCritFactor(int a_StartIndex, int a_EndIndex, double varianceStart, double varianceEnd) {
        double factor = Math.sqrt(1.0 / (double)this.m_SampleSize[a_StartIndex] + 1.0 / (double)this.m_SampleSize[a_EndIndex]);
        return factor;
    }

    private void simpleOrder(int cyclicFlag, int valueIP, SimpOrderW simpOrderW, SimpOrderM2 simpOrderM2, ThetaHat simpOrderThetaHat, Sum simpOrderCrit, Hp hp, int numPointsStart, int numPointsEnd, double varianceStart, double varianceEnd) {
        double localSWT = 0.0;
        if (cyclicFlag != 3) {
            simpOrderW.W[valueIP] = simpOrderM2.m2;
        }
        for (int i = 1; i <= valueIP; ++i) {
            for (int it = i; it <= valueIP; ++it) {
                for (int is = 1; is <= i; ++is) {
                    this.m_RMean.rMeanOrMax[is] = 0.0;
                    localSWT = 0.0;
                    for (int k = is; k <= it; ++k) {
                        double thetaMultByW = simpOrderThetaHat.yy[k] * simpOrderW.W[k];
                        this.m_RMean.rMeanOrMax[is] = this.m_RMean.rMeanOrMax[is] + thetaMultByW;
                        localSWT += simpOrderW.W[k];
                    }
                    this.m_Weight1.weight[is] = localSWT;
                    this.m_RMean.rMeanOrMax[is] = this.m_RMean.rMeanOrMax[is] / localSWT;
                }
                this.sorter(i, valueIP, this.m_RMean, this.m_Weight1);
                this.m_RMax.rMeanOrMax[it - i + 1] = this.m_RMean.rMeanOrMax[i];
                this.m_Weight2.weight[it - i + 1] = this.m_Weight1.weight[i];
            }
            int localN = valueIP - i + 1;
            this.sorter(localN, valueIP, this.m_RMax, this.m_Weight2);
            hp.hp[i] = this.m_RMax.rMeanOrMax[1];
        }
        double factor = Math.sqrt(1.0 / (double)numPointsStart + 1.0 / (double)numPointsEnd);
        simpOrderCrit.x = (hp.hp[valueIP] - hp.hp[1]) / factor;
    }

    private void sorter(int numRows, int nn, RmeanOrMax meanOrMaxValue, Weight weightValue) {
        int m2 = 2 * numRows - 1;
        while ((m2 /= 2) >= 1) {
            int k = numRows - m2;
            for (int i = 1; i <= k; ++i) {
                int n2;
                int el2;
                for (int j2 = 1; j2 <= i && !(meanOrMaxValue.rMeanOrMax[el2 = (n2 = i - (j2 - 1)) + m2] > meanOrMaxValue.rMeanOrMax[n2]); j2 += m2) {
                    double b2 = meanOrMaxValue.rMeanOrMax[n2];
                    double rb3 = weightValue.weight[n2];
                    meanOrMaxValue.rMeanOrMax[n2] = meanOrMaxValue.rMeanOrMax[el2];
                    weightValue.weight[n2] = weightValue.weight[el2];
                    meanOrMaxValue.rMeanOrMax[el2] = b2;
                    weightValue.weight[el2] = rb3;
                }
            }
        }
    }

    private void umbl(int valueNGRP, ThetaHat rawMean, ThetaHat stdErrArray, int ipk, Sum t1, Sum t2, Hp hp, int slope, int[] sampleSize, double[] variance) {
        block13: {
            int p;
            int m;
            SimpOrderW simpOrderW2;
            Sum crit2;
            Sum crit1;
            block14: {
                ThetaHat tmpMean;
                block12: {
                    crit1 = new Sum();
                    crit2 = new Sum();
                    tmpMean = new ThetaHat(valueNGRP);
                    simpOrderW2 = new SimpOrderW();
                    for (int i = 1; i <= valueNGRP; ++i) {
                        this.m_SimpOrderW.W[i] = sampleSize[i];
                    }
                    if (ipk != valueNGRP) break block12;
                    this.m_SimpOrderM2.m2 = this.m_SimpOrderW.W[valueNGRP];
                    this.simpleOrder(30, valueNGRP, this.m_SimpOrderW, this.m_SimpOrderM2, rawMean, t1, hp, sampleSize[1], sampleSize[ipk], variance[1], variance[ipk]);
                    break block13;
                }
                if (ipk != 1) break block14;
                for (int j = 1; j <= valueNGRP; ++j) {
                    tmpMean.yy[j] = rawMean.yy[valueNGRP - j + 1];
                    simpOrderW2.W[j] = this.m_SimpOrderW.W[valueNGRP - j + 1];
                }
                this.m_SimpOrderM2.m2 = simpOrderW2.W[valueNGRP];
                this.simpleOrder(30, valueNGRP, simpOrderW2, this.m_SimpOrderM2, tmpMean, t1, this.m_Hpp, sampleSize[1], sampleSize[ipk], variance[1], variance[ipk]);
                for (int k = 1; k <= valueNGRP; ++k) {
                    hp.hp[k] = this.m_Hpp.hp[valueNGRP - k + 1];
                }
                break block13;
            }
            if (!(ipk > 1 & ipk < valueNGRP)) break block13;
            for (m = ipk; m <= valueNGRP; ++m) {
                this.m_THat2.yy[m - ipk + 1] = rawMean.yy[valueNGRP - m + ipk];
                simpOrderW2.W[m - ipk + 1] = this.m_SimpOrderW.W[valueNGRP - m + ipk];
            }
            for (p = 1; p <= ipk; ++p) {
                this.m_THat1.yy[p] = rawMean.yy[p];
            }
            for (int r = 1; r <= valueNGRP; ++r) {
                if (r < ipk) {
                    this.m_THat3.yy[r] = this.m_THat1.yy[r];
                    simpOrderW2.W[r] = this.m_SimpOrderW.W[r];
                    continue;
                }
                if (r < ipk) continue;
                int counter2 = r - ipk + 1;
                this.m_THat3.yy[r] = this.m_THat2.yy[counter2];
                simpOrderW2.W[r] = this.m_SimpOrderW.W[valueNGRP - counter2 + 1];
            }
            this.getThetaHatMax(simpOrderW2, valueNGRP, this.m_THat3);
            this.m_THat2.yy[valueNGRP - ipk + 1] = this.m_ThatMax.thatMax;
            for (m = ipk; m <= valueNGRP; ++m) {
                simpOrderW2.W[m - ipk + 1] = this.m_SimpOrderW.W[valueNGRP - m + ipk];
            }
            int localNS = valueNGRP - ipk + 1;
            this.m_SimpOrderM2.m2 = 1.0E10;
            this.simpleOrder(30, localNS, simpOrderW2, this.m_SimpOrderM2, this.m_THat2, crit1, this.m_Hp2, sampleSize[ipk], sampleSize[valueNGRP], variance[ipk], variance[valueNGRP]);
            this.m_THat1.yy[ipk] = this.m_ThatMax.thatMax;
            this.simpleOrder(30, ipk, this.m_SimpOrderW, this.m_SimpOrderM2, this.m_THat1, crit2, this.m_Hp1, sampleSize[1], sampleSize[ipk], variance[1], variance[ipk]);
            if (crit1.x > crit2.x) {
                t1.x = crit1.x;
                t2.x = crit2.x;
            } else {
                t1.x = crit2.x;
                t2.x = crit1.x;
            }
            for (p = 1; p <= valueNGRP; ++p) {
                if (p < ipk) {
                    hp.hp[p] = this.m_Hp1.hp[p];
                    continue;
                }
                if (p < ipk) continue;
                hp.hp[p] = this.m_Hp2.hp[valueNGRP - p + 1];
            }
        }
    }

    private void getThetaHatMax(SimpOrderW abc, int valueNGRP, ThetaHat xyz) {
        double[] finalVector = new double[valueNGRP + 1];
        double[] revThetaHat = new double[valueNGRP + 1];
        for (int i = 1; i <= valueNGRP; ++i) {
            this.m_Revn.W[i] = abc.W[valueNGRP + 1 - i];
            revThetaHat[i] = xyz.yy[valueNGRP + 1 - i];
        }
        for (int j = 1; j <= valueNGRP; ++j) {
            this.m_Wp.W[j] = this.m_Revn.W[j] * revThetaHat[j];
        }
        this.getCumulativeSum(this.m_Wp, valueNGRP, this.m_Csnp);
        this.getCumulativeSum(this.m_Revn, valueNGRP, this.m_Csn);
        for (int k = 1; k <= valueNGRP; ++k) {
            finalVector[k] = this.m_Csnp.cs[k] / this.m_Csn.cs[k];
        }
        double maximumValue = 0.0;
        int lengthOfArray = 0;
        lengthOfArray = finalVector.length;
        maximumValue = finalVector[1];
        for (int x = 1; x < lengthOfArray; ++x) {
            if (!(finalVector[x] > maximumValue)) continue;
            maximumValue = finalVector[x];
        }
        this.m_ThatMax.thatMax = maximumValue;
    }

    private void getCumulativeSum(SimpOrderW aaa, int valueIMA, Csnp zzz) {
        zzz.cs[1] = aaa.W[1];
        for (int i = 2; i <= valueIMA; ++i) {
            zzz.cs[i] = zzz.cs[i - 1] + aaa.W[i];
        }
    }

    private class QValueComparator
    implements Comparator {
        public static final int COMPARE_P_VALUES = 1;
        public static final int COMPARE_INDICES = 2;
        public int comparisonType;

        private QValueComparator() {
        }

        public int compare(Object obj1, Object obj2) {
            QValueClass q1 = (QValueClass)obj1;
            QValueClass q2 = (QValueClass)obj2;
            if (this.comparisonType == 1) {
                return new Double(q1.pValue).compareTo(new Double(q2.pValue));
            }
            return new Integer(q1.index).compareTo(new Integer(q2.index));
        }
    }

    private class QValueClass {
        public double pValue;
        public double qValue;
        public int index;

        public QValueClass(int idx) {
            this.index = idx;
        }
    }

    private class SubRegion {
        public int startIndex = -1;
        public int endIndex = -1;
        public double critValue;
        public int rcount = 0;
        public boolean isSignificant = true;
    }

    private class GeneIndexComparator
    implements Comparator {
        private GeneIndexComparator() {
        }

        public int compare(Object obj1, Object obj2) {
            Gene gene1 = (Gene)obj1;
            Gene gene2 = (Gene)obj2;
            return Integer.signum(gene1.inpIndex - gene2.inpIndex);
        }
    }

    private class PValueComparator
    implements Comparator {
        private PValueComparator() {
        }

        public int compare(Object obj1, Object obj2) {
            Gene gene1 = (Gene)obj1;
            Gene gene2 = (Gene)obj2;
            return Double.compare(gene1.pValue, gene2.pValue);
        }
    }

    private class UpperCiComparator
    implements Comparator {
        private UpperCiComparator() {
        }

        public int compare(Object obj1, Object obj2) {
            Gene gene1 = (Gene)obj1;
            Gene gene2 = (Gene)obj2;
            return Double.compare(gene1.upperCi, gene2.upperCi);
        }
    }

    private class LowerCiComparator
    implements Comparator {
        private LowerCiComparator() {
        }

        public int compare(Object obj1, Object obj2) {
            Gene gene1 = (Gene)obj1;
            Gene gene2 = (Gene)obj2;
            return Double.compare(gene1.lowerCi, gene2.lowerCi);
        }
    }

    public class ThetaHatWithZData {
        public double[][] z;

        public ThetaHatWithZData(int array1Size, int array2Size) {
            this.z = new double[array1Size + 1][array2Size + 1];
        }
    }

    public class ThetaHat {
        public double[] yy;

        public ThetaHat(int totalSamples) {
            this.yy = new double[totalSamples + 1];
        }
    }

    private class Csnp {
        public double[] cs = new double[31];

        private Csnp() {
        }
    }

    private class Weight {
        public double[] weight = new double[31];

        private Weight() {
        }
    }

    private class RmeanOrMax {
        public double[] rMeanOrMax = new double[31];

        private RmeanOrMax() {
        }
    }

    private class ThatMax {
        public double thatMax;

        private ThatMax() {
        }
    }

    private class SimpOrderM2 {
        public double m2;

        private SimpOrderM2() {
        }
    }

    private class SimpOrderW {
        public double[] W = new double[31];

        private SimpOrderW() {
        }
    }

    private class Hp {
        public double[] hp = new double[31];

        private Hp() {
        }
    }

    private class Sum {
        public double x;

        private Sum() {
        }
    }

    private class Crit {
        public double[] crit = new double[201];
        public double[] crit2 = new double[201];
        public double[] crit3 = new double[201];

        private Crit() {
        }
    }

    private class Pvt {
        public double pvt;

        private Pvt() {
        }
    }

    public class DblValue {
        public double value;
    }
}

