/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;

public class GeneLookup {
    private String m_LookupFilename;
    private int m_OntologyColumn;
    private int m_NameColumn;
    private String m_GeneName;
    private String m_GeneSymbol;
    private String m_GeneOntology;
    private boolean m_FileIsOpen;
    private BufferedReader m_Reader;
    private final int MIN_COLUMNS = 3;
    private final int LAST_GENEID_COLUMN = 4;

    public GeneLookup(String a_LookupFilename) {
        this.m_LookupFilename = a_LookupFilename;
        this.m_OntologyColumn = 9;
        this.m_NameColumn = 5;
    }

    public String getName() {
        return this.m_GeneName;
    }

    public String getOntology() {
        return this.m_GeneOntology;
    }

    public String getSymbol() {
        return this.m_GeneSymbol;
    }

    public boolean lookForGene(String a_GeneID) {
        boolean returnValue = false;
        String tmpLine = "";
        this.initialize();
        this.m_GeneName = "";
        this.m_GeneSymbol = "";
        this.m_GeneOntology = "";
        if (!this.m_FileIsOpen) {
            return false;
        }
        try {
            while (tmpLine != null) {
                tmpLine = this.m_Reader.readLine();
                String[] tokens = tmpLine.split("\t");
                int numTokens = tokens.length;
                if (numTokens < 3) continue;
                for (int i = 0; i < 4 && i < numTokens; ++i) {
                    String tmpId = tokens[i];
                    if (a_GeneID.compareTo(tmpId.trim()) != 0) continue;
                    returnValue = true;
                    break;
                }
                if (!returnValue) continue;
                if (tokens.length > this.m_OntologyColumn) {
                    String tmpOntology = tokens[this.m_OntologyColumn];
                    this.m_GeneOntology = this.parseOntology(tmpOntology);
                }
                if (tokens.length > this.m_NameColumn) {
                    String tmpName = tokens[this.m_NameColumn];
                    this.parseNameAndSymbol(tmpName);
                }
                returnValue = true;
                break;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        this.close();
        return returnValue;
    }

    private String parseOntology(String a_InputStr) {
        int strPos2;
        String returnValue = "";
        int strPos1 = a_InputStr.indexOf(40);
        while (strPos1 > -1 && (strPos2 = this.FindClosingParen(a_InputStr, strPos1 + 1)) > -1) {
            String tmpStr = a_InputStr.substring(strPos1 + 1, strPos2);
            returnValue = returnValue + tmpStr + "; ";
            a_InputStr = a_InputStr.substring(strPos2);
            strPos1 = a_InputStr.indexOf(40);
        }
        if (returnValue == "") {
            returnValue = a_InputStr;
        }
        return returnValue;
    }

    private int FindClosingParen(String a_InputStr, int a_StartIndex) {
        int returnValue = -1;
        int parenCount = 1;
        for (int i = a_StartIndex; i < a_InputStr.length(); ++i) {
            if (a_InputStr.charAt(i) == '(') {
                ++parenCount;
                continue;
            }
            if (a_InputStr.charAt(i) != ')' || --parenCount != 0) continue;
            returnValue = i;
            break;
        }
        return returnValue;
    }

    private void parseNameAndSymbol(String a_InputStr) {
        String[] tokens = a_InputStr.split(";");
        if (tokens.length > 1) {
            this.m_GeneSymbol = tokens[0];
            this.m_GeneName = tokens[1];
        } else {
            this.m_GeneSymbol = "";
            this.m_GeneName = a_InputStr;
        }
    }

    public void initialize() {
        String tmpFilename = this.m_LookupFilename;
        File tmpFile = new File(tmpFilename);
        if (!tmpFile.exists()) {
            LocatorClass locator = new LocatorClass();
            tmpFilename = locator.pathString + "/" + this.m_LookupFilename;
            tmpFile = new File(tmpFilename);
        }
        if (tmpFile.exists()) {
            try {
                this.m_Reader = new BufferedReader(new FileReader(tmpFilename));
                this.m_FileIsOpen = true;
            }
            catch (Exception e) {
                this.m_FileIsOpen = false;
            }
        } else {
            this.m_FileIsOpen = false;
        }
    }

    public void close() {
        try {
            if (this.m_FileIsOpen) {
                this.m_Reader.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

