/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;

public class AdvancedInputWindow
extends JPanel
implements ActionListener {
    private final String SETTINGS_FILENAME = "InputSettings.txt";
    private Origen_Data m_MainDoc;
    private boolean m_CheckSubRegions;
    private double m_SubRegionPValue;
    private String checkSubRegionsString = "Perform Reclassification at P-value ";
    private String skipItString = "Skip the Reclassification";
    private JTextField reclassifyPValueField;
    private JRadioButton checkSubRegionsRadioButton;
    private JRadioButton skipReclassifyRadioButton;

    public AdvancedInputWindow(JFrame frame, Origen_Data mainDoc) {
        this.m_MainDoc = mainDoc;
        this.m_CheckSubRegions = this.m_MainDoc.getCheckSubRegions();
        this.m_SubRegionPValue = this.m_MainDoc.getSubRegionPValue();
        this.setLayout(new BorderLayout());
        this.skipReclassifyRadioButton = new JRadioButton(this.skipItString);
        this.skipReclassifyRadioButton.addActionListener(this);
        this.skipReclassifyRadioButton.setActionCommand("skipReclassify");
        this.skipReclassifyRadioButton.setToolTipText("Check the box to skip the reclassification algorithm.");
        this.checkSubRegionsRadioButton = new JRadioButton(this.checkSubRegionsString);
        this.checkSubRegionsRadioButton.addActionListener(this);
        this.checkSubRegionsRadioButton.setActionCommand("m_CheckSubRegions");
        this.checkSubRegionsRadioButton.setToolTipText("Check the box to possibly reclassify genes after testing for significance in each sub-region of the profile.");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.skipReclassifyRadioButton);
        buttonGroup.add(this.checkSubRegionsRadioButton);
        this.reclassifyPValueField = new JTextField(40);
        Box reclassifyBox = Box.createHorizontalBox();
        reclassifyBox.add(this.checkSubRegionsRadioButton);
        reclassifyBox.add(this.reclassifyPValueField);
        JButton ok = new JButton("OK");
        ok.addActionListener(this);
        ok.setActionCommand("ok");
        JButton help = new JButton("Help");
        help.addActionListener(this);
        help.setActionCommand("help");
        JPanel labelPane = new JPanel(new GridLayout(0, 1, 10, 20));
        labelPane.add(this.skipReclassifyRadioButton);
        labelPane.add(reclassifyBox);
        labelPane.add(new JSeparator(0));
        JPanel buttonPane = new JPanel(new GridLayout(1, 1, 100, 20));
        buttonPane.add(ok);
        buttonPane.add(help);
        this.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        this.add((Component)labelPane, "North");
        this.add((Component)buttonPane, "Last");
        LocatorClass locator = new LocatorClass();
        Image image = Toolkit.getDefaultToolkit().getImage(locator.pathString + "/GRAPH05.GIF");
        if (image != null) {
            frame.setIconImage(image);
        }
        String tmpStr = new DecimalFormat("0.00").format(this.m_SubRegionPValue);
        this.reclassifyPValueField.setText(tmpStr);
        if (this.m_CheckSubRegions) {
            this.checkSubRegionsRadioButton.setSelected(true);
        } else {
            this.skipReclassifyRadioButton.setSelected(true);
            this.reclassifyPValueField.setEnabled(false);
        }
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                if (AdvancedInputWindow.this.m_CheckSubRegions) {
                    AdvancedInputWindow.this.checkSubRegionsRadioButton.requestFocus();
                } else {
                    AdvancedInputWindow.this.skipReclassifyRadioButton.requestFocus();
                }
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if ("ok".equals(e.getActionCommand())) {
            this.m_CheckSubRegions = this.checkSubRegionsRadioButton.isSelected();
            String tmpStr = this.reclassifyPValueField.getText();
            this.m_SubRegionPValue = ResultsViewer.getDoubleValue(tmpStr, true);
            if (this.m_SubRegionPValue < 0.0) {
                return;
            }
            if (this.m_CheckSubRegions && (this.m_SubRegionPValue <= 0.0 || this.m_SubRegionPValue > 1.0)) {
                JOptionPane.showMessageDialog(this, "The p-value must be between 0 and 1", "Error", 0);
                return;
            }
            this.m_MainDoc.setCheckSubRegions(this.m_CheckSubRegions);
            this.m_MainDoc.setSubRegionPValue(this.m_SubRegionPValue);
        } else if ("help".equals(e.getActionCommand())) {
            LocatorClass locator = new LocatorClass();
            HelpWindow helpWindow = new HelpWindow("ORIOGEN Help", locator.pathString + "/Advanced_help.htm");
        } else if ("m_CheckSubRegions".equals(e.getActionCommand())) {
            boolean tmpBool = this.checkSubRegionsRadioButton.isSelected();
            this.reclassifyPValueField.setEnabled(tmpBool);
        } else if ("skipReclassify".equals(e.getActionCommand())) {
            boolean tmpBool = this.checkSubRegionsRadioButton.isSelected();
            this.reclassifyPValueField.setEnabled(tmpBool);
        } else {
            System.out.println(e.getActionCommand());
        }
    }
}

