#############################################################################################################
##                                                                                                         ##
##  "format.output" is a utility function to process haplore output to get TRIMMEST input pedigree file    ##
##                                                                                                         ##
##   NOTE:  Use -L1 -E1 option when running the program HAPLORE                                            ##
##          This program assumes that the data include only triad families                                 ##
##                                                                                                         ##
#############################################################################################################

format.output<-function(.haplore.out='haplore.out' ,fid='fid.txt',.hap.freq="hap.freq" ,
                      .risk.inp="risk.inp", .max.hap.no=200) {

system(paste("tail -n ",.max.hap.no," ",.haplore.out,
            " | awk 'BEGIN {start=0} $2==\"total\" {start=1} ; start==2 {print $0}; start==1 {start=2}; '>",
            .hap.freq,sep=''))
system(paste("grep -e \"\(\" -e 'Family' -e 'ConfigID' ",
       .haplore.out," | awk -F\\[\\(\\)\\,\\:] 'BEGIN {pid=0;} $1==\"Family ID is\" {pid=$2;};",
       "$1 !~ /^#/ && $1 != \"Family ID is\" {print pid,$1,$2,$3,$5,$6,$8,$9,$10,$11,$12,$13}' >",
       .risk.inp,sep=''))


read.table(.risk.inp,fill=T)->ped
kid<-ped[is.na(ped[,7]),]
ped<-ped[!is.na(ped[,7]),]
ped1<-ped
# check if parents are in the correct order from haplore ouput
# the columns of resulting file should be in this order
# PID->ConfigID-> F1.hap->F2.hap->M1.hap->M2.hap->C1.hap->C2.hap->prob
read.table(fid)->fid
if (dim(fid)[1] != dim(kid)[1]) stop("Error: Number of triads in fid.txt does not match haplore output")
# need to recode the pid as continuous integer from 1 to match the rows of fid
unique(ped[,1])->pid
as.data.frame(ped[,1])->pid.all
colnames(pid.all)<-'pid'
cbind(pid,1:length(pid))->pid

merge(pid.all,pid,by='pid',sort=F)[,2]->pid.recode

ped1[kid[pid.recode,4]==fid[pid.recode,1],3:4]<-ped[kid[pid.recode,4]==fid[pid.recode,1],5:6]
ped1[kid[pid.recode,4]==fid[pid.recode,1],5:6]<-ped[kid[pid.recode,4]==fid[pid.recode,1],3:4]

write(t(ped1),file=.risk.inp,ncol=dim(ped1)[2])
 }


