############################################################################
###  "setup.mt" is a function to generate all the possible triad configuration
##               for 2 or 3 haplotype scenarios

 setup.mt<-function(two.risk.hap=F) {
 all.mt<-matrix(c(222,1,2,2,2,4,0,
212,2,2,1,2,3,0,
211,2,2,1,1,3,0,
122,2,1,2,2,3,0,
121,2,1,2,1,3,0,
201,3,2,0,1,2,0,
21,3,0,2,1,2,0,
112,4,1,1,2,2,0,
111,4,1,1,1,2,0.693147181,
110,4,1,1,0,2,0,
101,5,1,0,1,1,0,
100,5,1,0,0,1,0,
11,5,0,1,1,1,0,
10,5,0,1,0,1,0,
0,6,0,0,0,0,0),nrow=15,byrow=T)
 colnames(all.mt)<-c("triad","mt","mm","ff","cc","m.f","offset")
 all.mt<- as.data.frame(all.mt)

if (two.risk.hap) {
all.mt<-matrix(
c(1,111111,1,11,11,11,1,1,1,1,0,4,0,
2,121111,2,12,11,11,1,1,1,2,0,3,1,
3,121112,2,12,11,12,1,2,1,2,0,3,1,
4,111211,2,11,12,11,1,1,1,1,0,3,1,
5,111212,2,11,12,12,1,2,1,1,0,3,1,
6,131111,3,13,11,11,1,1,1,3,0,3,0,
7,131113,3,13,11,13,1,3,1,3,0,3,0,
8,111311,3,11,13,11,1,1,1,1,0,3,0,
9,111313,3,11,13,13,1,3,1,1,0,3,0,
10,221112,4,22,11,12,1,2,2,2,0,2,2,
11,112212,4,11,22,12,1,2,1,1,0,2,2,
12,231112,5,23,11,12,1,2,2,3,0,2,1,
13,231113,5,23,11,13,1,3,2,3,0,2,1,
14,112312,5,11,23,12,1,2,1,1,0,2,1,
15,112313,5,11,23,13,1,3,1,1,0,2,1,
16,331113,6,33,11,13,1,3,3,3,0,2,0,
17,113313,6,11,33,13,1,3,1,1,0,2,0,
18,121211,7,12,12,11,1,1,1,2,0,2,2,
19,121212,7,12,12,12,1,2,1,2,0.693147181,2,2,
20,121222,7,12,12,22,2,2,1,2,0,2,2,
21,131211,8,13,12,11,1,1,1,3,0,2,1,
22,131213,8,13,12,13,1,3,1,3,0,2,1,
23,131212,8,13,12,12,1,2,1,3,0,2,1,
24,131223,8,13,12,23,2,3,1,3,0,2,1,
25,121311,8,12,13,11,1,1,1,2,0,2,1,
26,121313,8,12,13,13,1,3,1,2,0,2,1,
27,121312,8,12,13,12,1,2,1,2,0,2,1,
28,121323,8,12,13,23,2,3,1,2,0,2,1,
29,221212,9,22,12,12,1,2,2,2,0,1,3,
30,221222,9,22,12,22,2,2,2,2,0,1,3,
31,122212,9,12,22,12,1,2,1,2,0,1,3,
32,122222,9,12,22,22,2,2,1,2,0,1,3,
33,231212,10,23,12,12,1,2,2,3,0,1,2,
34,231213,10,23,12,13,1,3,2,3,0,1,2,
35,231222,10,23,12,22,2,2,2,3,0,1,2,
36,231223,10,23,12,23,2,3,2,3,0,1,2,
37,122312,10,12,23,12,1,2,1,2,0,1,2,
38,122313,10,12,23,13,1,3,1,2,0,1,2,
39,122322,10,12,23,22,2,2,1,2,0,1,2,
40,122323,10,12,23,23,2,3,1,2,0,1,2,
41,331213,11,33,12,13,1,3,3,3,0,1,1,
42,331223,11,33,12,23,2,3,3,3,0,1,1,
43,123313,11,12,33,13,1,3,1,2,0,1,1,
44,123323,11,12,33,23,2,3,1,2,0,1,1,
45,131311,12,13,13,11,1,1,1,3,0,2,0,
46,131313,12,13,13,13,1,3,1,3,0.693147181,2,0,
47,131333,12,13,13,33,3,3,1,3,0,2,0,
48,221312,13,22,13,12,1,2,2,2,0,1,2,
49,221323,13,22,13,23,2,3,2,2,0,1,2,
50,132212,13,13,22,12,1,2,1,3,0,1,2,
51,132223,13,13,22,23,2,3,1,3,0,1,2,
52,231312,14,23,13,12,1,2,2,3,0,1,1,
53,231313,14,23,13,13,1,3,2,3,0,1,1,
54,231323,14,23,13,23,2,3,2,3,0,1,1,
55,231333,14,23,13,33,3,3,2,3,0,1,1,
56,132312,14,13,23,12,1,2,1,3,0,1,1,
57,132313,14,13,23,13,1,3,1,3,0,1,1,
58,132323,14,13,23,23,2,3,1,3,0,1,1,
59,132333,14,13,23,33,3,3,1,3,0,1,1,
60,331313,15,33,13,13,1,3,3,3,0,1,0,
61,331333,15,33,13,33,3,3,3,3,0,1,0,
62,133313,15,13,33,13,1,3,1,3,0,1,0,
63,133333,15,13,33,33,3,3,1,3,0,1,0,
64,222222,16,22,22,22,2,2,2,2,0,0,4,
65,232222,17,23,22,22,2,2,2,3,0,0,3,
66,232223,17,23,22,23,2,3,2,3,0,0,3,
67,222322,17,22,23,22,2,2,2,2,0,0,3,
68,222323,17,22,23,23,2,3,2,2,0,0,3,
69,332223,18,33,22,23,2,3,3,3,0,0,2,
70,223323,18,22,33,23,2,3,2,2,0,0,2,
71,232322,19,23,23,22,2,2,2,3,0,0,2,
72,232323,19,23,23,23,2,3,2,3,0.693147181,0,2,
73,232333,19,23,23,33,3,3,2,3,0,0,2,
74,332323,20,33,23,23,2,3,3,3,0,0,1,
75,332333,20,33,23,33,3,3,3,3,0,0,1,
76,233323,20,23,33,23,2,3,2,3,0,0,1,
77,233333,20,23,33,33,3,3,2,3,0,0,1,
78,333333,21,33,33,33,3,3,3,3,0,0,0),nrow=78,byrow=T)
 colnames(all.mt)<-c("sort","triad","mt","mm","ff","cc","c1","c2","m1","m2","offset","m.f1","m.f2")
 all.mt<- as.data.frame(all.mt)
}
    return(all.mt)
 }
 #############################################################################
 # This following function "f.groupsum" was borrowed from the program Haplin #
 # Thanks to Drs.  H. K. GJESSING and R. T. LIE                              #
 #############################################################################

   "f.groupsum"<-
function(X, INDICES, expand = T)
{
	if(length(X) != length(INDICES)) stop("Different lengths of X and INDICES!")	#

	.l <- length(X)
	.order <- order(INDICES, na.last = T)	# SAVE ORIGINAL ORDERING
	.x <- X[.order]	#
	.indices <- match(INDICES[.order], unique.default(INDICES[.order]))
  	.cumsum <- cumsum(.x)
	.cumsum <- c(.cumsum, .cumsum[.l])
	.first <- c(!duplicated(.indices), T)	# FIRST IN EACH GROUP
	.ind <- (1:.l)[.first[-1]]	# LAST IN EACH GROUP
	.step <- c(.cumsum[.ind][1], diff(.cumsum[.ind]))	# COMPUTE INCREASE IN CUMSUM OVER EACH GROUP
	.sum <- .step[.indices]	# MATCH BACK TO SORTED INDICES
	.sum <- .sum[order(.order)]	# SORT BACK TO ORIGINAL ORDERING
	if(!expand){
			.nondup <- !duplicated(INDICES)
			.ut <- data.frame(sumx = .sum[.nondup], INDICES = INDICES[.nondup])
			return(.ut)
		}
	return(.sum)
}
#################################################################################
### "mend.factor" calculates the mendelian factor
##
mend.fact<-function(line0) {
ct.same<-0
if( (min(line0[1],line0[3])== line0[5]) &  (max(line0[1],line0[3])== line0[6])) ct.same<-ct.same+1
if( (min(line0[1],line0[4])== line0[5]) &  (max(line0[1],line0[4])== line0[6])) ct.same<-ct.same+1
if( (min(line0[2],line0[3])== line0[5]) &  (max(line0[2],line0[3])== line0[6])) ct.same<-ct.same+1
if( (min(line0[2],line0[4])== line0[5]) &  (max(line0[2],line0[4])== line0[6])) ct.same<-ct.same+1

return(ct.same/4)
}
#################################################################################
### "prob.ordered" returns the probablity of observed triad diplotype given parental diplotype set assuming mating symmetry
##

prob.ordered<-function(line0,.digit) {
ct.same<-0
line1<-line0
.perm<-list(c(3,4,5,6,3,5),c(3,4,5,6,3,6),c(3,4,5,6,4,5),c(3,4,5,6,4,6),c(5,6,3,4,3,5),c(5,6,3,4,3,6),c(5,6,3,4,4,5),c(5,6,3,4,4,6))
for (k in 1:8) {
line1[3:8]<-line0[.perm[[k]]]
a<-min(line1[7:8])
b<-max(line1[7:8])
line1[7:8]<-c(a,b)
tri.perm<-0
for (i in 1:6) tri.perm<-tri.perm+line1[2+i]*10^(.digit*(6-i))
if (tri.perm == line1[10]) ct.same<-ct.same+1
 }
return(ct.same/8)
}

####################################################################################
###  "fit.HWE" performs the EM steps to fit a log-linear model under HWE assumption
##             for a single risk haplotype scenario
# eff can be "C" "M" "MC" "N"
fit.HWE<-function(eff='C',c.additive=T,m.additive=T,max.iter=100,hap.ct=hap.ct0, ped,ped.111, triad,geno, risk.hap,.LL=F) {
 #initialize relative weights of the non-risk haplotypes
 apply(hap.ct*ped$prob,2,sum)/sum(ped$prob)/4->freq.old
 non.risk.pro<- freq.old/(1-freq.old[risk.hap])

#EM to get likihood under alternative

risk.m.old<-c(1,1,1)
risk.m<-c(1,1,1)
risk.old<-c(1,1,1)
risk<-c(1,1,1)

iter<-0
.stop<-0
old.LL<-0
while (iter<max.iter & !.stop) {
  iter<-iter+1
  f.groupsum(ped$prob,triad)->triad.prob
  as.data.frame(cbind(as.numeric(triad),as.numeric(triad.prob)))->triad.obs
  colnames(triad.obs)<-c('triad','prob')
  triad.fitted <-cbind(ped[,c(1,2)],triad.obs)

  triad.obs<- triad.obs[!duplicated(triad.obs[,1]),]
  all.mt <- setup.mt(FALSE)
  merge(all.mt,triad.obs,all.x=T)->triad.fill
  triad.fill$prob[is.na(triad.fill$prob)]<-0
if (c.additive)   cc<- (triad.fill$cc) else   cc<-as.factor(triad.fill$cc)
if (m.additive)   mm<- (triad.fill$mm)  else  mm<-as.factor(triad.fill$mm)
  if (eff=='C')   {var.eff<-'+ cc'}
  if (eff=='M')   {var.eff<-'+ mm'}
  if (eff=='MC')  {var.eff<-'+ cc+ mm'}
  if (eff=='N')   {var.eff<-''}

  .formula<-paste('triad.fill$prob~ (triad.fill$m.f)',var.eff,sep='')

  suppressWarnings(glm(formula=as.formula(.formula),  family=poisson,offset=triad.fill$offset))->reg


 if (length(reg$coefficients[names(reg$coefficients)=='cc'])) { exp(reg$coefficients[names(reg$coefficients)=='cc'])->risk[2]
     risk[2]^2->risk[3] }
 if (length(reg$coefficients[names(reg$coefficients)=='mm'])) { exp(reg$coefficients[names(reg$coefficients)=='mm'])->risk.m[2]
     risk.m[2]^2->risk.m[3] }
 if (length(reg$coefficients[names(reg$coefficients)=='cc1'])) exp(reg$coefficients[names(reg$coefficients)=='cc1'])->risk[2]
 if (length(reg$coefficients[names(reg$coefficients)=='cc2'])) exp(reg$coefficients[names(reg$coefficients)=='cc2'])->risk[3]
 if (length(reg$coefficients[names(reg$coefficients)=='mm1'])) exp(reg$coefficients[names(reg$coefficients)=='mm1'])->risk.m[2]
 if (length(reg$coefficients[names(reg$coefficients)=='mm2'])) exp(reg$coefficients[names(reg$coefficients)=='mm2'])->risk.m[3]
 std.c<-c(0,0)
 std.m<-c(0,0)
 if (length(reg$coefficients[names(reg$coefficients)=='cc'])) { summary(reg)$coefficients[names(reg$coefficients)=='cc',2]->std.c[1]}
 if (length(reg$coefficients[names(reg$coefficients)=='mm'])) { summary(reg)$coefficients[names(reg$coefficients)=='mm',2]->std.m[1]}
 if (length(reg$coefficients[names(reg$coefficients)=='cc1']))  summary(reg)$coefficients[names(reg$coefficients)=='cc1',2]->std.c[1]
 if (length(reg$coefficients[names(reg$coefficients)=='cc2'])) summary(reg)$coefficients[names(reg$coefficients)=='cc2',2]->std.c[2]
 if (length(reg$coefficients[names(reg$coefficients)=='mm1'])) summary(reg)$coefficients[names(reg$coefficients)=='mm1',2]->std.m[1]
 if (length(reg$coefficients[names(reg$coefficients)=='mm2'])) summary(reg)$coefficients[names(reg$coefficients)=='mm2',2]->std.m[2]

 1/(1+exp(-reg$coefficients[names(reg$coefficients)=='triad.fill$m.f']))->p.risk

#update frequencies for non-risk haplotype proportionally
  non.risk.pro*(1-p.risk)->freq.new
  freq.new[risk.hap]<-p.risk
  old.prob<- ped$prob

#updating triad configuration probabilities and in turn non-risk haplotype frequcies and their relative proportions
 unadj.prob<-as.numeric(freq.new[ped[,3]]* freq.new[ped[,4]]*freq.new[ped[,5]]*freq.new[ped[,6]] * 2^(ped.111)
                      * risk[1+geno[,5]+geno[,6]]*risk.m[1+geno[,3]+geno[,4]])
 f.groupsum(unadj.prob,ped$pid) -> pid.sum
 ped$prob<-unadj.prob/pid.sum
 apply(hap.ct*ped$prob,2,sum)/sum(ped$prob)/4->freq.new

 non.risk.pro<- freq.new/(1-freq.new[risk.hap])
 non.risk.pro*(1-p.risk)->freq.new
 freq.new[risk.hap]<-p.risk
 q.risk<-1-p.risk
 r1<-risk[2];r2<-risk[3];  s1<-risk.m[2];s2<-risk.m[3];
 p.D<- q.risk^3+ (r1+s1)*q.risk^2*p.risk +  s1*r1*q.risk*p.risk + (s2*r1+s1*r2)*q.risk*p.risk^2 + s2*r2*p.risk^3

#calculating likehood under the alternative
  freq.new[ped[,3]]* freq.new[ped[,4]]*freq.new[ped[,5]]*freq.new[ped[,6]]* 2^(ped.111)*
  risk[1+geno[,5]+geno[,6]]*risk.m[1+geno[,3]+geno[,4]]/p.D->LL1

  triad.fitted$prob<-ped$prob
 .fitted<-cbind(triad.fill$triad,reg$fitted/sum(reg$fitted))
  colnames(.fitted)<-c('triad','pred')
  merge(triad.fitted,.fitted,all.x=T)-> triad.fitted

  sum(-2*log(f.groupsum(LL1,ped$pid,expand=F)[,1])) -> neg2LnL1

#deviance for the pseudodata
  sum(-2*log(LL1)) -> neg2LnL1.psu

   diff1<-sum(abs(freq.old-freq.new))
   diff2<-sum(abs(old.prob-ped$prob))
   diff3<-(old.LL-neg2LnL1)
   old.LL<-neg2LnL1

 if (diff2<0.0000001 & diff2<0.0000001 & diff3<0.0000001) .stop<-1
  freq.old<-freq.new
  risk[2]->risk.old[2]
  risk[3]->risk.old[3]
    }

 if (!.LL)  cat("Final fit: Effect= ",eff,"; -2LnL: ",neg2LnL1,"\n")
 if (!.LL)  cat("Final fit estimates: Offspring_Risk: ",risk,  " Maternal_Risk: ", risk.m," Risk hap freq:" ,p.risk,"\n")
 if (!.LL) return(c(neg2LnL1,risk[2:3],risk.m[2:3],p.risk)) else   return(c(neg2LnL1,risk[2:3],risk.m[2:3],p.risk,std.c,std.m))
}

####################################################################################
###  "fit.HWE.2hap" performs the EM steps to fit a log-linear model under HWE assumption
##             for a two-risk-haplotype scenario

fit.HWE.2hap<-function(eff='C2',additive=T, max.iter=100,hap.ct=hap.ct0, ped,ped.111, triad,geno1,geno2,risk.hap,risk.hap.comp) {
 #initialize relative weights of the non-risk haplotypes
 apply(hap.ct*ped$prob,2,sum)/sum(ped$prob)/4->freq.old
 non.risk.pro<- freq.old/(1-freq.old[risk.hap])
 
risk.m.old<-c(1,1,1)
risk.m<-c(1,1,1)
risk.old<-c(1,1,1)
risk<-c(1,1,1)
risk.m.comp.old<-c(1,1,1)
risk.m.comp<-c(1,1,1)
risk.comp.old<-c(1,1,1)
risk.comp<-c(1,1,1)

iter<-0
.stop<-0
old.LL<-0
  all.mt <- setup.mt(two.risk.hap=T)
  all.mt$offset[all.mt$offset>0]<-log(2)

  cc.ct1<-(all.mt$c1==1)*1+(all.mt$c2==1)*1
  cc.ct2<-(all.mt$c1==2)*1+(all.mt$c2==2)*1
  mm.ct1<- (all.mt$m1==1)*1+(all.mt$m2==1)*1
  mm.ct2<- (all.mt$m1==2)*1+(all.mt$m2==2)*1
  all.mt<-cbind(all.mt, cc.ct1, cc.ct2, mm.ct1, mm.ct2)

while (iter<max.iter & !.stop) {
  iter<-iter+1
  f.groupsum(ped$prob,triad)->triad.prob
  as.data.frame(cbind(as.numeric(triad),as.numeric(triad.prob)))->triad.obs1
  colnames(triad.obs1)<-c('triad','prob')
  triad.obs<- triad.obs1[!duplicated(triad.obs1[,1]),]

  merge(all.mt,triad.obs,all.x=T)->triad.fill
  triad.fill$prob[is.na(triad.fill$prob)]<-0
  cc.ct1<- triad.fill$cc.ct1
  cc.ct2<- triad.fill$cc.ct2
  mm.ct1<- triad.fill$mm.ct1
  mm.ct2<- triad.fill$mm.ct2

  if (!additive)  {  cc.ct1<-as.factor(cc.ct1); cc.ct2<-as.factor(cc.ct2);  mm.ct1<-as.factor(mm.ct1); mm.ct2<-as.factor(mm.ct2); }
  if (eff=='C1_1')   {var.eff<-'+ cc.ct1'; par1<-'cc1'; par2<-'cc2'}
  if (eff=='C1_2')   {var.eff<-'+ cc.ct2'; par1<-'cc1'; par2<-'cc2'}
  if (eff=='C2')   {var.eff<-'+ cc.ct1 + cc.ct2'; par1<-'cc1'; par2<-'cc2'}
  if (eff=='M1_1')   {var.eff<-'+ mm.ct1'; par1<-'cc1'; par2<-'cc2'}
  if (eff=='M1_2')   {var.eff<-'+ mm.ct2'; par1<-'cc1'; par2<-'cc2'}
  if (eff=='M2')   {var.eff<-'+ mm.ct1 + mm.ct2'; par1<-'cc1'; par2<-'cc2'}

  if (eff=='N')   {var.eff<-''}

  .formula<-paste('triad.fill$prob~ (triad.fill$m.f1) + (triad.fill$m.f2)',var.eff,sep='')
  suppressWarnings(glm(formula=as.formula(.formula),  family=poisson,offset=triad.fill$offset))->reg

if (additive) {
 if (length(reg$coefficients[names(reg$coefficients)=='cc.ct1'])) exp(reg$coefficients[names(reg$coefficients)=='cc.ct1'])->risk[2]
     risk[2]^2->risk[3]
 if (length(reg$coefficients[names(reg$coefficients)=='mm.ct1'])) exp(reg$coefficients[names(reg$coefficients)=='mm.ct1'])->risk.m[2]
     risk.m[2]^2->risk.m[3]
  if (length(reg$coefficients[names(reg$coefficients)=='cc.ct2'])) exp(reg$coefficients[names(reg$coefficients)=='cc.ct2'])->risk.comp[2]
     risk.comp[2]^2->risk.comp[3]
 if (length(reg$coefficients[names(reg$coefficients)=='mm.ct2'])) exp(reg$coefficients[names(reg$coefficients)=='mm.ct2'])->risk.m.comp[2]
     risk.m.comp[2]^2->risk.m.comp[3]
     }   else    {
 if (length(reg$coefficients[names(reg$coefficients)=='cc.ct11'])) exp(reg$coefficients[names(reg$coefficients)=='cc.ct11'])->risk[2]
 if (length(reg$coefficients[names(reg$coefficients)=='cc.ct12'])) exp(reg$coefficients[names(reg$coefficients)=='cc.ct12'])->risk[3]
 if (length(reg$coefficients[names(reg$coefficients)=='mm.ct11'])) exp(reg$coefficients[names(reg$coefficients)=='mm.ct11'])->risk.m[2]
 if (length(reg$coefficients[names(reg$coefficients)=='mm.ct12'])) exp(reg$coefficients[names(reg$coefficients)=='mm.ct12'])->risk.m[3]
 if (length(reg$coefficients[names(reg$coefficients)=='cc.ct21'])) exp(reg$coefficients[names(reg$coefficients)=='cc.ct21'])->risk.comp[2]
 if (length(reg$coefficients[names(reg$coefficients)=='cc.ct22'])) exp(reg$coefficients[names(reg$coefficients)=='cc.ct22'])->risk.comp[3]
 if (length(reg$coefficients[names(reg$coefficients)=='mm.ct21'])) exp(reg$coefficients[names(reg$coefficients)=='mm.ct21'])->risk.m.comp[2]
 if (length(reg$coefficients[names(reg$coefficients)=='mm.ct22'])) exp(reg$coefficients[names(reg$coefficients)=='mm.ct22'])->risk.m.comp[3]
}

  exp(reg$coefficients[names(reg$coefficients)=='triad.fill$m.f1'])->p.r
  exp(reg$coefficients[names(reg$coefficients)=='triad.fill$m.f2'])->q.r
  p.r/(1+p.r+q.r)->f.risk
  q.r/(1+p.r+q.r)->f.comp

#update frequencies for non-risk haplotype proportionally
  non.risk.pro*(1-f.risk-f.comp)->freq.new
  freq.new[risk.hap]<-f.risk
  freq.new[risk.hap.comp]<-f.comp

#calculating likehood under the alternative
 old.prob<- ped$prob

#updating triad configuration probabilities and in turn non-risk haplotype frequcies and their relative proportions
 unadj.prob<-as.numeric(freq.new[ped[,3]]* freq.new[ped[,4]]*freq.new[ped[,5]]*freq.new[ped[,6]] * 2^(ped.111)
                      * risk[1+geno1[,5]+geno1[,6]]*risk.m[1+geno1[,3]+geno1[,4]]
                      * risk.comp[1+geno2[,5]+geno2[,6]]*risk.m.comp[1+geno2[,3]+geno2[,4]])

 f.groupsum(unadj.prob,ped$pid) -> pid.sum
 ped$prob<-unadj.prob/pid.sum
 apply(hap.ct*ped$prob,2,sum)/sum(ped$prob)/4->freq.new

 non.risk.pro<- freq.new/(1-freq.new[risk.hap]-freq.new[risk.hap.comp])
  non.risk.pro*(1-f.risk-f.comp)->freq.new
  freq.new[risk.hap]<-f.risk
  freq.new[risk.hap.comp]<-f.comp
   f.rest<-(1-f.risk-f.comp)

if (eff=='C1_1' | eff=='C1_2'|eff=='C2') { r11<-risk[2]; r12<-risk[3]; r21<-risk.comp[2];r22<-risk.comp[3]} else {
 r11<-risk.m[2]; r12<-risk.m[3]; r21<-risk.m.comp[2];r22<-risk.m.comp[3]}
 # for simplicity consider child and mother scenarios seperately, not applicable to joint MxC effect
 p.D<-f.risk^2*r12+f.comp^2*r22+f.rest^2+2*r11*r21*f.risk*f.comp+2*r11*f.risk*f.rest+2*r21*f.comp*f.rest

#calculating likehood under the alternative
  freq.new[ped[,3]]* freq.new[ped[,4]]*freq.new[ped[,5]]*freq.new[ped[,6]] * 2^(ped.111)*
                       risk[1+geno1[,5]+geno1[,6]]*risk.m[1+geno1[,3]+geno1[,4]]*
                       risk.comp[1+geno2[,5]+geno2[,6]]*risk.m.comp[1+geno2[,3]+geno2[,4]]/p.D->LL1

  sum(-2*log(f.groupsum(LL1,ped$pid,expand=F)[,1])) -> neg2LnL1

   diff1<-sum(abs(freq.old-freq.new))
   diff2<-sum(abs(old.prob-ped$prob))
   diff3<-abs(old.LL-neg2LnL1)
   old.LL<-neg2LnL1

 if (diff2<0.0000001 & diff2<0.0000001 & diff3<0.0000001) .stop<-1
  freq.old<-freq.new

  }
 rst<-c(neg2LnL1,risk[2:3],risk.comp[2:3],risk.m[2:3],risk.m.comp[2:3],f.risk,f.comp)
 names(rst)<-c("-2LL","R1","R2","comp.R1","comp.R2","S1","S2","comp.S1","comp.S2","hap.fr","comp.fr")
 return(rst)
 }


##############################################################################################
### "fit.geno" performs the EM steps to fit a log-linear model under random mating assumption
##             for a single risk haplotype scenario
##
fit.geno <-function(eff='C',c.additive=T,m.additive=T,max.iter=100, ped, ped.diplo,mend.const,triad, all.mt, index.geno, geno,geno.ct, geno.bin, risk.hap) {

risk.m.old<-c(1,1,1)
risk.m<-c(1,1,1)
risk.old<-c(1,1,1)
risk<-c(1,1,1)

iter<-0
.stop<-0
old.LL<-0
fam.num<-sum(ped$prob)
while (iter<max.iter & !.stop) {
  iter<-iter+1
  f.groupsum(ped$prob,triad)->triad.prob
  as.data.frame(cbind(as.numeric(triad),as.numeric(triad.prob)))->triad.obs
  colnames(triad.obs)<-c('triad','prob')
  triad.fitted <-cbind(ped[,c(1,2)],triad.obs)

  triad.obs<- triad.obs[!duplicated(triad.obs[,1]),]

  merge(all.mt,triad.obs,all.x=T)->triad.fill
  triad.fill$prob[is.na(triad.fill$prob)]<-0
if (c.additive)  { cc<- (triad.fill$cc)} else  {cc1<-1*(triad.fill$cc==1);cc2<-1*(triad.fill$cc==2);cc<-cbind(cc1,cc2)}
if (m.additive)  { mm<- (triad.fill$mm)}  else  {mm1<-1*(triad.fill$mm==1);mm2<-1*(triad.fill$mm==2);mm<-cbind(mm1,mm2)}
  if (eff=='C')   {var.eff<-'+ cc'}
  if (eff=='M')   {var.eff<-'+ mm'}
  if (eff=='MC')  {var.eff<-'+ cc+ mm'}
  if (eff=='N')   {var.eff<-''}

  g0<-triad.fill$g0
  g1<-triad.fill$g1
  g2<-triad.fill$g2

  .formula<-paste('triad.fill$prob~ -1 + g0 + g1+ g2',var.eff,sep='')

  suppressWarnings(glm(formula=as.formula(.formula), family=poisson, offset=log(triad.fill$offset*fam.num)))->reg


 if (length(reg$coefficients[names(reg$coefficients)=='cc'])) { exp(reg$coefficients[names(reg$coefficients)=='cc'])->risk[2]
     risk[2]^2->risk[3] }
 if (length(reg$coefficients[names(reg$coefficients)=='mm'])) { exp(reg$coefficients[names(reg$coefficients)=='mm'])->risk.m[2]
     risk.m[2]^2->risk.m[3] }
 if (length(reg$coefficients[names(reg$coefficients)=='cccc1'])) exp(reg$coefficients[names(reg$coefficients)=='cccc1'])->risk[2]
 if (length(reg$coefficients[names(reg$coefficients)=='cccc2'])) exp(reg$coefficients[names(reg$coefficients)=='cccc2'])->risk[3]
 if (length(reg$coefficients[names(reg$coefficients)=='mmmm1'])) exp(reg$coefficients[names(reg$coefficients)=='mmmm1'])->risk.m[2]
 if (length(reg$coefficients[names(reg$coefficients)=='mmmm2'])) exp(reg$coefficients[names(reg$coefficients)=='mmmm2'])->risk.m[3]
 std.c<-c(0,0)
 std.m<-c(0,0)
 if (length(reg$coefficients[names(reg$coefficients)=='cc'])) {
 summary(reg)$coefficients[ row.names(summary(reg)$coefficients)=='cc',2]->std.c[1]}
 if (length(reg$coefficients[names(reg$coefficients)=='mm'])) {
 summary(reg)$coefficients[ row.names(summary(reg)$coefficients)=='mm',2]->std.m[1]}
 if (length(reg$coefficients[names(reg$coefficients)=='cccc1']))  {
 summary(reg)$coefficients[ row.names(summary(reg)$coefficients)=='cccc1',2]->std.c[1] }
 if (length(reg$coefficients[names(reg$coefficients)=='cccc2'])) {
 summary(reg)$coefficients[ row.names(summary(reg)$coefficients)=='cccc2',2]->std.c[2] }
 if (length(reg$coefficients[names(reg$coefficients)=='mmmm1'])) {
 summary(reg)$coefficients[ row.names(summary(reg)$coefficients)=='mmmm1',2]->std.m[1]}
 if (length(reg$coefficients[names(reg$coefficients)=='mmmm2'])) {
 summary(reg)$coefficients[ row.names(summary(reg)$coefficients)=='mmmm2',2]->std.m[2]}


exp(reg$coefficients[1:3])-> g.fr
g.fr<-g.fr/sum(g.fr)
p.Dis<-sum(apply(cbind(triad.fill$offset,g.fr[triad.fill$mm+1],g.fr[triad.fill$ff+1],risk[triad.fill$cc+1], risk.m[triad.fill$mm+1]),
             1,prod))

prob.corr<- ped$prob/(risk[1+geno[,5]+geno[,6]]*risk.m[1+geno[,3]+geno[,4]])
 f.groupsum(c(prob.corr,prob.corr),c(ped.diplo[,1],ped.diplo[,2]),expand=FALSE)->geno.ct
geno.ct<-geno.ct[,1]/sum(geno.ct[,1])
 old.prob<- ped$prob

 # factor to adjust for case status   use all diplotypes to calculate disease rate
fac<- f.groupsum(apply(cbind(triad.fill$offset,g.fr[triad.fill$mm+1],g.fr[triad.fill$ff+1],risk[triad.fill$cc+1], risk.m[triad.fill$mm+1]),
             1,prod),triad.fill$cc,expand=FALSE)[,1]/
      f.groupsum(apply(cbind(triad.fill$offset,g.fr[triad.fill$mm+1],g.fr[triad.fill$ff+1]),
             1,prod),triad.fill$cc,expand=FALSE)[,1]
 p.Dis<-sum(geno.ct*fac[geno.bin[,3]+geno.bin[,4]+1])

#updating triad configuration probabilities and in turn non-risk haplotype frequcies and their relative proportions
unadj.prob<- geno.ct[index.geno[,1]]*geno.ct[index.geno[,2]]* mend.const*
             risk[1+geno[,5]+geno[,6]]*risk.m[1+geno[,3]+geno[,4]] /p.Dis

 f.groupsum(unadj.prob,ped$pid) -> pid.sum
 ped$prob<-unadj.prob/pid.sum

 sum(-2*log(f.groupsum(unadj.prob,ped$pid,expand=F)[,1])) -> neg2LnL1

   diff2<-sum(abs(old.prob-ped$prob))
   diff3<-(old.LL-neg2LnL1)
   old.LL<-neg2LnL1
# the following command is commented out.  Remove the # in the front if you want to see the iteration details
#  cat('iter=',iter," geno.fr=",g.fr," -2LnL=",neg2LnL1," Risk_C=",risk[2:3]," Risk_M=", risk.m[2:3] ,"\n")
 
 if ( diff2<0.001 & diff3<0.0001) .stop<-1
    }
   cat("Final fit: Effect= ",eff,"; -2LnL: ",neg2LnL1,"\n")
   cat("Final fit estimates: Offspring_Risk: ",risk,  " Maternal_Risk: ", risk.m," Risk_geno_freq: " ,g.fr,"\n")
  return(c(neg2LnL1,risk[-1], risk.m[-1],g.fr))
}

#############################################################################################
### "fit.full" performs the EM steps to fit a log-linear model with the full model 
##             (all the mating type parameters) for a single risk haplotype scenario

fit.full <-function(eff='C',c.additive=T,m.additive=T,max.iter=100, ped,triad, geno,mt.set, 
                   mt.bin,index.mt, prob.to.order, risk.hap,.LL=F){

all.mt <- setup.mt(F)
risk.m.old<-c(1,1,1)
risk.m<-c(1,1,1)
risk.old<-c(1,1,1)
risk<-c(1,1,1)


iter<-0
.stop<-0
old.LL<-0

while (iter<max.iter & !.stop) {
  iter<-iter+1
  old.prob<-ped$prob
  f.groupsum(ped$prob,triad)->triad.prob
  as.data.frame(cbind(as.numeric(triad),as.numeric(triad.prob)))->triad.obs
  colnames(triad.obs)<-c('triad','prob')
  triad.obs<- triad.obs[!duplicated(triad.obs[,1]),]
  merge(all.mt,triad.obs,all.x=T)->triad.fill
  triad.fill$prob[is.na(triad.fill$prob)]<-0
  mt<-as.factor(triad.fill$mt)
if (c.additive)   cc<- (triad.fill$cc) else   cc<-as.factor(triad.fill$cc)
if (m.additive)   mm<- (triad.fill$mm)  else  mm<-as.factor(triad.fill$mm)
  if (eff=='C')   {var.eff<-'+ cc'}
  if (eff=='M')   {var.eff<-'+ mm'}
  if (eff=='MC')  {var.eff<-'+ cc+ mm'}
  if (eff=='N')   {var.eff<-''}

   .formula<-paste('triad.fill$prob~  -1+  mt ',var.eff,sep='')
  suppressWarnings(glm(formula=as.formula(.formula),  family=poisson,offset=triad.fill$offset))->reg


 if (length(reg$coefficients[names(reg$coefficients)=='cc'])) { exp(reg$coefficients[names(reg$coefficients)=='cc'])->risk[2]
     risk[2]^2->risk[3] }
 if (length(reg$coefficients[names(reg$coefficients)=='mm'])) { exp(reg$coefficients[names(reg$coefficients)=='mm'])->risk.m[2]
     risk.m[2]^2->risk.m[3] }
 if (length(reg$coefficients[names(reg$coefficients)=='cc1'])) exp(reg$coefficients[names(reg$coefficients)=='cc1'])->risk[2]
 if (length(reg$coefficients[names(reg$coefficients)=='cc2'])) exp(reg$coefficients[names(reg$coefficients)=='cc2'])->risk[3]
 if (length(reg$coefficients[names(reg$coefficients)=='mm1'])) exp(reg$coefficients[names(reg$coefficients)=='mm1'])->risk.m[2]
 if (length(reg$coefficients[names(reg$coefficients)=='mm2'])) exp(reg$coefficients[names(reg$coefficients)=='mm2'])->risk.m[3]
 std.c<-c(0,0)
 std.m<-c(0,0)
 if (length(reg$coefficients[names(reg$coefficients)=='cc'])) { summary(reg)$coefficients[names(reg$coefficients)=='cc',2]->std.c[1]}
 if (length(reg$coefficients[names(reg$coefficients)=='mm'])) { summary(reg)$coefficients[names(reg$coefficients)=='mm',2]->std.m[1]}
 if (length(reg$coefficients[names(reg$coefficients)=='cc1']))  summary(reg)$coefficients[names(reg$coefficients)=='cc1',2]->std.c[1]
 if (length(reg$coefficients[names(reg$coefficients)=='cc2'])) summary(reg)$coefficients[names(reg$coefficients)=='cc2',2]->std.c[2]
 if (length(reg$coefficients[names(reg$coefficients)=='mm1'])) summary(reg)$coefficients[names(reg$coefficients)=='mm1',2]->std.m[1]
 if (length(reg$coefficients[names(reg$coefficients)=='mm2'])) summary(reg)$coefficients[names(reg$coefficients)=='mm2',2]->std.m[2]

  #convert exp(beta) to mating type frequency u
    exp(reg$coefficients[1:6])->mt.tot
    mt.tot<- mt.tot*c(1,4,2,4,4,1)
    mt.tot<-mt.tot/sum(mt.tot)

f.groupsum(ped$prob,mt.set,expand=FALSE)->mt.set.ct
mt.set.ct[,1]<-mt.set.ct[,1]/sum(mt.set.ct[,1])
# relative weights for each mating types
wt <- list( mt.set.ct[mt.bin==1,1]/sum( mt.set.ct[mt.bin==1,1]),
      mt.set.ct[mt.bin==2,1]/sum( mt.set.ct[mt.bin==2,1]),
      mt.set.ct[mt.bin==3,1]/sum( mt.set.ct[mt.bin==3,1]),
      mt.set.ct[mt.bin==4,1]/sum( mt.set.ct[mt.bin==4,1]),
      mt.set.ct[mt.bin==5,1]/sum( mt.set.ct[mt.bin==5,1]),
      mt.set.ct[mt.bin==6,1]/sum( mt.set.ct[mt.bin==6,1]))
 for (k in 1:6) {
 mt.set.ct[mt.bin==k,1]<-wt[[k]]*mt.tot[k]
 }

.coef<- c(1, rep(0.25, 4), 0.5, 0.5, 0.25, 0.5, 0.25, rep(0.25, 4), 1)
 cbind(all.mt,.coef)->p.D
p.D$mt<-mt.tot[p.D$mt]
p.D.vec<-(p.D$mt*p.D$.coef*risk[2]^(p.D$cc==1)*risk[3]^(p.D$cc==2)*risk.m[2]^(p.D$mm==1)*risk.m[3]^(p.D$mm==2))
p.Dis<-sum(p.D.vec)

#re-assign probability of fraction within each family
fr.geno<-c(0,0,0)
(mt.tot[1]*2+mt.tot[2]+mt.tot[3])/2->fr.geno[3]
(mt.tot[4]*2+mt.tot[2]+mt.tot[5])/2->fr.geno[2]
(mt.tot[6]*2+mt.tot[3]+mt.tot[5])/2->fr.geno[1]

mt.set.ct[index.mt,1]*prob.to.order* risk[1+geno[,5]+geno[,6]]*risk.m[1+geno[,3]+geno[,4]]/p.Dis->unadj.prob
 f.groupsum(unadj.prob,ped$pid) -> pid.sum    #summed probability within each family
 ped$prob<-unadj.prob/pid.sum                 #adjusted probablility for each triad configuration so each family sum up to 1
 sum(-2*log(f.groupsum(unadj.prob,ped$pid,expand=F)[,1])) -> neg2LnL1

   diff2<-sum(abs(old.prob-ped$prob))
   diff3<-(old.LL-neg2LnL1)
   old.LL<-neg2LnL1
 if ( diff2<0.001 & diff3<0.0001) .stop<-1
  risk->risk.old
}
 if (!.LL)  cat("Final fit: Effect= ",eff,"; -2LnL: ",neg2LnL1,"Iter: ",iter,"\n")
 if (!.LL)  cat("Final fit estimates: Offspring_Risk: ",risk,  " Maternal_Risk: ", risk.m," Risk_geno_freq: " ,fr.geno,"\n")
if (!.LL) return(c(neg2LnL1,risk[2:3],risk.m[2:3],fr.geno)) else   return(c(neg2LnL1,risk[2:3],risk.m[2:3],fr.geno,std.c,std.m))
}



# HAplotype Relative Risk Estimation
#############################################################################################################
#   "TRIMMEST" is the main function used to fit a log-linear model using genotypes from case-parent triads.    
#                                                                     
#############################################################################################################
# ".model" can be  "hwe", "hwe.2hap", "geno", and "full"
# "eff" can be "C_2df", "M_2df", "C.add", "M.add"
TRIMMEST<-function(.ped.in="risk.inp",.model='hwe',.target.hap=0,eff='C_2df') {
if (.target.hap[1]==0) stop("ERROR: Need change the inupt parameter '.target.hap' to your target haplotype")
if (.model=='hwe.2hap' & length(.target.hap)!=2) stop("ERROR: Need two target haplotypes for a two-risk-haplotype model")
if (!(eff %in%c('C_2df', 'C_add','M_2df','M_add'))) stop("Possible eff values are: 'C_2df', 'C_add','M_2df','M_add'")
read.table(.ped.in)->ped

max(ped[,3:8])->hap.no
risk.hap<-.target.hap

#.digit is the number of digits for # of haplotypes, i.e., <10 then .digit=1, >=10 & <99 then .digit=2
.digit <-1
if (hap.no<100 & hap.no >= 10) .digit <-2
if (hap.no<1000 & hap.no >= 100) .digit <-3
total.n<-dim(ped)[1]
amb.n<-dim(table(ped[,1]))-sum(table(ped[,1])==1)
cat(" Total number of triad types:",total.n, " \n Number of families with ambiguous transmission tetratypes:",amb.n,"\n")
colnames(ped)<-c('pid','haps','f1','f2','m1','m2','c1','c2','prob')

#Prepare data to fit log-linear model under HWE
if (.model=='hwe') {  

#change the hap coding to 0/1 nonrisk/risk and store in 'geno'
apply(ped[,3:8],2,function (v){1*(v%in%risk.hap)})->geno
m<-geno[,3]+geno[,4]
f<-geno[,1]+geno[,2]
c<-geno[,5]+geno[,6]
paste(pmin(f,m),pmax(f,m),sep='')->mt  #unordered
paste(m,f,c,sep='')->triad  #ordered

#a vector of indicators for families being the same heterozygous genotype for all 3 individuals
ped.111<-1*((apply(ped[,3:4],1,min)== apply(ped[,5:6],1,min)) &  (apply(ped[,7:8],1,min)== apply(ped[,5:6],1,min)) &
  (apply(ped[,3:4],1,max)== apply(ped[,5:6],1,max)) &  (apply(ped[,7:8],1,max)== apply(ped[,5:6],1,max)) & (ped[,3] != ped[,4]) )

#indicator matix for the occurence of each haplotype in parents
hap.ct0<-NULL
for (k in 1:hap.no) {
((ped[,3]==k)+ (ped[,4]==k )+ (ped[,5]==k)+(ped[,6]==k))-> ct1
 hap.ct0<-cbind(hap.ct0,ct1)
 }

 if (eff=='C_2df') {
fit.alt<- fit.HWE(eff='MC',c.additive=F,m.additive=F,max.iter=100,hap.ct=hap.ct0,ped,ped.111, triad,geno,risk.hap,.LL=F) 
fit.null<- fit.HWE(eff='M',c.additive=F,m.additive=F,max.iter=100,hap.ct=hap.ct0,ped,ped.111, triad,geno,risk.hap,.LL=F) 
cat('\n\n||****************************************  RESULT  ***************************************||\n')
cat('Testing child effect 2-df LRT: Chi2=',fit.null[1]-fit.alt[1],"p-value=",1-pchisq(fit.null[1]-fit.alt[1],2),'\n')
cat('Estimates for child effects  : R1=',fit.alt[2],"R2=",fit.alt[3],'; estimated risk haplotype frequency=',fit.alt[6],'\n')
} else if (eff=='C_add') {
fit.alt<- fit.HWE(eff='MC',c.additive=T,m.additive=F,max.iter=100,hap.ct=hap.ct0,ped,ped.111, triad,geno,risk.hap,.LL=F)  
fit.null<- fit.HWE(eff='M',c.additive=T,m.additive=F,max.iter=100,hap.ct=hap.ct0,ped,ped.111, triad,geno,risk.hap,.LL=F) 
cat('\n\n||****************************************  RESULT  ***************************************||\n')
cat('Testing child effect 1-df LRT: Chi2=',fit.null[1]-fit.alt[1],"p-value=",1-pchisq(fit.null[1]-fit.alt[1],1),'\n')
cat('Estimates for child effects  : R1=',fit.alt[2],"R2=",fit.alt[3],'; estimated risk haplotype frequency=',fit.alt[6],'\n')
} else if (eff=='M_2df') {
fit.alt<- fit.HWE(eff='MC',c.additive=F,m.additive=F,max.iter=100,hap.ct=hap.ct0,ped,ped.111, triad,geno,risk.hap,.LL=F) 
fit.null<- fit.HWE(eff='C',c.additive=F,m.additive=F,max.iter=100,hap.ct=hap.ct0,ped,ped.111, triad,geno,risk.hap,.LL=F) 
cat('\n\n||****************************************  RESULT  ***************************************||\n')
cat('Testing maternal effect 2-df LRT: Chi2=',fit.null[1]-fit.alt[1],"p-value=",1-pchisq(fit.null[1]-fit.alt[1],2),'\n')
cat('Estimates for maternal effects  : S1=',fit.alt[4],"S2=",fit.alt[5],'; estimated risk haplotype frequency=',fit.alt[6],'\n')
}else if (eff=='M_add') {
fit.alt<- fit.HWE(eff='MC',c.additive=F,m.additive=T,max.iter=100,hap.ct=hap.ct0,ped,ped.111, triad,geno,risk.hap,.LL=F) 
fit.null<- fit.HWE(eff='C',c.additive=F,m.additive=T,max.iter=100,hap.ct=hap.ct0,ped,ped.111, triad,geno,risk.hap,.LL=F)  
cat('\n\n||****************************************  RESULT  ***************************************||\n')
cat('Testing maternal effect 1-df LRT: Chi2=',fit.null[1]-fit.alt[1],"p-value=",1-pchisq(fit.null[1]-fit.alt[1],1),'\n')
cat('Estimates for maternal effects  : S1=',fit.alt[4],"S2=",fit.alt[5],'; estimated risk haplotype frequency=',fit.alt[6],'\n')}

} else if (.model=='hwe.2hap') {

risk.hap <-.target.hap[1]
risk.hap.comp <-.target.hap[2]

#change the hap coding to 0/1 nonrisk/risk and store in 'geno'
apply(ped[,3:8],2,function (v){1*(v%in%risk.hap)})->geno1
apply(ped[,3:8],2,function (v){1*(v%in%risk.hap.comp)})->geno2
# recode so that 1 and 2 are the two risk haplotypes respectively, the rest non-risk haplotypes are coded as 3
 geno<-geno1*0+3
 geno[geno1==1]<-1
 geno[geno2==1]<-2

ff<-cbind(pmin(geno[,1],geno[,2]),pmax(geno[,1],geno[,2]))
mm<-cbind(pmin(geno[,3],geno[,4]),pmax(geno[,3],geno[,4]))
cc<-cbind(pmin(geno[,5],geno[,6]),pmax(geno[,5],geno[,6]))
paste(mm[,1],mm[,2],ff[,1],ff[,2],cc[,1],cc[,2],sep='')->triad  #ordered

hap.ct0<-NULL
for (k in 1:hap.no) {
((ped[,3]==k)+ (ped[,4]==k )+ (ped[,5]==k)+(ped[,6]==k))-> ct1
 hap.ct0<-cbind(hap.ct0,ct1)
 }
ped.111<-1*((apply(ped[,3:4],1,min)== apply(ped[,5:6],1,min)) &  (apply(ped[,7:8],1,min)== apply(ped[,5:6],1,min)) &
  (apply(ped[,3:4],1,max)== apply(ped[,5:6],1,max)) &  (apply(ped[,7:8],1,max)== apply(ped[,5:6],1,max)) & (ped[,3] != ped[,4]) )

 fit.null<- fit.HWE.2hap(eff='N',additive=T, max.iter=100,hap.ct=hap.ct0, ped,ped.111, triad,geno1,geno2,risk.hap,risk.hap.comp)
if (eff=='C_2df')  {fit.alt<- fit.HWE.2hap(eff='C2',additive=F, max.iter=100,hap.ct=hap.ct0, ped,ped.111, triad,geno1,geno2,risk.hap,risk.hap.comp)
cat('Testing child effect & two risk haplotypes 4-df LRT: Chi2=',fit.null[1]-fit.alt[1],"p-value=",1-pchisq(fit.null[1]-fit.alt[1],4),'\n')
cat('Estimates for child effects  : Hap1_R1=',fit.alt[2],"Hap1_R2=",fit.alt[3],'Hap2_R1=',fit.alt[4],"Hap2_R2=",fit.alt[5],'\n')
  }
if (eff=='C_add')  {fit.alt<- fit.HWE.2hap(eff='C2',additive=T, max.iter=100,hap.ct=hap.ct0, ped,ped.111,triad,geno1,geno2,risk.hap,risk.hap.comp)
cat('Testing child effect & two risk haplotypes 2-df LRT: Chi2=',fit.null[1]-fit.alt[1],"p-value=",1-pchisq(fit.null[1]-fit.alt[1],2),'\n')
cat('Estimates for child effects  : Hap1_R1=',fit.alt[2],"Hap1_R2=",fit.alt[3],'Hap2_R1=',fit.alt[4],"Hap2_R2=",fit.alt[5],'\n')
}
if (eff=='M_2df')  {fit.alt<- fit.HWE.2hap(eff='M2',additive=F, max.iter=100,hap.ct=hap.ct0, ped,ped.111, triad,geno1,geno2,risk.hap,risk.hap.comp)
cat('Testing maternal effect & two risk haplotypes 4-df LRT: Chi2=',fit.null[1]-fit.alt[1],"p-value=",1-pchisq(fit.null[1]-fit.alt[1],4),'\n')
cat('Estimates for child effects  : Hap1_R1=',fit.alt[6],"Hap1_R2=",fit.alt[7],'Hap2_R1=',fit.alt[8],"Hap2_R2=",fit.alt[9],'\n')
}
if (eff=='M_add')  {fit.alt<- fit.HWE.2hap(eff='M2',additive=T, max.iter=100,hap.ct=hap.ct0, ped,ped.111, triad,geno1,geno2,risk.hap,risk.hap.comp)
cat('Testing maternal effect & two risk haplotypes 2-df LRT: Chi2=',fit.null[1]-fit.alt[1],"p-value=",1-pchisq(fit.null[1]-fit.alt[1],2),'\n')
cat('Estimates for child effects  : Hap1_R1=',fit.alt[6],"Hap1_R2=",fit.alt[7],'Hap2_R1=',fit.alt[8],"Hap2_R2=",fit.alt[9],'\n')
}
cat('Estimated frequency for risk haplotype_1=',fit.alt[10],'; frequency for risk haplotype_2=',fit.alt[11],'\n')
 
}  else if (.model=='geno') {
ped.tmp<-ped
 
#re-order 3,4  5,6 7,8 so that diplotype will be in order
ped.tmp[,3]<-pmin(ped[,3],ped[,4])
ped.tmp[,4]<-pmax(ped[,3],ped[,4])
ped.tmp[,5]<-pmin(ped[,5],ped[,6])
ped.tmp[,6]<-pmax(ped[,5],ped[,6])
ped.tmp[,7]<-pmin(ped[,7],ped[,8])
ped.tmp[,8]<-pmax(ped[,7],ped[,8])
ped<-ped.tmp

fam.num<-sum(ped$prob)
ped.diplo<- cbind(ped[,3]*10^.digit+ped[,4],ped[,5]*10^.digit+ped[,6],ped[,7]*10^.digit+ped[,8])
#initialize the counts for mt.set , mt.set.ct is shorter than mt.set or ped
 f.groupsum(c(ped$prob,ped$prob),c(ped.diplo[,1],ped.diplo[,2]),expand=FALSE)->geno.ct
 floor(geno.ct[,2]/ 10^.digit)->geno.bin
 cbind(geno.bin,geno.ct[,2]-floor(geno.ct[,2]/ 10^.digit)*10^.digit)->geno.bin
 cbind(geno.bin,geno.bin==risk.hap) ->geno.bin
 unlist(lapply(ped.diplo[,1],function(x) {return(which(geno.ct[,2]==x))}))-> index.geno
 cbind(index.geno,unlist(lapply(ped.diplo[,2],function(x) {return(which(geno.ct[,2]==x))})))-> index.geno
 apply(ped[,3:8],1,mend.fact)-> mend.const

max.iter<-100
#change the hap coding to 0/1 nonrisk/risk and store in 'geno'
apply(ped[,3:8],2,function (v){1*(v%in%risk.hap)})->geno
m<-geno[,3]+geno[,4]
f<-geno[,1]+geno[,2]
c<-geno[,5]+geno[,6]
paste(m,f,c,sep='')->triad  #ordered

 setup.mt(two.risk.hap=F)->all.mt
 all.mt$offset<-c(1,.5,.5,.5,.5,1,1,.25,.5,.25,.5,.5,.5,.5,1)
 (all.mt$mm==0)+(all.mt$ff==0)->g0
 (all.mt$mm==1)+(all.mt$ff==1)->g1
 (all.mt$mm==2)+(all.mt$ff==2)->g2
all.mt<-cbind(all.mt,g0,g1,g2)

if (eff=='C_2df')  {
fit.alt <- fit.geno(eff='MC',c.additive=F,m.additive=F,max.iter=100, ped, ped.diplo, mend.const,triad, all.mt, index.geno, geno,geno.ct, geno.bin, risk.hap)
fit.null<- fit.geno(eff='M',c.additive=F,m.additive=F,max.iter=100, ped, ped.diplo,mend.const,triad, all.mt, index.geno, geno,geno.ct, geno.bin, risk.hap)
cat('\n\n||****************************************  RESULT  ***************************************||\n')
cat('Testing child effect under random mating 2-df LRT: Chi2=',fit.null[1]-fit.alt[1],"p-value=",1-pchisq(fit.null[1]-fit.alt[1],2),'\n')
cat('Estimates for child effects  : R1=',fit.alt[2],"R2=",fit.alt[3],'\n')
  }
if (eff=='C_add')  {
fit.alt <- fit.geno(eff='MC',c.additive=T,m.additive=F,max.iter=100, ped,ped.diplo, mend.const,triad, all.mt, index.geno, geno,geno.ct, geno.bin, risk.hap)
fit.null<- fit.geno(eff='M',c.additive=T,m.additive=F,max.iter=100, ped, ped.diplo,mend.const,triad, all.mt, index.geno, geno,geno.ct, geno.bin, risk.hap)
cat('\n\n||****************************************  RESULT  ***************************************||\n')
cat('Testing child effect under random mating 1-df LRT: Chi2=',fit.null[1]-fit.alt[1],"p-value=",1-pchisq(fit.null[1]-fit.alt[1],1),'\n')
cat('Estimates for child effects  : R1=',fit.alt[2],"R2=",fit.alt[3],'\n')
  }
if (eff=='M_2df')  {
fit.alt <- fit.geno(eff='MC',c.additive=F,m.additive=F,max.iter=100, ped, ped.diplo,mend.const,triad, all.mt, index.geno, geno,geno.ct, geno.bin, risk.hap)
fit.null<- fit.geno(eff='C',c.additive=F,m.additive=F,max.iter=100, ped,ped.diplo, mend.const,triad, all.mt, index.geno, geno,geno.ct, geno.bin, risk.hap)
cat('\n\n||****************************************  RESULT  ***************************************||\n')
cat('Testing maternal effect under random mating 2-df LRT: Chi2=',fit.null[1]-fit.alt[1],"p-value=",1-pchisq(fit.null[1]-fit.alt[1],2),'\n')
cat('Estimates for child effects  : S1=',fit.alt[4],"S2=",fit.alt[5],'\n')
  }
if (eff=='M_add')  {
fit.alt <- fit.geno(eff='MC',c.additive=F,m.additive=T,max.iter=100, ped,ped.diplo, mend.const,triad, all.mt, index.geno, geno,geno.ct, geno.bin, risk.hap)
fit.null<- fit.geno(eff='C',c.additive=F,m.additive=T,max.iter=100, ped,ped.diplo, mend.const,triad, all.mt, index.geno, geno,geno.ct, geno.bin, risk.hap)
cat('\n\n||****************************************  RESULT  ***************************************||\n')
cat('Testing maternal effect under random mating 1-df LRT: Chi2=',fit.null[1]-fit.alt[1],"p-value=",1-pchisq(fit.null[1]-fit.alt[1],1),'\n')
cat('Estimates for child effects  : S1=',fit.alt[4],"S2=",fit.alt[5],'\n')
  }
cat("Genotype frequncies (0,1,2) copies of risk haplotype = (",fit.alt[6],",",fit.alt[7],",",fit.alt[8],")",'\n')      
} else if (.model=='full') {

ped.tmp<-ped
#re-order 3,4  5,6 7,8 so that diplotype will be in order
ped.tmp[,3]<-pmin(ped[,3],ped[,4])
ped.tmp[,4]<-pmax(ped[,3],ped[,4])
ped.tmp[,5]<-pmin(ped[,5],ped[,6])
ped.tmp[,6]<-pmax(ped[,5],ped[,6])
ped.tmp[,7]<-pmin(ped[,7],ped[,8])
ped.tmp[,8]<-pmax(ped[,7],ped[,8])
ped<-ped.tmp

n.fam<-sum(ped$prob)
 fam.num<-n.fam
tri.diplotype<-0
for (i in 1:6) tri.diplotype<-tri.diplotype+ped[,2+i]*10^(.digit*(6-i))
#probablity of observed triad diplotype given parental haplotype set
ped.mt<-cbind(ped,tri.diplotype)
apply(ped.mt,1,prob.ordered,.digit)-> prob.to.order

# mt.set is the unordered mating types,one for each transmission tetratype
mt.set<-0
.set1<-pmin(ped[,3]* 10^.digit + ped[,4], ped[,5]* 10^.digit + ped[,6])
.set2<-pmax(ped[,3]* 10^.digit + ped[,4], ped[,5]* 10^.digit + ped[,6])
mt.set<-.set1*10^(2*.digit)+.set2

#initialize the counts for mt.set , mt.set.ct is shorter than mt.set or ped
 f.groupsum(ped$prob,mt.set,expand=FALSE)->mt.set.ct
# the index of  frequencies vector for a mating type in the order of haplore output.  This match the mt.set with mt.set.ct
 unlist(lapply(mt.set,function(x) {return(which(mt.set.ct[,2]==x))}))-> index.mt

#match mt.set to dichotomized mating types mt.bin
mt.h1<-  floor(mt.set.ct[,2]/(10^(.digit*3)))
mt.h2<- floor((mt.set.ct[,2]-mt.h1*(10^(.digit*3)))/(10^(.digit*2)))
mt.h3<- floor((mt.set.ct[,2]-mt.h1*(10^(.digit*3))-mt.h2*(10^(.digit*2)))/(10^(.digit)))
mt.h4<- mt.set.ct[,2]-mt.h1*(10^(.digit*3))-mt.h2*(10^(.digit*2))-mt.h3*(10^(.digit))
parent1<-(mt.h1==risk.hap) + (mt.h2==risk.hap)
parent2<-(mt.h3==risk.hap) + (mt.h4==risk.hap)
mt.bin <- (parent1==parent2)*(6-(2*parent1+(parent1==2))) + (parent1!=parent2)*(5-(parent1+parent2)*(parent1==2 | parent2==2))

#change the hap coding to 0/1 nonrisk/risk and store in 'geno'
apply(ped[,3:8],2,function (v){1*(v%in%risk.hap)})->geno
m<-geno[,3]+geno[,4]
f<-geno[,1]+geno[,2]
c<-geno[,5]+geno[,6]
paste(m,f,c,sep='')->triad  #ordered

 if (eff=='C_2df') {
fit.alt<- fit.full(eff='MC',c.additive=F,m.additive=F,max.iter=100, ped,triad, geno,mt.set, mt.bin,index.mt, prob.to.order, risk.hap,.LL=F)
fit.null<-fit.full(eff='M',c.additive=F,m.additive=F,max.iter=100, ped,triad, geno,mt.set, mt.bin,index.mt, prob.to.order, risk.hap,.LL=F)
cat('\n\n||****************************************  RESULT  ***************************************||\n')
cat('Testing child effect 2-df LRT: Chi2=',fit.null[1]-fit.alt[1],"p-value=",1-pchisq(fit.null[1]-fit.alt[1],2),'\n')
cat('Estimates for child effects  : R1=',fit.alt[2],"R2=",fit.alt[3],'\n')
} else if (eff=='C_add') {
fit.alt<- fit.full(eff='MC',c.additive=T,m.additive=F,max.iter=100, ped,triad, geno,mt.set, mt.bin,index.mt, prob.to.order, risk.hap,.LL=F)
fit.null<-fit.full(eff='M',c.additive=T,m.additive=F,max.iter=100, ped,triad, geno,mt.set, mt.bin,index.mt, prob.to.order, risk.hap,.LL=F)
cat('\n\n||****************************************  RESULT  ***************************************||\n')
cat('Testing child effect 1-df LRT: Chi2=',fit.null[1]-fit.alt[1],"p-value=",1-pchisq(fit.null[1]-fit.alt[1],1),'\n')
cat('Estimates for child effects  : R1=',fit.alt[2],"R2=",fit.alt[3],'\n')
} else if (eff=='M_2df') {
fit.alt<- fit.full(eff='MC',c.additive=F,m.additive=F,max.iter=100, ped,triad, geno,mt.set, mt.bin,index.mt, prob.to.order, risk.hap,.LL=F)
fit.null<-fit.full(eff='C',c.additive=F,m.additive=F,max.iter=100, ped,triad, geno,mt.set, mt.bin,index.mt, prob.to.order, risk.hap,.LL=F)
cat('\n\n||****************************************  RESULT  ***************************************||\n')
cat('Testing maternal effect 2-df LRT: Chi2=',fit.null[1]-fit.alt[1],"p-value=",1-pchisq(fit.null[1]-fit.alt[1],2),'\n')
cat('Estimates for maternal effects  : S1=',fit.alt[4],"S2=",fit.alt[5],'\n')
}else if (eff=='M_add') {
fit.alt<- fit.full(eff='MC',c.additive=F,m.additive=T,max.iter=100, ped,triad, geno,mt.set, mt.bin,index.mt, prob.to.order, risk.hap,.LL=F)
fit.null<-fit.full(eff='C',c.additive=F,m.additive=T,max.iter=100, ped,triad, geno,mt.set, mt.bin,index.mt, prob.to.order, risk.hap,.LL=F)
cat('\n\n||****************************************  RESULT  ***************************************||\n')
cat('Testing maternal effect 1-df LRT: Chi2=',fit.null[1]-fit.alt[1],"p-value=",1-pchisq(fit.null[1]-fit.alt[1],1),'\n')
cat('Estimates for maternal effects  : S1=',fit.alt[4],"S2=",fit.alt[5],'\n')
}
cat("Genotype frequncies (0,1,2) copies of risk haplotype = (",fit.alt[6],",",fit.alt[7],",",fit.alt[8],")",'\n')
}

cat('||************************************  END OF RESULT  ************************************||')
cat('\n\n')
}

######################################################################################
### Test run
######################################################################################
## Assume that you set the working directory to the same directory of the input pedigree file with the file name "risk.inp"
TRIMMEST("risk.inp",'hwe',2,'C_2df')
TRIMMEST("risk.inp",'geno',2,'C_add')
TRIMMEST("risk.inp",'full',2,'M_2df')
TRIMMEST("risk.inp",'hwe.2hap',c(1,2),'C_2df')