#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>

#define  MAX_MATRIX_LENGTH 100

double **alloc_double_double(int ,int );

double **read_pwm(int *matrixLen,char *fileName) {

   register int m,n;
   int numCol,numRow;
   double colSum;
   double **pwm;
   FILE *fp;

   pwm=alloc_double_double(MAX_MATRIX_LENGTH,4);

   fp=fopen(fileName,"r");
   if (!fp) { perror(fileName); exit(0); }

   fscanf(fp,"%d %d",&numRow,&numCol);
   if (numRow !=4) { printf("\nError: please check documentation for PWM format.\n"); exit(0); }

   for (m=0; m<4; m++) {
      for (n=0; n<numCol; n++) fscanf(fp,"%lf",&pwm[n][m]);
   }
   fclose(fp);

   printf("\nInitial PWM:\n");
   for (m=0; m<4; m++) {
      for (n=0; n<numCol; n++) {
        if (n<numCol-1) printf("%5.3f\t",pwm[n][m]);
        else            printf("%5.3f\n",pwm[n][m]); 
      }
   }

   for (n=0; n<numCol; n++) {
      colSum=0; for (m=0; m<4; m++) colSum  +=pwm[n][m];
      for (m=0; m<4; m++) pwm[n][m] /=colSum;
   }
   *matrixLen=numCol;

   return (pwm); 
}
