#include <stdio.h>
#include <stdlib.h>
#include <string.h>

void sort_double(double *,int );

void score_seq(int numSeq,char **seq,char **rSeq,int *seqLen,double **pwm,int matLen,double sumMin,
   double sumMax,double *score) {

   register int ii,i,m;
   double scale,plusScore,minusScore,maxScore;

   scale=sumMax-sumMin;
   if (scale==0) {
      for (ii=0; ii<numSeq; ii++) score[ii]=0;
   }
   else {
      for (ii=0; ii<numSeq; ii++) {
         maxScore=0;
         /* scan plus strand */
         for(i=0; i<seqLen[ii]-matLen+1; i++) {
            plusScore=0;
            for (m=0; m<matLen; m++) {
               switch(seq[ii][i+m]) {
                  case 'a': plusScore +=pwm[m][0]; break;
                  case 'c': plusScore +=pwm[m][1]; break;
                  case 'g': plusScore +=pwm[m][2]; break;
                  case 't': plusScore +=pwm[m][3]; break;
                  default:  plusScore=-1; break;
               }
            }
            plusScore=(plusScore-sumMin)/scale;
            if (plusScore>maxScore) maxScore=plusScore;
         }
         /* scan reverse complementary strand */
         for(i=0; i<seqLen[ii]-matLen+1; i++) {
            minusScore=0;
            for (m=0; m<matLen; m++) {
               switch(rSeq[ii][i+m]) {
                  case 'a': minusScore +=pwm[m][0]; break;
                  case 'c': minusScore +=pwm[m][1]; break;
                  case 'g': minusScore +=pwm[m][2]; break;
                  case 't': minusScore +=pwm[m][3]; break;
                  default:  plusScore=-1; break;
               }
            }
            minusScore=(minusScore-sumMin)/scale;
            if (minusScore>maxScore) maxScore=minusScore;
         }
         score[ii]=maxScore;
      }
      sort_double(score,numSeq);
   }
}
