
#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>
#include "ga_pwm.h"

void roulett_wheel(Fitness *fitness,int populationSize,Wheel *wheel,int generation) {

   register int i;
   double totalScore,worstScore,range,area;
   double *scaledScore;

   worstScore=fitness[populationSize-1].value;
   range=fitness[0].value-worstScore;

   if (range<0.00001 && generation!=1) {
      printf("GA converged ...\n");
      for (i=0; i<populationSize; i++) {
         wheel[i].index=i;
         wheel[i].start=i;
         wheel[i].end=i+1;
      }
   }
   else {
      scaledScore=alloc_double(populationSize);

      totalScore=0;
      for (i=0; i<populationSize; i++) {
         /* range scale */
         scaledScore[i]=(fitness[i].value-worstScore)/range;
         totalScore += scaledScore[i];
      }
      for (i=0; i<populationSize; i++) scaledScore[i] /= totalScore;

      area=(double)populationSize*scaledScore[0];
      wheel[0].start=0;
      wheel[0].end  =area;
      wheel[0].index=fitness[0].index;

      for (i=1; i<populationSize; i++) {
         wheel[i].start=wheel[i-1].end;
         area=(double)populationSize*scaledScore[i];
         wheel[i].end=area+wheel[i].start;
         wheel[i].index=fitness[i].index;
      }
      if (scaledScore) { free(scaledScore); scaledScore = NULL; }
   }
}

