#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>
#include <malloc.h>
#include "ga_pwm.h"

void mutation(double ***PWM,int matrixLen,Wheel *wheel,int populationSize,int best,
   double mutationRate,int numGen,Constraint *fix,int numConstraints) {

   register int ii,i,j,k;
   int numColMutation,wh2,found,whichRow,mutationLen;
   int *whichCol,*newPopu;
   double colSum,du;
   double ***tmpPWM;
   char *fixPos;

   fixPos=alloc_char(matrixLen+1);
   whichCol=alloc_int(matrixLen);
   newPopu=alloc_int(populationSize);
   tmpPWM=alloc_double_double_double(populationSize,matrixLen,4);

   newPopu[0]=best;

   /* form a new population of PWMs based on roulette wheel selection */
   for (ii=1; ii<populationSize; ii++) {
      du=(double)populationSize*genrand();
      found=0;
      for (j=0; j<populationSize; j++) {
         if (du>=wheel[j].start && du<=wheel[j].end) { newPopu[ii]=wheel[j].index; found=1; break; }
      }
      if (!found) {
         wh2=(int)(populationSize*genrand());
         if (wh2==populationSize) wh2--;
         newPopu[ii]=wh2;
      }
   }

   /* store new population in a temporary matrix */
   for (ii=0; ii<populationSize; ii++) {
      for (i=0; i<matrixLen; i++) {
         for (j=0; j<4; j++) tmpPWM[ii][i][j]=PWM[newPopu[ii]][i][j];
      }
   }

   /* find out which positions to be fixed */
   for (i=0; i<matrixLen; i++) fixPos[i]='0';
   for (k=0; k<numConstraints; k++) {
      if (numGen>=fix[k].startGen && numGen<=fix[k].endGen) {
         for (i=0; i<matrixLen; i++) {
            switch (fix[k].s1[i]) {
               case 'a': fixPos[i]='1'; break; 
               case 'c': fixPos[i]='1'; break; 
               case 'g': fixPos[i]='1'; break; 
               case 't': fixPos[i]='1'; break; 
               default:  break;
            } 
         }
         break; 
      }
   }
   /* number of eligible positions for mutation */
   mutationLen=0; for (i=0; i<matrixLen; i++) { if (fixPos[i]=='0') mutationLen++;  }

   for (ii=1; ii<populationSize; ii++) {
      /* determine the number of columns to be mutated */
      numColMutation=num_mutated(mutationLen);
      /* find out which of the columns */
      which_to_mutate(whichCol,numColMutation,matrixLen,fixPos);

      for (i=0; i<numColMutation; i++) {

         /* if no constraints, random select a base from [a,c,g,t] for mutation */
         whichRow=(int)(4.0*genrand()); if (whichRow==4) whichRow=3;
         for (k=0; k<numConstraints; k++) {
            if (numGen>=fix[k].startGen && numGen<=fix[k].endGen) {
               /* a or c */
               if      (fix[k].s1[whichCol[i]]=='m') {
                  if (genrand()>0.5) whichRow=0; else whichRow=1;
               }
               /* a or g */
               else if (fix[k].s1[whichCol[i]]=='r') {
                  if (genrand()>0.5) whichRow=0; else whichRow=2;
               }
               /* a or t */
               else if (fix[k].s1[whichCol[i]]=='w') { 
                  if (genrand()>0.5) whichRow=0; else whichRow=3;
               }
               /* c or g */
               else if (fix[k].s1[whichCol[i]]=='s') {
                  if (genrand()>0.5) whichRow=1; else whichRow=2;
               }
               /* c or t */
               else if (fix[k].s1[whichCol[i]]=='y') {
                  if (genrand()>0.5) whichRow=1; else whichRow=3;
               }
               /* g or t */
               else if (fix[k].s1[whichCol[i]]=='k') {
                  if (genrand()>0.5) whichRow=2; else whichRow=3;
               }
               /* a, c or g */
               else if (fix[k].s1[whichCol[i]]=='v') {
                  whichRow=(int)(3.0*genrand()); if (whichRow==3) whichRow=2;
               }
               /* a, c or t */
               else if (fix[k].s1[whichCol[i]]=='h') {
                  whichRow=(int)(3.0*genrand()); if (whichRow==3) whichRow=2; if (whichRow==2) whichRow=3;
               }
               /* a, g or t */
               else if (fix[k].s1[whichCol[i]]=='d') {
                  whichRow=(int)(3.0*genrand()); if (whichRow==3) whichRow=2; if (whichRow==1) whichRow=3;
               }
               /* c, g or t */
               else if (fix[k].s1[whichCol[i]]=='b') {
                  whichRow=(int)(3.0*genrand()); if (whichRow==3) whichRow=2; if (whichRow==0) whichRow=3;
               }
               /* a, c, g, or t */
               else  { }
               break;
            }
         }

         /* add or substract a small value, d=mutationRate */
         if (genrand()>0.5) tmpPWM[ii][whichCol[i]][whichRow] +=mutationRate;
         else                      tmpPWM[ii][whichCol[i]][whichRow] -=mutationRate;
         if (tmpPWM[ii][whichCol[i]][whichRow]<0) tmpPWM[ii][whichCol[i]][whichRow]=0;

         /* column-wide standardize */
         colSum=0; for (j=0; j<4; j++) colSum +=tmpPWM[ii][whichCol[i]][j];
         for (j=0; j<4; j++) tmpPWM[ii][whichCol[i]][j] /=colSum;
      }
   }

   /* after mutation, reassign the new population */
   for (ii=0; ii<populationSize; ii++) {
      for (i=0; i<matrixLen; i++) {
         for (j=0; j<4; j++) PWM[ii][i][j]=tmpPWM[ii][i][j];
      }
   }
   if (whichCol)     { free(whichCol);     whichCol=NULL;     }
   if (newPopu)      { free(newPopu);      newPopu=NULL;      }
   if (tmpPWM[0][0]) { free(tmpPWM[0][0]); tmpPWM[0][0]=NULL; }
   if (tmpPWM[0])    { free(tmpPWM[0]);    tmpPWM[0]=NULL;    }
   if (tmpPWM)       { free(tmpPWM);       tmpPWM=NULL;       }
   if (fixPos)       { free(fixPos);       fixPos=NULL;       }
}

int num_mutated(int maxNumMutate) {

   register int i;
   double rand;

   rand=genrand();
   for (i=maxNumMutate; i>1; i--) {
      if (rand>=(1.0/(pow(2.0,(double)i))) && rand<(1.0/(pow(2.0,(double)(i-1))))) return (i);
   }
   return (1);
}

void which_to_mutate(int *which,int numReplacement,int matrixLen,char *fixPos) {

   register int i;
   int num_filled,used,dummy;
   double du;

   num_filled=0; for (i=0; i<numReplacement; i++) *(which+i)=-1;

   while (num_filled<numReplacement) {
      du=(double)matrixLen*genrand();
      dummy=(int)du;
      if (dummy==matrixLen) dummy--;

      used=0;
      if (fixPos[dummy]=='1') used=1;
      else {
         used=0;
         for (i=0; i<num_filled; i++) {
            if (dummy==which[i]) { used=1; break; }
         }
         if (!used) {
            which[num_filled]=dummy;
            num_filled++;
         }
      }
   }
}

