#define MAX_NUM_SEQ         5001
#define MAX_SEQ_LENGTH      10001

#ifndef _CONFIG_H_
#include "config.h"
#endif

typedef struct fitness_score Fitness;
struct fitness_score {
   double value;
   int    index;
};
typedef struct roulette Wheel;
struct roulette {
   double start,end;
   int index;
};
typedef struct position_constraint Constraint;
struct position_constraint {
   int startGen,endGen;
   char *s1;
};


/* Random number generators for 32 and 64 bit integers */

#if SIZEOF_LONG == 8

void sgenrand_64bits(unsigned long long seed);
double genrand_64bits(void);

#define sgenrand(x) sgenrand_64bits(x)
#define genrand() genrand_64bits()

#else

void sgenrand_32bits(int seed);
double genrand_32bits(void);

#define sgenrand(x) sgenrand_32bits(x)
#define genrand() genrand_32bits()

#endif



int num_mutated(int );
int Compare_fitness(const void *, const void *);
int Compare_double(const void *, const void *);
int *alloc_int (int );
char *alloc_char(int );
char **alloc_char_char(int ,int );
char **read_seq(int *,int *,char **,int ,int ,char *);
double *alloc_double(int );
double **read_initial_pwm(int *,char *);
double **alloc_double_double(int ,int );
double ***alloc_double_double_double(int ,int ,int );
double cal_ROC(double *,int ,double *,int ,double );
void sum_position_min(double *,double **,int );
void sum_position_max(double *,double **,int );
void transform_pwm(double **,double **,int );
void conserved_position(double **,int ,char *);
void reverse_seq(char **,char **,int ,int *);
void which_to_mutate(int *,int ,int ,char *);
void sort_fitness(Fitness *,int );
void roulett_wheel(Fitness *,int ,Wheel *,int );
void sort_double(double *,int );
void shaker_sort_double(double *,int ,int );
void mutation(double ***,int ,Wheel *,int ,int ,double ,int ,Constraint *,int );
void score_seq(int ,char **,char **,int *,double **,int ,double ,double ,double *);
Constraint *read_constraints(char *,int ,int *,int ,int );
