#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <malloc.h>
#include "ga_pwm.h"

Constraint *read_constraints(char *fileName,int matrixLen,int *numConstraints,int motifLen,int numGeneration) {

   FILE *fp;
   register int i,j;
   int constraintsCn;
   Constraint *fix;

   fp=fopen(fileName,"r"); 
   if (!fp) { perror(fileName); exit(0); }

   fscanf(fp,"%d ",&constraintsCn);

   if (constraintsCn<1 || constraintsCn>numGeneration) {
      printf("\n\nError: the first line in %s must contain a number between 0-%d\n",fileName,numGeneration);
      printf("followed by the same number of lines.\n"); 
      printf("See gapwm_documentation for a detail.\n\n");
      exit(0);
   }
   fix=(Constraint *)calloc(constraintsCn,sizeof(Constraint));
   for (i=0; i<constraintsCn; i++)  fix[i].s1=alloc_char(matrixLen+1); 
 
   for (i=0; i<constraintsCn; i++) {
      fscanf(fp,"%d %d %s",&(fix[i].startGen),&(fix[i].endGen),fix[i].s1); 
      if (fix[i].startGen<1 || fix[i].startGen>numGeneration) {
         printf("Error in %s: start generation for constraint\n",fileName);
         printf("See gapwm_documentation for a detail.\n\n");
         exit(0);
      }
      if (fix[i].endGen<1 || fix[i].endGen>numGeneration) {
         printf("Error in %s: end generation for constraint\n",fileName);
         printf("See gapwm_documentation for a detail.\n\n");
         exit(0);
      }
      if (strlen(fix[i].s1)!=motifLen) {
         printf("Error in %s: string for constraint\n",fileName); exit(0); 
         printf("See gapwm_documentation for a detail.\n\n");
         exit(0);
      }

      for (j=0; j<matrixLen; j++) {
         switch (fix[i].s1[j]) {
            case 'A': fix[i].s1[j]='a'; break; 
            case 'C': fix[i].s1[j]='c'; break; 
            case 'G': fix[i].s1[j]='g'; break; 
            case 'T': fix[i].s1[j]='t'; break; 
            case 'W': fix[i].s1[j]='w'; break; 
            case 'R': fix[i].s1[j]='r'; break; 
            case 'K': fix[i].s1[j]='k'; break; 
            case 'S': fix[i].s1[j]='s'; break; 
            case 'Y': fix[i].s1[j]='y'; break; 
            case 'M': fix[i].s1[j]='m'; break; 
            case 'B': fix[i].s1[j]='b'; break; 
            case 'D': fix[i].s1[j]='d'; break; 
            case 'H': fix[i].s1[j]='h'; break; 
            case 'V': fix[i].s1[j]='v'; break; 
            case 'N': fix[i].s1[j]='n'; break; 
            default:  break;
         } 
      }
   }
   fclose(fp);

   printf("\n\nYou specified the following constraints:\n\n");
   for (i=0; i<constraintsCn; i++) {
      printf("   Generations %4d-%4d:\n",fix[i].startGen,fix[i].endGen);
      for (j=0; j<matrixLen; j++) {
         switch (fix[i].s1[j]) {
            case 'a': printf("      position[%2d]:  no mutation allowed\n",j+1); break; 
            case 'c': printf("      position[%2d]:  no mutation allowed\n",j+1); break; 
            case 'g': printf("      position[%2d]:  no mutation allowed\n",j+1); break; 
            case 't': printf("      position[%2d]:  no mutation allowed\n",j+1); break; 
            case 'w': printf("      position[%2d]:  mutation restricted to 'A' or 'T'\n",j+1); break; 
            case 'r': printf("      position[%2d]:  mutation restricted to 'A' or 'G'\n",j+1); break; 
            case 'k': printf("      position[%2d]:  mutation restricted to 'G' or 'T'\n",j+1); break; 
            case 's': printf("      position[%2d]:  mutation restricted to 'C' or 'G'\n",j+1); break; 
            case 'y': printf("      position[%2d]:  mutation restricted to 'C' or 'T'\n",j+1); break; 
            case 'm': printf("      position[%2d]:  mutation restricted to 'A' or 'C'\n",j+1); break; 
            case 'b': printf("      position[%2d]:  mutation restricted to 'C', 'G', or 'T'\n",j+1); break; 
            case 'd': printf("      position[%2d]:  mutation restricted to 'A', 'G', or 'T'\n",j+1); break; 
            case 'h': printf("      position[%2d]:  mutation restricted to 'A', 'C', or 'T'\n",j+1); break; 
            case 'v': printf("      position[%2d]:  mutation restricted to 'A', 'C', or 'G'\n",j+1); break; 
            case 'n': printf("      position[%2d]:  mutation without any constraints\n",j+1); break; 
            default: break;
         } 
      }
      printf("\n");
   }
   if (constraintsCn>0) printf("   No constraints after generations %4d.\n\n",fix[constraintsCn-1].endGen+1);

   *numConstraints=constraintsCn;
   return (fix);
}
