#include <stdio.h>
#include <stdlib.h>

double cal_ROC(double *scoreMotif,int numMotifSeq,double *scoreBackg,int numBackgSeq,double upBound) {

   register int ii,i;
   double fractMotif[1000],fractBackg[1000],height,width,area,increment,cutoff;
   int numM,numB,total;

   /* scoreBackg and scoreMotif are sorted in descending order */
   increment=(scoreBackg[0]-scoreBackg[numBackgSeq-1])/1000.0;
   total=1000;
   for (ii=0; ii<1000; ii++) {
      cutoff=scoreBackg[0]-ii*increment;
      numM=0;
      for (i=0; i<numMotifSeq; i++) {
         if (scoreMotif[i]>=cutoff) numM++;
         else break;
      }
      fractMotif[ii]=(double)numM/(double)numMotifSeq;

      numB=0;
      for (i=0; i<numBackgSeq; i++) {
         if (scoreBackg[i]>=cutoff) numB++;
         else break;
      }
      fractBackg[ii]=(double)numB/(double)numBackgSeq;
      if (fractBackg[ii]>upBound) { total=ii; break; }

   }
   /* for (ii=0; ii<199; ii++) printf("%5.4f %5.4f\n",fractMotif[ii],fractBackg[ii]); */

   area=0;
   for (ii=0; ii<total-1; ii++) {
      width=fractBackg[ii+1]-fractBackg[ii];
      if (width!=0) {
         height=(fractMotif[ii]+fractMotif[ii+1])/2;
         area += (width*height);
      }
   }
   return (area);
}

