#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <malloc.h>

char *alloc_char(int );
char **alloc_char_char(int, int);

char **read_seq(int *numSeq,int *seqLen,char **geneID,int maxNumSeq,int maxSeqLen,char *fileName) {

   FILE *fp;
   register int i,j;
   int len,num_seq,cn,maxBufferLen;
   char  **seq,*buffer;

   fp=fopen(fileName,"r");
   if (!fp) { perror(fileName); exit(0); }

   maxBufferLen=10000;
   seq=alloc_char_char(maxNumSeq,maxSeqLen+1);
   buffer=alloc_char(maxBufferLen);

   i=0;
   if (fgets(buffer,maxBufferLen,fp)) {
      while (!feof(fp)){
         len=strlen(buffer);
         buffer[len-1]='\0';
         if (buffer[0]=='>') {
            strcpy(geneID[i],buffer);
            cn=0;
            do {
               if (fgets(buffer,maxBufferLen,fp)) {
                  if (buffer[0]!='>') {
                     len=strlen(buffer);
                     for (j=0; j<len-1; j++) {
                        if (cn<maxSeqLen) { 
                           seq[i][cn]=buffer[j]; cn++; 
                        }
                     }
                  }
                  else break;
               }
               else break;
            } while (buffer[0]!='>');
            seq[i][cn]='\0'; seqLen[i]=cn;
            if (i==maxNumSeq) { printf("max number of seq reached!\n"); exit(0); }
            i++;
         }
      };
   }
   fclose(fp);
   if (buffer) { free(buffer); buffer=NULL; }

   num_seq=i;
   for (i=0; i<num_seq; i++) {
      for (j=0; j<seqLen[i]; j++) {
         switch(seq[i][j]) {
            case 'A': seq[i][j]='a'; break;
            case 'C': seq[i][j]='c'; break;
            case 'G': seq[i][j]='g'; break;
            case 'T': seq[i][j]='t'; break;
            case 'N': seq[i][j]='n'; break;
            case 'a': seq[i][j]='a'; break;
            case 'c': seq[i][j]='c'; break;
            case 'g': seq[i][j]='g'; break;
            case 't': seq[i][j]='t'; break;
            case 'n': seq[i][j]='n'; break;
            default:  seq[i][j]='n'; break;
         }
      }
   }
   *numSeq=num_seq;
   /*------------------------------------------------------------------------
   fp=fopen("debug.seq","w");
   for (i=0; i<num_seq; i++) {
      fprintf(fp,"%s\n",geneID[i]);
      fprintf(fp,"%s\n",seq[i]);
   }
   fclose(fp);
   for (i=0; i<num_seq; i++) printf("seq[%4d] length: %5d\n",i+1,seqLen[i]);
   ------------------------------------------------------------------------*/
   return (seq);
}

