#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <malloc.h>
#define MAX_MATRIX_LENGTH  100

char *alloc_char(int );
double **alloc_double_double(int ,int );

int main(int argc,char **argv) {

   int matrixLen,total,generation,start,end;
   char *buffer,*tok;
   double **matrix;
   register int i,j;
   FILE *fp,*fq;

   printf("\n---------This program averages PWMs----------\n\n");
   if (argc!=6) { 
      printf("\nUSAGE: avePWM outputFromGA matrixLen start end outputFile\n\n");
      printf("   outputFromGA:   The output file from GA that contains the best PWMs for all generations\n");
      printf("   matrixLen:      Length of pwm (motif)\n");
      printf("   start and end:  The range of generations for which PWMs are averged.\n\n");
      printf("   outputFile:     Name of output file name for the averaged pwm\n");
      exit(0); 
   }

   matrix=alloc_double_double(MAX_MATRIX_LENGTH,4);
   buffer=alloc_char(1000);

   fq=fopen(argv[5],"w");

   start=atoi(argv[3]);
   end=atoi(argv[4]);
   if (start<0 || end<0) {
      printf("Error: start should >=0 and end >0\n"); exit(0);  
   }

   matrixLen=atoi(argv[2]);
   fp=fopen(argv[1],"r");
   if (!fp) { perror(argv[1]); exit(0); }

   for (j=0; j<matrixLen; j++) {
      for (i=0; i<4; i++) matrix[j][i]=0; 
   }

   total=0;
   do {
      if (!feof(fp)) fgets(buffer,1000,fp);
      else {
         printf("Error: No data in %s???\n\n",argv[1]); exit(0); 
      }
   } while (strncmp(buffer,"generation:",11)!=0);
   tok=strtok(buffer," ");
   tok=strtok(0," ");
   generation=atoi(tok);
   printf("reading matrix from generation: %4d\n",generation);
   fgets(buffer,1000,fp);
   if (generation>=start && generation<=end) {
      for (i=0; i<4; i++) {
         fgets(buffer,1000,fp);
         tok=strtok(buffer,"\t");
         matrix[0][i] +=atof(tok);
         for (j=1; j<matrixLen; j++) {
            tok=strtok(0,"\t");
            matrix[j][i] +=atof(tok);
         }
      }
      total++;
   }
   else { 
      for (i=0; i<4; i++)  fgets(buffer,1000,fp);
   }
  
   while (!feof(fp)) {
      fgets(buffer,1000,fp);
      fgets(buffer,1000,fp);
      if (strncmp(buffer,"generation",10)==0) {
         tok=strtok(buffer," ");
         tok=strtok(0," ");
         generation=atoi(tok);
         printf("reading matrix from generation: %4d\n",generation);
         fgets(buffer,1000,fp);
         if (generation>=start && generation<=end) {
            for (i=0; i<4; i++) {
               fgets(buffer,1000,fp);
               tok=strtok(buffer,"\t");
               matrix[0][i] +=atof(tok);
               for (j=1; j<matrixLen; j++) {
                  tok=strtok(0,"\t");
                  matrix[j][i] +=atof(tok);
               }
            }
            total++;
         }
         else { 
            for (i=0; i<4; i++)  fgets(buffer,1000,fp);
         }
      }
      else break;
   }; 
   fclose(fp); 

   printf("\nThe number of PWMs in the specified range[%d-%d]: %4d\n",start,end,total);
   fprintf(fq,"4\t%d\n",matrixLen);
   for (i=0; i<4; i++) {
      for (j=0; j<matrixLen; j++) {
         if (j<matrixLen-1) fprintf(fq,"%6.5f\t",matrix[j][i]/(double)total);
         else fprintf(fq,"%6.5f\n",matrix[j][i]/(double)total);
      }
   }
   fprintf(fq,"averaged PWM from PWMs from generations %4d-%4d in %s\n",start,end,argv[1]);
   fclose(fq);
  
   if (buffer)       { free(buffer);       buffer=NULL;      }
   if (matrix[0])    { free(matrix[0]);    matrix[0]=NULL;   }
   if (matrix)       { free(matrix);       matrix=NULL;      }

   return (1);
}

double **alloc_double_double(int size1,int size2) {

   double **tmp=NULL;
   register int i;

   tmp=(double **)calloc(size1,sizeof(double *));
   if (!tmp)   { printf("tmp calloc failed!\n"); exit(1); }

   tmp[0]=(double *)calloc(size1*size2,sizeof(double));
   if (tmp[0]==0) { printf("bit calloc failed!\n"); exit(1); }

   /* set up vector pointers */
   for (i=1; i<size1; i++) {
      tmp[i]=tmp[0]+(size2 * i);
   }

   return (tmp);
}

char *alloc_char(int size1) {

   char *tmp=NULL;
   tmp=(char *)calloc(size1,sizeof(char));
   if (!tmp)   { printf("tmp calloc failed!\n"); exit(1); }
   return (tmp);
}
