#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <math.h>
#include <assert.h>
#include "background.h"
#include "defines.h"
int chin(const char *s, char c) {
    while (*s) if (*s++ == c) return 1;
    return 0;
}
int main(int argc, char **argv)
{
    int pwmLen;			// motif length (binding site length)
    time_t start;
    
    int MarkovOrder;		// order of Markov model

    if (argc < 4) {		
	printf
	    ("Usage (print out k-mer frequencies): ./kmerFreq inputSeqFile kmer ouputFile\n");
	printf
	    ("Usage (print out k-mer counts):      ./kmerFreq inputSeqFile kmer ouputFile c\n");
	exit(0);
    }
    int do_frequency = 1;
    if (argc == 5 && chin(argv[4],'c')) do_frequency = 0;
    start = time(NULL);
    fprintf(stderr, "Loading file `%s'...\n", argv[1]);
    FASTA_file *sq = open_fasta(argv[1]);
    fprintf(stderr, "Loaded %ld seqences in %ld seconds.\n",
	sq->sequence_count, time(NULL)-start);

    pwmLen = atoi(argv[2]);	// needed for computing scores blow
    MarkovOrder = pwmLen;//atoi(argv[3]);

    bg_model *bgmodel = alloc_bg_model(MarkovOrder);
    bgmodel->filename = argv[1];
    build_bg_model(bgmodel, sq, do_frequency);
	

    FILE *out = fopen(argv[3], "w");
    assert(NULL != out);
    int formatflag = 1;
    if (argc == 5 && chin(argv[4],'f')) formatflag = 0;

    print_bg_model(bgmodel, out, formatflag);	
    // replace 1 by zero for original output format

    fclose(out);

    return (1);
}
