#ifndef __DEFINES_H__
#define __DEFINES_H__

#define PSEUDO_COUNT            0.0001   // pseudo count // leping
#define PSEUDO_FREQ             0.000001 // pseudo count // leping

#define min(a,b)                (((a)<(b))?(a):(b))
#define max(a,b)                (((a)>(b))?(a):(b))
#define mod(a,b)		((a)-(b)*((a)/(b)))

// bcs 2009
// Note: don't increase this unless you have 128 bit computers now or
// something; 64 bit integer = 32 bases (ACGT). This is just a string buffer.
#define INT2NUC_BUFFER_LENGTH	33
// Set to 0 if you just don't want to know about rounding errors...
// but you probably shouldn't.
#define SHOW_FP_ERROR		1


#define FASTA_SQ_CN_GUESS 	16384 // Automatic resizing is not working yet	
#define FASTA_LEN_GUESS 	256
#define FASTA_NAME_MAXLEN 	128   // Increase this for bad FASTA files.
// FASTA files are reccomended to have at most 80 char lines so this should
// be plenty for reasonably conformant files.
#define FASTA_LINE_MAX		128

// When we write our own FASTA files, use this line width.
#define FASTA_LINE		50    // NO MORE THAN 80!!


typedef struct FASTAentry {
	char *name;
	char *sequence;
	size_t seq_len;
	/* as an alternative to storing this explicitly, we could do
	  something with known breakpoints, e.g. letting the max length be 
	  the smallest greater power of two, and doing null termination... */
	size_t max_seq_len;
} FASTA_entry;

typedef struct FASTA {
	size_t sequence_count;
	size_t max_sequence_count;
	FASTA_entry *seqs;

} FASTA_file;

FASTA_file *open_fasta(const char *filename);
int write_fasta(FASTA_file *f, const char *filename);
FASTA_file *alloc_fasta(void);
void fasta_add_data(FASTA_file *f, size_t i, char *data);
void fasta_set_name(FASTA_file *f, size_t i, char *name);
void fasta_finish(FASTA_file *f, size_t i);
size_t fasta_add_seq(FASTA_file *f);
#endif
