#include <stdio.h>
#include <stdlib.h>
#include <string.h>
// #include <malloc.h>
#define MAX_ORDER	8

typedef struct background_model BACKGROUND_Model;
struct background_model {
   int *monomerCn,*dimerCn,  *trimerCn, *tetramerCn,*pentamerCn,*hexamerCn,*heptamerCn,*octamerCn,*nonamerCn;
};

int *alloc_int(int );
char *alloc_char(int );
char **alloc_char_char(int ,int );
void read_userBackgModel(char *fileName,BACKGROUND_Model *back,char **,int );
void average(BACKGROUND_Model *back,int ,char **,char *);
double *alloc_double(int );
BACKGROUND_Model *alloc_background(int numChr);

int main(int argc,char **argv) {

   BACKGROUND_Model *back;
   int i,numChr;
   char **kmer;

   if (argc<2) {
      printf("Usage: ./aveCount counts_files output\n"); 
      printf("example: ./aveCount count1.txt count2.txt count3.txt count4.txt\n");
      exit(0); 
   }

   numChr=argc-2;
   back=alloc_background(numChr);
   kmer=alloc_char_char(349524,MAX_ORDER+2);

   for (i=0; i<argc-2; i++) {
      read_userBackgModel(argv[i+1],&(back[i]),kmer,i);
   }
   average(back,numChr,kmer,argv[argc-1]);

   return (1);
}

void average(BACKGROUND_Model *back,int numChr,char **kmer,char *fileName) {

   register int i,ii;
   double sum;
   double *monomerFreq,*dimerFreq,  *trimerFreq, *tetramerFreq,*pentamerFreq,*hexamerFreq,*heptamerFreq,*octamerFreq,*nonamerFreq;
   int *monomerCn,*dimerCn,  *trimerCn, *tetramerCn,*pentamerCn,*hexamerCn,*heptamerCn,*octamerCn,*nonamerCn;
   FILE *fp;

   monomerFreq=alloc_double(4);       // marginal
   dimerFreq=alloc_double(16);        // marginal
   trimerFreq=alloc_double(64);       // marginal
   tetramerFreq=alloc_double(256);    // marginal
   pentamerFreq=alloc_double(1024);   // marginal
   hexamerFreq=alloc_double(4096);    // marginal
   heptamerFreq=alloc_double(16384);  // marginal
   octamerFreq=alloc_double(65536);   // marginal
   nonamerFreq=alloc_double(262144);  // marginal
   monomerCn=alloc_int(4);       // marginal
   dimerCn=alloc_int(16);        // marginal
   trimerCn=alloc_int(64);       // marginal
   tetramerCn=alloc_int(256);    // marginal
   pentamerCn=alloc_int(1024);   // marginal
   hexamerCn=alloc_int(4096);    // marginal
   heptamerCn=alloc_int(16384);  // marginal
   octamerCn=alloc_int(65536);   // marginal
   nonamerCn=alloc_int(262144);  // marginal

   for (i=0; i<4; i++)      {
      monomerCn[i]=0; for (ii=0; ii<numChr; ii++) monomerCn[i] +=back[ii].monomerCn[i];
   }
   sum=0; for (i=0; i<4; i++) sum +=monomerCn[i];     
   for (i=0; i<4; i++) monomerFreq[i]=(double)monomerCn[i]/(double)sum;    

   for (i=0; i<16; i++)      {
      dimerCn[i]=0; for (ii=0; ii<numChr; ii++) dimerCn[i] +=back[ii].dimerCn[i];
   }
   sum=0; for (i=0; i<16; i++) sum +=dimerCn[i];     
   for (i=0; i<16; i++) dimerFreq[i]=(double)dimerCn[i]/(double)sum;    

   for (i=0; i<64; i++)      {
      trimerCn[i]=0; for (ii=0; ii<numChr; ii++) trimerCn[i] +=back[ii].trimerCn[i];
   }
   sum=0; for (i=0; i<64; i++) sum +=trimerCn[i];     
   for (i=0; i<64; i++) trimerFreq[i]=(double)trimerCn[i]/(double)sum;    

   for (i=0; i<256; i++)      {
      tetramerCn[i]=0; for (ii=0; ii<numChr; ii++) tetramerCn[i] +=back[ii].tetramerCn[i];
   }
   sum=0; for (i=0; i<256; i++) sum +=tetramerCn[i];     
   for (i=0; i<256; i++) tetramerFreq[i]=(double)tetramerCn[i]/(double)sum;    

   for (i=0; i<1024; i++)      {
      pentamerCn[i]=0; for (ii=0; ii<numChr; ii++) pentamerCn[i] +=back[ii].pentamerCn[i];
   }
   sum=0; for (i=0; i<1024; i++) sum +=pentamerCn[i];     
   for (i=0; i<1024; i++) pentamerFreq[i]=(double)pentamerCn[i]/(double)sum;    

   for (i=0; i<4096; i++)      {
      hexamerCn[i]=0; for (ii=0; ii<numChr; ii++) hexamerCn[i] +=back[ii].hexamerCn[i];
   }
   sum=0; for (i=0; i<4096; i++) sum +=hexamerCn[i];     
   for (i=0; i<4096; i++) hexamerFreq[i]=(double)hexamerCn[i]/(double)sum;    

   for (i=0; i<16384; i++)      {
      heptamerCn[i]=0; for (ii=0; ii<numChr; ii++) heptamerCn[i] +=back[ii].heptamerCn[i];
   }
   sum=0; for (i=0; i<16384; i++) sum +=heptamerCn[i];     
   for (i=0; i<16384; i++) heptamerFreq[i]=(double)heptamerCn[i]/(double)sum;    

   for (i=0; i<65536; i++)      {
      octamerCn[i]=0; for (ii=0; ii<numChr; ii++) octamerCn[i] +=back[ii].octamerCn[i];
   }
   sum=0; for (i=0; i<65536; i++) sum +=octamerCn[i];     
   for (i=0; i<65536; i++) octamerFreq[i]=(double)octamerCn[i]/(double)sum;    

   for (i=0; i<262144; i++)      {
      nonamerCn[i]=0; for (ii=0; ii<numChr; ii++) nonamerCn[i] +=back[ii].nonamerCn[i];
   }
   sum=0; for (i=0; i<262144; i++) sum +=nonamerCn[i];     
   for (i=0; i<262144; i++) nonamerFreq[i]=(double)nonamerCn[i]/(double)sum;    

   fp=fopen(fileName,"w");

   fprintf(fp,"#monomer frequency\n");
   for (i=0; i<4; i++)      fprintf(fp,"%s\t%15.14f\n",kmer[i],monomerFreq[i]);
   fprintf(fp,"#dimer frequency\n");
   for (i=0; i<16; i++)     fprintf(fp,"%s\t%15.14f\n",kmer[i+4],dimerFreq[i]);
   fprintf(fp,"#trimer frequency\n");
   for (i=0; i<64; i++)     fprintf(fp,"%s\t%15.14f\n",kmer[i+20],trimerFreq[i]);
   fprintf(fp,"#tetramer frequency\n");
   for (i=0; i<256; i++)    fprintf(fp,"%s\t%15.14f\n",kmer[i+84],tetramerFreq[i]);
   fprintf(fp,"#pentamer frequency\n");
   for (i=0; i<1024; i++)   fprintf(fp,"%s\t%15.14f\n",kmer[i+340],pentamerFreq[i]);
   fprintf(fp,"#hexamer frequency\n");
   for (i=0; i<4096; i++)   fprintf(fp,"%s\t%15.14f\n",kmer[i+1364],hexamerFreq[i]);
   fprintf(fp,"#heptamer frequency\n");
   for (i=0; i<16384; i++)  fprintf(fp,"%s\t%15.14f\n",kmer[i+5460],heptamerFreq[i]);
   fprintf(fp,"#octamer frequency\n");
   for (i=0; i<65536; i++)  fprintf(fp,"%s\t%15.14f\n",kmer[i+21844],octamerFreq[i]);
   fprintf(fp,"#nonamer frequency\n");
   for (i=0; i<262144; i++) fprintf(fp,"%s\t%15.14f\n",kmer[i+87380],nonamerFreq[i]);
   fclose(fp);

}

void read_userBackgModel(char *fileName,BACKGROUND_Model *back,char **kmer,int id) {

   FILE *fp;
   char *buffer,*tok;
   int *cn,maxOligomer;
   int kmerCn,len,len2,tabFound,maxAllowedOligomer,count;
   register int i;

   fp=fopen(fileName,"r");
   if (!fp) { perror(fileName); exit(0); }

   maxAllowedOligomer=MAX_ORDER+1;
   buffer=alloc_char(256);
   cn=alloc_int(maxAllowedOligomer);
   for (i=0; i<maxAllowedOligomer; i++) { cn[i]=0; }

   maxOligomer=1; kmerCn=0;
   while (!feof(fp)) {
      if ((fgets(buffer,256,fp))>0)  {
         if (buffer[0]!='#') {
            len=strlen(buffer);
            buffer[len-1]='\0';
            tabFound=0;
            for (i=0; i<len; i++) { 
               if (buffer[i]=='\t') { tabFound=1; break; } 
            }
            if (tabFound) {
               tok=strtok(buffer,"\t");
               len2=strlen(tok);
               if (id==0) {
                  strcpy(kmer[kmerCn],tok); 
                  kmer[kmerCn][len2]='\0'; 
                  kmerCn++; 
               }

               if (len2>maxAllowedOligomer) continue;

               if (len2>maxOligomer) maxOligomer=len2;
               tok=strtok(0,"\t");
               count=atoi(tok);
               switch (len2) {
                  case 1:  { back->monomerCn[cn[0]] =count; cn[0]++; break; }
                  case 2:  { back->dimerCn[cn[1]]   =count; cn[1]++; break; }
                  case 3:  { back->trimerCn[cn[2]]  =count; cn[2]++; break; }
                  case 4:  { back->tetramerCn[cn[3]]=count; cn[3]++; break; }
                  case 5:  { back->pentamerCn[cn[4]]=count; cn[4]++; break; }
                  case 6:  { back->hexamerCn[cn[5]] =count; cn[5]++; break; }
                  case 7:  { back->heptamerCn[cn[6]]=count; cn[6]++; break; }
                  case 8:  { back->octamerCn[cn[7]] =count; cn[7]++; break; }
                  case 9:  { back->nonamerCn[cn[8]] =count; cn[8]++; break; }
                  default: break; 
               } 
            }
            else {
               tok=strtok(buffer," ");
               len2=strlen(tok);
               if (len2>10) { printf("Error: up to 9th order is allowed!\n"); exit(0); }
               if (id==0) {
                  strcpy(kmer[kmerCn],tok); 
                  kmer[kmerCn][len2]='\0'; 
                  kmerCn++; 
               }
               tok=strtok(0," ");
               count=atoi(tok);
               switch (len2) {
                  case 1:  { back->monomerCn[cn[0]] =count; cn[0]++; break; }
                  case 2:  { back->dimerCn[cn[1]]   =count; cn[1]++; break; }
                  case 3:  { back->trimerCn[cn[2]]  =count; cn[2]++; break; }
                  case 4:  { back->tetramerCn[cn[3]]=count; cn[3]++; break; }
                  case 5:  { back->pentamerCn[cn[4]]=count; cn[4]++; break; }
                  case 6:  { back->hexamerCn[cn[5]] =count; cn[5]++; break; }
                  case 7:  { back->heptamerCn[cn[6]]=count; cn[6]++; break; }
                  case 8:  { back->octamerCn[cn[7]] =count; cn[7]++; break; }
                  case 9:  { back->nonamerCn[cn[8]] =count; cn[8]++; break; }
                  default: break; 
               } 
            } 
         } 
      }
   }
   fclose(fp);

   if (buffer) { free(buffer); buffer=NULL; }
   if (cn)     { free(cn);     cn=NULL;     }
}


BACKGROUND_Model *alloc_background(int numChr) {

   BACKGROUND_Model *back;
   int i;

   back=NULL;

   back=(BACKGROUND_Model *)calloc(numChr,sizeof(BACKGROUND_Model));

   for (i=0; i<numChr; i++) {
      back[i].monomerCn=alloc_int(4);       // marginal
      back[i].dimerCn=alloc_int(16);        // marginal
      back[i].trimerCn=alloc_int(64);       // marginal
      back[i].tetramerCn=alloc_int(256);    // marginal
      back[i].pentamerCn=alloc_int(1024);   // marginal
      back[i].hexamerCn=alloc_int(4096);    // marginal
      back[i].heptamerCn=alloc_int(16384);  // marginal
      back[i].octamerCn=alloc_int(65536);   // marginal
      back[i].nonamerCn=alloc_int(262144);  // marginal
   }
   return (back);
}

char *alloc_char(int size1) {

   char *tmp=NULL;
   tmp=(char *)calloc(size1,sizeof(char));
   if (!tmp)   { printf("tmp calloc failed!\n"); exit(1); }
   return (tmp);
}

int *alloc_int(int size1) {

   int *tmp=NULL;
   tmp=(int *)calloc(size1,sizeof(int));
   if (!tmp)   { printf("tmp calloc failed!\n"); exit(1); }
   return (tmp);
}

double *alloc_double(int size1) {

   double *tmp=NULL;
   tmp=(double *)calloc(size1,sizeof(double));
   if (!tmp)   { printf("tmp calloc failed!\n"); exit(1); }
   return (tmp);
}

char **alloc_char_char(int size1,int size2) {

   char **tmp=NULL;
   register int i;

   tmp=(char **)calloc(size1,sizeof(char *));
   if (!tmp)   { printf("tmp calloc failed!\n"); exit(1); }

   tmp[0]=(char *)calloc(size1*size2,sizeof(char)); 
   if (tmp[0]==0) { printf("bit calloc failed!\n"); exit(1); }

   /* set up vector pointers */
   for (i=1; i<size1; i++)  tmp[i]=tmp[0]+(size2 * i);

   return (tmp);
}


