
#include <stdlib.h>
#include "fdr_pwm.h"


// sort the double vector in the descending order
void sort_double(double *data,int size) {

   int (*compar)(const void *,const void *);
   compar=Compare_double;
   qsort((void *)data,(size_t)size,sizeof(double),compar);
}
                                                                                                                                      
int Compare_double(const void *s1,const void *s2) {

   if (*((double *)s1)< (*(double *)s2)) { return 1; }
   if (*((double *)s1)> (*(double *)s2)) { return -1; }
      return 0;
}

void sort_segments(Segment *s2,int size) {

   int (*compar)(const void *,const void *);
   compar=Compare_segments;
   qsort((void *)s2,(size_t)size,sizeof(Segment),compar);
}

int Compare_segments(const void *s1,const void *s2) {

   if (((Segment *)s1)->value < ((Segment *)s2)->value) { return  1; }
   if (((Segment *)s1)->value > ((Segment *)s2)->value) { return -1; }
      return 0;
}

void sort_subseq(Subseq *subseq,int size){

    int (*compar)(const void *,const void *);
    compar=Compare_subseq;
    qsort((void *)subseq,(size_t)size,sizeof(Subseq),compar);
}

int Compare_subseq(const void *s1,const void *s2) {

   if (((Subseq *)s1)->value < ((Subseq *)s2)->value) { return  1; }
   if (((Subseq *)s1)->value > ((Subseq *)s2)->value) { return -1; }
      return 0;
}

void sort_motif(Motifs *motif,int size){
int Compare_motif(const void *s1,const void *s2);

    int (*compar)(const void *,const void *);
    compar=Compare_motif;
    qsort((void *)motif,(size_t)size,sizeof(Motifs),compar);
}

int Compare_motif(const void *s1,const void *s2) {

   if (((Motifs *)s1)->evalue < ((Motifs *)s2)->evalue) { return  1; }
   if (((Motifs *)s1)->evalue > ((Motifs *)s2)->evalue) { return -1; }
   return 0;
}

void shaker_sort_decending(Segment *x,int total,int numTop) {

   register int a,b,c,d;
   double value;
   int index,strand;

   c=1;
   b=total-1; d=total-1;

   do {
      for (a=d; a >=c; --a) {
         if (x[a-1].value>x[a].value) {
            value=x[a-1].value;
            x[a-1].value=x[a].value;
            x[a].value=value;
            index=x[a-1].index;
            x[a-1].index=x[a].index;
            x[a].index=index;
            strand=x[a-1].strand;
            x[a-1].strand=x[a].strand;
            x[a].strand=strand;
            b=a;
         }
      }

      c=b+1;
      for (a=c; a<d+1; ++a) {
         if (x[a-1].value>x[a].value) {
            value=x[a-1].value;
            x[a-1].value=x[a].value;
            x[a].value=value;
            index=x[a-1].index;
            x[a-1].index=x[a].index;
            x[a].index=index;
            strand=x[a-1].strand;
            x[a-1].strand=x[a].strand;
            x[a].strand=strand;
            b=a;
         }
      }
      d=b-1;
      if (c>d) break;
   } while (c<=numTop);
}

