#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "fdr_pwm.h"
#include "fdr_defines.h"

// align the binding sites and compute base frequency
void binding_site_base_freq(Subseq *topSubSeq,char **seq,char **rseq, int *seqLen, int motifLen,int numSite1, double **opwm){

   register int ii,jj,n,k;
  
   for(ii=0; ii<motifLen; ii++){
      for(jj=0; jj<4; jj++) opwm[ii][jj]=0.0;
   }
   if(numSite1==0) {printf("Number of binding sites==0\n"); exit(0);}
   else{
      for (ii=0; ii<numSite1; ii++) {
         if (topSubSeq[ii].strand==1) {
            for (n=topSubSeq[ii].posID, k=0; n<topSubSeq[ii].posID+motifLen; n++,k++)  {
               switch(seq[topSubSeq[ii].seqID][n]) {
                  case 'a': opwm[k][0]++; break;
                  case 'c': opwm[k][1]++; break;
                  case 'g': opwm[k][2]++; break;
                  case 't': opwm[k][3]++; break;
                  default: break;
               }
            }
         }
         else {
            for (n=seqLen[topSubSeq[ii].seqID]-motifLen-topSubSeq[ii].posID, k=0; n<seqLen[topSubSeq[ii].seqID]-topSubSeq[ii].posID; n++,k++)  {
               switch(rseq[topSubSeq[ii].seqID][n]) {
                  case 'a': opwm[k][0]++; break;
                  case 'c': opwm[k][1]++; break;
                  case 'g': opwm[k][2]++; break;
                  case 't': opwm[k][3]++; break;
                  default: break;
               }
            }
         }
      }
      for(ii=0; ii<motifLen;ii++){
          for(jj=0; jj<4; jj++) opwm[ii][jj]/=numSite1;
      }
   }
}
     

