#include <stdlib.h>
#include <string.h>
#include "fdr_defines.h"

/* calculate score for each subsequence with length of w */
void score_subsequences(int numSeq,char **seq,char **rseq,int *seqLen,double **pwm,
   int motifLen,double **score,double **rscore,double *bfreq) {

   register int ii,i,m;
   double plusScore,minusScore;
   double *colAve;
   int temp;

   colAve=alloc_double(motifLen);
   for (m=0; m<motifLen; m++) {
      colAve[m]=0; for (i=0; i<4; i++) { colAve[m] +=(pwm[m][i]*bfreq[i]); }
   }

   for (ii=0;  ii<numSeq; ii++) {
      for(i=0;  i<seqLen[ii]-motifLen+1; i++) {
         plusScore=0;
         for (m=0; m<motifLen;m++) {
            switch(seq[ii][i+m]) {
               case 'a': plusScore +=pwm[m][0]; break;
               case 'c': plusScore +=pwm[m][1]; break;
               case 'g': plusScore +=pwm[m][2]; break;
               case 't': plusScore +=pwm[m][3]; break;
               case 'n': plusScore +=colAve[m]; break;
               default: break;
            }
         }
         score[ii][i]=plusScore;
      }

      for(i=0;  i<seqLen[ii]-motifLen+1; i++){
         temp=seqLen[ii]-i-motifLen;
         minusScore=0;
         for (m=0; m<motifLen;m++) {
            switch(rseq[ii][i+m]) {
               case 'a': minusScore +=pwm[m][0]; break;
               case 'c': minusScore +=pwm[m][1]; break;
               case 'g': minusScore +=pwm[m][2]; break;
               case 't': minusScore +=pwm[m][3]; break;
               case 'n': minusScore +=colAve[m]; break;
               default: break;
            }
         }
         rscore[ii][temp]=minusScore;
      }
   }
   if (colAve) { free(colAve); colAve=NULL; }
}

