#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <malloc.h>
#include "fdr_defines.h"
#include "alloc.h"

/* read background sequences file */
char **read_seq0(int *numSeq,int *seqLen,int maxNumSeq,int maxSeqLen,char *fileName) {
 
   FILE *fp;
   register int i,j;
   int len,num_seq,cn,header_found;
   char  **seq,*buffer;

   fp=fopen(fileName,"r");
   if (!fp) { perror(fileName); exit(0); }

   seq=alloc_char_char(maxNumSeq,maxSeqLen+1);
   buffer=alloc_char(maxSeqLen);

   i=0;  cn=0;
   while (!feof(fp)) {
      if (fgets(buffer,maxSeqLen,fp)) {
         len=strlen(buffer);
         /* excluding the newline char */
         buffer[len-1]='\0';
         header_found=0;
         for (j=0; j<len-1; j++) {
            if (buffer[j]=='>') { header_found=1; break; } 
         }
         if (header_found) {
            if (cn!=0) { 
               seqLen[i]=cn; seq[i][cn]='\0'; i++; cn=0; 
               if (i==maxNumSeq) { 
                  printf("Maximal number of backg sequences reached. Reset <MAX_NUM_SEQ> in fdr_defines.h and rebulid\n"); exit(0); 
               } 
            }
         }
         else {
            len=strlen(buffer);
            for (j=0; j<len; j++) {
               if (buffer[j]=='\0') break;
               switch (buffer[j]) {
                  case 'A': buffer[j]='a'; break; 
                  case 'C': buffer[j]='c'; break; 
                  case 'G': buffer[j]='g'; break; 
                  case 'T': buffer[j]='t'; break;
                  case 'N': buffer[j]='n'; break; 
                  default: break;
               }
               if (buffer[j]=='a' || buffer[j]=='c' || buffer[j]=='g' || 
                   buffer[j]=='t' || buffer[j]=='n') {
                  seq[i][cn]=buffer[j]; 
                  if (cn<maxSeqLen) cn++; 
               }
            }
         }
      }
   };
   fclose(fp);
   seqLen[i]=cn; seq[i][cn]='\0'; i++;
   if (buffer) { free(buffer); buffer=NULL; } 

   num_seq=i; *numSeq=num_seq;
   return (seq);
}

char **read_seq(int *numSeq,int *seqLen,char **geneID,int maxNumSeq,int maxSeqLen,char *fileName) {

   FILE *fp;
   register int i,j,k;
   int len,num_seq,cn,maxBufferLen,pos,dotCn,numCn,yesSpace;
   char  **seq,*buffer,*tok,*sscore;

   fp=fopen(fileName,"r");
   if (!fp) { perror(fileName); exit(0); }

   maxBufferLen=MAX_BUFFER_LENGTH;
   seq=alloc_char_char(maxNumSeq,maxSeqLen+1);
   buffer=alloc_char(maxBufferLen);
   sscore=alloc_char(100);

   i=0;
   if (fgets(buffer,maxBufferLen,fp)>0) {
      while (!feof(fp)){
         len=strlen(buffer);
         buffer[len]='\0';
         if (buffer[0]=='>') {
            yesSpace=0;
            for (j=1; j<len; j++) {
               if (buffer[j]==' ') { yesSpace=1; break; } 
            }
            if (yesSpace) tok=strtok(buffer," ");
            else          tok=strtok(buffer,"\n");
            strcpy(geneID[i],tok);
            len=strlen(tok);
            geneID[i][len]='\0';
  
            cn=0;
            do {
               if (fgets(buffer,maxBufferLen,fp)) {
                  len=strlen(buffer);
                  buffer[len-1]='\0';
                  if (buffer[0]!='>') {
                     for (j=0; j<len-1; j++) {
                        if (cn<maxSeqLen) { 
                           seq[i][cn]=buffer[j]; cn++; 
                        }
                     }
                  }
                  else break;
               }
               else break;
            } while (buffer[0]!='>');
            seq[i][cn]='\0'; seqLen[i]=cn;
            if (cn>1) {
               i++; 
               if (i>=maxNumSeq) { 
                  printf("\n\nErro: maximal number of seqences reached!\n"); 
                  printf("Please reset MAX_NUM_SEQ in ga_dyads.h and rebuild (see installation)\n\n");
                  exit(0); 
               }
            }
         }
      };
   }
   fclose(fp);
   if (buffer) { free(buffer); buffer=NULL; }

   num_seq=i;
   for (i=0; i<num_seq; i++) {
      for (j=0; j<seqLen[i]; j++) {
         switch(seq[i][j]) {
            case 'A': seq[i][j]='a'; break;
            case 'C': seq[i][j]='c'; break;
            case 'G': seq[i][j]='g'; break;
            case 'T': seq[i][j]='t'; break;
            case 'N': seq[i][j]='n'; break;
            case 'a': seq[i][j]='a'; break;
            case 'c': seq[i][j]='c'; break;
            case 'g': seq[i][j]='g'; break;
            case 't': seq[i][j]='t'; break;
            case 'n': seq[i][j]='n'; break;
            default:  seq[i][j]='n'; break;
         }
      }
   }
   *numSeq=num_seq;
   //for (i=0; i<2; i++) printf("seq[%4d] length: %5d\n",i+1,seqLen[i]);
   /*------------------------------------------------------------------------
   fp=fopen("debug.seq","w");
   for (i=0; i<num_seq; i++) {
      fprintf(fp,"%s\n",geneID[i]);
      fprintf(fp,"%s\n",seq[i]);
   }
   fclose(fp);
   for (i=0; i<num_seq; i++) printf("seq[%4d] length: %5d\n",i+1,seqLen[i]);
   ------------------------------------------------------------------------*/
   if (sscore) { free(sscore); sscore=NULL; }

   return (seq);
}

