#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <malloc.h>
#include "fdr_defines.h"
#include "alloc.h"

double ***read_initial_pwm(int *pwmLen,char **pwmName,int *numPWM,int argc,char **argv) {

   register int i,j,k,m,n;
   int numCol,numRow,pwmCn,cn1,len;
   double ***pwm;
   double colSum;
   FILE *fp;

   pwm=alloc_double_double_double(argc-1,MAX_MATRIX_LENGTH,4);

   pwmCn=0;
   for (i=1; i<argc; i++) {
      len=strlen(argv[i]);
      // printf("%s\n",argv[i]);
      if (len>3 && argv[i][len-3]=='.' && argv[i][len-2]=='m' && argv[i][len-1]=='x') {
         cn1=0;
         for (j=0; j < (int)strlen(argv[i]); j++) {
            if (argv[i][j]=='/') cn1=j;
         }
         if (cn1==0) {
            for (j=0; j < (int)strlen(argv[i]); j++) pwmName[pwmCn][j]=argv[i][j]; pwmName[pwmCn][j]='\0';
         }
         else {
            for (j=cn1+1,k=0; j < (int)strlen(argv[i]); j++,k++) pwmName[pwmCn][k]=argv[i][j]; pwmName[pwmCn][k]='\0';
         }
         // printf("%s\n",pwmName[pwmCn]);
         fp=fopen(argv[i],"r");
         if (!fp) { perror(argv[i]); exit(0); }

         fscanf(fp,"%d %d",&numRow,&numCol);
         if (numRow !=4) { printf("\n\nError: please check documentation for input format.\n"); exit(0); }
         if (numCol<2) {
             printf("\nMatrix length too short - ignored\n");
             continue;
         }
         if (numCol>MAX_MATRIX_LENGTH) {
             printf("\nMax matrix length exceeded - ignored\n");
             continue;
         }
         for (m=0; m<4; m++) {
            for (n=0; n<numCol; n++) {
               fscanf(fp,"%lf",&pwm[pwmCn][n][m]);
               if (pwm[pwmCn][n][m]<0) { 
                  printf("\n\nError: elements in PWM must be positive. Please see examples on gapwm website\n"); 
                  exit(0); 
               } 
            }
         }
         fclose(fp);
        
         for (n=0; n<numCol; n++) {
            colSum=0; for (m=0; m<4; m++) colSum +=pwm[pwmCn][n][m]; 
            for (m=0; m<4; m++) pwm[pwmCn][n][m]/=colSum; 
         }
 
         printf("\nInitial PWM:\n");
         for (m=0; m<4; m++) {
            for (n=0; n<numCol; n++) {
              if (n<numCol-1) printf("%5.1f ",pwm[pwmCn][n][m]);
              else            printf("%5.1f\n",pwm[pwmCn][n][m]); 
            }
         }
         pwmLen[pwmCn]=numCol; pwmCn++;
      }
   }
   printf("\nTotal number of starting PWMs: %5d\n",pwmCn);
   *numPWM=pwmCn;
   return (pwm); 
}
