#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "fdr_pwm.h"
#include "fdr_defines.h"

void binding_site_location(Subseq *topSubSeq,char **seq,char **rseq, char **geneID, 
   int *seqLen,int motifLen,int numSite1,FILE *fp){

   register int ii,jj,n;

   for (ii=0; ii<numSite1; ii++) {
      fprintf(fp,"%s\n",geneID[topSubSeq[ii].seqID]);
      if (topSubSeq[ii].strand==1) {
         if (topSubSeq[ii].posID-10<0) { 
            for(jj=topSubSeq[ii].posID-10;jj<0;jj++) fprintf(fp," ");
         }
         for (n=max(0,topSubSeq[ii].posID-10); n<topSubSeq[ii].posID; n++) 
            fprintf(fp,"%c",seq[topSubSeq[ii].seqID][n]);
         for (n=topSubSeq[ii].posID; n<topSubSeq[ii].posID+motifLen; n++)  {
            switch(seq[topSubSeq[ii].seqID][n]) {
               case 'a': fprintf(fp,"A"); break;
               case 'c': fprintf(fp,"C"); break;
               case 'g': fprintf(fp,"G"); break;
               case 't': fprintf(fp,"T"); break;
               default: break;
            }
         }
         for (n=topSubSeq[ii].posID+motifLen; n<min(topSubSeq[ii].posID+motifLen+10,seqLen[topSubSeq[ii].seqID]); n++) 
            fprintf(fp,"%c",seq[topSubSeq[ii].seqID][n]);
         if(topSubSeq[ii].posID+motifLen+10>seqLen[topSubSeq[ii].seqID])
            for(jj=0;jj<topSubSeq[ii].posID+motifLen+10-seqLen[topSubSeq[ii].seqID];jj++) fprintf(fp," ");
         fprintf(fp,"\t%4d\t(+)\n\n",topSubSeq[ii].posID);
      }
      else {
         if (seqLen[topSubSeq[ii].seqID]-motifLen-topSubSeq[ii].posID-10<0) {
            for(jj=seqLen[topSubSeq[ii].seqID]-motifLen-topSubSeq[ii].posID-10;jj<0;jj++) fprintf(fp," ");
         }
         for (n=max(0,seqLen[topSubSeq[ii].seqID]-motifLen-topSubSeq[ii].posID-10); n<seqLen[topSubSeq[ii].seqID]-motifLen-topSubSeq[ii].posID; n++) 
            fprintf(fp,"%c",rseq[topSubSeq[ii].seqID][n]);
         for (n=seqLen[topSubSeq[ii].seqID]-motifLen-topSubSeq[ii].posID; n<seqLen[topSubSeq[ii].seqID]-topSubSeq[ii].posID; n++)  {
            switch(rseq[topSubSeq[ii].seqID][n]) {
               case 'a': fprintf(fp,"A"); break;
               case 'c': fprintf(fp,"C"); break;
               case 'g': fprintf(fp,"G"); break;
               case 't': fprintf(fp,"T"); break;
               default: break;
            }
         }
         for (n=seqLen[topSubSeq[ii].seqID]-topSubSeq[ii].posID; n<min(seqLen[topSubSeq[ii].seqID]-topSubSeq[ii].posID+10,seqLen[topSubSeq[ii].seqID]); n++) 
            fprintf(fp,"%c",rseq[topSubSeq[ii].seqID][n]);
         if(seqLen[topSubSeq[ii].seqID]-topSubSeq[ii].posID+10>seqLen[topSubSeq[ii].seqID])
            for(jj=0;jj<seqLen[topSubSeq[ii].seqID]-topSubSeq[ii].posID+10-seqLen[topSubSeq[ii].seqID];jj++) fprintf(fp," ");
         fprintf(fp,"\t%4d\t(-)\n\n",topSubSeq[ii].posID);
      }
   }
}
     

