#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "fdr_pwm.h"
#include "fdr_defines.h"

int *alloc_int(int );

void binding_site_location(Subseq *site,char **seq,char **rseq, char **geneID,
   int *seqLen,int numSeq,int pwmLen,int nsites,FILE *fq){


   register int i,j;
   int cn[4],maxHeaderLen;
   int *seqCn;

   seqCn=alloc_int(numSeq);

   maxHeaderLen=strlen(geneID[0]);
   for (i=1; i<numSeq; i++) {
      if (strlen(geneID[i])>maxHeaderLen) maxHeaderLen=strlen(geneID[i]); 
   }
   maxHeaderLen=min(maxHeaderLen,MAX_SEQ_HEADER);

   for (i=0; i<numSeq; i++) seqCn[i]=0;
   for (i=0; i<nsites; i++) seqCn[site[i].seqID]++; 
  
   for (i=0; i<4; i++) cn[i]=0; 
   for (i=0; i<numSeq; i++) {
      if (seqCn[i]==0) cn[0]++; 
      if (seqCn[i]==1) cn[1]++; 
      if (seqCn[i]==2) cn[2]++; 
      if (seqCn[i]>2)  cn[3]++; 
   }
   if (seqCn) { free(seqCn); seqCn=NULL; }

   fprintf(fq,"   #seq_0_site  #seq_1_site  #seq_2_site  #seq_>2_site\n");
   fprintf(fq,"   %9d%10d%10d%10d\n",cn[0],cn[1],cn[2],cn[3]);
   fprintf(fq,"\nIndividual sites: [%2dbp flanking--MOTIF--%2dbp flanking] [strand] [seq] [pos]\n",FLANKING_BASES,FLANKING_BASES);
   for (i=0; i<nsites; i++) {
      for (j=0; j<min(maxHeaderLen,strlen(geneID[site[i].seqID])); j++)  fprintf(fq,"%c",geneID[site[i].seqID][j]); 
      for (j=strlen(geneID[site[i].seqID]); j<maxHeaderLen; j++) fprintf(fq," ");
      fprintf(fq,"\t");
 
      if (site[i].strand==1) {
         if (site[i].posID<FLANKING_BASES) {
            if (site[i].posID<0) {
               for (j=0; j<FLANKING_BASES; j++) fprintf(fq," "); 
            }
            else {
               for (j=0; j<FLANKING_BASES-site[i].posID; j++) fprintf(fq," "); 
               for (j=0; j<site[i].posID; j++) fprintf(fq,"%c",seq[site[i].seqID][j]);
            }
         }
         else {
            for (j=site[i].posID-FLANKING_BASES; j<site[i].posID; j++) fprintf(fq,"%c",seq[site[i].seqID][j]);
         }

         if (site[i].posID<0) {
            for (j=site[i].posID; j<0; j++) fprintf(fq,"X"); 
            for (j=0; j<pwmLen+site[i].posID; j++) {
               switch(seq[site[i].seqID][j]) {
                  case 'a': fprintf(fq,"A"); break;
                  case 'c': fprintf(fq,"C"); break;
                  case 'g': fprintf(fq,"G"); break;
                  case 't': fprintf(fq,"T"); break;
                  case 'n': fprintf(fq,"N"); break;
                  default: break;
               }
            }
         }
         else {
            for (j=site[i].posID; j<min(seqLen[site[i].seqID],site[i].posID+pwmLen); j++) {
               switch(seq[site[i].seqID][j]) {
                  case 'a': fprintf(fq,"A"); break;
                  case 'c': fprintf(fq,"C"); break;
                  case 'g': fprintf(fq,"G"); break;
                  case 't': fprintf(fq,"T"); break;
                  case 'n': fprintf(fq,"N"); break;
                  default: break;
               }
            }
         }
         if (site[i].posID+pwmLen-seqLen[site[i].seqID]>0) {
            for (j=seqLen[site[i].seqID]; j<site[i].posID+pwmLen; j++) fprintf(fq,"X"); 
         }
         // print flanking region
         for (j=site[i].posID+pwmLen; j<min(site[i].posID+pwmLen+FLANKING_BASES,seqLen[site[i].seqID]); j++) 
            fprintf(fq,"%c",seq[site[i].seqID][j]);
         if (site[i].posID+pwmLen+FLANKING_BASES>seqLen[site[i].seqID]) { 
            for (j=0; j<site[i].posID+pwmLen+FLANKING_BASES-seqLen[site[i].seqID]; j++) fprintf(fq," "); 
         }
         fprintf(fq,"\t+\t%d\t%d\n",site[i].seqID+1,site[i].posID+1);
      }
      else {
         site[i].posID=seqLen[site[i].seqID]-site[i].posID-pwmLen;
         if (site[i].posID<FLANKING_BASES) {
            if (site[i].posID<0) {
               for (j=0; j<FLANKING_BASES; j++) fprintf(fq," "); 
            }
            else {
               for (j=0; j<FLANKING_BASES-site[i].posID; j++) fprintf(fq," "); 
               for (j=0; j<site[i].posID; j++) fprintf(fq,"%c",rseq[site[i].seqID][j]);
            }
         }
         else {
            for (j=site[i].posID-FLANKING_BASES; j<site[i].posID; j++) fprintf(fq,"%c",rseq[site[i].seqID][j]);
         }

         if (site[i].posID<0) {
            for (j=site[i].posID; j<0; j++) fprintf(fq,"X"); 
            for (j=0; j<pwmLen+site[i].posID; j++) {
               switch(rseq[site[i].seqID][j]) {
                  case 'a': fprintf(fq,"A"); break;
                  case 'c': fprintf(fq,"C"); break;
                  case 'g': fprintf(fq,"G"); break;
                  case 't': fprintf(fq,"T"); break;
                  case 'n': fprintf(fq,"N"); break;
                  default: break;
               }
            }
         }
         else {
            for (j=site[i].posID; j<min(seqLen[site[i].seqID],site[i].posID+pwmLen); j++) {
               switch(rseq[site[i].seqID][j]) {
                  case 'a': fprintf(fq,"A"); break;
                  case 'c': fprintf(fq,"C"); break;
                  case 'g': fprintf(fq,"G"); break;
                  case 't': fprintf(fq,"T"); break;
                  case 'n': fprintf(fq,"N"); break;
                  default: break;
               }
            }
         }
         if (site[i].posID+pwmLen-seqLen[site[i].seqID]>0) {
            for (j=seqLen[site[i].seqID]; j<site[i].posID+pwmLen; j++) fprintf(fq,"X"); 
         }
         // print flanking region
         for (j=site[i].posID+pwmLen; j<min(site[i].posID+pwmLen+FLANKING_BASES,seqLen[site[i].seqID]); j++) 
            fprintf(fq,"%c",rseq[site[i].seqID][j]);
         if (site[i].posID+pwmLen+FLANKING_BASES>seqLen[site[i].seqID]) { 
            for (j=0; j<site[i].posID+pwmLen+FLANKING_BASES-seqLen[site[i].seqID]; j++) fprintf(fq," "); 
         }
         fprintf(fq,"\t-\t%d\t%d\n",site[i].seqID+1,seqLen[site[i].seqID]-site[i].posID);
      }
   }
   fprintf(fq,"\n");
   fprintf(fq,"-------------------------------------------------------\n");
   fflush(fq);
}

