#include <stdio.h>
#include "config.h"
#include "random.h"

typedef struct motif_info Motifs;
struct motif_info {
   int numSite;
   char oconsensus[100],fconsensus[100],name[200];
   double evalue,specifiedFDR,actualBound,m,e;
};

typedef struct subsequence_info Segment;
struct subsequence_info {
   double value;
   int  index,strand;
};

typedef struct subseq_score Subseq;
struct subseq_score {
   double value;
   int seqID,posID,strand;
};

int range(double score);
int Compare_double(const void *s1, const void *s2);
int Compare_subseq(const void *s1, const void *s2);
int Compare_segments(const void *s1,const void *s2);
int count_base(int ,int *,char **);
int select_top_Cmax_subsequences(Segment *,Segment *,int ,int ,int );
int select_top_subseqs(Subseq *,double **,double **,int ,int *,int ,int ,int );

double check_convergence(double **,double **,int );
double ***read_initial_pwm(int *pwmLen,char **pwmName,int *numPWM,int argc,char **argv);
double ***initial_PWM(int numPWMs,int matLen);
double ***denovo_PWM(int numPWMs,int *pwmLen,char **);
double false_discovery(Subseq *,int ,Subseq *,int ,double ,int *,double *,int ,int );

char **read_seq(int *,int *,char **,int ,int ,char *);
char **read_seq0(int *,int *,int ,int ,char *);
void reverse_seq(char **,char **,int ,int *);
char **background(int ,char **,int *,int ,int ,int ,double *,int );
void backg_freq(char** , int , int *, double *);

void sort_double(double *,int );
void base_frequency(char** seq, int numSeq, int *seqLen, double *freq) ;
void sort_segments(Segment *,int );
void sort_subseq(Subseq *, int );
void sort_motif(Motifs *, int );
void transform_mat(double **,double **,int );
void score_subsequences(int ,char **,char **,int *,double **,int ,double **,double **,double *);
void normalize_per_seq(double **,double **,int *,int ,int ,int *);
void normalize_global(double **,double **,int *,int ,int ,int *);
void count_num_sites_per_seq(Subseq *,int ,int ,int *);
void construct_pwm(double **,double **,double **,char **,char **,int *,int ,int );
void binding_site_location(Subseq *,char **,char **,char**,int *,int ,int,int, FILE *);
void binding_site_base_freq(Subseq *,char **,char **, int *, int ,int , double **);
void motif_consensus(double **opwm,int pwmLen,char *consensus);
double E_value(double **, int , double *, int , int , int *, double *, double *, FILE *);



