#include <stdlib.h>
#include <string.h>
#include <stdio.h>

/* construct the new PWM */
void construct_pwm(double **PWM,double **score,double **rscore,char **seq,char **rseq,
   int *seqLen,int numseq,int motifLen) {

   register int i,j,k;
   int tempid;
   double temp;

   for (i=0; i<motifLen; i++) {
      for (j=0; j<4; j++) PWM[i][j]=0; 
   }

   for(i=0; i<numseq; i++){
      for(j=0;j<seqLen[i]-motifLen+1; j++){
         tempid=seqLen[i]-motifLen-j;
         for(k=0;k<motifLen;k++){
            switch(seq[i][j+k]) {
               case 'a': PWM[k][0]+=score[i][j]; break;
               case 'c': PWM[k][1]+=score[i][j]; break;
               case 'g': PWM[k][2]+=score[i][j]; break;
               case 't': PWM[k][3]+=score[i][j]; break;
               default: break;
            }
         }
         for(k=0;k<motifLen;k++){
            switch(rseq[i][tempid+k]) {
               case 'a': PWM[k][0]+=rscore[i][j]; break;
               case 'c': PWM[k][1]+=rscore[i][j]; break;
               case 'g': PWM[k][2]+=rscore[i][j]; break;
               case 't': PWM[k][3]+=rscore[i][j]; break;
               default: break;
            }
         }
      }
   }
   for(i=0; i<motifLen; i++){
      temp=0.0; for(j=0;j<4; j++) temp+=PWM[i][j];
      if(temp>0.0){
         for(j=0;j<4; j++) PWM[i][j]=PWM[i][j]/temp;
      }
      else {
         for(j=0;j<4; j++) PWM[i][j]=0.25;
      }
   }
  /*
   for(i=0; i<motifLen; i++){
      for (j=0; j<4; j++) printf("%5.3f ",PWM[i][j]); printf("\n"); 
   }
  */
}

