/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class TabbedPane
extends JPanel
implements ActionListener {
    private JTabbedPane tabbedPane = new JTabbedPane();
    private static TabbedPane instance = null;
    private JPanel tab1;
    private JPanel tab2;
    private ParameterPane pp;
    private TextPane textp;
    private File f;
    private String filename;
    private JButton submitButton;
    private JButton exportButton;
    private TableScroller tsOverall;
    private Vector header;
    private Vector original;
    private Vector orig;
    private Vector training;
    private Vector testing;

    private TabbedPane() {
        this.add(this.tabbedPane);
    }

    private void makeHeader() {
        this.header = new Vector();
        this.header.add("No.");
        this.header.add("Sample");
        this.header.add("Label");
    }

    public Vector getHeader() {
        return this.header;
    }

    public Vector getOriginal() {
        return this.orig;
    }

    public void createOriginalCopy(Vector vector) {
        this.orig = new Vector();
        for (int i = 0; i < vector.size(); ++i) {
            this.orig.add((Vector)vector.get(i));
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("Submit")) {
            Vector vector = IO.readFile(this.f);
            SFAM sFAM = new SFAM();
            String[][] stringArray = IO.convert_to_string_array(vector);
            if (!this.pp.checkboxIsSelected()) {
                if (this.pp.getValidationMethod().equals("r1")) {
                    int[] nArray = this.pp.getTrainingIdx();
                    int[] nArray2 = this.pp.getTestingIdx();
                    sFAM.loadData(stringArray);
                    sFAM.fuzzyARTMAP_benchmarkSpectrum(nArray, nArray2, this.pp.getVigilance(), this.pp.getTestingSetVector());
                    PredictionTracker predictionTracker = sFAM.getPT();
                    CVPrediction_SingleRunPanel cVPrediction_SingleRunPanel = new CVPrediction_SingleRunPanel(predictionTracker, predictionTracker.generateStatStr());
                    cVPrediction_SingleRunPanel.setupGUI();
                    this.tab2.removeAll();
                    this.tab2 = cVPrediction_SingleRunPanel;
                    this.tab2.validate();
                    this.tab2.repaint();
                } else if (this.pp.getValidationMethod().equals("r2")) {
                    sFAM.loadData(stringArray);
                    sFAM.crossValivation(this.pp.getVigilance());
                    PredictionTracker predictionTracker = sFAM.getPT();
                    this.tab2.removeAll();
                    CVPrediction_SingleRunPanel cVPrediction_SingleRunPanel = new CVPrediction_SingleRunPanel(predictionTracker, predictionTracker.generateStatStr());
                    cVPrediction_SingleRunPanel.setupGUI();
                    this.tab2 = cVPrediction_SingleRunPanel;
                    this.tab2.validate();
                    this.tab2.repaint();
                }
            } else {
                double d = 0.0;
                Vector vector2 = new Vector();
                DecimalFormat decimalFormat = new DecimalFormat("0.00");
                int[] nArray = null;
                int[] nArray3 = null;
                sFAM.loadData(stringArray);
                System.out.println("At Vigilance = 0.0, computing....");
                if (this.pp.getValidationMethod().equals("r1")) {
                    nArray = this.pp.getTrainingIdx();
                    nArray3 = this.pp.getTestingIdx();
                }
                if (this.pp.getValidationMethod().equals("r1")) {
                    sFAM.fuzzyARTMAP_benchmarkSpectrum(nArray, nArray3, 0.0f, this.pp.getTestingSetVector());
                } else if (this.pp.getValidationMethod().equals("r2")) {
                    sFAM.crossValivationSpectrum(0.0f);
                }
                PredictionTracker predictionTracker = sFAM.getPT();
                predictionTracker.computePercentage();
                String string2 = decimalFormat.format(0.0);
                String string3 = decimalFormat.format(predictionTracker.getRightPred());
                String string4 = decimalFormat.format(predictionTracker.getWrongPred());
                String string5 = decimalFormat.format(predictionTracker.getNoPred());
                Vector<String> vector3 = new Vector<String>();
                vector3.add(string2);
                vector3.add(string3);
                vector3.add(string4);
                vector3.add(string5);
                vector2.add(vector3);
                double d2 = 0.0;
                for (int i = 0; i < 100; ++i) {
                    float f = (float)(d2 += 0.01);
                    if (this.pp.getValidationMethod().equals("r1")) {
                        sFAM.fuzzyARTMAP_benchmarkSpectrum(nArray, nArray3, f, this.pp.getTestingSetVector());
                    } else if (this.pp.getValidationMethod().equals("r2")) {
                        sFAM.crossValivationSpectrum(f);
                    }
                    predictionTracker = sFAM.getPT();
                    predictionTracker.computePercentage();
                    string2 = decimalFormat.format(d2);
                    string3 = decimalFormat.format(predictionTracker.getRightPred());
                    string4 = decimalFormat.format(predictionTracker.getWrongPred());
                    string5 = decimalFormat.format(predictionTracker.getNoPred());
                    System.out.println("At Vigilance = " + string2 + ", computing....");
                    vector3 = new Vector();
                    vector3.add(string2);
                    vector3.add(string3);
                    vector3.add(string4);
                    vector3.add(string5);
                    vector2.add(vector3);
                }
                Vector<String> vector4 = new Vector<String>();
                vector4.add("Vigilance");
                vector4.add("Right Prediction(%)");
                vector4.add("Wrong Prediction(%)");
                vector4.add("No Prediction(%)");
                this.tsOverall = new TableScroller(vector2, (Vector)vector4);
                this.tsOverall.setTableSize(new Dimension(700, 600));
                this.tab2.removeAll();
                this.tab2.add(this.tsOverall.getComp(), "Center");
                JPanel jPanel = new JPanel(new FlowLayout(2));
                this.exportButton = new JButton("Save As Text (Tab delimited)");
                this.exportButton.setActionCommand("Save as Tab-Delimited Text File");
                this.exportButton.addActionListener(this);
                jPanel.add(this.exportButton);
                this.tab2.add((Component)jPanel, "South");
                this.tab2.validate();
                this.tab2.repaint();
            }
            this.refreshTabbedPane();
        } else if (string.equals("Save as Tab-Delimited Text File")) {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setCurrentDirectory(MainGUI._cwd);
            int n = jFileChooser.showSaveDialog(this);
            if (n == 0) {
                File file = jFileChooser.getSelectedFile();
                String string6 = file.getPath();
                Vector vector = this.tsOverall.getSource();
                Vector vector5 = this.tsOverall.getHeader();
                try {
                    int n2;
                    BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string6));
                    for (n2 = 0; n2 < vector5.size(); ++n2) {
                        bufferedWriter.write((String)vector5.get(n2) + "\t");
                    }
                    bufferedWriter.newLine();
                    for (n2 = 0; n2 < vector.size(); ++n2) {
                        Vector vector6 = (Vector)vector.get(n2);
                        for (int i = 0; i < vector6.size(); ++i) {
                            String string7 = (String)vector6.get(i);
                            bufferedWriter.write(string7 + "\t");
                        }
                        bufferedWriter.newLine();
                    }
                    bufferedWriter.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public void setupGUI(String string, File file) {
        this.readHeader(string);
        this.makeHeader();
        this.filename = string;
        this.f = file;
        this.pp = ParameterPane.getInstance();
        this.pp.setupGUI(string, this.original, this.header);
        this.tab1 = new JPanel(new BorderLayout());
        JPanel jPanel = new JPanel();
        this.submitButton = new JButton("Submit");
        this.submitButton.addActionListener(this);
        jPanel.add(this.submitButton);
        this.tab1.add((Component)this.pp.getPanel(), "Center");
        this.tab1.add((Component)jPanel, "South");
        this.tab2 = new JPanel(new BorderLayout());
        this.tabbedPane.addTab("Parameters", this.tab1);
        this.tabbedPane.addTab("Prediction", this.tab2);
    }

    public static TabbedPane getInstance() {
        if (instance == null) {
            instance = new TabbedPane();
        }
        return instance;
    }

    private ArrayList process(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = stringTokenizer.nextToken();
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        return arrayList;
    }

    private void readHeader(String string) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            ArrayList arrayList = null;
            String string2 = bufferedReader.readLine();
            if (string2 != null) {
                arrayList = this.process(string2);
            }
            ArrayList arrayList2 = null;
            string2 = bufferedReader.readLine();
            if (string2 != null) {
                arrayList2 = this.process(string2);
            }
            bufferedReader.close();
            int n = 1;
            this.original = new Vector();
            for (int i = 0; i < arrayList2.size(); ++i) {
                Vector<String> vector = new Vector<String>();
                String string3 = Integer.toString(i + n);
                String string4 = (String)arrayList.get(i);
                String string5 = (String)arrayList2.get(i);
                vector.add(string3);
                vector.add(string4);
                vector.add(string5);
                this.original.add(vector);
            }
            this.createOriginalCopy(this.original);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void refreshTabbedPane() {
        this.tabbedPane.removeAll();
        this.pp = ParameterPane.getInstance();
        this.tab1 = new JPanel(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.add(this.submitButton);
        this.tab1.add((Component)this.pp.getPanel(), "Center");
        this.tab1.add((Component)jPanel, "South");
        this.tabbedPane.addTab("Parameters", this.tab1);
        this.tabbedPane.addTab("Prediction", this.tab2);
        this.validate();
        this.repaint();
    }
}

