/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.ActionEvent;
import java.text.DecimalFormat;
import java.util.TreeSet;
import java.util.Vector;

public class SFAM {
    private boolean paraLoaded = false;
    private String dataFilename;
    private IO myIO;
    private FUZZYARTMAPDataHolder sdh;
    private FuzzyArtMap myARTMAP;
    private boolean dataLoaded = false;
    private boolean trainNetDone;
    private boolean createSetPara;
    private boolean analyzeSetPara;
    private boolean trainSetPara;
    private boolean testSetPara;
    private DecimalFormat df;
    private String netSelection;
    private String output_breif = "";
    private String output_detail = "";
    private PredictionTracker pt;
    private String cvSummary;

    public void crossValivation(float f) {
        this.sdh.setVigilance(f);
        this.output_breif = "";
        this.output_detail = "";
        if (!this.paraLoaded) {
            return;
        }
        this.pt = new PredictionTracker(this.sdh.arraySet);
        TabbedPane tabbedPane = TabbedPane.getInstance();
        Vector vector = tabbedPane.getOriginal();
        int n = this.sdh.getTot_pats();
        int n2 = n - 1;
        int n3 = 1;
        this.sdh.selectTrainSet = new int[n2];
        this.sdh.selectTestSet = new int[n3];
        this.sdh.setTrain_pats(n2);
        this.sdh.setTest_pats(n3);
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        for (int i = 0; i < n; ++i) {
            this.sdh.selectTestSet[0] = i + 1;
            for (int j = 0; j < n2; ++j) {
                if (j < i) {
                    this.sdh.selectTrainSet[j] = j + 1;
                    continue;
                }
                if (j < i) continue;
                this.sdh.selectTrainSet[j] = j + 2;
            }
            Vector vector2 = (Vector)vector.get(i);
            this.benchmark(vector2);
            n4 += this.sdh.tot_wrong - this.sdh.tot_no_prediction;
            n5 += this.sdh.tot_right;
            n6 += n3 - (this.sdh.tot_wrong - this.sdh.tot_no_prediction) - this.sdh.tot_right;
        }
    }

    public void crossValivationSpectrum(float f) {
        this.sdh.setVigilance(f);
        this.output_breif = "";
        this.output_detail = "";
        if (!this.paraLoaded) {
            return;
        }
        this.pt = new PredictionTracker(this.sdh.arraySet);
        TabbedPane tabbedPane = TabbedPane.getInstance();
        Vector vector = tabbedPane.getOriginal();
        int n = this.sdh.getTot_pats();
        int n2 = n - 1;
        int n3 = 1;
        this.sdh.selectTrainSet = new int[n2];
        this.sdh.selectTestSet = new int[n3];
        this.sdh.setTrain_pats(n2);
        this.sdh.setTest_pats(n3);
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        for (int i = 0; i < n; ++i) {
            this.sdh.selectTestSet[0] = i + 1;
            for (int j = 0; j < n2; ++j) {
                if (j < i) {
                    this.sdh.selectTrainSet[j] = j + 1;
                    continue;
                }
                if (j < i) continue;
                this.sdh.selectTrainSet[j] = j + 2;
            }
            Vector vector2 = (Vector)vector.get(i);
            this.benchmarkSpectrum(vector2);
            n4 += this.sdh.tot_wrong - this.sdh.tot_no_prediction;
            n5 += this.sdh.tot_right;
            n6 += n3 - (this.sdh.tot_wrong - this.sdh.tot_no_prediction) - this.sdh.tot_right;
        }
    }

    private void note(ActionEvent actionEvent) {
        String string = "1. What is Fuzzy ARTMAP?\n\n  Fuzzy ARTMAP is ";
        string = string + "a class of neural network architectures that perform\n";
        string = string + "  incremental supervised learning of recognition categories and\n";
        string = string + "  multidimentional maps in response to input vectors presented\n";
        string = string + "  in arbitrary order.\n\n  The architecture, called fuzzy ARTMAP,";
        string = string + " achieves a synthesis of fuzzy\n  logic and adaptive resonance theory";
        string = string + " (ART) neural networks by \n  exploiting a close formal";
        string = string + " similarity between the computations of \n";
        string = string + "  fuzzy subsethood and ART category choice, resonance,";
        string = string + " and learning. \n  Fuzzy ARTMAP also realizes a new minimax";
        string = string + " learning rule that conjointly\n  minimizes predictive error";
        string = string + " and maximizes code compression, or \n  generalization. ";
        string = string + "This is achieved by a match tracking process that \n";
        string = string + "  increases the ART vigilance parameter by the minimum amount needed \n";
        string = string + "  to correct a predictive error. As a result, the system automatically \n";
        string = string + "  learns a minimal number of recognition categories, or \"hidden units\", \n";
        string = string + "  to meet accuracy criteria. Category proliferation is prevented by \n";
        string = string + "  normalizing input vectors at a preprocessing stage. A normalization \n";
        string = string + "  procedure called complement coding leads to a symmetric theory in \n";
        string = string + "  which the AND operator and the OR operator of fuzzy logic play \n";
        string = string + "  complementary roles. Complement coding uses on cells and off cells \n";
        string = string + "  to present the input pattern, and preserves individual feature \n";
        string = string + "  amplitudes while normalizing the total on cell/off cell vector. \n";
        string = string + "  Learning is stable because all adaptive weights can only decrease \n";
        string = string + "  in time. Decreasing weights correspond to increasing sizes of \n";
        string = string + "  category \"boxes\". Smaller vigilance values lead to larger category \n";
        string = string + "  boxes. Improved prediction is achieved by training the system \n";
        string = string + "  several times using different orderings of the input set. This \n";
        string = string + "  voting strategy can also be used to assign confidence estimates to \n";
        string = string + "  competing predictions given small, noisy, or incomplete training \n";
        string = string + "  sets. Four classes of simulations illustrate fuzzy ARTMAP performance \n";
        string = string + "  in relation to benchmark back-propagation and genetic algorithm systems.\n\n";
        string = string + " \nreference: \nFuzzy ARTMAP: A neural Network Architecture";
        string = string + " for Incremental Supervised \nLearning of Analog Multidimensional Maps\n";
        string = string + "Gail A. Carpenter, Stephen Grossberg, Natalya Markuzon, John H.Reynolds,\n";
        string = string + "and David B. Rosen\nIEEE Transactions on Neural Networls, Vol.3, No.5, 698-713,";
        string = string + " September 1992\n\n2. Input/Output\n\nColumnwise data input example:\n";
        string = string + "p52s10\tp52s11\tp52s12\tp52s13\t...\nagent1\tagent1 agent2 agent2\t";
        string = string + "...\n2.1\t2.5\t3.2\t3.1\t...\n0.5\t0.8\t4.3\t4.4\t...\n";
        string = string + "........\n\n\nRowwise data input example:\np52s10\tagent1\t2.1\t";
        string = string + "0.5 ...\np52s11\tagent1\t2.5\t0.8 ...\np52s12\tagent2\t3.2\t";
        string = string + "4.3 ...\np52s13\tagent2\t3.1\t4.4 ...\n........\n\n3. Commands:\n\n";
        string = string + "(1) Benchmark:\n\tRUN -- operate on the input data with the set paramters.\n";
        string = string + "\tValidation --\toperate on the input data with all the data\n\t";
        string = string + "as training set except one as testing set. \n\tThe testing one go ";
        string = string + "through all the data set.\n(2) Interactive:\n\tOperation following the order - \n";
        string = string + "\tcreate net, \n\ttrainning net, \n\tanalyze net,\n\ttesting net\n";
        string = string + "\twith parameter set up, then RUN.  \n\n";
    }

    public void loadData(String[][] stringArray) {
        if (stringArray == null) {
            return;
        }
        this.sdh = new FUZZYARTMAPDataHolder();
        this.myIO = new IO(this.sdh);
        this.myARTMAP = new FuzzyArtMap(this.sdh, this.myIO);
        this.load_dat(stringArray);
        this.dataLoaded = true;
        this.createSetPara = false;
        this.trainSetPara = false;
        this.trainNetDone = false;
        this.analyzeSetPara = false;
        this.testSetPara = false;
        this.myARTMAP.normalize();
        this.setParameters();
    }

    private void setParameters() {
        if (this.dataLoaded) {
            if (this.sdh.network_loaded) {
                this.sdh.free_memory();
                this.sdh.free_series_data();
            }
            this.setDefaultParameter();
            this.paraLoaded = true;
        }
    }

    private void load_dat(String[][] stringArray) {
        int n;
        int n2;
        int n3 = stringArray[0].length - 1;
        if (n3 < 2) {
            return;
        }
        this.sdh.setNum_pats(n3);
        this.sdh.printSlide = new String[n3];
        this.sdh.agents = new String[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            this.sdh.printSlide[n2] = stringArray[0][n2 + 1];
            this.sdh.agents[n2] = stringArray[1][n2 + 1];
        }
        this.sdh.set = new TreeSet();
        for (n2 = 0; n2 < n3; ++n2) {
            this.sdh.set.add(this.sdh.agents[n2]);
        }
        int n4 = this.sdh.set.size();
        int[] nArray = new int[n3];
        Object[] objectArray = new Object[n4];
        objectArray = this.sdh.set.toArray();
        this.sdh.arraySet = new Object[n4];
        this.sdh.arraySet = this.sdh.set.toArray();
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < n4; ++n) {
                if (!this.sdh.agents[n2].equals((String)this.sdh.arraySet[n])) continue;
                nArray[n2] = n;
                n = n4;
            }
        }
        int n5 = stringArray.length - 2;
        this.sdh.setA_length(n5);
        this.sdh.setB_length(n4);
        this.sdh.dpt = new float[n3][n5 + n4];
        this.sdh.geneID = new String[n5];
        for (n2 = 0; n2 < n5; ++n2) {
            this.sdh.geneID[n2] = stringArray[n2 + 2][0];
            for (n = 0; n < n3; ++n) {
                this.sdh.dpt[n][n2] = Float.parseFloat(stringArray[n2 + 2][n + 1]);
            }
        }
        for (n = 0; n < n3; ++n) {
            for (n2 = n5; n2 < n5 + n4; ++n2) {
                this.sdh.dpt[n][n2] = 0.0f;
            }
            this.sdh.dpt[n][n5 + nArray[n]] = 1.0f;
        }
        nArray = null;
    }

    public void setDefaultParameter() {
        this.sdh.setRandomInit(1);
        this.sdh.setOrderedSet(2);
        this.sdh.setTrack_on_choice(0);
        this.sdh.setNo_learn_if_wrong(0);
        this.sdh.setTwo_binary_categories(0);
        this.sdh.setOn_line(true);
        this.sdh.setNum_voters(2);
        this.sdh.setNum_runs(1);
        this.sdh.setMax_iterations(1);
        this.sdh.setComplement(1);
        this.sdh.setNum_data_category(this.sdh.getB_length());
        this.sdh.setTrain_pats(700);
        this.sdh.setTest_pats(300);
        this.sdh.setTot_pats(this.sdh.getNum_pats());
        this.sdh.setDnInit(1.0f);
        this.sdh.setAlpha(0.001f);
        this.sdh.setEpsilon(0.001f);
        this.sdh.setRate(1.0f);
        this.sdh.setZ_bar(0.0f);
        this.sdh.setMin_arho(0.6f);
        this.sdh.setBrho(1.0f);
        this.sdh.setNoise_rate(0.0f);
        this.sdh.setNoise_tolerance(0.0f);
        this.sdh.setTrace(1);
        this.sdh.setExplain(0);
        this.sdh.setTrace_weight(0);
        this.sdh.setDisplay_confusion_matrix(1);
    }

    private void benchmarkSpectrum(Vector vector) {
        if (!this.dataLoaded) {
            return;
        }
        if (!this.paraLoaded) {
            return;
        }
        this.sdh.alloc_series_memory();
        this.myARTMAP.init_series();
        this.sdh.alloc_memory();
        this.myARTMAP.pre_scan_data();
        for (int i = 0; i < this.sdh.getNum_runs(); ++i) {
            int n;
            for (n = 0; n < this.sdh.getTot_pats(); ++n) {
                this.sdh.Index[n] = n;
            }
            if (this.sdh.getOrderedSet() == 0) {
                this.myARTMAP.setup_index(this.sdh.getTot_pats());
            }
            this.myARTMAP.init_votes();
            for (n = 0; n < this.sdh.getNum_voters(); ++n) {
                if (this.sdh.getOrderedSet() == 0 || this.sdh.getOrderedSet() == 2) {
                    this.myARTMAP.setup_index(this.sdh.getTrain_pats());
                }
                int[] nArray = this.sdh.num_category;
                this.sdh.getClass();
                nArray[0] = 0;
                int[] nArray2 = this.sdh.num_category;
                this.sdh.getClass();
                nArray2[1] = 0;
                this.sdh.alloc_memory();
                this.myARTMAP.init_ARTMAP();
                this.myARTMAP.init_ARTs();
                this.myARTMAP.init_ARTB();
                this.myARTMAP.processSpectrum();
                this.sdh.free_memory();
                this.myARTMAP.count_votes(n);
            }
        }
        if (this.sdh.getDisplay_confusion_matrix()) {
            this.myARTMAP.calculate_correlation_coeff();
        }
        this.pt.update_prediction(this.sdh.p_table, vector);
        this.sdh.free_series_data();
        this.sdh.network_loaded = false;
    }

    private void benchmark(Vector vector) {
        if (!this.dataLoaded) {
            return;
        }
        if (!this.paraLoaded) {
            return;
        }
        this.sdh.alloc_series_memory();
        this.myARTMAP.init_series();
        this.sdh.alloc_memory();
        this.myARTMAP.pre_scan_data();
        for (int i = 0; i < this.sdh.getNum_runs(); ++i) {
            int n;
            for (n = 0; n < this.sdh.getTot_pats(); ++n) {
                this.sdh.Index[n] = n;
            }
            if (this.sdh.getOrderedSet() == 0) {
                this.myARTMAP.setup_index(this.sdh.getTot_pats());
            }
            this.myARTMAP.init_votes();
            for (n = 0; n < this.sdh.getNum_voters(); ++n) {
                if (this.sdh.getTrace() > 0) {
                    this.myIO.output_detail = this.myIO.output_detail + "Voter " + (n + 1) + "\n";
                }
                if (this.sdh.getOrderedSet() == 0 || this.sdh.getOrderedSet() == 2) {
                    this.myARTMAP.setup_index(this.sdh.getTrain_pats());
                }
                int[] nArray = this.sdh.num_category;
                this.sdh.getClass();
                nArray[0] = 0;
                int[] nArray2 = this.sdh.num_category;
                this.sdh.getClass();
                nArray2[1] = 0;
                this.sdh.alloc_memory();
                this.myARTMAP.init_ARTMAP();
                this.myARTMAP.init_ARTs();
                this.myARTMAP.init_ARTB();
                this.myARTMAP.process();
                this.sdh.free_memory();
                this.myARTMAP.count_votes(n);
            }
        }
        if (this.sdh.getDisplay_confusion_matrix()) {
            this.myARTMAP.calculate_correlation_coeff();
        }
        this.pt.update_prediction(this.sdh.p_table, vector);
        this.sdh.free_series_data();
        this.sdh.network_loaded = false;
    }

    public String getCVSummary() {
        return this.cvSummary;
    }

    public PredictionTracker getPT() {
        return this.pt;
    }

    private void benchmarkTT(Vector vector) {
        if (!this.dataLoaded) {
            return;
        }
        if (!this.paraLoaded) {
            return;
        }
        this.sdh.alloc_series_memory();
        this.myARTMAP.init_series();
        this.sdh.alloc_memory();
        String string = this.myARTMAP.pre_scan_data();
        this.myIO.output_detail = this.myIO.output_detail + string;
        for (int i = 0; i < this.sdh.getNum_runs(); ++i) {
            int n;
            this.myIO.output_detail = this.myIO.output_detail + "RUN " + (i + 1) + "\n";
            for (n = 0; n < this.sdh.getTot_pats(); ++n) {
                this.sdh.Index[n] = n;
            }
            if (this.sdh.getOrderedSet() == 0) {
                this.myARTMAP.setup_index(this.sdh.getTot_pats());
            }
            this.myARTMAP.init_votes();
            for (n = 0; n < this.sdh.getNum_voters(); ++n) {
                if (this.sdh.getTrace() > 0) {
                    this.myIO.output_detail = this.myIO.output_detail + "Voter " + (n + 1) + "\n";
                }
                if (this.sdh.getOrderedSet() == 0 || this.sdh.getOrderedSet() == 2) {
                    this.myARTMAP.setup_index(this.sdh.getTrain_pats());
                }
                int[] nArray = this.sdh.num_category;
                this.sdh.getClass();
                nArray[0] = 0;
                int[] nArray2 = this.sdh.num_category;
                this.sdh.getClass();
                nArray2[1] = 0;
                this.sdh.alloc_memory();
                this.myARTMAP.init_ARTMAP();
                this.myARTMAP.init_ARTs();
                this.myARTMAP.init_ARTB();
                this.output_breif = this.output_breif + this.myARTMAP.processTT(this.pt, vector, n);
                this.sdh.free_memory();
                this.myARTMAP.count_votes(n);
            }
        }
        if (this.sdh.getDisplay_confusion_matrix()) {
            this.myARTMAP.calculate_correlation_coeff();
        }
        this.cvSummary = this.output_breif = this.output_breif + this.myIO.print_series_data();
        this.sdh.free_series_data();
        this.sdh.network_loaded = false;
    }

    private void benchmarkTTSpectrum(Vector vector) {
        if (!this.dataLoaded) {
            return;
        }
        if (!this.paraLoaded) {
            return;
        }
        this.sdh.alloc_series_memory();
        this.myARTMAP.init_series();
        this.sdh.alloc_memory();
        this.myARTMAP.pre_scan_data();
        for (int i = 0; i < this.sdh.getNum_runs(); ++i) {
            int n;
            for (n = 0; n < this.sdh.getTot_pats(); ++n) {
                this.sdh.Index[n] = n;
            }
            if (this.sdh.getOrderedSet() == 0) {
                this.myARTMAP.setup_index(this.sdh.getTot_pats());
            }
            this.myARTMAP.init_votes();
            for (n = 0; n < this.sdh.getNum_voters(); ++n) {
                if (this.sdh.getOrderedSet() == 0 || this.sdh.getOrderedSet() == 2) {
                    this.myARTMAP.setup_index(this.sdh.getTrain_pats());
                }
                int[] nArray = this.sdh.num_category;
                this.sdh.getClass();
                nArray[0] = 0;
                int[] nArray2 = this.sdh.num_category;
                this.sdh.getClass();
                nArray2[1] = 0;
                this.sdh.alloc_memory();
                this.myARTMAP.init_ARTMAP();
                this.myARTMAP.init_ARTs();
                this.myARTMAP.init_ARTB();
                this.myARTMAP.processTTSpectrum(this.pt, vector, n);
                this.sdh.free_memory();
                this.myARTMAP.count_votes(n);
            }
        }
        if (this.sdh.getDisplay_confusion_matrix()) {
            this.myARTMAP.calculate_correlation_coeff();
        }
        this.myIO.print_series_data();
        this.sdh.free_series_data();
        this.sdh.network_loaded = false;
    }

    private void benchmark() {
        if (!this.dataLoaded) {
            return;
        }
        if (!this.paraLoaded) {
            return;
        }
        this.sdh.alloc_series_memory();
        this.myARTMAP.init_series();
        this.sdh.alloc_memory();
        String string = this.myARTMAP.pre_scan_data();
        this.myIO.output_detail = this.myIO.output_detail + string;
        for (int i = 0; i < this.sdh.getNum_runs(); ++i) {
            int n;
            this.myIO.output_detail = this.myIO.output_detail + "RUN " + (i + 1) + "\n";
            for (n = 0; n < this.sdh.getTot_pats(); ++n) {
                this.sdh.Index[n] = n;
            }
            if (this.sdh.getOrderedSet() == 0) {
                this.myARTMAP.setup_index(this.sdh.getTot_pats());
            }
            this.myARTMAP.init_votes();
            for (n = 0; n < this.sdh.getNum_voters(); ++n) {
                if (this.sdh.getTrace() > 0) {
                    this.myIO.output_detail = this.myIO.output_detail + "Voter " + (n + 1) + "\n";
                }
                if (this.sdh.getOrderedSet() == 0 || this.sdh.getOrderedSet() == 2) {
                    this.myARTMAP.setup_index(this.sdh.getTrain_pats());
                }
                int[] nArray = this.sdh.num_category;
                this.sdh.getClass();
                nArray[0] = 0;
                int[] nArray2 = this.sdh.num_category;
                this.sdh.getClass();
                nArray2[1] = 0;
                this.sdh.alloc_memory();
                this.myARTMAP.init_ARTMAP();
                this.myARTMAP.init_ARTs();
                this.myARTMAP.init_ARTB();
                this.output_breif = this.output_breif + this.myARTMAP.process();
                this.sdh.free_memory();
                this.myARTMAP.count_votes(n);
            }
        }
        if (this.sdh.getDisplay_confusion_matrix()) {
            this.myARTMAP.calculate_correlation_coeff();
        }
        this.output_breif = this.output_breif + this.myIO.print_series_data();
        this.pt.update_prediction(this.sdh.p_table);
        this.sdh.free_series_data();
        this.sdh.network_loaded = false;
    }

    public void fuzzyARTMAP_benchmarkSpectrum(int[] nArray, int[] nArray2, float f, Vector vector) {
        this.pt = new PredictionTracker(this.sdh.arraySet);
        this.sdh.applyParameters(f, nArray, nArray2);
        if (this.paraLoaded) {
            this.benchmarkTTSpectrum(vector);
        }
    }

    public void fuzzyARTMAP_benchmark(int[] nArray, int[] nArray2, float f, Vector vector) {
        this.pt = new PredictionTracker(this.sdh.arraySet);
        this.sdh.applyParameters(f, nArray, nArray2);
        if (this.paraLoaded) {
            this.benchmarkTT(vector);
        }
    }

    public void fuzzyARTMAP_benchmark(int[] nArray, float f) {
        this.sdh.applyParameters(f, nArray);
        if (this.paraLoaded) {
            this.benchmark();
        }
    }

    public String output_brief() {
        return this.output_breif;
    }

    public String output_detail() {
        return this.myIO.output_detail;
    }
}

