/*
 * Decompiled with CFR 0.152.
 */
import java.text.DecimalFormat;
import java.util.Vector;

public class PredictionTracker {
    private int[][] confusionMat;
    private Vector[][] tracker;
    private String[] classArray;
    private int row;
    private int col;
    private double rightPred;
    private double wrongPred;
    private double noPred;
    private int rightPrediction;
    private int wrongPrediction;
    private int noPrediction;
    private int total;

    public int locateColumn(String string) {
        for (int i = 0; i < this.classArray.length; ++i) {
            if (!string.equals(this.classArray[i])) continue;
            return i;
        }
        return -1;
    }

    public int locateNoPredRow() {
        return this.row - 1;
    }

    public PredictionTracker(Object[] objectArray) {
        int n;
        this.row = objectArray.length + 1;
        this.col = objectArray.length;
        this.classArray = new String[objectArray.length];
        this.confusionMat = new int[this.row][this.col];
        this.tracker = new Vector[this.row][this.col];
        for (n = 0; n < this.col; ++n) {
            this.classArray[n] = (String)objectArray[n];
        }
        for (n = 0; n < this.row; ++n) {
            for (int i = 0; i < this.col; ++i) {
                this.confusionMat[n][i] = 0;
                this.tracker[n][i] = new Vector();
            }
        }
    }

    public void update_prediction(int n, int n2, Vector vector) {
        int[][] nArray = new int[this.row][this.col];
        for (int i = 0; i < this.row; ++i) {
            for (int j = 0; j < this.col; ++j) {
                nArray[i][j] = 0;
            }
        }
        nArray[n][n2] = 1;
        this.updatePrediction(nArray, vector);
    }

    public void update_prediction(int[][][] nArray, Vector vector) {
        int[][] nArray2 = new int[this.row][this.col];
        for (int i = 0; i < this.row; ++i) {
            for (int j = 0; j < this.col; ++j) {
                nArray2[i][j] = nArray[1][i][j];
            }
        }
        this.updatePrediction(nArray2, vector);
    }

    public void update_prediction(int[][][] nArray) {
        for (int i = 0; i < this.row; ++i) {
            for (int j = 0; j < this.col; ++j) {
                this.confusionMat[i][j] = nArray[1][i][j];
            }
        }
    }

    public void computePercentage() {
        int n;
        int n2;
        this.total = 0;
        for (n2 = 0; n2 < this.row; ++n2) {
            for (n = 0; n < this.col; ++n) {
                this.total += this.confusionMat[n2][n];
            }
        }
        this.rightPrediction = 0;
        this.wrongPrediction = 0;
        this.noPrediction = 0;
        for (n2 = 0; n2 < this.row; ++n2) {
            for (n = 0; n < this.col; ++n) {
                if (n2 == n) {
                    this.rightPrediction += this.confusionMat[n2][n];
                    continue;
                }
                if (n2 == this.row - 1) {
                    this.noPrediction += this.confusionMat[n2][n];
                    continue;
                }
                this.wrongPrediction += this.confusionMat[n2][n];
            }
        }
        this.rightPred = (double)this.rightPrediction * 100.0 / (double)this.total;
        this.wrongPred = (double)this.wrongPrediction * 100.0 / (double)this.total;
        this.noPred = (double)this.noPrediction * 100.0 / (double)this.total;
    }

    public String generateStatStr() {
        this.computePercentage();
        String string = "-- Statistical summary over " + this.total + " run --\n";
        DecimalFormat decimalFormat = new DecimalFormat("0.00");
        String string2 = decimalFormat.format(this.rightPred);
        String string3 = decimalFormat.format(this.wrongPred);
        String string4 = decimalFormat.format(this.noPred);
        string = string + "There is total " + this.rightPrediction + " right prediction " + string2 + "%.\n";
        string = string + "There is total " + this.wrongPrediction + " wrong prediction " + string3 + "%.\n";
        string = string + "There is total " + this.noPrediction + " no prediction " + string4 + "%.\n";
        return string;
    }

    public double getRightPred() {
        return this.rightPred;
    }

    public double getWrongPred() {
        return this.wrongPred;
    }

    public double getNoPred() {
        return this.noPred;
    }

    public void updatePrediction(int[][] nArray, Vector vector) {
        for (int i = 0; i < this.row; ++i) {
            for (int j = 0; j < this.col; ++j) {
                int[] nArray2 = this.confusionMat[i];
                int n = j;
                nArray2[n] = nArray2[n] + nArray[i][j];
                if (nArray[i][j] != 1) continue;
                this.tracker[i][j].add(vector);
            }
        }
    }

    public int getRow() {
        return this.row;
    }

    public Vector getSampleList(int n, int n2) {
        return this.tracker[n][n2];
    }

    public int[][] getMat() {
        return this.confusionMat;
    }

    public String[] getClassLabel() {
        return this.classArray;
    }

    public String getClassByIndex(int n) {
        return this.classArray[n];
    }

    public void printMat() {
        for (int i = 0; i < this.row; ++i) {
            for (int j = 0; j < this.col; ++j) {
                System.out.print("\t" + this.confusionMat[i][j]);
            }
            System.out.println();
        }
    }
}

