/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ParameterPane {
    private JPanel jp;
    private static ParameterPane instance = null;
    private ButtonGroup group;
    private JPanel labelPane;
    private JScrollPane combineScroll;
    private JPanel midPanel;
    private JPanel vigPanel;
    private JCheckBox jcb;
    private JSlider slider;
    private JTextField jtf;
    private JSplitPane jsp1;
    private SampleSelectionPanel ssp;

    private ParameterPane() {
    }

    public boolean checkboxIsSelected() {
        return this.jcb.isSelected();
    }

    public float getVigilance() {
        float f = Float.parseFloat(this.jtf.getText());
        return f;
    }

    public int[] getTrainingIdx() {
        return this.ssp.getTrainingSet();
    }

    public int[] getTestingIdx() {
        return this.ssp.getTestingSet();
    }

    public String getValidationMethod() {
        String string = this.group.getSelection().getActionCommand();
        return string;
    }

    public Vector getTestingSetVector() {
        return this.ssp.getTestingsetVector();
    }

    public void setupGUI(String string, Vector vector, Vector vector2) {
        this.jp = new JPanel(new GridLayout(1, 1));
        this.labelPane = new JPanel(new GridLayout(3, 1, 0, 0));
        this.labelPane.add(new JLabel(" File:  " + string, 2));
        this.midPanel = new JPanel(new FlowLayout(0));
        JRadioButton jRadioButton = new JRadioButton("Training/Testing Set");
        jRadioButton.setSelected(true);
        jRadioButton.setActionCommand("r1");
        JRadioButton jRadioButton2 = new JRadioButton("Leave One Out Cross Validation");
        jRadioButton2.setActionCommand("r2");
        this.group = new ButtonGroup();
        this.group.add(jRadioButton);
        this.group.add(jRadioButton2);
        VoteActionListener voteActionListener = new VoteActionListener();
        jRadioButton.addActionListener(voteActionListener);
        jRadioButton2.addActionListener(voteActionListener);
        this.midPanel.add(new JLabel("Validation:", 2));
        this.midPanel.add(jRadioButton);
        this.midPanel.add(jRadioButton2);
        this.jcb = new JCheckBox("Apply All Values in Vigilance Spectrum");
        this.jcb.setSelected(false);
        this.jcb.setActionCommand("vigilance_spectrum");
        this.jcb.addActionListener(new CheckBoxActionListener());
        this.midPanel.add(this.jcb);
        this.vigPanel = new JPanel(new FlowLayout(0));
        this.slider = new JSlider();
        this.slider.setPaintLabels(true);
        this.slider.setPaintTicks(true);
        this.slider.setMajorTickSpacing(10);
        this.slider.setMinorTickSpacing(1);
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        hashtable.put(new Integer(0), new JLabel("0.0"));
        hashtable.put(new Integer(10), new JLabel("0.1"));
        hashtable.put(new Integer(20), new JLabel("0.2"));
        hashtable.put(new Integer(30), new JLabel("0.3"));
        hashtable.put(new Integer(40), new JLabel("0.4"));
        hashtable.put(new Integer(50), new JLabel("0.5"));
        hashtable.put(new Integer(60), new JLabel("0.6"));
        hashtable.put(new Integer(70), new JLabel("0.7"));
        hashtable.put(new Integer(80), new JLabel("0.8"));
        hashtable.put(new Integer(90), new JLabel("0.9"));
        hashtable.put(new Integer(100), new JLabel("1.0"));
        this.slider.setLabelTable(hashtable);
        this.slider.setSnapToTicks(true);
        this.slider.setPreferredSize(new Dimension(700, 45));
        this.vigPanel.add(new JLabel("Vigilance:", 2));
        this.vigPanel.add(this.slider);
        this.jtf = new JTextField(8);
        this.jtf.setText("" + (double)this.slider.getValue() / 100.0);
        this.vigPanel.add(this.jtf);
        this.slider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                JSlider jSlider = (JSlider)changeEvent.getSource();
                ParameterPane.this.jtf.setText("" + (double)jSlider.getValue() / 100.0);
            }
        });
        this.labelPane.add(this.midPanel);
        this.labelPane.add(this.vigPanel);
        this.ssp = new SampleSelectionPanel(vector, new Vector(), new Vector(), vector2);
        this.ssp.createCenterPanel();
        this.combineScroll = new JScrollPane(this.ssp);
        this.jsp1 = new JSplitPane(0, this.labelPane, this.combineScroll);
        this.jsp1.setDividerSize(4);
        this.jsp1.setContinuousLayout(true);
        this.jsp1.setDividerLocation(160);
        this.jp.add(this.jsp1);
    }

    public static ParameterPane getInstance() {
        if (instance == null) {
            instance = new ParameterPane();
        }
        return instance;
    }

    public JPanel getPanel() {
        return this.jp;
    }

    class VoteActionListener
    implements ActionListener {
        VoteActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = ParameterPane.this.group.getSelection().getActionCommand();
            if (string.equals("r2")) {
                ParameterPane.this.jp.removeAll();
                ParameterPane.this.jp.add(ParameterPane.this.labelPane);
                ParameterPane.this.jp.validate();
                ParameterPane.this.jp.repaint();
                MainGUI mainGUI = MainGUI.getInstance();
                mainGUI.validate();
                mainGUI.repaint();
            } else if (string.equals("r1")) {
                ParameterPane.this.jp.removeAll();
                ParameterPane.this.jsp1 = new JSplitPane(0, ParameterPane.this.labelPane, ParameterPane.this.combineScroll);
                ParameterPane.this.jsp1.setDividerSize(4);
                ParameterPane.this.jsp1.setContinuousLayout(true);
                ParameterPane.this.jsp1.setDividerLocation(160);
                ParameterPane.this.jp.add(ParameterPane.this.jsp1);
                ParameterPane.this.jp.validate();
                ParameterPane.this.jp.repaint();
                MainGUI mainGUI = MainGUI.getInstance();
                mainGUI.validate();
                mainGUI.repaint();
            }
        }
    }

    class CheckBoxActionListener
    implements ActionListener {
        CheckBoxActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
            boolean bl = jCheckBox.isSelected();
            if (bl) {
                ParameterPane.this.vigPanel.setVisible(false);
                ParameterPane.this.labelPane.validate();
                ParameterPane.this.labelPane.repaint();
                MainGUI mainGUI = MainGUI.getInstance();
                mainGUI.validate();
                mainGUI.repaint();
            } else {
                ParameterPane.this.vigPanel.setVisible(true);
                ParameterPane.this.labelPane.validate();
                ParameterPane.this.labelPane.repaint();
                MainGUI mainGUI = MainGUI.getInstance();
                mainGUI.validate();
                mainGUI.repaint();
            }
        }
    }
}

