/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.File;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JFrame;

public final class MainGUI
extends JFrame {
    public static int WIDTH = 1024;
    public static int HEIGHT = 768;
    private static MainGUI instance = null;
    public static File _cwd = null;
    private MenuBar menuBar;

    private MainGUI() {
    }

    public void setCurrentDirectory() {
        _cwd = new File(".");
    }

    public static MainGUI getInstance() {
        if (instance == null) {
            instance = new MainGUI();
        }
        return instance;
    }

    public void setupGUI() {
        this.setCurrentDirectory();
        try {
            this.setDefaultCloseOperation(3);
            this.setTitle("  Expression Predictor");
            URL uRL = this.getClass().getResource("ExPIcon.gif");
            ImageIcon imageIcon = new ImageIcon(uRL);
            this.setIconImage(imageIcon.getImage());
            this.menuBar = new MenuBar(this.getInstance());
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            if (WIDTH >= dimension.width || HEIGHT >= dimension.height) {
                WIDTH = (int)dimension.getWidth() - 50;
                HEIGHT = (int)dimension.getHeight() - 150;
            }
            this.setSize(WIDTH, HEIGHT);
            this.setLocation(dimension.width / 2 - WIDTH / 2, dimension.height / 2 - HEIGHT / 2);
            this.setJMenuBar(this.menuBar);
            this.setVisible(true);
            this.validate();
            this.repaint();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        try {
            SplashScreen splashScreen = new SplashScreen();
            MainGUI mainGUI = MainGUI.getInstance();
            mainGUI.setupGUI();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }
}

