/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.util.Vector;

public class FuzzyArtMap {
    private int predict_category;
    private int desired_category;
    private BufferedReader in;
    private FUZZYARTMAPDataHolder sdh;
    private IO myIO;
    private String bString;
    private boolean reallocate = true;
    int tmpR;
    int tmpC;

    public FuzzyArtMap(FUZZYARTMAPDataHolder fUZZYARTMAPDataHolder, IO iO) {
        this.sdh = fUZZYARTMAPDataHolder;
        this.myIO = iO;
    }

    public void normalize() {
        for (int i = 0; i < this.sdh.getA_length(); ++i) {
            int n;
            float f = -9999.0f;
            float f2 = 9999.0f;
            for (n = 0; n < this.sdh.getNum_pats(); ++n) {
                if (this.sdh.dpt[n][i] == -1.0f) continue;
                if (this.sdh.dpt[n][i] > f) {
                    f = this.sdh.dpt[n][i];
                }
                if (!(this.sdh.dpt[n][i] < f2)) continue;
                f2 = this.sdh.dpt[n][i];
            }
            if (f == f2) {
                for (n = 0; n < this.sdh.getNum_pats(); ++n) {
                    if (this.sdh.dpt[n][i] == -1.0f) continue;
                    this.sdh.dpt[n][i] = 1.0f;
                }
                continue;
            }
            for (n = 0; n < this.sdh.getNum_pats(); ++n) {
                if (this.sdh.dpt[n][i] == -1.0f) continue;
                this.sdh.dpt[n][i] = (this.sdh.dpt[n][i] - f2) / (f - f2);
            }
        }
    }

    public void init_series() {
        int n;
        this.sdh.min_times_through_training = 100;
        this.sdh.max_times_through_training = 0;
        this.sdh.tot_times_through_training = 0;
        this.sdh.tot_committed_nodes = 0;
        this.sdh.min_committed_node = 99999;
        this.sdh.max_committed_node = -1;
        this.sdh.min_rate_on_test = 100.0f;
        this.sdh.max_rate_on_test = 0.0f;
        this.sdh.tot_no_prediction = 0;
        this.sdh.sum_rate_on_test = 0.0f;
        this.sdh.sum_sq_rate_on_test = 0.0f;
        for (n = 0; n < this.sdh.getNum_voters(); ++n) {
            for (int i = 0; i < 2; ++i) {
                for (int j = 0; j < this.sdh.getNum_data_category(); ++j) {
                    this.sdh.right_wrong[n][i][j] = 0;
                }
            }
        }
        for (n = 0; n < this.sdh.getNum_voters(); ++n) {
            this.sdh.sum_rate[n] = 0.0f;
            this.sdh.sum_sq_rate[n] = 0.0f;
        }
        if (this.sdh.getDisplay_confusion_matrix()) {
            for (n = 0; n < this.sdh.getNum_voters(); ++n) {
                for (int i = 0; i < this.sdh.getNum_data_category() + 1; ++i) {
                    for (int j = 0; j < this.sdh.getNum_data_category(); ++j) {
                        this.sdh.p_table[n][i][j] = 0;
                    }
                }
            }
        }
    }

    public String pre_scan_data() {
        int n;
        String string = "";
        for (n = 0; n < this.sdh.getTot_pats(); ++n) {
            this.sdh.Index[n] = n;
        }
        for (n = 0; n <= this.sdh.getNum_data_category(); ++n) {
            this.sdh.frequency[n] = 0;
        }
        for (n = 0; n < this.sdh.getTot_pats(); ++n) {
            string = string + this.myIO.read_pattern(n);
            float[][] fArray = this.sdh.pattern;
            this.sdh.getClass();
            int n2 = this.data_category(fArray[1], this.sdh.getB_length(), n);
            string = string + this.bString;
            this.bString = "";
            if (n2 == -1) {
                n2 = this.sdh.getNum_data_category();
            }
            int n3 = n2;
            this.sdh.frequency[n3] = this.sdh.frequency[n3] + 1;
        }
        string = string + "Number of Data Category = " + this.sdh.getNum_data_category() + "\n";
        for (n = 0; n < this.sdh.getNum_data_category(); ++n) {
            string = string + "Frequency of Category " + (n + 1) + " = " + this.sdh.frequency[n] + "\n";
        }
        string = string + "\n";
        this.sdh.free_memory();
        return string;
    }

    private int data_category(float[] fArray, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        this.bString = "";
        for (int i = 0; i < n; ++i) {
            if (!((double)fArray[i] > 0.5)) continue;
            n4 = i;
            ++n3;
        }
        if (n3 == 1) {
            return n4;
        }
        this.bString = this.bString + "Warning: Error in class of pattern " + n2 + "\n";
        return -1;
    }

    public void setup_index(int n) {
        for (int i = 0; i < n; ++i) {
            int n2 = (int)(Math.random() * (double)this.sdh.RAND_MAX % (double)n);
            int n3 = this.sdh.Index[i];
            this.sdh.Index[i] = this.sdh.Index[n2];
            this.sdh.Index[n2] = n3;
        }
    }

    public void init_votes() {
        for (int i = 0; i < this.sdh.getTest_pats(); ++i) {
            for (int j = 0; j <= this.sdh.getNum_data_category(); ++j) {
                this.sdh.num_votes[i][j] = 0;
            }
            this.sdh.actual_category[i] = 0;
        }
    }

    public void init_ARTMAP() {
        int n = 0;
        while (true) {
            int[] nArray = this.sdh.num_category;
            this.sdh.getClass();
            if (n >= nArray[0] + 1) break;
            this.sdh.confidence[n] = 1.0f;
            this.sdh.makes_prediction[n] = false;
            int n2 = 0;
            while (true) {
                int[] nArray2 = this.sdh.num_category;
                this.sdh.getClass();
                if (n2 >= nArray2[1] + 1) break;
                this.sdh.IAMI[n][n2] = 0;
                ++n2;
            }
            ++n;
        }
    }

    void init_ARTs() {
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < this.sdh.num_category[i] + 1; ++j) {
                this.sdh.committed[i][j] = false;
                for (int k = 0; k < this.sdh.num_att[i]; ++k) {
                    this.sdh.dn[i][j][k] = this.sdh.getDnInit();
                }
            }
        }
        float[] fArray = this.sdh.rho;
        this.sdh.getClass();
        fArray[0] = this.sdh.getMin_arho();
        float[] fArray2 = this.sdh.rho;
        this.sdh.getClass();
        fArray2[1] = this.sdh.getBrho();
    }

    void init_ARTB() {
        this.sdh.refresh_F2();
        if (this.sdh.getTwo_binary_categories()) {
            this.sdh.pattern[1][0] = 0.0f;
            this.sdh.pattern[1][1] = 1.0f;
            this.sdh.getClass();
            this.B_only(0);
            this.sdh.pattern[1][0] = 1.0f;
            this.sdh.pattern[1][1] = 0.0f;
            this.sdh.getClass();
            this.B_only(0);
        } else {
            for (int i = 0; i < this.sdh.getB_length(); ++i) {
                for (int j = 0; j < this.sdh.getB_length(); ++j) {
                    this.sdh.pattern[1][j] = 0.0f;
                    if (!this.sdh.getComplement()) continue;
                    this.sdh.pattern[1][j + this.sdh.getB_length()] = 1.0f;
                }
                this.sdh.pattern[1][i] = 1.0f;
                if (this.sdh.getComplement()) {
                    this.sdh.pattern[1][i + this.sdh.getB_length()] = 0.0f;
                }
                this.sdh.getClass();
                this.B_only(0);
            }
        }
    }

    public void B_only(int n) {
        this.sdh.getClass();
        if (n == 0 && this.reallocate) {
            this.sdh.getClass();
            this.sdh.getClass();
            this.sdh.getClass();
            this.learn(1, this.ART(1, 0));
        }
    }

    public void learn(int n, int n2) {
        if (!this.reallocate) {
            return;
        }
        float f = this.sdh.committed[n][n2] ? this.sdh.getRate() : 1.0f;
        if (!this.sdh.getNo_learn_if_wrong() || this.sdh.wrong) {
            for (int i = 0; i < this.sdh.num_att[n]; ++i) {
                if (!(this.sdh.pattern[n][i] < this.sdh.dn[n][n2][i])) continue;
                this.sdh.dn[n][n2][i] = (1.0f - f) * this.sdh.dn[n][n2][i] + f * this.sdh.pattern[n][i];
            }
        }
        this.sdh.committed[n][n2] = true;
    }

    public String process() {
        int n;
        boolean bl = false;
        String string = "";
        String string2 = "";
        this.sdh.times_through_training = 0;
        boolean bl2 = false;
        if (this.sdh.selectTrainSet != null) {
            bl2 = true;
        }
        while (!bl) {
            this.sdh.num_wrong = 0;
            this.sdh.num_right = 0;
            this.sdh.num_perfect_mismatch = 0;
            this.sdh.num_no_prediction = 0;
            bl = true;
            this.sdh.got_all_train_right = true;
            if (this.sdh.getTrace() >= 1) {
                string = string + "-- Learning Iteration " + (this.sdh.times_through_training + 1) + "\n";
            }
            for (n = 0; n < this.sdh.getTrain_pats(); ++n) {
                this.sdh.refresh_system();
                if (bl2) {
                    string = string + this.myIO.read_pattern(this.sdh.selectTrainSet[n] - 1);
                    this.sdh.getClass();
                    this.predict_category = this.B_then_A(0, this.sdh.selectTrainSet[n] - 1);
                    string = string + this.bString;
                    this.bString = "";
                    if (this.sdh.no_prediction) {
                        string = string + this.sdh.printSlide[this.sdh.selectTrainSet[n] - 1] + " has no prediction.\n\n";
                    } else if (this.sdh.wrong) {
                        string = string + this.sdh.printSlide[this.sdh.selectTrainSet[n] - 1] + " has wrong prediction as " + (String)this.sdh.arraySet[this.predict_category] + ".\n\n";
                    }
                } else {
                    string = string + this.myIO.read_pattern(n);
                    this.sdh.getClass();
                    this.predict_category = this.B_then_A(0, n);
                    string = string + this.bString;
                    this.bString = "";
                    if (this.sdh.no_prediction) {
                        string = string + this.sdh.printSlide[n] + " has no prediction.\n\n";
                    } else if (this.sdh.wrong) {
                        string = string + this.sdh.printSlide[n] + " has wrong prediction as " + (String)this.sdh.arraySet[this.predict_category] + ".\n\n";
                    }
                }
                this.record_train_performance(this.predict_category);
            }
            if (this.sdh.getTrace() >= 1) {
                string = string + this.myIO.report_train_performance();
            }
            ++this.sdh.times_through_training;
            if (this.sdh.getOn_line()) continue;
            if (this.sdh.times_through_training < this.sdh.getMax_iterations() && this.sdh.num_right + this.sdh.num_perfect_mismatch != this.sdh.getTrain_pats()) {
                bl = false;
                continue;
            }
            if (this.sdh.num_right == this.sdh.getTrain_pats()) continue;
            string2 = string2 + "WARNING : Training stopped when 100%% recognition not achieved\n\n";
        }
        if (this.sdh.getTrace() >= 1) {
            string = string + "\n\nTesting ...\n\n";
        }
        this.sdh.num_wrong = 0;
        this.sdh.num_right = 0;
        this.sdh.num_perfect_mismatch = 0;
        this.sdh.num_no_prediction = 0;
        for (n = 0; n < this.sdh.getTest_pats(); ++n) {
            this.sdh.refresh_system();
            if (bl2) {
                string = string + this.myIO.read_pattern(this.sdh.selectTestSet[n] - 1);
                this.sdh.getClass();
                this.predict_category = this.B_then_A(1, this.sdh.selectTestSet[n] - 1);
                string = string + this.bString;
                this.bString = "";
                if (this.sdh.no_prediction) {
                    string = string + this.sdh.printSlide[this.sdh.selectTestSet[n] - 1] + " has no prediction.\n";
                } else if (this.sdh.wrong) {
                    string = string + this.sdh.printSlide[this.sdh.selectTestSet[n] - 1] + " has wrong prediction as " + (String)this.sdh.arraySet[this.predict_category] + ".\n";
                }
            } else {
                string = string + this.myIO.read_pattern(n + this.sdh.getTrain_pats());
                this.sdh.getClass();
                this.predict_category = this.B_then_A(1, n);
                string = string + this.bString;
                this.bString = "";
                if (this.sdh.no_prediction) {
                    string = string + this.sdh.printSlide[n + this.sdh.getTrain_pats()] + " has no prediction.\n";
                } else if (this.sdh.wrong) {
                    string = string + this.sdh.printSlide[n + this.sdh.getTrain_pats()] + " has wrong prediction as " + (String)this.sdh.arraySet[this.predict_category] + ".\n";
                }
            }
            string = string + this.record_test_performance(n, this.predict_category);
            int[] nArray = this.sdh.actual_category;
            this.sdh.getClass();
            this.sdh.getClass();
            nArray[n] = this.ART(1, 1);
            if (this.reallocate) continue;
            return "There is in realloc_memory.\n";
        }
        if (this.sdh.getTrace() >= 1) {
            string = string + this.myIO.report_test_performance();
        }
        this.collect_statistics();
        if (this.sdh.getTrace_weight()) {
            string = string + this.myIO.display_weight();
        }
        this.myIO.output_detail = this.myIO.output_detail + string;
        return string2;
    }

    public String processSpectrum() {
        int n;
        boolean bl = false;
        String string = "";
        this.sdh.times_through_training = 0;
        boolean bl2 = false;
        if (this.sdh.selectTrainSet != null) {
            bl2 = true;
        }
        while (!bl) {
            this.sdh.num_wrong = 0;
            this.sdh.num_right = 0;
            this.sdh.num_perfect_mismatch = 0;
            this.sdh.num_no_prediction = 0;
            bl = true;
            this.sdh.got_all_train_right = true;
            for (n = 0; n < this.sdh.getTrain_pats(); ++n) {
                this.sdh.refresh_system();
                if (bl2) {
                    this.myIO.read_pattern(this.sdh.selectTrainSet[n] - 1);
                    this.sdh.getClass();
                    this.predict_category = this.B_then_A(0, this.sdh.selectTrainSet[n] - 1);
                } else {
                    this.myIO.read_pattern(n);
                    this.sdh.getClass();
                    this.predict_category = this.B_then_A(0, n);
                    this.bString = "";
                }
                this.record_train_performance(this.predict_category);
            }
            ++this.sdh.times_through_training;
            if (this.sdh.getOn_line()) continue;
            if (this.sdh.times_through_training < this.sdh.getMax_iterations() && this.sdh.num_right + this.sdh.num_perfect_mismatch != this.sdh.getTrain_pats()) {
                bl = false;
                continue;
            }
            if (this.sdh.num_right == this.sdh.getTrain_pats()) continue;
            string = string + "WARNING : Training stopped when 100%% recognition not achieved\n\n";
        }
        this.sdh.num_wrong = 0;
        this.sdh.num_right = 0;
        this.sdh.num_perfect_mismatch = 0;
        this.sdh.num_no_prediction = 0;
        for (n = 0; n < this.sdh.getTest_pats(); ++n) {
            this.sdh.refresh_system();
            if (bl2) {
                this.myIO.read_pattern(this.sdh.selectTestSet[n] - 1);
                this.sdh.getClass();
                this.predict_category = this.B_then_A(1, this.sdh.selectTestSet[n] - 1);
            } else {
                this.myIO.read_pattern(n + this.sdh.getTrain_pats());
                this.sdh.getClass();
                this.predict_category = this.B_then_A(1, n);
            }
            this.record_test_performance(n, this.predict_category);
            int[] nArray = this.sdh.actual_category;
            this.sdh.getClass();
            this.sdh.getClass();
            nArray[n] = this.ART(1, 1);
            if (this.reallocate) continue;
            return "There is in realloc_memory.\n";
        }
        this.collect_statistics();
        if (this.sdh.getTrace_weight()) {
            this.myIO.display_weight();
        }
        return string;
    }

    public String processTT(PredictionTracker predictionTracker, Vector vector, int n) {
        int n2;
        boolean bl = false;
        String string = "";
        String string2 = "";
        this.sdh.times_through_training = 0;
        boolean bl2 = false;
        if (this.sdh.selectTrainSet != null) {
            bl2 = true;
        }
        while (!bl) {
            this.sdh.num_wrong = 0;
            this.sdh.num_right = 0;
            this.sdh.num_perfect_mismatch = 0;
            this.sdh.num_no_prediction = 0;
            bl = true;
            this.sdh.got_all_train_right = true;
            if (this.sdh.getTrace() >= 1) {
                string = string + "-- Learning Iteration " + (this.sdh.times_through_training + 1) + "\n";
            }
            for (n2 = 0; n2 < this.sdh.getTrain_pats(); ++n2) {
                this.sdh.refresh_system();
                if (bl2) {
                    string = string + this.myIO.read_pattern(this.sdh.selectTrainSet[n2] - 1);
                    this.sdh.getClass();
                    this.predict_category = this.B_then_A(0, this.sdh.selectTrainSet[n2] - 1);
                    string = string + this.bString;
                    this.bString = "";
                    if (this.sdh.no_prediction) {
                        string = string + this.sdh.printSlide[this.sdh.selectTrainSet[n2] - 1] + " has no prediction.\n\n";
                    } else if (this.sdh.wrong) {
                        string = string + this.sdh.printSlide[this.sdh.selectTrainSet[n2] - 1] + " has wrong prediction as " + (String)this.sdh.arraySet[this.predict_category] + ".\n\n";
                    }
                } else {
                    string = string + this.myIO.read_pattern(n2);
                    this.sdh.getClass();
                    this.predict_category = this.B_then_A(0, n2);
                    string = string + this.bString;
                    this.bString = "";
                    if (this.sdh.no_prediction) {
                        string = string + this.sdh.printSlide[n2] + " has no prediction.\n\n";
                    } else if (this.sdh.wrong) {
                        string = string + this.sdh.printSlide[n2] + " has wrong prediction as " + (String)this.sdh.arraySet[this.predict_category] + ".\n\n";
                    }
                }
                this.record_train_performance(this.predict_category);
            }
            if (this.sdh.getTrace() >= 1) {
                string = string + this.myIO.report_train_performance();
            }
            ++this.sdh.times_through_training;
            if (this.sdh.getOn_line()) continue;
            if (this.sdh.times_through_training < this.sdh.getMax_iterations() && this.sdh.num_right + this.sdh.num_perfect_mismatch != this.sdh.getTrain_pats()) {
                bl = false;
                continue;
            }
            if (this.sdh.num_right == this.sdh.getTrain_pats()) continue;
            string2 = string2 + "WARNING : Training stopped when 100%% recognition not achieved\n\n";
        }
        if (this.sdh.getTrace() >= 1) {
            string = string + "\n\nTesting ...\n\n";
        }
        this.sdh.num_wrong = 0;
        this.sdh.num_right = 0;
        this.sdh.num_perfect_mismatch = 0;
        this.sdh.num_no_prediction = 0;
        for (n2 = 0; n2 < this.sdh.getTest_pats(); ++n2) {
            this.sdh.refresh_system();
            if (bl2) {
                string = string + this.myIO.read_pattern(this.sdh.selectTestSet[n2] - 1);
                this.sdh.getClass();
                this.predict_category = this.B_then_A(1, this.sdh.selectTestSet[n2] - 1);
                string = string + this.bString;
                this.bString = "";
                Vector vector2 = (Vector)vector.get(n2);
                String string3 = (String)vector2.get(2);
                this.tmpC = predictionTracker.locateColumn(string3);
                if (this.sdh.no_prediction) {
                    string = string + this.sdh.printSlide[this.sdh.selectTestSet[n2] - 1] + " has no prediction.\n";
                    this.tmpR = predictionTracker.locateNoPredRow();
                } else if (this.sdh.wrong) {
                    string = string + this.sdh.printSlide[this.sdh.selectTestSet[n2] - 1] + " has wrong prediction as " + (String)this.sdh.arraySet[this.predict_category] + ".\n";
                    this.tmpR = this.predict_category;
                } else {
                    this.tmpR = this.tmpC;
                }
                if (n == 1 && this.tmpC != -1) {
                    predictionTracker.update_prediction(this.tmpR, this.tmpC, (Vector)vector.get(n2));
                }
            } else {
                string = string + this.myIO.read_pattern(n2 + this.sdh.getTrain_pats());
                this.sdh.getClass();
                this.predict_category = this.B_then_A(1, n2);
                string = string + this.bString;
                this.bString = "";
                if (this.sdh.no_prediction) {
                    string = string + this.sdh.printSlide[n2 + this.sdh.getTrain_pats()] + " has no prediction.\n";
                } else if (this.sdh.wrong) {
                    string = string + this.sdh.printSlide[n2 + this.sdh.getTrain_pats()] + " has wrong prediction as " + (String)this.sdh.arraySet[this.predict_category] + ".\n";
                }
            }
            string = string + this.record_test_performance(n2, this.predict_category);
            int[] nArray = this.sdh.actual_category;
            this.sdh.getClass();
            this.sdh.getClass();
            nArray[n2] = this.ART(1, 1);
            if (this.reallocate) continue;
            return "There is in realloc_memory.\n";
        }
        if (this.sdh.getTrace() >= 1) {
            string = string + this.myIO.report_test_performance();
        }
        this.collect_statistics();
        if (this.sdh.getTrace_weight()) {
            string = string + this.myIO.display_weight();
        }
        this.myIO.output_detail = this.myIO.output_detail + string;
        return string2;
    }

    public String processTTSpectrum(PredictionTracker predictionTracker, Vector vector, int n) {
        int n2;
        boolean bl = false;
        String string = "";
        this.sdh.times_through_training = 0;
        boolean bl2 = false;
        if (this.sdh.selectTrainSet != null) {
            bl2 = true;
        }
        while (!bl) {
            this.sdh.num_wrong = 0;
            this.sdh.num_right = 0;
            this.sdh.num_perfect_mismatch = 0;
            this.sdh.num_no_prediction = 0;
            bl = true;
            this.sdh.got_all_train_right = true;
            for (n2 = 0; n2 < this.sdh.getTrain_pats(); ++n2) {
                this.sdh.refresh_system();
                if (bl2) {
                    this.myIO.read_pattern(this.sdh.selectTrainSet[n2] - 1);
                    this.sdh.getClass();
                    this.predict_category = this.B_then_A(0, this.sdh.selectTrainSet[n2] - 1);
                } else {
                    this.myIO.read_pattern(n2);
                    this.sdh.getClass();
                    this.predict_category = this.B_then_A(0, n2);
                }
                this.record_train_performance(this.predict_category);
            }
            if (this.sdh.getTrace() >= 1) {
                this.myIO.report_train_performance();
            }
            ++this.sdh.times_through_training;
            if (this.sdh.getOn_line()) continue;
            if (this.sdh.times_through_training < this.sdh.getMax_iterations() && this.sdh.num_right + this.sdh.num_perfect_mismatch != this.sdh.getTrain_pats()) {
                bl = false;
                continue;
            }
            if (this.sdh.num_right == this.sdh.getTrain_pats()) continue;
            string = string + "WARNING : Training stopped when 100%% recognition not achieved\n\n";
        }
        this.sdh.num_wrong = 0;
        this.sdh.num_right = 0;
        this.sdh.num_perfect_mismatch = 0;
        this.sdh.num_no_prediction = 0;
        for (n2 = 0; n2 < this.sdh.getTest_pats(); ++n2) {
            this.sdh.refresh_system();
            if (bl2) {
                this.myIO.read_pattern(this.sdh.selectTestSet[n2] - 1);
                this.sdh.getClass();
                this.predict_category = this.B_then_A(1, this.sdh.selectTestSet[n2] - 1);
                Vector vector2 = (Vector)vector.get(n2);
                String string2 = (String)vector2.get(2);
                this.tmpC = predictionTracker.locateColumn(string2);
                this.tmpR = this.sdh.no_prediction ? predictionTracker.locateNoPredRow() : (this.sdh.wrong ? this.predict_category : this.tmpC);
                if (n == 1 && this.tmpC != -1) {
                    predictionTracker.update_prediction(this.tmpR, this.tmpC, (Vector)vector.get(n2));
                }
            } else {
                this.myIO.read_pattern(n2 + this.sdh.getTrain_pats());
                this.sdh.getClass();
                this.predict_category = this.B_then_A(1, n2);
            }
            this.record_test_performance(n2, this.predict_category);
            int[] nArray = this.sdh.actual_category;
            this.sdh.getClass();
            this.sdh.getClass();
            nArray[n2] = this.ART(1, 1);
            if (this.reallocate) continue;
            return "There is in realloc_memory.\n";
        }
        if (this.sdh.getTrace() >= 1) {
            this.myIO.report_test_performance();
        }
        this.collect_statistics();
        if (this.sdh.getTrace_weight()) {
            this.myIO.display_weight();
        }
        return string;
    }

    public String train_process() {
        boolean bl = false;
        String string = "";
        this.sdh.times_through_training = 0;
        boolean bl2 = false;
        if (this.sdh.selectTrainSet != null) {
            bl2 = true;
        }
        while (!bl) {
            this.sdh.num_wrong = 0;
            this.sdh.num_right = 0;
            this.sdh.num_perfect_mismatch = 0;
            this.sdh.num_no_prediction = 0;
            bl = true;
            this.sdh.got_all_train_right = true;
            if (this.sdh.getTrace() >= 1) {
                string = string + "-- Learning Iteration " + (this.sdh.times_through_training + 1) + "\n";
            }
            for (int i = 0; i < this.sdh.getTrain_pats(); ++i) {
                this.sdh.refresh_system();
                if (bl2) {
                    string = string + this.myIO.read_pattern(this.sdh.selectTrainSet[i] - 1);
                    this.sdh.getClass();
                    this.predict_category = this.B_then_A(0, this.sdh.selectTrainSet[i] - 1);
                    string = string + this.bString;
                    this.bString = "";
                    if (this.sdh.no_prediction) {
                        string = string + this.sdh.printSlide[this.sdh.selectTrainSet[i] - 1] + " has no prediction.\n";
                    } else if (this.sdh.wrong) {
                        string = string + this.sdh.printSlide[this.sdh.selectTrainSet[i] - 1] + " has wrong prediction as " + (String)this.sdh.arraySet[this.predict_category] + ".\n";
                    }
                } else {
                    string = string + this.myIO.read_pattern(i);
                    this.sdh.getClass();
                    this.predict_category = this.B_then_A(0, i);
                    string = string + this.bString;
                    this.bString = "";
                    if (this.sdh.no_prediction) {
                        string = string + this.sdh.printSlide[i] + " has no prediction.\n";
                    } else if (this.sdh.wrong) {
                        string = string + this.sdh.printSlide[i] + " has wrong prediction as " + (String)this.sdh.arraySet[this.predict_category] + ".\n";
                    }
                }
                this.record_train_performance(this.predict_category);
            }
            if (this.sdh.getTrace() >= 1) {
                string = string + this.myIO.report_train_performance();
            }
            ++this.sdh.times_through_training;
            if (this.sdh.getOn_line()) continue;
            if (this.sdh.times_through_training < this.sdh.getMax_iterations() && this.sdh.num_right + this.sdh.num_perfect_mismatch != this.sdh.getTrain_pats()) {
                bl = false;
                continue;
            }
            if (this.sdh.num_right == this.sdh.getTrain_pats()) continue;
            string = string + "WARNING : Training stopped when 100%% recognition not achieved\n";
        }
        this.myIO.output_detail = this.myIO.output_detail + string;
        return string;
    }

    public String test_process() {
        boolean bl = false;
        String string = "";
        boolean bl2 = false;
        if (this.sdh.selectTrainSet != null) {
            bl2 = true;
        }
        if (this.sdh.getTrace() >= 1) {
            string = string + "Testing ...\n\n";
        }
        this.sdh.num_wrong = 0;
        this.sdh.num_right = 0;
        this.sdh.num_perfect_mismatch = 0;
        this.sdh.num_no_prediction = 0;
        for (int i = 0; i < this.sdh.getTest_pats(); ++i) {
            this.sdh.refresh_system();
            if (bl2) {
                string = string + this.myIO.read_pattern(this.sdh.selectTestSet[i] - 1);
                this.sdh.getClass();
                this.predict_category = this.B_then_A(1, this.sdh.selectTestSet[i] - 1);
                string = string + this.bString;
                this.bString = "";
            } else {
                string = string + this.myIO.read_pattern(i);
                this.sdh.getClass();
                this.predict_category = this.B_then_A(1, i);
                string = string + this.bString;
                this.bString = "";
            }
            string = string + this.record_test_performance(i, this.predict_category);
            int[] nArray = this.sdh.actual_category;
            this.sdh.getClass();
            this.sdh.getClass();
            nArray[i] = this.ART(1, 1);
            if (this.reallocate) continue;
            return "There is in realloc_memory.\n";
        }
        string = string + this.myIO.report_test_performance();
        this.myIO.output_detail = this.myIO.output_detail + string;
        return string;
    }

    public int B_then_A(int n, int n2) {
        this.bString = "";
        boolean bl = false;
        boolean bl2 = false;
        this.sdh.perfect_mismatch = false;
        if (this.sdh.getTrace() >= 2) {
            this.bString = this.bString + "Pattern " + n2 + " :\n";
        }
        this.sdh.getClass();
        int n3 = this.ART(1, n);
        this.sdh.getClass();
        if (n == 0) {
            this.sdh.getClass();
            this.learn(1, n3);
        }
        this.sdh.actual_result = n3;
        do {
            this.sdh.getClass();
            int n4 = this.ART(0, n);
            if (this.sdh.getTrace() >= 2) {
                this.bString = this.bString + "A_winner " + n4 + " B_winner " + n3 + "\n";
            }
            if (this.sdh.makes_prediction[n4]) {
                bl = true;
                this.sdh.no_prediction = false;
                for (int i = 0; i < this.sdh.num_category[1] + 1; ++i) {
                    if (this.sdh.IAMI[n4][i] != 1 || this.sdh.first_prediction != -1) continue;
                    this.sdh.first_prediction = i;
                }
                if (this.sdh.IAMI[n4][n3] == 1) {
                    if (this.sdh.getTrace() >= 2) {
                        this.bString = this.bString + "Expectation confirmed\n\n";
                    }
                    bl2 = false;
                    this.sdh.getClass();
                    if (n != 0) continue;
                    this.sdh.getClass();
                    this.learn(0, n4);
                    this.change_confidence(n4, 0, n);
                    continue;
                }
                if (this.sdh.getTrace() >= 2) {
                    this.bString = this.bString + "Expectation mismatched.\n";
                }
                bl2 = true;
                this.sdh.wrong = true;
                this.bString = this.bString + this.IA_reset(n4, n, n2);
                this.sdh.getClass();
                if (n != 0) continue;
                this.change_confidence(n4, 1, n);
                continue;
            }
            if (this.sdh.getTrace() >= 2) {
                this.bString = this.bString + "No prediction.\n";
            }
            this.sdh.wrong = true;
            bl = false;
            this.sdh.getClass();
            if (n != 0) continue;
            this.sdh.getClass();
            this.learn(0, n4);
            this.sdh.getClass();
            this.learn(1, n3);
            this.learn_prediction(n4, n3);
        } while (bl && bl2 && !this.sdh.perfect_mismatch);
        return this.sdh.first_prediction;
    }

    private int ART(int n, int n2) {
        int n3;
        boolean bl;
        int n4;
        for (n4 = 0; n4 <= this.sdh.num_category[n]; ++n4) {
            this.sdh.F2[n][n4] = this.choiceOrderFunction(n, n4);
        }
        do {
            float f = -1.0f;
            n3 = -1;
            for (n4 = 0; n4 <= this.sdh.num_category[n]; ++n4) {
                if (!(f < this.sdh.F2[n][n4])) continue;
                f = this.sdh.F2[n][n4];
                n3 = n4;
            }
        } while (bl = this.ARTreset(n, n3));
        if (n3 == this.sdh.num_category[n]) {
            this.sdh.getClass();
            if (n2 == 0) {
                int n5 = n;
                this.sdh.num_category[n5] = this.sdh.num_category[n5] + 1;
                if (!this.sdh.realloc_memory(n)) {
                    this.reallocate = false;
                }
            }
        }
        return n3;
    }

    private float choiceOrderFunction(int n, int n2) {
        if ((double)this.sdh.F2[n][n2] == -1.0) {
            return -1.0f;
        }
        float f = 0.0f;
        float f2 = 0.0f;
        for (int i = 0; i < this.sdh.num_att[n]; ++i) {
            f2 += this.sdh.dn[n][n2][i];
            if (this.sdh.pattern[n][i] < this.sdh.dn[n][n2][i]) {
                f += this.sdh.pattern[n][i];
                continue;
            }
            f += this.sdh.dn[n][n2][i];
        }
        return f / (f2 += this.sdh.getAlpha());
    }

    private boolean ARTreset(int n, int n2) {
        if (this.matchFunction(n, n2) < this.sdh.rho[n]) {
            this.sdh.F2[n][n2] = -1.0f;
            return true;
        }
        return false;
    }

    private float matchFunction(int n, int n2) {
        float f = 0.0f;
        float f2 = 0.0f;
        for (int i = 0; i < this.sdh.num_att[n]; ++i) {
            f2 += this.sdh.pattern[n][i];
            if (this.sdh.pattern[n][i] < this.sdh.dn[n][n2][i]) {
                f += this.sdh.pattern[n][i];
                continue;
            }
            f += this.sdh.dn[n][n2][i];
        }
        return f / f2;
    }

    public void change_confidence(int n, int n2, int n3) {
        this.sdh.getClass();
        if (n3 == 0) {
            float f = this.sdh.getNoise_rate() * (1.0f - this.sdh.confidence[n] - (float)n2);
            this.sdh.confidence[n] = f + this.sdh.confidence[n];
            if (this.sdh.confidence[n] < this.sdh.getNoise_tolerance()) {
                this.destroy(n);
            }
        }
    }

    private void destroy(int n) {
        int n2 = 0;
        while (true) {
            int[] nArray = this.sdh.num_att;
            this.sdh.getClass();
            if (n2 >= nArray[0]) break;
            float[][][] fArray = this.sdh.dn;
            this.sdh.getClass();
            fArray[0][n][n2] = this.sdh.getDnInit();
            ++n2;
        }
        n2 = 0;
        while (true) {
            int[] nArray = this.sdh.num_category;
            this.sdh.getClass();
            if (n2 >= nArray[1] + 1) break;
            this.sdh.IAMI[n][n2] = 0;
            ++n2;
        }
        this.sdh.confidence[n] = 1.0f;
        this.sdh.makes_prediction[n] = false;
        boolean[][] blArray = this.sdh.committed;
        this.sdh.getClass();
        blArray[0][n] = false;
    }

    public String IA_reset(int n, int n2, int n3) {
        boolean bl = false;
        String string = "";
        this.sdh.wrong = true;
        if (this.sdh.getTrack_on_choice()) {
            this.sdh.getClass();
            if ((double)this.choiceOrderFunction(0, n) >= 0.99) {
                bl = true;
            }
        }
        this.sdh.getClass();
        float f = this.matchFunction(0, n);
        if (this.sdh.getTrack_on_choice()) {
            if (bl && this.sdh.rho[0] < f + this.sdh.getEpsilon()) {
                this.sdh.rho[0] = f + this.sdh.getEpsilon();
            }
        } else if (this.sdh.rho[0] < f + this.sdh.getEpsilon()) {
            this.sdh.rho[0] = f + this.sdh.getEpsilon();
        }
        if ((double)this.sdh.rho[0] >= 1.0) {
            this.sdh.perfect_mismatch = true;
            int n4 = n3 + 1;
            string = string + "WARNING: PERFECT_MISMATCH ON PATTERN " + n4 + " : " + (this.sdh.Index[n3] + 1) + "\n";
            ++this.sdh.num_perfect_mismatch;
        } else {
            this.sdh.getClass();
            if (n2 == 0) {
                this.sdh.got_all_train_right = false;
            }
            this.sdh.F2[0][n] = -1.0f;
        }
        return string;
    }

    public void learn_prediction(int n, int n2) {
        for (int i = 0; i < this.sdh.num_category[1] + 1; ++i) {
            this.sdh.IAMI[n][i] = 0;
        }
        this.sdh.IAMI[n][n2] = 1;
        this.sdh.makes_prediction[n] = true;
    }

    public void record_train_performance() {
        if (this.sdh.no_prediction) {
            ++this.sdh.num_no_prediction;
        } else if (this.sdh.wrong) {
            ++this.sdh.num_wrong;
        } else {
            ++this.sdh.num_right;
        }
    }

    public void record_train_performance(int n) {
        this.record_train_performance();
    }

    public String record_test_performance(int n, int n2) {
        String string = "";
        if (this.sdh.no_prediction) {
            if (n2 != -1) {
                string = string + "Error\n";
            }
            ++this.sdh.num_no_prediction;
            this.sdh.num_votes[n][this.sdh.getNum_data_category()] = this.sdh.getNum_voters() + 1;
        } else {
            this.sdh.num_votes[n][n2] = this.sdh.getNum_voters() + 1;
            if (this.sdh.wrong) {
                ++this.sdh.num_wrong;
            } else {
                ++this.sdh.num_right;
            }
        }
        return string;
    }

    public void collect_statistics() {
        this.sdh.tot_times_through_training += this.sdh.times_through_training;
        if (this.sdh.times_through_training > this.sdh.max_times_through_training) {
            this.sdh.max_times_through_training = this.sdh.times_through_training;
        }
        if (this.sdh.times_through_training < this.sdh.min_times_through_training) {
            this.sdh.min_times_through_training = this.sdh.times_through_training;
        }
        if (this.sdh.min_committed_node > this.sdh.num_category[0]) {
            this.sdh.min_committed_node = this.sdh.num_category[0];
        }
        if (this.sdh.max_committed_node < this.sdh.num_category[0]) {
            this.sdh.max_committed_node = this.sdh.num_category[0];
        }
        this.sdh.tot_committed_nodes += this.sdh.num_category[0];
        float f = (float)(100 * this.sdh.num_right) / (float)this.sdh.getTest_pats();
        this.sdh.sum_rate_on_test += f;
        this.sdh.sum_sq_rate_on_test += f * f;
        if (f < this.sdh.min_rate_on_test) {
            this.sdh.min_rate_on_test = f;
        }
        if (f > this.sdh.max_rate_on_test) {
            this.sdh.max_rate_on_test = f;
        }
    }

    public void count_votes(int n) {
        int n2 = 0;
        for (int i = 0; i < this.sdh.getTest_pats(); ++i) {
            int n3 = this.sdh.num_votes[i][0];
            int n4 = 0;
            for (int j = 1; j <= this.sdh.getNum_data_category(); ++j) {
                if (this.sdh.num_votes[i][j] <= n3 && (this.sdh.num_votes[i][j] != n3 || this.sdh.frequency[j] <= this.sdh.frequency[n4])) continue;
                n3 = this.sdh.num_votes[i][j];
                n4 = j;
            }
            if (n4 == this.sdh.getNum_data_category()) {
                ++this.sdh.tot_no_prediction;
            } else if (n4 == this.sdh.actual_category[i]) {
                ++n2;
                int[] nArray = this.sdh.right_wrong[n][0];
                int n5 = n4;
                nArray[n5] = nArray[n5] + 1;
            } else {
                int[] nArray = this.sdh.right_wrong[n][1];
                int n6 = n4;
                nArray[n6] = nArray[n6] + 1;
            }
            if (!this.sdh.getDisplay_confusion_matrix()) continue;
            int[] nArray = this.sdh.p_table[n][n4];
            int n7 = this.sdh.actual_category[i];
            nArray[n7] = nArray[n7] + 1;
        }
        float f = (float)(100 * n2) / (float)this.sdh.getTest_pats();
        int n8 = n;
        this.sdh.sum_rate[n8] = this.sdh.sum_rate[n8] + f;
        int n9 = n;
        this.sdh.sum_sq_rate[n9] = this.sdh.sum_sq_rate[n9] + f * f;
    }

    public void calculate_correlation_coeff() {
        for (int i = 0; i < this.sdh.getNum_voters(); ++i) {
            int n = 0;
            while (n < this.sdh.getNum_data_category()) {
                int n2;
                int n3 = this.sdh.p_table[i][n][n];
                int n4 = 0;
                for (n2 = 0; n2 < this.sdh.getNum_data_category(); ++n2) {
                    n4 += this.sdh.p_table[i][n][n2];
                }
                n4 -= n3;
                int n5 = 0;
                for (n2 = 0; n2 < this.sdh.getNum_data_category() + 1; ++n2) {
                    n5 += this.sdh.p_table[i][n2][n];
                }
                int n6 = this.sdh.getNum_runs() * this.sdh.getTest_pats() - (n5 -= n3) - n3 - n4;
                this.sdh.C[i][n] = n3 * n6 - n5 * n4;
                float f = (float)Math.sqrt((float)(n6 + n5) * (float)(n6 + n4) * (float)(n3 + n5) * (float)(n3 + n4));
                float[] fArray = this.sdh.C[i];
                int n7 = n++;
                fArray[n7] = fArray[n7] / f;
            }
        }
    }

    public void analyze_net() {
        String string = "";
        int[] nArray = this.sdh.num_category;
        this.sdh.getClass();
        this.sdh.num_pattern_coded = new int[nArray[0]];
        int[] nArray2 = this.sdh.num_category;
        this.sdh.getClass();
        this.sdh.num_predict_right = new int[nArray2[0]];
        int[] nArray3 = this.sdh.num_category;
        this.sdh.getClass();
        this.sdh.num_predict_wrong = new int[nArray3[0]];
        int[] nArray4 = this.sdh.num_category;
        this.sdh.getClass();
        this.sdh.norm1 = new float[nArray4[0]];
        this.calculate_norm();
    }

    private void calculate_norm() {
        int n = 0;
        while (true) {
            int[] nArray = this.sdh.num_category;
            this.sdh.getClass();
            if (n >= nArray[0]) break;
            this.sdh.norm1[n] = 0.0f;
            int n2 = 0;
            while (true) {
                int[] nArray2 = this.sdh.num_att;
                this.sdh.getClass();
                if (n2 >= nArray2[0]) break;
                int n3 = n;
                float f = this.sdh.norm1[n3];
                float[][][] fArray = this.sdh.dn;
                this.sdh.getClass();
                this.sdh.norm1[n3] = f + fArray[0][n][n2];
                ++n2;
            }
            ++n;
        }
    }

    public String analyze_coding() {
        int n;
        int n2 = 0;
        this.bString = "";
        String string = "";
        string = string + "\nAnalyzing Coding Statistics with Training Set ..\n";
        string = string + "\nAnalyzing net. Please wait ...\n";
        boolean bl = false;
        if (this.sdh.selectTrainSet != null) {
            bl = true;
        }
        for (n = 0; n < this.sdh.getTot_pats(); ++n) {
            this.sdh.Index[n] = n;
        }
        n = 0;
        while (true) {
            int[] nArray = this.sdh.num_category;
            this.sdh.getClass();
            if (n >= nArray[0]) break;
            this.sdh.num_pattern_coded[n] = 0;
            ++n;
        }
        for (n = 0; n < this.sdh.getTrain_pats(); ++n) {
            this.sdh.refresh_system();
            string = bl ? string + this.myIO.read_pattern(this.sdh.selectTrainSet[n] - 1) : string + this.myIO.read_pattern(n);
            this.sdh.getClass();
            this.sdh.getClass();
            int n3 = n2 = this.ART(0, 1);
            this.sdh.num_pattern_coded[n3] = this.sdh.num_pattern_coded[n3] + 1;
        }
        return string;
    }

    public String analyze_predicting() {
        int n;
        boolean bl = false;
        if (this.sdh.selectTrainSet != null) {
            bl = true;
        }
        String string = "";
        string = string + "\nAnalyzing Predicting Statistics with Test Set ..\n";
        string = string + "\nAnalyzing net. Please wait ...\n";
        for (n = 0; n < this.sdh.getTot_pats(); ++n) {
            this.sdh.Index[n] = n;
        }
        n = 0;
        while (true) {
            int[] nArray = this.sdh.num_category;
            this.sdh.getClass();
            if (n >= nArray[0]) break;
            this.sdh.num_predict_right[n] = 0;
            this.sdh.num_predict_wrong[n] = 0;
            ++n;
        }
        for (n = 0; n < this.sdh.getTest_pats(); ++n) {
            this.sdh.refresh_system();
            if (bl) {
                string = string + this.myIO.read_pattern(this.sdh.selectTestSet[n] - 1);
                this.sdh.getClass();
                this.predict_category = this.B_then_A(1, this.sdh.selectTestSet[n] - 1);
                string = string + this.bString;
                this.bString = "";
            } else {
                string = string + this.myIO.read_pattern(n);
                this.sdh.getClass();
                this.predict_category = this.B_then_A(1, n);
                string = string + this.bString;
                this.bString = "";
            }
            this.sdh.getClass();
            this.sdh.getClass();
            int n2 = this.ART(0, 1);
            this.sdh.getClass();
            this.sdh.getClass();
            this.desired_category = this.ART(1, 1);
            if (this.predict_category == this.desired_category) {
                int n3 = n2;
                this.sdh.num_predict_right[n3] = this.sdh.num_predict_right[n3] + 1;
                continue;
            }
            int n4 = n2;
            this.sdh.num_predict_wrong[n4] = this.sdh.num_predict_wrong[n4] + 1;
        }
        this.count_transient_categories();
        return string;
    }

    private void count_transient_categories() {
        this.sdh.num_transient_category = 0;
        int n = 0;
        while (true) {
            int[] nArray = this.sdh.num_category;
            this.sdh.getClass();
            if (n >= nArray[0]) break;
            if (this.sdh.num_pattern_coded[n] == 0) {
                ++this.sdh.num_transient_category;
            }
            ++n;
        }
    }

    public String getBString() {
        return this.bString;
    }

    public void setBString(String string) {
        this.bString = string;
    }
}

