#include "config.h"

#include <stdio.h>
#include <stdlib.h>

#include "defines.h"

void seq_probabilities(WSCORE *wscore,SAMPLE *data,MODEL *model,int two_motif_model) {

   register int i,j;

   // add up the probabilities and estimate the joint 1 & 2 proportion
   for (i=0; i<3; i++) {
     for (j=0; j<3; j++) data->p[i][j]=0; 
   }

   data->p[0][0]=wscore->ws00;
   for(i=0; i<data->numUniq[0]; i++) {
      if      (data->strand[0][i]=='+') data->p[1][0] +=wscore->ws10[i];
      else if (data->strand[0][i]=='-') data->p[2][0] +=wscore->ws20[i];
   }
   if (two_motif_model) {
      for(i=0; i<data->numUniq[0]; i++) {
         for(j=0; j<data->numUniq[1]; j++) {
            if ((data->pos[0][i]<data->pos[1][j] && (data->pos[0][i]+model->pwmLen[0]-1)<data->pos[1][j]) ||
                (data->pos[1][j]<data->pos[0][i] && (data->pos[1][j]+model->pwmLen[1]-1)<data->pos[0][i]) ) {

               if      (data->strand[0][i]=='+' && data->strand[1][j]=='+') data->p[1][1] +=wscore->ws11[i][j];
               else if (data->strand[0][i]=='+' && data->strand[1][j]=='-') data->p[1][2] +=wscore->ws12[i][j];
               else if (data->strand[0][i]=='-' && data->strand[1][j]=='+') data->p[2][1] +=wscore->ws21[i][j];
               else if (data->strand[0][i]=='-' && data->strand[1][j]=='-') data->p[2][2] +=wscore->ws22[i][j];
            }
         }
      }
      for(j=0; j<data->numUniq[1]; j++) {
         if      (data->strand[1][j]=='+') data->p[0][1] +=wscore->ws01[j];
         else if (data->strand[1][j]=='-') data->p[0][2] +=wscore->ws02[j];
      }
   }
   // printf("prop. %4.2f %4.2f %4.2f\n", data->p[0][0], data->p[1][0], data->p[2][0]);
}

