#include "config.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include "defines.h"

char *alloc_char(int );
int read_pwm0(char *fileName,MODEL *initia) {

   register int m,n,i,k;
   int numCol,numRow;
   int isTab,len,cn1;
   int pwmCn=0;   // the first one is the primary motif
   char *buffer,*tok;
   FILE *fp;

   fp=fopen(fileName,"r");
   if (!fp) { perror(fileName); exit(0); }

   buffer=alloc_char(250);
   while (!feof(fp)) {
      if (fgets(buffer,250,fp)>0) {
         len=strlen(buffer);
         if (len<3) continue;
         buffer[len-1]='\0';
         if ((buffer[0]=='#' || isalpha(buffer[0]) || buffer[0]=='>') && len>3) { 

            cn1=0;
            for (i=0; i<len; i++) {
               if (buffer[i]=='/') cn1=i; 
            }
            for (k=0,i=cn1; i<len-1; i++) {
               if (buffer[i]=='#' ||buffer[i]=='>') continue;
               initia->name[pwmCn][k]=buffer[i]; 
               if (buffer[i]==' ') break;
               k++; 
            }
            initia->name[pwmCn][i]='\0';
            printf("PWM header: %s\n",initia->name[pwmCn]);
            continue; 
         }
         isTab=0;
         for (i=0; i<len; i++) {
            if (buffer[i]=='\t') isTab=1; 
         }
         if (isTab) {
            tok=strtok(buffer,"\t");
            numRow=atoi(tok);
            tok=strtok(0,"\t");
            numCol=atoi(tok);
         }
         else {
            tok=strtok(buffer," ");
            numRow=atoi(tok);
            tok=strtok(0," ");
            numCol=atoi(tok);
         } 
         if (numRow !=4 || numCol<2) { 
            printf("\n\nError:\n");
            printf("PMW format: numRow(4) numCol\n");
            printf("then the 4 x numCol matrix\n");
            printf("multiple PWMs can be concatenated. Comments started with # are allowed\n");
            printf("\nexample:\n"); 
            printf("#E-box\n");
            printf("      4  12\n");
            printf("      0  3       0       2       5       0       0       16      0       0       1       5\n");
            printf("      7  5       3       3       1       0       0       0       16      0       5       6\n");
            printf("      5  4       6       11      7       0       15      0       0       16      0       3\n");
            printf("      4  4       7       0       3       16      1       0       0       0       10      2\n");
            printf("#Hnf4a\n");
            printf("      4  13\n");
            printf("      0.3276 0.0863 0.1897 0.0863 0.0346 0.8963 0.7929 0.8446 0.0001 0.0518 0.0518 0.0173 0.7929\n");
            printf("      0.1380 0.0346 0.0518 0.2759 0.8274 0.0173 0.0346 0.0001 0.0001 0.0173 0.3276 0.8101 0.0346\n");
            printf("      0.3620 0.7929 0.5171 0.3448 0.0346 0.0001 0.1724 0.1552 0.9997 0.4482 0.1207 0.0346 0.1035\n");
            printf("      0.1724 0.0863 0.2414 0.2931 0.1035 0.0863 0.0001 0.0001 0.0001 0.4827 0.4999 0.1380 0.0690\n");
            printf("Hnf4a\n");
            printf("4       10\n");
            printf("      20      25      25      13      2       37      40      41      0       37\n");
            printf("      4       6       3       4       21      5       2       0       22      0\n");
            printf("      2       9       8       23      1       0       0       1       1       3\n");
            printf("      16      2       6       2       18      0       0       0       19      2\n");
            printf("\n");
            exit(0); 
         }
       
         if (numCol>MAX_PWM_LENGTH) {
            printf("\nThe max PWM length (%d) reached.\n",MAX_PWM_LENGTH); 
            printf("Reset the value in 'defines.h'\n");
            exit(0);
         }
         for (m=0; m<4; m++) {
            fgets(buffer,250,fp);
            len=strlen(buffer);
            buffer[len-1]='\0';
            isTab=0;
            for (i=0; i<len; i++) {
               if (buffer[i]=='\t') isTab=1; 
            }
            if (isTab) {
               tok=strtok(buffer,"\t");
               initia->pwm[pwmCn][0][m]=atof(tok);
               for (n=1; n<numCol; n++) {
                  tok=strtok(0,"\t");
                  initia->pwm[pwmCn][n][m]=atof(tok);
               }
            }
            else {
               tok=strtok(buffer," ");
               initia->pwm[pwmCn][0][m]=atof(tok);
               for (n=1; n<numCol; n++) {
                  tok=strtok(0," ");
                  initia->pwm[pwmCn][n][m]=atof(tok);
               }
            }
         }
         for (n=0; n<numCol; n++) initia->pwm[pwmCn][n][4]=0.25;
         initia->pwmLen[pwmCn]=n;
         pwmCn++;
         if (pwmCn==MAX_NUM_PWM) { 
            printf("max number of PWMs reached!\n");
            printf("reset MAX_NUM_PWM in 'defines.h' accordingly\n"); 
            exit(0); 
         }
      }
   }
   fclose(fp);
   if (buffer) { free(buffer); buffer=NULL; }

   printf("reading %s: number of pwms: %d\n",fileName,pwmCn);

   if (pwmCn==0) { printf("Error: no PWM found!\n"); exit(0); }

   return (pwmCn);
}

void print_all_pwm(MODEL *initia,int numPWM) {

   int i,j,k;

   for (i=0; i<numPWM; i++) {
      printf("PWM:\t%s\n",initia->name[i]);
      for (k=0; k<4; k++) {
         for (j=0; j<initia->pwmLen[i]; j++) printf("%5.4f ",initia->pwm[i][j][k]); printf("\n");
      }
      printf("\n");
   }
}
