#include "config.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

char *alloc_char(int );

/*----------------------------------------
# Proportion:
0.1111 0.1111 0.1111 
0.1111 0.1111 0.1111
0.1111 0.1111 0.1111 
----------------------------------------*/

void read_parameters(char *fileName,double p[][3]) {

   FILE *fp;
   char *buffer,*tok;
   int isTab,len,numRow,numCol;
   register int i,k;
  
   buffer=alloc_char(1000);

   printf("reading %s\n",fileName);
 
   fp=fopen(fileName,"r");
   if (!fp) { perror(fileName); exit(0); }   

   while (!feof(fp)) {
      if (fgets(buffer,1000,fp)>0) {
         if (buffer[0]=='#') continue;
         len=strlen(buffer);
         buffer[len-1]='\0';

         isTab=0;
         for (i=0; i<len; i++) {
            if (buffer[i]=='\t') { isTab=1; break; } 
         }
         if (isTab) {
            tok=strtok(buffer,"\t");
            numRow=atoi(tok);
            tok=strtok(0,"\t");
            numCol=atoi(tok);
         }
         else {
            tok=strtok(buffer," ");
            numRow=atoi(tok);
            tok=strtok(0," ");
            numCol=atoi(tok);
         }
         if (numRow!=3 || (numCol!=1 && numCol!=3)) {
            printf("\nError: \n");
            printf("  Please specify whether it is a 3x3 matrix (for a two-motif model) or a vector of 3 elements (one-motif model\n");
            printf("  \nFor example:\n\n");
            printf("  #prior proportions for a two-motif model - uniform for all nine states\n");
            printf("  0.11111 0.11111 0.11111\n");
            printf("  0.11111 0.11111 0.11111\n");
            printf("  0.11111 0.11111 0.11111\n");
            printf("\n       or\n\n");
            printf("  #prior proportions for a one-motif model uniform for background motif1+, motif1-\n");
            printf("  0.33333\n");
            printf("  0.33333\n");
            printf("  0.33333\n");
            printf("\n");
            exit(0);
         }

         for (k=0; k<numRow; k++) {
            if (fgets(buffer,1000,fp)>0) {
               len=strlen(buffer);
               buffer[len-1]='\n'; 
               isTab=0;
               for (i=0; i<len; i++) {
                  if (buffer[i]=='\t') { isTab=1; break; } 
               }
               if (isTab) { 
                  tok=strtok(buffer,"\t");
                  p[k][0]=atof(tok);
                  for (i=0; i<numCol-1; i++) {
                    tok=strtok(0,"\t");
                    p[k][i+1]=atof(tok);
                  }
               }
               else {
                  tok=strtok(buffer," ");
                  p[k][0]=atof(tok);
                  for (i=0; i<numCol-1; i++) {
                     tok=strtok(0," ");
                     p[k][i+1]=atof(tok);
                  }
               } 
            } 
         } 
      }
   }
   if (numCol==3) {
      printf("Initial proportions:\n");
      printf("       |    0   motif2+  motif2-\n");
      printf("-----------------------------------\n");
      printf("     0 |%5.4f %5.4f %5.4f\n",p[0][0],p[0][1],p[0][2]);
      printf("motif1+|%5.4f %5.4f %5.4f\n",p[1][0],p[1][1],p[1][2]);
      printf("motif1-|%5.4f %5.4f %5.4f\n",p[2][0],p[2][1],p[2][2]);
   }
   else {
      printf("Initial proportions:\n");
      printf("       |\n");
      printf("-----------------------------------\n");
      printf("     0 |%5.4f\n",p[0][0]);
      printf("motif1+|%5.4f\n",p[1][0]);
      printf("motif1-|%5.4f\n",p[2][0]);
   }

   if (buffer) { free(buffer); buffer=NULL; }
}

void print_parameters(double p[][3],int two_motif_model) {
 
   if (two_motif_model) {
      printf("Initial proportions:\n");
      printf("       |    0   motif2+  motif2-\n");
      printf("-----------------------------------\n");
      printf("     0 |%5.4f %5.4f %5.4f\n",p[0][0],p[0][1],p[0][2]);
      printf("motif1+|%5.4f %5.4f %5.4f\n",p[1][0],p[1][1],p[1][2]);
      printf("motif1-|%5.4f %5.4f %5.4f\n",p[2][0],p[2][1],p[2][2]);
   }
   else {
      printf("Initial proportions:\n");
      printf("       |\n");
      printf("-----------------------------------\n");
      printf("     0 |%5.4f\n",p[0][0]);
      printf("motif1+|%5.4f\n",p[1][0]);
      printf("motif1-|%5.4f\n",p[2][0]);
   }
}

