#include "config.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#include "defines.h"

void motif_prior(SAMPLE *data,int numSeq,int pwmLen1,int pwmLen2,PRIOR *prior,int priorType,double sigma1,double sigma2) {

   register int i,j;
   register int k; 
   double mean,pi,sum;
   // FILE *fp;

   // fp=fopen("prior.debug","w");

   pi=3.1415926;
   for (i=0; i<numSeq; i++) {
      // prior for the primary motif - gaussian
      if (priorType==1) {
         mean=data[i].length/2.0;
         for (j=0; j<data[i].length-pwmLen1+1; j++) {
            prior[i].m1[j]=exp(-(j-mean)*(j-mean)/(2*sigma1*sigma1))/(sigma1*sqrt(2.0*pi));
         }
         sum=0; for (j=0; j<data[i].length-pwmLen1+1; j++) sum +=prior[i].m1[j];
         for (j=0; j<data[i].length-pwmLen1+1; j++) prior[i].m1[j]=log(prior[i].m1[j]/sum);

         for (j=0; j<data[i].length-pwmLen2+1; j++) {
            prior[i].m2[j]=exp(-(j-mean)*(j-mean)/(2*sigma2*sigma2))/(sigma2*sqrt(2.0*pi));
         }
         sum=0; for (j=0; j<data[i].length-pwmLen2+1; j++) sum +=prior[i].m2[j];
         for (j=0; j<data[i].length-pwmLen2+1; j++) prior[i].m2[j]=log(prior[i].m2[j]/sum);

         /*-----------------------------------testing--------------------------------
         for (j=0; j<data[i].length-pwmLen1+1; j++) {
            for (k=0; k<data[i].length-pwmLen2+1; k++) {
               if ((j<k && (j+pwmLen1-1)<k) || (k<j && (k+pwmLen2-1)<j) ) {
                  prior[i].m12[j][k]=prior[i].m1[j]+prior[i].m2[k]; 
               }
            }
         }

         sum=0;
         for (j=0; j<data[i].length-pwmLen1+1; j++) {
            for (k=0; k<data[i].length-pwmLen2+1; k++) {
               if ((j<k && (j+pwmLen1-1)<k) || (k<j && (k+pwmLen2-1)<j) ) {
                  prior[i].m12[j][k]=exp(prior[i].m12[j][k]);
                  sum +=prior[i].m12[j][k];
               }
            }
         }

         for (j=0; j<data[i].length-pwmLen1+1; j++) {
            for (k=0; k<data[i].length-pwmLen2+1; k++) {
               if ((j<k && (j+pwmLen1-1)<k) || (k<j && (k+pwmLen2-1)<j) ) {
                  prior[i].m12[j][k]=log(prior[i].m12[j][k]/sum);
               }
               else prior[i].m12[j][k]=-9999;
            }
         }
         -----------------------------end-testing---------------------------*/
      }
      // prior for the primary motif - uniform
      else if (priorType==0) {
         for (j=0; j<data[i].length-pwmLen1+1; j++) prior[i].m1[j]=-log((double)(data[i].length-pwmLen1+1));
         for (j=0; j<data[i].length-pwmLen2+1; j++) prior[i].m2[j]=-log((double)(data[i].length-pwmLen2+1));
      }
      else { printf("Error: motif location prior type not known: %d\n",priorType); exit(0); }
   }
}

