#include "config.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifdef HAVE_MALLOC_H
#include <malloc.h>
#endif

#include "defines.h"
// #include "random.h"

char *alloc_char(int );
void adjust_pwm(double **,int );

int *print_result(int cycle,int numSeq,SAMPLE *data,MODEL *model,M_SITE *site,int nsites,double logev[],int printProb,double maxDist[],
   P_SIM *sim,MODEL *initial,int numStartingPWM,int two_motif_model,FILE *fq1,FILE *fq2,FILE *fq3) {

   register int i,j,k;
   int numPWMs;
   int loc[2];
   static int siteCn[2];
   int s;
   char strand[2];
   char *fileName,*fileName2;
   double p_f[2];
   FILE *fo=NULL;
   FILE *fo2=NULL;

   fileName =alloc_char(200);
   fileName2=alloc_char(200);

   if (two_motif_model) {
      numPWMs=2;
      strcpy(fileName,model->name[0]);
      strcat(fileName,"_");
      strcat(fileName,model->name[1]);
      strcat(fileName,".txt");
      strcpy(fileName2,model->name[0]);
      strcat(fileName2,"_");
      strcat(fileName2,model->name[1]);
      strcat(fileName2,".loc");
      fo =fopen(fileName,"w");
      fo2=fopen(fileName2,"w");
      //sprintf(fileName,"1%d.txt",cycle+1);
   }
   else {
      numPWMs=1;
      strcpy(fileName,model->name[0]);
      strcat(fileName,".txt");
      //sprintf(fileName,"%d.txt",cycle+0);
      fo =fopen(fileName,"w");
   }

   fprintf(fo,"cycle: %3d\n",cycle+1);

   if (numPWMs==2) {
      fprintf(fo,"starting PWM1:\t\t%s\n",model->name[0]); 
      fprintf(fo,"consensus:\t\t%s\n",model->consensus[0]); 
      fprintf(fo,"starting PWM2:\t\t%s\n",model->name[1]); 
      fprintf(fo,"consensus:\t\t%s\n",model->consensus[1]); 
   }
   else {
      fprintf(fo,"starting PWM:\t%s\n",model->name[0]); 
      fprintf(fo,"starting PWM consensus:\t%s\n",model->consensus[0]); 
   }

   fprintf(fo,"\nStarting PWM(s):\n");
   for (i=0; i<numPWMs; i++) {
      if (i==0) fprintf(fo,">starting_pwm1:\n",cycle+1);
      else      fprintf(fo,">starting_pwm2:\n",cycle+1);
      for (k=0; k<4; k++) {
         switch (k) {
            case 0: fprintf(fo,"A "); break;
            case 1: fprintf(fo,"C "); break;
            case 2: fprintf(fo,"G "); break;
            case 3: fprintf(fo,"T "); break;
            default: break;
         }
         for (j=0; j<initial->pwmLen[i]; j++) {
            if (j<initial->pwmLen[i]-1) fprintf(fo,"%5.4f ",initial->pwm[i][j][k]);
            else fprintf(fo,"%5.4f\n",initial->pwm[i][j][k]);
         }
      }
   }
   fprintf(fo,"\n");

   fprintf(fo,"\nEstimated PWM(s):\n");
   for (i=0; i<numPWMs; i++) {
      if (i==0) fprintf(fo,">c%d_pwm1:\n",cycle+1);
      else      fprintf(fo,">c%d_pwm2:\n",cycle+1);
      for (k=0; k<4; k++) {
         switch (k) {
            case 0: fprintf(fo,"A "); break;
            case 1: fprintf(fo,"C "); break;
            case 2: fprintf(fo,"G "); break;
            case 3: fprintf(fo,"T "); break;
            default: break;
         }
         for (j=0; j<model->pwmLen[i]; j++) {
            if (j<model->pwmLen[i]-1) fprintf(fo,"%5.4f ",model->pwm[i][j][k]);
            else fprintf(fo,"%5.4f\n",model->pwm[i][j][k]);
         }
      }
   }
   fprintf(fo,"\n");

   fprintf(fo,"\nEstimated proportions:\n");

   if (numPWMs==2) {
      p_f[0]=model->p[1][0]+model->p[2][0]+model->p[1][1]+model->p[1][2]+model->p[2][1]+model->p[2][2];
      p_f[1]=model->p[0][1]+model->p[0][2]+model->p[1][1]+model->p[1][2]+model->p[2][1]+model->p[2][2];

      fprintf(fo,"       |    0   motif2+  motif2-\n");
      fprintf(fo,"-----------------------------------\n");
      fprintf(fo,"     0 |%6.5f %6.5f %6.5f\n",model->p[0][0],model->p[0][1],model->p[0][2]);
      fprintf(fo,"motif1+|%6.5f %6.5f %6.5f\n",model->p[1][0],model->p[1][1],model->p[1][2]);
      fprintf(fo,"motif1-|%6.5f %6.5f %6.5f\n",model->p[2][0],model->p[2][1],model->p[2][2]);
      fprintf(fo,"\n");
      fprintf(fo,"background(p00):\t\t\t\t%6.5f\n",model->p[0][0]);
      fprintf(fo,"primary motif(p10+p20+p11+p12+p21+p22):\t\t%6.5f\n",p_f[0]);
      fprintf(fo,"co-motif(p01+p02+p11+p12+p21+p22):\t\t%6.5f\n",p_f[1]);
      fprintf(fo,"\nmax abs difference between the starting PWM1(%s) and the estimated PWM1: %6.4f\n",model->name[0],maxDist[0]);
      fprintf(fo,"max abs difference between the starting PWM2(%s) and the estimated PWM2: %6.4f\n",model->name[1],maxDist[1]);
      fprintf(fo,"The starting PWMs that are most similar to the estimated PWM2\t");
      for (i=0; i<min(5,numStartingPWM); i++) {
         if (i<min(5,numStartingPWM)-1)
            fprintf(fo,"%s[%5.3f]\t",initial->name[sim[i].wh],sim[i].dis); 
         else 
            fprintf(fo,"%s[%5.3f]\n",initial->name[sim[i].wh],sim[i].dis); 
      } fprintf(fo,"\n");

      fprintf(fq3,"%s\t",model->name[1]);
      for (i=0; i<min(5,numStartingPWM); i++) {
         if (i<min(5,numStartingPWM)-1)
            fprintf(fq3,"%s[%5.3f]\t",initial->name[sim[i].wh],sim[i].dis); 
         else
            fprintf(fq3,"%s[%5.3f]\n",initial->name[sim[i].wh],sim[i].dis); 
      }
      fflush(fq3);
   }
   else {
      fprintf(fo,"     0 |%6.5f\n",model->p[0][0]);
      fprintf(fo,"motif1+|%6.5f\n",model->p[1][0]);
      fprintf(fo,"motif1-|%6.5f\n\n",model->p[2][0]);
      fprintf(fo,"background(p0):\t\t\t%6.5f\n",model->p[0][0]);
      fprintf(fo,"primary motif(p10+p20):\t\t%6.5f\n",model->p[1][0]+model->p[2][0]);
      fprintf(fo,"max abs difference between startingl and estimated %s PWM: %6.4f\n\n",model->name[0],maxDist[0]);
   }

   fprintf(fo,"Predicted sites:\n");  
   siteCn[0]=0; siteCn[1]=0;
   for (i=0; i<nsites; i++) {

      loc[0]=site[i].loc[0];
      loc[1]=site[i].loc[1]; 
      s=site[i].seq;
      strand[0]=site[i].strand[0];
      strand[1]=site[i].strand[1];

      fprintf(fo,"%s\t",data[s].name); 
      if (loc[0]!=DUMMY_LOCATION) {
         siteCn[0]++;
         fprintf(fo,"%d\t%d\t%c\t",s+1,loc[0]+1,strand[0]); 
         if (strand[0]=='+') {
            for (j=0; j<model->pwmLenNew[0]; j++) {
               if (j+loc[0]<0) fprintf(fo,"N");
               else {
                  switch (data[s].seq[j+loc[0]]) {
                     case 'a': fprintf(fo,"A"); break; 
                     case 'c': fprintf(fo,"C"); break; 
                     case 'g': fprintf(fo,"G"); break; 
                     case 't': fprintf(fo,"T"); break; 
                     default:  fprintf(fo,"N"); break; 
                  }
               }
            }
         }
         else {
            for (j=0,k=model->pwmLenNew[0]-1; k>=0; k--,j++) {
               if (k+loc[0]>data[s].length) fprintf(fo,"N");
               else {
                  switch (data[s].seq[k+loc[0]]) {
                     case 'a': fprintf(fo,"T"); break; 
                     case 'c': fprintf(fo,"G"); break; 
                     case 'g': fprintf(fo,"C"); break; 
                     case 't': fprintf(fo,"A"); break; 
                     default:  fprintf(fo,"N"); break; 
                  }
               }
            }
         }
         fprintf(fo,"\t");
      }
      else {
         fprintf(fo,"n/a\tn/a\tn/a\t"); 
         for (j=0; j<model->pwmLenNew[0]; j++) fprintf(fo," "); fprintf(fo,"\t");
      }
      if (loc[1]!=DUMMY_LOCATION && two_motif_model) {
         siteCn[1]++;
         fprintf(fo,"%d\t%c\t",loc[1]+1,strand[1]); 
         if (strand[1]=='+') {
            for (j=0; j<model->pwmLenNew[1]; j++) {
               if (j+loc[1]<0) fprintf(fo,"N");
               else {
                  switch (data[s].seq[j+loc[1]]) {
                     case 'a': fprintf(fo,"A"); break; 
                     case 'c': fprintf(fo,"C"); break; 
                     case 'g': fprintf(fo,"G"); break; 
                     case 't': fprintf(fo,"T"); break; 
                     default:  fprintf(fo,"N"); break; 
                  }
               }
            }
         }
         else {
            for (j=0,k=model->pwmLenNew[1]-1; k>=0; k--,j++) {
               if (k+loc[1]>data[s].length) fprintf(fo,"N");
               else {
                  switch (data[s].seq[k+loc[1]]) {
                     case 'a': fprintf(fo,"T"); break; 
                     case 'c': fprintf(fo,"G"); break; 
                     case 'g': fprintf(fo,"C"); break; 
                     case 't': fprintf(fo,"A"); break; 
                     default:  fprintf(fo,"N"); break; 
                  } 
               }
            }
         }
         fprintf(fo,"\t");
      }
      else if (two_motif_model) {
         fprintf(fo,"n/a\tn/a\t"); 
         for (j=0; j<model->pwmLenNew[1]; j++) fprintf(fo," "); fprintf(fo,"\t");
      }

      if (printProb) {
         if (two_motif_model) { 
            fprintf(fo,"%4.3f\t%4.3f\t%4.3f\t%4.3f\t%4.3f\t%4.3f\t%4.3f\t%4.3f\t%4.3f\n",
               data[s].p[0][0], 
               data[s].p[1][0], 
               data[s].p[2][0], 
               data[s].p[0][1], 
               data[s].p[0][2], 
               data[s].p[1][1], 
               data[s].p[1][2], 
               data[s].p[2][1], 
               data[s].p[2][2]);
         }
         else {
            fprintf(fo,"%4.3f\t%4.3f\t%4.3f\n",
               data[s].p[0][0], 
               data[s].p[1][0], 
               data[s].p[2][0]);
         }
      }
      else fprintf(fo,"\n");
   }

   fprintf(fo,"\nnumber of motif 1 sites:\t%d\n",siteCn[0]);
   fprintf(fo,"log(E-value):\t\t\t%8.3f\n",logev[0]);
   if (numPWMs==2) {
      fprintf(fo,"number of motif 2 sites:\t%d\n",siteCn[1]);
      fprintf(fo,"log(E-value):\t\t\t%8.3f\n",logev[1]);
   }
   fprintf(fo,"------------------------------------------------------\n\n");
   fflush(fo);

   if (two_motif_model) {
      fprintf(fo2,"#the predicted location of the motif2 site for plotting\n");
      fprintf(fo2,"#the last two columns for ploting motif1 and motif2 joint distribution\n");
      fprintf(fo2,"#motif1\tmotif2\tmotif1\tmotif2\n");
      for (i=0; i<nsites; i++) {
         if (site[i].loc[0]!=DUMMY_LOCATION)
            fprintf(fo2,"%d\t",site[i].loc[0]);
         else fprintf(fo2,"NA\t");
         if (site[i].loc[1]!=DUMMY_LOCATION)
            fprintf(fo2,"%d\t",site[i].loc[1]);
         else fprintf(fo2,"NA\t");
         if (site[i].loc[0]!=DUMMY_LOCATION && site[i].loc[1]!=DUMMY_LOCATION)
            fprintf(fo2,"%d\t%d\n",site[i].loc[0],site[i].loc[1]); 
         else fprintf(fo2,"NA\tNA\n"); 
      }
      fclose(fo2);

      fprintf(fq2,">%s\n",model->name[1]);
      for (k=0; k<4; k++) {
         switch (k) {
            case 0: fprintf(fq2,"A "); break;
            case 1: fprintf(fq2,"C "); break;
            case 2: fprintf(fq2,"G "); break;
            case 3: fprintf(fq2,"T "); break;
            default: break;
         }
         for (j=0; j<model->pwmLen[1]; j++) {
            if (j<model->pwmLen[1]-1) fprintf(fq2,"%5.4f ",model->pwm[1][j][k]);
            else fprintf(fq2,"%5.4f\n",model->pwm[1][j][k]);
         }
      }
      fprintf(fq2,"\n"); fflush(fq2);
   }
 
   fprintf(fq1,">%s\n",model->name[0]);
   for (k=0; k<4; k++) {
      switch(k) {
         case 0: fprintf(fq1,"A "); break;
         case 1: fprintf(fq1,"C "); break;
         case 2: fprintf(fq1,"G "); break;
         case 3: fprintf(fq1,"T "); break;
         default: break;
      }
      for (j=0; j<model->pwmLenNew[0]; j++) {
         if (j<model->pwmLenNew[0]-1) fprintf(fq1,"%5.4f ", model->pwm[0][j][k]);
         else                         fprintf(fq1,"%5.4f\n",model->pwm[0][j][k]);
      }
   }
   fflush(fq1);

   fclose(fo);
   if (fileName)  { free(fileName);  fileName=NULL;  }
   if (fileName2) { free(fileName2); fileName2=NULL; }
 
   return (siteCn);
}

void print_model(int cycle,double diff,MODEL *model,int two_motif_model,FILE *fp) {

   int i,j,k;
   int numPWMs=1;
   if (two_motif_model) numPWMs=2;

   fprintf(fp,"cycle:\t\t\t\t%d\n",cycle+1);
   fprintf(fp,"max pwm difference:\t\t%6.5f\n",diff);
   fprintf(fp,"\nestimated proportion:\n");
   for (i=0; i<3; i++) {
      for (j=0; j<3; j++) {
         if (j<2) fprintf(fp,"%5.4f ", model->p[i][j]);
         else     fprintf(fp,"%5.4f\n",model->p[i][j]);
      }
   }

   for (i=0; i<numPWMs; i++) {
      if (i==0) fprintf(fp,">c%d_estimated_pwm1:\n",cycle+1);
      else      fprintf(fp,">c%d_estimated_pwm2:\n",cycle+1);
      for (k=0; k<4; k++) {
         switch (k) {
            case 0: fprintf(fp,"A "); break;
            case 1: fprintf(fp,"C "); break;
            case 2: fprintf(fp,"G "); break;
            case 3: fprintf(fp,"T "); break;
            default: break;
         }
         for (j=0; j<model->pwmLen[i]; j++) {
            if (j<model->pwmLen[i]-1) fprintf(fp,"%5.4f ", model->pwm[i][j][k]);
            else                      fprintf(fp,"%5.4f\n",model->pwm[i][j][k]);
         }
      }
   }
   fflush(fp);
}

