#include "config.h"

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#include "defines.h"

int range(double score);

void normalization(WSCORE *wscore,SAMPLE *data,MODEL *model,int two_motif_model) {

   register int i,j;
   double totalProbabilityPerSeq,temp;
   int largeNum;

   // normalization - two-motif model
   // add up the scores 
   totalProbabilityPerSeq=wscore->ws00;

   // add motif1 on the sequence
   for(i=0; i<data->numUniq[0]; i++) {
      if      (data->strand[0][i]=='+') totalProbabilityPerSeq +=wscore->ws10[i];
      else if (data->strand[0][i]=='-') totalProbabilityPerSeq +=wscore->ws20[i];
   }

   // add both motifs on the sequence
   if (two_motif_model) {
      for(i=0; i<data->numUniq[0]; i++) {
         for(j=0; j<data->numUniq[1]; j++) {
            if ((data->pos[0][i]<data->pos[1][j] && (data->pos[0][i]+model->pwmLen[0]-1)<data->pos[1][j]) ||
                (data->pos[1][j]<data->pos[0][i] && (data->pos[1][j]+model->pwmLen[1]-1)<data->pos[0][i]) ) {

               if      (data->strand[0][i]=='+' && data->strand[1][j]=='+') totalProbabilityPerSeq +=wscore->ws11[i][j];
               else if (data->strand[0][i]=='+' && data->strand[1][j]=='-') totalProbabilityPerSeq +=wscore->ws12[i][j];
               else if (data->strand[0][i]=='-' && data->strand[1][j]=='+') totalProbabilityPerSeq +=wscore->ws21[i][j];
               else if (data->strand[0][i]=='-' && data->strand[1][j]=='-') totalProbabilityPerSeq +=wscore->ws22[i][j];
            } 
         } 
      } 
      for(j=0; j<data->numUniq[1]; j++) {
         if      (data->strand[1][j]=='+') totalProbabilityPerSeq +=wscore->ws01[j];
         else if (data->strand[1][j]=='-') totalProbabilityPerSeq +=wscore->ws02[j];
      }
   }
   // printf("total probability: %e\n",totalProbabilityPerSeq);

   // normalization
   temp=range(totalProbabilityPerSeq);
   largeNum=pow(10,temp);
   wscore->ws00=(wscore->ws00*largeNum)/(largeNum*totalProbabilityPerSeq);
   for(i=0; i<data->numUniq[0]; i++) {
      if      (data->strand[0][i]=='+') wscore->ws10[i]=(wscore->ws10[i]*largeNum)/(largeNum*totalProbabilityPerSeq);
      else if (data->strand[0][i]=='-') wscore->ws20[i]=(wscore->ws20[i]*largeNum)/(largeNum*totalProbabilityPerSeq);
   }
   if (two_motif_model) {
      for(i=0; i<data->numUniq[0]; i++) {
         for(j=0; j<data->numUniq[1]; j++) {
            if ((data->pos[0][i]<data->pos[1][j] && (data->pos[0][i]+model->pwmLen[0]-1)<data->pos[1][j]) ||
                (data->pos[1][j]<data->pos[0][i] && (data->pos[1][j]+model->pwmLen[1]-1)<data->pos[0][i]) ) {

               if      (data->strand[0][i]=='+' && data->strand[1][j]=='+') wscore->ws11[i][j]=(wscore->ws11[i][j]*largeNum)/(totalProbabilityPerSeq*largeNum);
               else if (data->strand[0][i]=='+' && data->strand[1][j]=='-') wscore->ws12[i][j]=(wscore->ws12[i][j]*largeNum)/(totalProbabilityPerSeq*largeNum);
               else if (data->strand[0][i]=='-' && data->strand[1][j]=='+') wscore->ws21[i][j]=(wscore->ws21[i][j]*largeNum)/(totalProbabilityPerSeq*largeNum);
               else if (data->strand[0][i]=='-' && data->strand[1][j]=='-') wscore->ws22[i][j]=(wscore->ws22[i][j]*largeNum)/(totalProbabilityPerSeq*largeNum);
            }
         }
      }
      for(j=0; j<data->numUniq[1]; j++) {
         if      (data->strand[1][j]=='+') wscore->ws01[j]=(wscore->ws01[j]*largeNum)/(largeNum*totalProbabilityPerSeq);
         else if (data->strand[1][j]=='-') wscore->ws02[j]=(wscore->ws02[j]*largeNum)/(largeNum*totalProbabilityPerSeq);
      }
   }
}

int range(double score) {

  int i;
  double temp;

  temp=score;
  for(i=1; i<10000; i++){
     temp=score*pow(10,i);
     if(temp>1.0) break;
  }
  return(i);
}

