//#ifndef __DEFINES_H__
//#define __DEFINES_H__

#define	CONVERGENCE		0.00010
#define	MAX_NUM_SEQ		20000
#define	MAX_SEQ_LENGTH		1000
#define	MAX_PWM_LENGTH		100
#define	PSEUDO_COUNT		0.0002
#define	MAX_BUFFER_LENGTH	10000
#define	MAX_ALLOWED_ORDER	9
#define	MAX_NUM_PWM		1500
#define	DUMMY_LOCATION		-9999
#define	DUMMY_SCORE		-9999
#define	LARGE_CONSTANT		1000

#define SIGMA1			30.0
#define SIGMA2			60.0

#define MIN_BITS1               0.30     // bits cutoff (out of 2 bits) for extending/trimming motif, choice one
#define MIN_BITS2               0.40     // choice two 
#define MIN_BITS3               0.50     // choice three

#define min(a,b)                (((a)<(b))?(a):(b))
#define max(a,b)                (((a)>(b))?(a):(b))
#define mod(a,b)                ((a)-(b)*((a)/(b)))

typedef struct sample_info SAMPLE;
struct sample_info { 
  char *seq;
  char *name;
  int length;
  double p[3][3];

   int **pos;
   char **strand;
   double **score;
   int numUniq[2];
};

typedef struct model_info MODEL;
struct model_info {
  double p[3][3],logp[3][3]; // two PWMs, each with three states, +,-,0
   // 0 - no motif
   // 1 on + strand
   // 2 on - strand
  
   // p[0][0] noise
   // p[1][0] primary  on +
   // p[2][0] primary  on -
   // p[0][1] cofactor on +
   // p[0][2] cofactor on -
   // p[1][1] primary  on +, cofactor on +
   // p[1][2] primary  on +, cofactor on - 
   // p[2][1] primary  on -, cofactor on +
   // p[2][2] primary  on -, cofactor on -

   double bfreq[5],logbfreq[5];
   double ***pwm,***logpwm;   // pwm is prime, pwm1 is covariate
   double ***rpwm,***logrpwm; //  covariate
   double ***opwm;
   int *pwmLen,pwmLenNew[2];
   char **consensus0; // starting PWM consensus
   char **consensus; // EM-optimized PWM consensus
   char **name;
};

typedef struct loc_prior PRIOR;
struct loc_prior {
   double *m1;
   double *m2;
   double **m12; // leping
};

typedef struct weightscore_info WSCORE;
struct weightscore_info {
   double   ws00; // noise
   double  *ws10; // +, 0  primary only
   double  *ws20; // -, 0  primary only
   double  *ws01; // 0, +  secondary only
   double  *ws02; // 0, -  secondary only
   double **ws11; // +, +
   double **ws12; // +, -
   double **ws21; // -, +
   double **ws22; // -, -
};

typedef struct likelihood_motif M_LIKELIHOOD;
struct likelihood_motif {
   double **site_p;
   double **site_m;
};

typedef struct likelihood_backg B_LIKELIHOOD;
struct likelihood_backg {
   double **site_b;
   double seq_b;
};

typedef struct motif_site M_SITE;
struct motif_site {
   int seq,pos;
   int loc[2];
   char strand[3];
};

// background
typedef struct background_model BACKGROUND_Model;
struct background_model {
   double *monomerFreq,*dimerFreq,  *trimerFreq, *tetramerFreq,*pentamerFreq,*hexamerFreq,*heptamerFreq,*octamerFreq,*nonamerFreq,*decamerFreq;
   double              *transition1,*transition2,*transition3, *transition4, *transition5,*transition6, *transition7,*transition8,*transition9;
   char **monomer,**dimer,**trimer,**tetramer,**pentamer,**hexamer,**heptamer,**octamer,**nonamer,**decamer;
};

typedef struct site_probability SiteProb;
struct site_probability {
   double s;
   int id;
};

typedef struct site_score SSCORE;
struct site_score {
   double score;
   int pos;
   char strand;
};

typedef struct pwm_similarity P_SIM;
struct pwm_similarity {
   int wh;
   double dis;
};

//#endif
