#include "config.h"

#include <stdlib.h>
#include <math.h>
#include <stdio.h>

#ifdef HAVE_MALLOC_H
#include <malloc.h>
#endif

#include "defines.h"

int Compare_double2(const void *s1, const void *s2);
void sort_double2(double *data,int size);

int check_pwm_uniqueness_dist(double ***opwm,int *pwmLen,int populationSize,Fitness *fitness,
   double distCutoff,double EvalueCutoff,char *uniqMotif,int window) {

   register int ii,jj,i,j,l,m;
   int numUniq,similarPlus,similarMinus,u_id,p_id;
   int *uniqID;
   double dist;
   double ***rpwm; 

   uniqID=alloc_int(populationSize);
   rpwm=alloc_double_double_double(populationSize,MAX_PWM_LENGTH,4);

   // reverse complement
   for (i=0; i<populationSize; i++) {
      for (l=0; l<pwmLen[i]; l++) {
         for (m=0; m<4; m++) { rpwm[i][l][m]=opwm[i][pwmLen[i]-l-1][3-m]; }
      }
   }

   for (i=0; i<populationSize; i++) uniqMotif[i]='0';
   if (fabs(fitness[0].value-DUMMY_FITNESS)>0.1) { uniqMotif[0]='1'; numUniq=1; } // always designate the first motif unique
   else numUniq=0;

   uniqID[0]=fitness[0].index;

   for (i=1; i<populationSize; i++) {

      // fitness are sorted in increasing order
      if (fitness[i].value>EvalueCutoff) break;

      p_id=fitness[i].index;        // GA population member ID
      similarPlus=0; similarMinus=0;// plus and minus orientation similarity
      for (j=0; j<numUniq; j++) {
         u_id=uniqID[j];
         for (jj=0; jj<pwmLen[p_id]-window+1; jj++) {
            for (ii=0; ii<pwmLen[u_id]-window+1; ii++) {

               dist=0;
               for (l=0; l<window; l++) {
                  for (m=0; m<4; m++) { dist +=fabs(opwm[u_id][l+ii][m]-opwm[p_id][l+jj][m]); }
               }
               if (dist<=window*distCutoff) {
                  similarPlus=1; break;
               }
            }
            if (similarPlus==1) break;
         }
         if (similarPlus==1) break;
      }
      if (!similarPlus) {
         for (j=0; j<numUniq; j++) {
            u_id=uniqID[j];
            for (jj=0; jj<pwmLen[p_id]-window+1; jj++) {
               for (ii=0; ii<pwmLen[u_id]-window+1; ii++) {

                  dist=0;
                  for (l=0; l<window; l++) {
                     for (m=0; m<4; m++) { dist +=fabs(opwm[u_id][l+ii][m]-rpwm[p_id][l+jj][m]); }
                  }
                  if (dist<=window*distCutoff) { similarMinus=1; break; }
               }
               if (similarMinus==1) break;
            }
            if (similarMinus==1) break;
         }
      }
      if (!similarPlus && !similarMinus) {
         uniqMotif[i]='1';
         uniqID[numUniq]=fitness[i].index;
         numUniq++;
      }
   }
   printf("number of unique: %d\n",numUniq);

   if (uniqID)     { free(uniqID);     uniqID=NULL;     }
   if (rpwm[0][0]) { free(rpwm[0][0]); rpwm[0][0]=NULL; }
   if (rpwm[0])    { free(rpwm[0]);    rpwm[0]=NULL;    }
   if (rpwm)       { free(rpwm);       rpwm=NULL;       }
   
   return (numUniq);
}
