#include "config.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#include "defines.h"

#define	SIMILARITY_ALPHA	0.40

int Compare_double2(const void *s1, const void *s2);
int Compare_similarity(const void *s1, const void *s2);

void sort_double2(double *,int );
void sort_similarity(P_SIM *,int );
void srandom(unsigned int );

double *alloc_double(int );
double **alloc_double_double(int ,int );
double ***alloc_double_double_double(int ,int ,int );

long int random(void);

double vector_similarity(void) {

  double v1[4],v2[4],sum,dist;
  double *d;
  int numRandom;
  register int i,j;
  unsigned int seed=123456789;
 
  numRandom=100000;  
  d=alloc_double(numRandom);

  srandom(seed);
  for (i=0; i<numRandom; i++) {
     for (j=0; j<4; j++) {
        v1[j]=(double)random()/(double)RAND_MAX;
        v2[j]=(double)random()/(double)RAND_MAX;
     }
     sum=0; for (j=0; j<4; j++) sum+=v1[j];
     if (sum!=0) { for (j=0; j<4; j++) v1[j]/=sum; }
     else        { for (j=0; j<4; j++) v1[j]=0.25; }

     sum=0; for (j=0; j<4; j++) sum+=v2[j];
     if (sum!=0) { for (j=0; j<4; j++) v2[j]/=sum; }
     else        { for (j=0; j<4; j++) v2[j]=0.25; }

     d[i]=0; for (j=0; j<4; j++) { d[i] +=fabs(v1[j]-v2[j]); } 
  }

  // sort in increasing order
  sort_double2(d,numRandom);
  dist=d[(int)(numRandom*SIMILARITY_ALPHA)];

  if (d) { free(d); d=NULL; }
  return (dist); 
}

/* increasing */
void sort_double2(double *data,int size) {

   int (*compar)(const void *,const void *);

   compar = Compare_double2;
   qsort((void *)data,(size_t)size,sizeof(double),compar);
}

int Compare_double2(const void *s1, const void *s2) {

   if (*((double *)s1)< (*(double *)s2)) { return -1; }
   if (*((double *)s1)> (*(double *)s2)) { return  1; }
      return 0;
}

void similarity_to_all_pwms(P_SIM *sim,MODEL *model0,MODEL *initia,int numPWM) {

   register int i,k,l,m,n;
   int window;
   double dist,minDist;
   double **qpwm=model0->pwm[1]; 
   double **rqpwm=model0->rpwm[1];
   int qpwmLen=model0->pwmLen[1];
   double ***pwm=initia->pwm;
   int *pwmLen=initia->pwmLen;

   for (i=0; i<numPWM; i++) {
      window=min(qpwmLen,pwmLen[i]);
      minDist=99999;
      for (m=0; m<qpwmLen-window+1; m++) {
         for (n=0; n<pwmLen[i]-window+1; n++) {
            dist=0;
            for (k=0; k<window; k++) {
               for (l=0; l<4; l++) dist +=fabs(qpwm[m+k][l]-pwm[i][n+k][l]);
            }
            if (dist<minDist) minDist=dist;
         }
      }
      for (m=0; m<qpwmLen-window+1; m++) {
         for (n=0; n<pwmLen[i]-window+1; n++) {
            dist=0;
            for (k=0; k<window; k++) {
               for (l=0; l<4; l++) dist +=fabs(rqpwm[m+k][l]-pwm[i][n+k][l]);
            }
            if (dist<minDist) minDist=dist;
         }
      }
      sim[i].wh=i;
      sim[i].dis=minDist/(double)window;
   }

   sort_similarity(sim,numPWM);
}

int similarity_to_original_pwm(double **pwm1,double **pwm2,int pwmLen) {

   register int k,l;
   double dist,distCutoff;

   distCutoff=vector_similarity();
// printf("alpha: %8.6f distance cutoff: %8.6f\n",SIMILARITY_ALPHA,distCutoff);

   dist=0;
   for (k=0; k<pwmLen; k++) {
      for (l=0; l<4; l++) dist +=fabs(pwm1[k][l]-pwm2[k][l]);
   }
//printf("dist: %8.3f, cutoff: %8.3f\n",dist,distCutoff*pwmLen);

   if (dist<=pwmLen*distCutoff) return (1);
   else return(0);
}

/* sort by increasing order */
void sort_similarity(P_SIM *sim,int size) {

   int (*compar)(const void *,const void *);

   compar=Compare_similarity;
   qsort((void *)sim,(size_t)size,sizeof(P_SIM),compar);
}

int Compare_similarity(const void *s1, const void *s2) {

   if (((P_SIM *)s1)->dis < ((P_SIM *)s2)->dis) { return -1; }
   if (((P_SIM *)s1)->dis > ((P_SIM *)s2)->dis) { return  1; }
      return 0;
}

int degenerate_pwm(double **pwm,int pwmLen) {

   register int i,j;
   int infoCn;
   double info;

   infoCn=0;
   for (i=0; i<pwmLen; i++) {
      info=2.0;
      for (j=0; j<4; j++) {
         if (pwm[i][j]>PSEUDO_COUNT) info +=(pwm[i][j]*log(pwm[i][j])/log(2.0));
      }
      if (info>=1.0) infoCn++;
   }
   if ((double)infoCn/(double)pwmLen<=0.25) return (1);
   return (0);
}
