
#include "config.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifdef HAVE_MALLOC_H
#include <malloc.h>
#endif

#include "defines.h"

float **alloc_float_float(int size1,int size2) {

   float **tmp=NULL;
   register int i;

   tmp=(float **)calloc(size1,sizeof(float *));
   if (!tmp)   { printf("tmp calloc failed!\n"); exit(1); }

   tmp[0]=(float *)calloc(size1*size2,sizeof(float));
   if (tmp[0]==0) { printf("bit calloc failed!\n"); exit(1); }

   /* set up vector pointers */
   for (i=1; i<size1; i++) tmp[i]=tmp[0]+(size2 * i);

   return (tmp);
}


double **alloc_double_double(int size1,int size2) {

   double **tmp=NULL;
   register int i;

   tmp=(double **)calloc(size1,sizeof(double *));
   if (!tmp)   { printf("tmp calloc failed!\n"); exit(1); }

   tmp[0]=(double *)calloc(size1*size2,sizeof(double));
   if (tmp[0]==0) { printf("bit calloc failed!\n"); exit(1); }

   /* set up vector pointers */
   for (i=1; i<size1; i++) tmp[i]=tmp[0]+(size2 * i);

   return (tmp);
}

char **alloc_char_char(int size1,int size2) {

   char **tmp=NULL;
   register int i;

   tmp=(char **)calloc(size1,sizeof(char *));
   if (!tmp)   { printf("tmp calloc failed!\n"); exit(1); }

   tmp[0]=(char *)calloc(size1*size2,sizeof(char));
   if (tmp[0]==0) { printf("bit calloc failed!\n"); exit(1); }

   /* set up vector pointers */
   for (i=1; i<size1; i++)  tmp[i]=tmp[0]+(size2 * i);

   return (tmp);
}

int **alloc_int_int(int size1,int size2) {

   int **tmp=NULL;
   register int i;

   tmp=(int **)calloc(size1,sizeof(int *));
   if (!tmp)   { printf("tmp calloc failed!\n"); exit(1); }

   tmp[0]=(int *)calloc(size1*size2,sizeof(int));
   if (tmp[0]==0) { printf("bit calloc failed!\n"); exit(1); }

   /* set up vector pointers */
   for (i=1; i<size1; i++)  tmp[i]=tmp[0]+(size2 * i);

   return (tmp);
}

char *alloc_char(int size1) {

   char *tmp=NULL;
   tmp=(char *)calloc(size1,sizeof(char));
   if (!tmp)   { printf("tmp calloc failed!\n"); exit(1); }
   return (tmp);
}

int *alloc_int(int size1) {

   int *tmp=NULL;
   tmp=(int *)calloc(size1,sizeof(int));
   if (!tmp)   { printf("tmp calloc failed!\n"); exit(1); }
   return (tmp);
}

float *alloc_float(int size1) {

   float *tmp=NULL;
   tmp=(float *)calloc(size1,sizeof(float));
   if (!tmp)   { printf("tmp calloc failed!\n"); exit(1); }
   return (tmp);
}

double *alloc_double(int size1) {

   double *tmp=NULL;
   tmp=(double *)calloc(size1,sizeof(double));
   if (!tmp)   { printf("tmp calloc failed!\n"); exit(1); }
   return (tmp);
}

int ***alloc_int_int_int(int num_niche,int pop_size,int size) {

   int ***tmp=NULL;
   register int i,j;

   tmp      =(int ***)calloc(num_niche,sizeof(int **));
   tmp[0]   =(int **) calloc(num_niche*pop_size,sizeof(int *));
   tmp[0][0]=(int *)  calloc(num_niche*pop_size*size,sizeof(int));

   for (i=1; i<num_niche; i++) tmp[i]=tmp[0]+i*pop_size;

   for (j=1; j<pop_size; j++) tmp[0][j]=tmp[0][0]+size*j;

   for (i=1; i<num_niche; i++) {
      tmp[i][0]=tmp[0][0]+size*pop_size*i;
      for (j=1; j<pop_size; j++)  tmp[i][j]=tmp[i][0]+size*j;
   }
   return (tmp);
}

double ***alloc_double_double_double(int size1,int size2,int size3) {

   double ***tmp=NULL;
   register int i,j;

   tmp      =(double ***)calloc(size1,sizeof(double **));
   tmp[0]   =(double **) calloc(size1*size2,sizeof(double *));
   tmp[0][0]=(double *)  calloc(size1*size2*size3,sizeof(double));

   for (i=1; i<size1; i++) tmp[i]=tmp[0]+i*size2;

   for (j=1; j<size2; j++) tmp[0][j]=tmp[0][0]+size3*j;

   for (i=1; i<size1; i++) {
      tmp[i][0]=tmp[0][0]+size3*size2*i;
      for (j=1; j<size2; j++)  tmp[i][j]=tmp[i][0]+size3*j;
   }
   return (tmp);
}

SAMPLE *alloc_data(int num) {

   SAMPLE *data=NULL;
   int i;

   data=(SAMPLE *)calloc(num,sizeof(SAMPLE));

   for (i=0; i<num; i++) {
      data[i].seq=alloc_char(MAX_SEQ_LENGTH);
      data[i].name=alloc_char(250);
      data[i].pos=NULL;
      data[i].strand=NULL;
      data[i].score=NULL;
   }
   return (data);
}

void alloc_data_additional(SAMPLE *data,int numSeq,int maxCandidates) {

   int i;
   for (i=0; i<numSeq; i++) {
      data[i].pos=alloc_int_int(2,maxCandidates);
      data[i].strand=alloc_char_char(2,maxCandidates);
      data[i].score=alloc_double_double(2,maxCandidates);
   }
}

MODEL *alloc_model(int num) {

   MODEL *model=NULL;
   int i;

   model=(MODEL *)calloc(1,sizeof(MODEL));
   for (i=0; i<1; i++) {
      model[i].pwm =alloc_double_double_double(num,MAX_PWM_LENGTH,5);
      model[i].rpwm=alloc_double_double_double(2,MAX_PWM_LENGTH,5);
      model[i].logpwm =alloc_double_double_double(2,MAX_PWM_LENGTH,5);
      model[i].logrpwm=alloc_double_double_double(2,MAX_PWM_LENGTH,5);
      model[i].opwm=alloc_double_double_double(2,MAX_PWM_LENGTH,5);
      model[i].consensus=alloc_char_char(2,MAX_PWM_LENGTH); 
      model[i].consensus0=alloc_char_char(num,MAX_PWM_LENGTH); 
      model[i].pwmLen=alloc_int(num); 
      model[i].name=alloc_char_char(num,200); 
   }
   return (model);
}

PRIOR *alloc_prior(int numSeq,int maxSeqLen) {

   PRIOR *prior=NULL;
   int i;

   prior=(PRIOR *)calloc(numSeq,sizeof(PRIOR));

   for (i=0; i<numSeq; i++) {
      prior[i].m1=alloc_double(maxSeqLen);
      prior[i].m2=alloc_double(maxSeqLen);
      prior[i].m12=alloc_double_double(maxSeqLen,maxSeqLen);
   }
   return (prior);
}
  
WSCORE *alloc_weight(int num,int maxSeqLen) {
 
   WSCORE *weight=NULL;
   register int i;
 
   weight=(WSCORE *)calloc(num,sizeof(WSCORE));
   for (i=0; i<num; i++) {
      weight[i].ws10=alloc_double(maxSeqLen);
      weight[i].ws20=alloc_double(maxSeqLen);
      weight[i].ws01=alloc_double(maxSeqLen);
      weight[i].ws02=alloc_double(maxSeqLen);
      weight[i].ws11=alloc_double_double(maxSeqLen,maxSeqLen);
      weight[i].ws12=alloc_double_double(maxSeqLen,maxSeqLen);
      weight[i].ws21=alloc_double_double(maxSeqLen,maxSeqLen);
      weight[i].ws22=alloc_double_double(maxSeqLen,maxSeqLen);
   } 
   return (weight);
}

M_SITE *alloc_motif_site(int numSeq) {

   M_SITE *site=NULL;
   site=(M_SITE *)calloc(numSeq,sizeof(M_SITE));
   if (!site) { printf("Error: calloc failed for M_SITE!\n"); exit(0); }

   return (site);
}

M_LIKELIHOOD *alloc_mlikelihood(int maxSeqLen) {

   M_LIKELIHOOD *ll=NULL;

   ll=(M_LIKELIHOOD *)calloc(1,sizeof(M_LIKELIHOOD));
   ll[0].site_p=alloc_double_double(2,maxSeqLen);
   ll[0].site_m=alloc_double_double(2,maxSeqLen);

   return (ll);
}

B_LIKELIHOOD *alloc_blikelihood(int numSeq,int maxSeqLen) {

   B_LIKELIHOOD *ll=NULL;
   int i;

   ll=(B_LIKELIHOOD *)calloc(numSeq,sizeof(B_LIKELIHOOD));

   for (i=0; i<numSeq; i++) {
      ll[i].site_b=alloc_double_double(2,maxSeqLen);
   }
   return (ll);
}

P_SIM *alloc_sim(int num) {

   P_SIM *sim=NULL;
   sim=(P_SIM *)calloc(num,sizeof(P_SIM));
   if (!sim) { printf("calloc failed for sim!\n"); exit(0); }
   return (sim);
}

void destroy_weightscore(int numSeq,WSCORE *wscore) {

   register int i;

   for (i=0; i<numSeq; i++) {
      if (wscore[i].ws10)    { free(wscore[i].ws10);    wscore[i].ws10=NULL;    }
      if (wscore[i].ws20)    { free(wscore[i].ws20);    wscore[i].ws20=NULL;    }
      if (wscore[i].ws01)    { free(wscore[i].ws01);    wscore[i].ws01=NULL;    }
      if (wscore[i].ws02)    { free(wscore[i].ws02);    wscore[i].ws02=NULL;    }
      if (wscore[i].ws11[0]) { free(wscore[i].ws11[0]); wscore[i].ws11[0]=NULL; }
      if (wscore[i].ws11)    { free(wscore[i].ws11);    wscore[i].ws11=NULL;    }
      if (wscore[i].ws12[0]) { free(wscore[i].ws12[0]); wscore[i].ws12[0]=NULL; }
      if (wscore[i].ws12)    { free(wscore[i].ws12);    wscore[i].ws12=NULL;    }
      if (wscore[i].ws21[0]) { free(wscore[i].ws21[0]); wscore[i].ws21[0]=NULL; }
      if (wscore[i].ws21)    { free(wscore[i].ws21);    wscore[i].ws21=NULL;    }
      if (wscore[i].ws22[0]) { free(wscore[i].ws22[0]); wscore[i].ws22[0]=NULL; }
      if (wscore[i].ws22)    { free(wscore[i].ws22);    wscore[i].ws22=NULL;    }
   }
   if (wscore) { free(wscore); wscore=NULL; }

}
