// this file contains the code for E-step in Em algorithm 
// E-step find the expectation of the missing variable given the data and the paramenter
#include "config.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#include "defines.h"

double **alloc_double_double(int ,int );
int Compare_score(const void *s1, const void *s2);
void sort_score(SSCORE *site,int size);
int highest_non_overlapping_sites(SSCORE *site,int total,int pwmLen,int *,char *,double *,int );
// P(loc,state|seq,M)

void weightscore_backg(int numSeq,SAMPLE *data,MODEL *model,B_LIKELIHOOD *ll_b,int two_motif_model) {

   register int iii,ii,i,k;
   int numPWMs=1;
   if (two_motif_model) numPWMs=2;

   for (iii=0; iii<numSeq; iii++) {
      for (ii=0; ii<numPWMs; ii++) {
         for(i=0; i<data[iii].length-model->pwmLen[ii]+1; i++) {

            ll_b[iii].site_b[ii][i]=0;
            for (k=0; k<model->pwmLen[ii]; k++) {
               switch (data[iii].seq[i+k]) {
                  case 'a':  
                     ll_b[iii].site_b[ii][i] +=model->logbfreq[0]; break; 
                  case 'c':  
                     ll_b[iii].site_b[ii][i] +=model->logbfreq[1]; break; 
                  case 'g':  
                     ll_b[iii].site_b[ii][i] +=model->logbfreq[2]; break; 
                  case 't':  
                     ll_b[iii].site_b[ii][i] +=model->logbfreq[3]; break; 
                  default: 
                     ll_b[iii].site_b[ii][i] +=model->logbfreq[4]; break;
               }
            }
         }
      }

      ll_b[iii].seq_b=0;
      for(i=0; i<data[iii].length; i++) {
         switch (data[iii].seq[i]) {
            case 'a': 
               ll_b[iii].seq_b +=model->logbfreq[0]; break; 
            case 'c': 
               ll_b[iii].seq_b +=model->logbfreq[1]; break; 
            case 'g': 
               ll_b[iii].seq_b +=model->logbfreq[2]; break; 
            case 't': 
               ll_b[iii].seq_b +=model->logbfreq[3]; break; 
            default: 
               ll_b[iii].seq_b +=model->logbfreq[4]; break; 
         } 
      }
      // printf("seq[%3d]\t%8.6f\n",iii+1,ll_b[iii].seq_b);
   }
}

void weightscore_motif(WSCORE *wscore, SAMPLE *data, MODEL *model,B_LIKELIHOOD *ll_b,PRIOR *prior,
   int maxCandidates,int two_motif_model,double sigma1) {

   register int ii,i,j,k;
   double **site_b=ll_b->site_b;  // log likelihood of a site from background model
   double    seq_b=ll_b->seq_b;   // log of sequence likelihood from background model
   double score,rscore;
   int cn,numNonACGT;
   SSCORE *site;

   site=(SSCORE *)calloc(2*data->length,sizeof(SSCORE));

   // ws00
   wscore->ws00=exp(model->logp[0][0]+seq_b); 

   int numPWMs=1;
   if (two_motif_model) numPWMs=2; 

   for (ii=0; ii<numPWMs; ii++) {

      cn=0;
      for(i=0; i<data->length-model->pwmLen[ii]+1; i++) {
         score=0; rscore=0; numNonACGT=0;
         for (k=0; k<model->pwmLen[ii]; k++) {
            switch (data->seq[i+k]) {
               case 'a':  
                  score +=model-> logpwm[ii][k][0];
                  rscore+=model->logrpwm[ii][k][0];
                  break; 
               case 'c':  
                  score +=model-> logpwm[ii][k][1];
                  rscore+=model->logrpwm[ii][k][1];
                  break; 
               case 'g':  
                  score +=model-> logpwm[ii][k][2];
                  rscore+=model->logrpwm[ii][k][2];
                  break; 
               case 't':  
                  score +=model-> logpwm[ii][k][3];
                  rscore+=model->logrpwm[ii][k][3];
                  break; 
               default: 
                  score +=model-> logpwm[ii][k][4];
                  rscore+=model->logrpwm[ii][k][4];
                  numNonACGT++;
                  break;
            }
         }
         site[cn].score=score;
         site[cn].pos=i;
         site[cn].strand='+';
         cn++;

         site[cn].score=rscore;
         site[cn].pos=i;
         site[cn].strand='-'; 
         cn++;
         
         // if more than 1/4 of nucleotides are 'n', not a candidate site
         if (numNonACGT>0.25*model->pwmLen[ii]) { 
            site[cn-2].score=DUMMY_SCORE; // plus  score
            site[cn-1].score=DUMMY_SCORE; // minus score
         }
      }
      sort_score(site,cn);
      /*----------------------test------------------------*/
      // restrict location for motif 1
      //if (ii==0) {
      //   for (i=0; i<cn; i++) {
      //      if (site[i].pos<data->length/2-3.0*sigma1 || site[i].pos>data->length/2+3.0*sigma1) {
      //         site[i].score=DUMMY_SCORE; 
      //      }
      //   } 
      //}
      /*----------------end-of-test-----------------------*/

      data->numUniq[ii]=highest_non_overlapping_sites(site,cn,model->pwmLen[ii],data->pos[ii],data->strand[ii],data->score[ii],maxCandidates);
   }
  
   double *score0=data->score[0];
   double *score1=data->score[1];
   char *strand0 =data->strand[0];
   char *strand1 =data->strand[1];
   int numUniq0  =data->numUniq[0];
   int numUniq1  =data->numUniq[1];
   int *pos0     =data->pos[0];
   int *pos1     =data->pos[1];
   double prior_m12=-log((double)((data->length-model->pwmLen[0]-model->pwmLen[1]+2)*(data->length-model->pwmLen[0]-model->pwmLen[1]+1)));

   for(i=0; i<numUniq0; i++) {

      if      (strand0[i]=='+') wscore->ws10[i]=exp(model->logp[1][0]+prior->m1[pos0[i]]+seq_b+score0[i]-site_b[0][pos0[i]]);
      else if (strand0[i]=='-') wscore->ws20[i]=exp(model->logp[2][0]+prior->m1[pos0[i]]+seq_b+score0[i]-site_b[0][pos0[i]]);

      if (two_motif_model) {
         // weight scores: ws11, ws12, ws21, ws22
         for(j=0; j<numUniq1; j++) {

            if ((pos0[i]<pos1[j] && (pos0[i]+model->pwmLen[0]-1)<pos1[j]) ||  
                (pos1[j]<pos0[i] && (pos1[j]+model->pwmLen[1]-1)<pos0[i]) ) {
 
               if      (strand0[i]=='+' && strand1[j]=='+') 
                  wscore->ws11[i][j] = exp( model->logp[1][1]            // prior - probability of joint motif1+/motif2+ 
                                          + prior_m12                    // prior - probability of motif1+/motif2+ locations 
                                          //+ prior->m12[pos0[i]][pos1[j]]                    // prior - probability of motif1+/motif2+ locations 
                                          + seq_b                        // entire sequence likelihood from background model
                                          + score0[i]                    // likelihood of motif1+ start at position i
                                          + score1[j]                    // likelihood of motif2+ start at position j
                                          - site_b[0][pos0[i]]           // background likelihood of length w1 start at position i 
                                          - site_b[1][pos1[j]] );        // background likelihood of length w2 start at position j

               else if (strand0[i]=='+' && strand1[j]=='-') 
                  wscore->ws12[i][j] = exp( model->logp[1][2]
                                          + prior_m12                    // prior - probability of motif1+/motif2+ locations
                                          //+ prior->m12[pos0[i]][pos1[j]]                    // prior - probability of motif1+/motif2+ locations
                                          + seq_b
                                          + score0[i]
                                          + score1[j]
                                          - site_b[0][pos0[i]]
                                          - site_b[1][pos1[j]] );
               else if (strand0[i]=='-' && strand1[j]=='+') 
                  wscore->ws21[i][j] = exp( model->logp[2][1]
                                          + prior_m12                   // prior - probability of motif1+/motif2+ locations
                                          //+ prior->m12[pos0[i]][pos1[j]]                   // prior - probability of motif1+/motif2+ locations
                                          + seq_b
                                          + score0[i]
                                          + score1[j]
                                          - site_b[0][pos0[i]]
                                          - site_b[1][pos1[j]] );
               else if (strand0[i]=='-' && strand1[j]=='-') 
                  wscore->ws22[i][j] = exp( model->logp[2][2]
                                          + prior_m12                 // prior - probability of motif1+/motif2+ locations 
                                          //+ prior->m12[pos0[i]][pos1[j]]                 // prior - probability of motif1+/motif2+ locations 
                                          + seq_b
                                          + score0[i]
                                          + score1[j]
                                          - site_b[0][pos0[i]]
                                          - site_b[1][pos1[j]] );
            }
            else {
               wscore->ws11[i][j] = 0;
               wscore->ws12[i][j] = 0;
               wscore->ws21[i][j] = 0;
               wscore->ws22[i][j] = 0;
            }
         }
      }
   }
   if (two_motif_model) {
      for(j=0; j<numUniq1; j++) {
         if      (strand1[j]=='+') wscore->ws01[j]=exp( model->logp[0][1]
                                                      + prior->m2[pos1[j]]
                                                      //+ prior_m2
                                                      + seq_b
                                                      + score1[j]
                                                      - site_b[1][pos1[j]] );
         else if (strand1[j]=='-') wscore->ws02[j]=exp( model->logp[0][2]
                                                      + prior->m2[pos1[j]]
                                                      // + prior_m2
                                                      + seq_b
                                                      + score1[j]
                                                      - site_b[1][pos1[j]] );
      }
   }
   if (site) { free(site); site=NULL; }
}

// per sequence 
void update_model_full(int two_motif_model,MODEL *model1, SAMPLE *data, WSCORE *wscore) {

   register int i,j,k;

   char *strand0=data->strand[0];
   char *strand1=data->strand[1];
 
   int *pos0=data->pos[0];
   int *pos1=data->pos[1];

   int numUniq0=data->numUniq[0];
   int numUniq1=data->numUniq[1];

   // update the PWM count matrices
   // state={0,0}, {1,0} and {2,0}

   // update the nine proportions for 2-motif model or five proportions for 1-motif model
   model1->p[0][0] +=wscore->ws00;

   for(i=0; i<numUniq0; i++) {

      if (strand0[i]=='+') {
         model1->p[1][0] +=wscore->ws10[i];
         for (k=0; k<model1->pwmLen[0]; k++) {
            switch (data->seq[k+pos0[i]]) {
               case 'a': 
                  model1-> pwm[0][k][0] +=wscore->ws10[i];
                  break;
               case 'c': 
                  model1-> pwm[0][k][1] +=wscore->ws10[i];
                  break;
               case 'g': 
                  model1-> pwm[0][k][2] +=wscore->ws10[i];
                  break;
               case 't': 
                  model1-> pwm[0][k][3] +=wscore->ws10[i];
                  break;
               default: break; 
            }
         }
      }
      else if (strand0[i]=='-') {
         model1->p[2][0] +=wscore->ws20[i];
         for (k=0; k<model1->pwmLen[0]; k++) {
            switch (data->seq[k+pos0[i]]) {
               case 'a': 
                  model1->rpwm[0][k][0] +=wscore->ws20[i];
                  break;
               case 'c': 
                  model1->rpwm[0][k][1] +=wscore->ws20[i];
                  break;
               case 'g': 
                  model1->rpwm[0][k][2] +=wscore->ws20[i];
                  break;
               case 't': 
                  model1->rpwm[0][k][3] +=wscore->ws20[i];
                  break;
               default: break; 
            }
         }
      }

      if (two_motif_model) {
         for(j=0; j<numUniq1; j++) {

            if ((pos0[i]<pos1[j] && (pos0[i]+model1->pwmLen[0]-1)<pos1[j]) ||  
                (pos1[j]<pos0[i] && (pos1[j]+model1->pwmLen[1]-1)<pos0[i]) ) {

               if      (strand0[i]=='+' && strand1[j]=='+') model1->p[1][1] +=wscore->ws11[i][j];
               else if (strand0[i]=='+' && strand1[j]=='-') model1->p[1][2] +=wscore->ws12[i][j];
               else if (strand0[i]=='-' && strand1[j]=='+') model1->p[2][1] +=wscore->ws21[i][j];
               else if (strand0[i]=='-' && strand1[j]=='-') model1->p[2][2] +=wscore->ws22[i][j];

               if (strand0[i]=='+' && strand1[j]=='+') {
                  for (k=0; k<model1->pwmLen[0]; k++) {
                     switch (data->seq[k+pos0[i]]) {
                        case 'a': 
                           model1-> pwm[0][k][0] +=wscore->ws11[i][j];
                           break;
                        case 'c': 
                           model1-> pwm[0][k][1] +=wscore->ws11[i][j];
                           break;
                        case 'g': 
                           model1-> pwm[0][k][2] +=wscore->ws11[i][j];
                           break;
                        case 't': 
                           model1-> pwm[0][k][3] +=wscore->ws11[i][j];
                           break;
                        default: break; 
                     }
                  }
                  for (k=0; k<model1->pwmLen[1]; k++) {
                     switch (data->seq[k+pos1[j]]) {
                        case 'a': 
                           model1-> pwm[1][k][0] +=wscore->ws11[i][j];
                           break;
                        case 'c': 
                           model1-> pwm[1][k][1] +=wscore->ws11[i][j];
                           break;
                        case 'g': 
                           model1-> pwm[1][k][2] +=wscore->ws11[i][j];
                           break;
                        case 't': 
                           model1-> pwm[1][k][3] +=wscore->ws11[i][j];
                           break;
                        default: break; 
                     }
                  }
               }
               else if (strand0[i]=='+' && strand1[j]=='-') {
                  for (k=0; k<model1->pwmLen[0]; k++) {
                     switch (data->seq[k+pos0[i]]) {
                        case 'a': 
                           model1-> pwm[0][k][0] +=wscore->ws12[i][j];
                           break;
                        case 'c': 
                           model1-> pwm[0][k][1] +=wscore->ws12[i][j];
                           break;
                        case 'g': 
                           model1-> pwm[0][k][2] +=wscore->ws12[i][j];
                           break;
                        case 't': 
                           model1-> pwm[0][k][3] +=wscore->ws12[i][j];
                           break;
                        default: break; 
                     }
                  }
                  for (k=0; k<model1->pwmLen[1]; k++) {
                     switch (data->seq[k+pos1[j]]) {
                        case 'a': 
                           model1->rpwm[1][k][0] +=wscore->ws12[i][j];
                           break;
                        case 'c': 
                           model1->rpwm[1][k][1] +=wscore->ws12[i][j];
                           break;
                        case 'g': 
                           model1->rpwm[1][k][2] +=wscore->ws12[i][j];
                           break;
                        case 't': 
                           model1->rpwm[1][k][3] +=wscore->ws12[i][j];
                           break;
                        default: break; 
                     }
                  }
               }
               else if (strand0[i]=='-' && strand1[j]=='+') {
                  for (k=0; k<model1->pwmLen[0]; k++) {
                     switch (data->seq[k+pos0[i]]) {
                        case 'a': 
                           model1->rpwm[0][k][0] +=wscore->ws21[i][j];
                           break;
                        case 'c': 
                           model1->rpwm[0][k][1] +=wscore->ws21[i][j];
                           break;
                        case 'g': 
                           model1->rpwm[0][k][2] +=wscore->ws21[i][j];
                           break;
                        case 't': 
                           model1->rpwm[0][k][3] +=wscore->ws21[i][j];
                           break;
                        default: break; 
                     }
                  }
                  for (k=0; k<model1->pwmLen[1]; k++) {
                     switch (data->seq[k+pos1[j]]) {
                        case 'a': 
                           model1-> pwm[1][k][0] +=wscore->ws21[i][j];
                           break;
                        case 'c': 
                           model1-> pwm[1][k][1] +=wscore->ws21[i][j];
                           break;
                        case 'g': 
                           model1-> pwm[1][k][2] +=wscore->ws21[i][j];
                           break;
                        case 't': 
                           model1-> pwm[1][k][3] +=wscore->ws21[i][j];
                           break;
                        default: break;
                      }
                  } 
               }
               if (strand0[i]=='-' && strand1[j]=='-') {
                  for (k=0; k<model1->pwmLen[0]; k++) {
                     switch (data->seq[k+pos0[i]]) {
                        case 'a': 
                           model1->rpwm[0][k][0] +=wscore->ws22[i][j];
                           break;
                        case 'c': 
                           model1->rpwm[0][k][1] +=wscore->ws22[i][j];
                           break;
                        case 'g': 
                           model1->rpwm[0][k][2] +=wscore->ws22[i][j];
                           break;
                        case 't': 
                           model1->rpwm[0][k][3] +=wscore->ws22[i][j];
                           break;
                        default: break; 
                     }
                  }
                  for (k=0; k<model1->pwmLen[1]; k++) {
                     switch (data->seq[k+pos1[j]]) {
                        case 'a': 
                           model1->rpwm[1][k][0] +=wscore->ws22[i][j];
                           break;
                        case 'c': 
                           model1->rpwm[1][k][1] +=wscore->ws22[i][j];
                           break;
                        case 'g': 
                           model1->rpwm[1][k][2] +=wscore->ws22[i][j];
                           break;
                        case 't': 
                           model1->rpwm[1][k][3] +=wscore->ws22[i][j];
                           break;
                        default: break;
                     }
                  }
               }
            }
         }
      }
   }

   if (two_motif_model) {
      for(j=0; j<numUniq1; j++) {

         // update motif2 (+/-) proportions
         if      (strand1[j]=='+') model1->p[0][1] +=wscore->ws01[j];
         else if (strand1[j]=='-') model1->p[0][2] +=wscore->ws02[j];
 
         // update motif2 PWM+/PWM- 
         if (strand1[j]=='+') {
            for (k=0; k<model1->pwmLen[1]; k++) {
               switch (data->seq[k+pos1[j]]) {
                  case 'a': 
                     model1-> pwm[1][k][0] +=wscore->ws01[j];
                     break;
                  case 'c': 
                     model1-> pwm[1][k][1] +=wscore->ws01[j];
                     break;
                  case 'g': 
                     model1-> pwm[1][k][2] +=wscore->ws01[j];
                     break;
                  case 't': 
                     model1-> pwm[1][k][3] +=wscore->ws01[j];
                     break;
                  default: break; 
               }
            }
         }
         else if (strand1[j]=='-') {
            for (k=0; k<model1->pwmLen[1]; k++) {
               switch (data->seq[k+pos1[j]]) {
                  case 'a': 
                     model1->rpwm[1][k][0] +=wscore->ws02[j];
                     break;
                  case 'c': 
                     model1->rpwm[1][k][1] +=wscore->ws02[j];
                     break;
                  case 'g': 
                     model1->rpwm[1][k][2] +=wscore->ws02[j];
                     break;
                  case 't': 
                     model1->rpwm[1][k][3] +=wscore->ws02[j];
                     break;
                  default: break; 
               }
            }
         }
      }
   }
}

// update everything except PWM for the co-factor motif
void update_model_partial(int two_motif_model,MODEL *model1, SAMPLE *data, WSCORE *wscore) {

   register int i,j,k;

   char *strand0=data->strand[0];
   char *strand1=data->strand[1];
 
   int *pos0=data->pos[0];
   int *pos1=data->pos[1];

   int numUniq0=data->numUniq[0];
   int numUniq1=data->numUniq[1];

   // update the PWM count matrices
   // state={0,0}, {1,0} and {2,0}

   // update the nine proportions for 2-motif model or five proportions for 1-motif model
   model1->p[0][0] +=wscore->ws00;

   for(i=0; i<numUniq0; i++) {
      if (strand0[i]=='+') {
         model1->p[1][0] +=wscore->ws10[i];
         for (k=0; k<model1->pwmLen[0]; k++) {
            switch (data->seq[k+pos0[i]]) {
               case 'a': 
                  model1-> pwm[0][k][0] +=wscore->ws10[i];
                  break;
               case 'c': 
                  model1-> pwm[0][k][1] +=wscore->ws10[i];
                  break;
               case 'g': 
                  model1-> pwm[0][k][2] +=wscore->ws10[i];
                  break;
               case 't': 
                  model1-> pwm[0][k][3] +=wscore->ws10[i];
                  break;
               default: break; 
            }
         }
      }
      else if (strand0[i]=='-') {
         model1->p[2][0] +=wscore->ws20[i];
         for (k=0; k<model1->pwmLen[0]; k++) {
            switch (data->seq[k+pos0[i]]) {
               case 'a': 
                  model1->rpwm[0][k][0] +=wscore->ws20[i];
                  break;
               case 'c': 
                  model1->rpwm[0][k][1] +=wscore->ws20[i];
                  break;
               case 'g': 
                  model1->rpwm[0][k][2] +=wscore->ws20[i];
                  break;
               case 't': 
                  model1->rpwm[0][k][3] +=wscore->ws20[i];
                  break;
               default: break; 
            }
         }
      }

      if (two_motif_model) {
         for(j=0; j<numUniq1; j++) {

            if ((pos0[i]<pos1[j] && (pos0[i]+model1->pwmLen[0]-1)<pos1[j]) ||  
                (pos1[j]<pos0[i] && (pos1[j]+model1->pwmLen[1]-1)<pos0[i]) ) {

               if      (strand0[i]=='+' && strand1[j]=='+') model1->p[1][1] +=wscore->ws11[i][j];
               else if (strand0[i]=='+' && strand1[j]=='-') model1->p[1][2] +=wscore->ws12[i][j];
               else if (strand0[i]=='-' && strand1[j]=='+') model1->p[2][1] +=wscore->ws21[i][j];
               else if (strand0[i]=='-' && strand1[j]=='-') model1->p[2][2] +=wscore->ws22[i][j];

               if (strand0[i]=='+' && strand1[j]=='+') {
                  for (k=0; k<model1->pwmLen[0]; k++) {
                     switch (data->seq[k+pos0[i]]) {
                        case 'a': 
                           model1-> pwm[0][k][0] +=wscore->ws11[i][j];
                           break;
                        case 'c': 
                           model1-> pwm[0][k][1] +=wscore->ws11[i][j];
                           break;
                        case 'g': 
                           model1-> pwm[0][k][2] +=wscore->ws11[i][j];
                           break;
                        case 't': 
                           model1-> pwm[0][k][3] +=wscore->ws11[i][j];
                           break;
                        default: break; 
                     }
                  }
               }
               else if (strand0[i]=='+' && strand1[j]=='-') { 
                  for (k=0; k<model1->pwmLen[0]; k++) {
                     switch (data->seq[k+pos0[i]]) {
                        case 'a': 
                           model1-> pwm[0][k][0] +=wscore->ws12[i][j];
                           break;
                        case 'c': 
                           model1-> pwm[0][k][1] +=wscore->ws12[i][j];
                           break;
                        case 'g': 
                           model1-> pwm[0][k][2] +=wscore->ws12[i][j];
                           break;
                        case 't': 
                           model1-> pwm[0][k][3] +=wscore->ws12[i][j];
                           break;
                        default: break; 
                     }
                  }
               }
               else if (strand0[i]=='-' && strand1[j]=='+') {
                  for (k=0; k<model1->pwmLen[0]; k++) {
                     switch (data->seq[k+pos0[i]]) {
                        case 'a': 
                           model1->rpwm[0][k][0] +=wscore->ws21[i][j];
                           break;
                        case 'c': 
                           model1->rpwm[0][k][1] +=wscore->ws21[i][j];
                           break;
                        case 'g': 
                           model1->rpwm[0][k][2] +=wscore->ws21[i][j];
                           break;
                        case 't': 
                           model1->rpwm[0][k][3] +=wscore->ws21[i][j];
                           break;
                        default: break; 
                     }
                  }
               }
               if (strand0[i]=='-' && strand1[j]=='-') {
                  for (k=0; k<model1->pwmLen[0]; k++) {
                     switch (data->seq[k+pos0[i]]) {
                        case 'a': 
                           model1->rpwm[0][k][0] +=wscore->ws22[i][j];
                           break;
                        case 'c': 
                           model1->rpwm[0][k][1] +=wscore->ws22[i][j];
                           break;
                        case 'g': 
                           model1->rpwm[0][k][2] +=wscore->ws22[i][j];
                           break;
                        case 't': 
                           model1->rpwm[0][k][3] +=wscore->ws22[i][j];
                           break;
                        default: break; 
                     }
                  }
               }
            }
         }
      }
   }

   if (two_motif_model) {
      for(j=0; j<numUniq1; j++) {

         // update motif2 (+/-) proportions
         if      (strand1[j]=='+') model1->p[0][1] +=wscore->ws01[j];
         else if (strand1[j]=='-') model1->p[0][2] +=wscore->ws02[j];
      }
   }
}

/* sort by decreasing order */
void sort_score(SSCORE *site,int size) {

   int (*compar)(const void *,const void *);

   compar=Compare_score;
   qsort((void *)site,(size_t)size,sizeof(SSCORE),compar);
}

int Compare_score(const void *s1, const void *s2) {

   if (((SSCORE *)s1)->score < ((SSCORE *)s2)->score) { return  1; }
   if (((SSCORE *)s1)->score > ((SSCORE *)s2)->score) { return -1; }
      return 0;
}

int  highest_non_overlapping_sites(SSCORE *site,int total,int pwmLen,int *pos,char *strand,double *score,int maxCandidates) {

   register int i,j;
   SSCORE *uniq;
   int numUniq,overlap;

   uniq=(SSCORE *)calloc(total,sizeof(SSCORE));

   numUniq=0;
   for (i=0; i<total; i++) {
      overlap=0;
      for (j=0; j<numUniq; j++) {
         if ((site[i].pos<=uniq[j].pos && (site[i].pos+pwmLen-1)>=uniq[j].pos) ||
             (uniq[j].pos<=site[i].pos && (uniq[j].pos+pwmLen-1)>=site[i].pos) ||
             site[i].score==DUMMY_SCORE ) {
            overlap=1; break; 
         } 
      }
      /*-------------------------------------------------------------------*/
      /* if you want to use all overlapping sites in EM, set overlap=0 and */
      /* set maxCandidateSites to 2*maxSeqLen in main.c to increase memory */
      /* allocation for respective variables                               */
      /*-------------------------------------------------------------------*/
      if (!overlap) { 
         uniq[numUniq].pos   =site[i].pos;
         uniq[numUniq].score =site[i].score; 
         uniq[numUniq].strand=site[i].strand; 
         numUniq++;
      } 
   }

   if (numUniq>maxCandidates) { printf("max number of candidate sites reached!\n"); }
 
   for (i=0; i<min(numUniq,maxCandidates); i++) {
      pos[i]   =uniq[i].pos;
      strand[i]=uniq[i].strand;
      score[i] =uniq[i].score;
   }
   if (uniq) { free(uniq); uniq=NULL; }

   return (max(1,numUniq));
}

